!***********************************************************************
!     for Calculation of Source Terms
!***********************************************************************
!
!---------------------------------------------------------------------
subroutine calsf(sf,uu,wwo,gm,dt,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1  
!
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: sf(2:5,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwo(3,nv,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: dt
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        sf(2,i,j,k)=-(gm(2,1,i,j,k)*wwo(2,3,i,j,k)&
                    +gm(3,1,i,j,k)*wwo(3,4,i,j,k)&
                    -gm(1,2,i,j,k)*wwo(1,3,i,j,k)&
                    -gm(1,3,i,j,k)*wwo(1,4,i,j,k))*dt&
                    +gm(0,1,i,j,k)*(uu(1,i,j,k)*c0**2&
                    +uu(5,i,j,k))*dt
        sf(3,i,j,k)=-(gm(3,2,i,j,k)*wwo(3,4,i,j,k)&
                    +gm(1,2,i,j,k)*wwo(1,2,i,j,k)&
                    -gm(2,3,i,j,k)*wwo(2,4,i,j,k)&
                    -gm(2,1,i,j,k)*wwo(2,2,i,j,k))*dt&
                    +gm(0,2,i,j,k)*(uu(1,i,j,k)*c0**2&
                    +uu(5,i,j,k))*dt
        sf(4,i,j,k)=-(gm(1,3,i,j,k)*wwo(1,2,i,j,k)&
                    +gm(2,3,i,j,k)*wwo(2,3,i,j,k)&
                    -gm(3,1,i,j,k)*wwo(3,2,i,j,k)&
                    -gm(3,2,i,j,k)*wwo(3,3,i,j,k))*dt&
                    +gm(0,3,i,j,k)*(uu(1,i,j,k)*c0**2&
                    +uu(5,i,j,k))*dt
        sf(5,i,j,k)=dt*c0**2*(gm(0,1,i,j,k)*uu(2,i,j,k)&
                    +gm(0,2,i,j,k)*uu(3,i,j,k)&
                    +gm(0,3,i,j,k)*uu(4,i,j,k))

      enddo
    enddo
  enddo
!
  return
end subroutine calsf
!
!   Calculation of Energy momentum Tesor term
!
!
!---------------------------------------------------------------------
subroutine caltenr(tenr,uu,uri,wwo,wok,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, gam, c0
  implicit none

  integer :: i, j, k, m, n, is1, ie1, js1, je1, ks1, ke1  
!
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwo(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: tenr(0:3,0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wok(3,is1:ie1,js1:je1,ks1:ke1)
!
!=====================================================================@

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        tenr(0,0,i,j,k)=uu(5,i,j,k)+uu(1,i,j,k)*c0**2
!
        tenr(0,1,i,j,k)=c0*uu(2,i,j,k)+wok(1,i,j,k)*tenr(0,0,i,j,k)
        tenr(0,2,i,j,k)=c0*uu(3,i,j,k)+wok(2,i,j,k)*tenr(0,0,i,j,k)
        tenr(0,3,i,j,k)=c0*uu(4,i,j,k)+wok(3,i,j,k)*tenr(0,0,i,j,k)
!
        tenr(1,0,i,j,k)=uri(2,i,j,k)+c0*wok(1,i,j,k)
        tenr(2,0,i,j,k)=uri(3,i,j,k)+c0*wok(2,i,j,k)
        tenr(3,0,i,j,k)=uri(4,i,j,k)+c0*wok(3,i,j,k)
!
        do n=1,3
          do m=1,3
            tenr(m,n,i,j,k)=wwo(m,n+1,i,j,k) &
                           +wok(m,i,j,k)*uu(n+1,i,j,k)*c0 &
                           +wok(n,i,j,k)*uu(m+1,i,j,k)*c0 &
                           +wok(m,i,j,k)*wok(n,i,j,k)*tenr(0,0,i,j,k)
          enddo
        enddo
!
      enddo
    enddo
  enddo

  return
end subroutine caltenr
!---------------------------------------------------------------------
subroutine kaddsf(sf,tenr,gm,wok,sgk,dt,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, gam, c0
  implicit none

  integer :: i, j, k, m, n, is1, ie1, js1, je1, ks1, ke1  
!
  real(8) :: sf(2:5,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: tenr(0:3,0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wok(3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: sgk(3,3,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: dt
!
!=====================================================================@

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
!
!  sf(2-4,*,*,*) recalculate
        do m=1,3
          sf(m+1,i,j,k)=gm(0,m,i,j,k)*tenr(0,0,i,j,k)*dt
          do n=1,3
            if( m.ne.n ) then
              sf(m+1,i,j,k)=sf(m+1,i,j,k)+gm(m,n,i,j,k)*tenr(m,n,i,j,k)*dt &
                           -gm(n,m,i,j,k)*tenr(n,n,i,j,k)*dt
            endif
          enddo
          do n=1,3
            sf(m+1,i,j,k)=sf(m+1,i,j,k) &
                         -( sgk(n,m,i,j,k)-wok(n,i,j,k)*gm(n,m,i,j,k) &
                         +wok(m,i,j,k)*gm(m,n,i,j,k) )*tenr(0,n,i,j,k)*dt
          enddo
        enddo
!
!  sf(5,*,*,*) recalculate  
        sf(5,i,j,k)=0.d0
        do m=1,3
          sf(5,i,j,k)=sf(5,i,j,k)+c0*gm(0,m,i,j,k)*tenr(0,m,i,j,k)*dt &
                     -wok(m,i,j,k)*sf(m+1,i,j,k)*c0
          do n=1,3
            sf(5,i,j,k)=sf(5,i,j,k)-c0*sgk(m,n,i,j,k)*tenr(m,n,i,j,k)*dt
          enddo
        enddo
!
      enddo
    enddo
  enddo  

  return
end subroutine kaddsf
!---------------------------------------------------------------------
subroutine kaddsf1(sf,tenr,gm,wok,sgk,dt,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1, merr  
!
  real(8) :: sf(2:5,is1:ie1,js1:je1,ks1:ke1)
  real(8), allocatable :: sfo(:,:,:,:)
!
  real(8) :: tenr(0:3,0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wok(3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: sgk(3,3,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: dt
!
  allocate( sfo(2:5,is1:ie1,js1:je1,ks1:ke1), stat=merr)
!
!=====================================================================@

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1         
        sfo(2,i,j,k)=sf(2,i,j,k)
        sfo(3,i,j,k)=sf(3,i,j,k)
        sfo(4,i,j,k)=sf(4,i,j,k)
        sf(5,i,j,k)=0.d0
      enddo
    enddo
  enddo
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1  
!
!  sf(2-4,*,*,*) recalculate
!  
        sf(2,i,j,k)=gm(0,1,i,j,k)*tenr(0,0,i,j,k)*dt &
                   +gm(1,2,i,j,k)*tenr(1,2,i,j,k)*dt &
                   -gm(2,1,i,j,k)*tenr(2,2,i,j,k)*dt &
                   +gm(1,3,i,j,k)*tenr(1,3,i,j,k)*dt &
                   -gm(3,1,i,j,k)*tenr(3,3,i,j,k)*dt &
                   -( sgk(1,1,i,j,k)-wok(1,i,j,k)*gm(1,1,i,j,k) &
                   +wok(1,i,j,k)*gm(1,1,i,j,k) )*tenr(0,1,i,j,k)*dt &
                   -( sgk(2,1,i,j,k)-wok(2,i,j,k)*gm(2,1,i,j,k) &
                   +wok(1,i,j,k)*gm(1,2,i,j,k) )*tenr(0,2,i,j,k)*dt &
                   -( sgk(3,1,i,j,k)-wok(3,i,j,k)*gm(3,1,i,j,k) &
                   +wok(1,i,j,k)*gm(1,3,i,j,k) )*tenr(0,3,i,j,k)*dt
!
        sf(3,i,j,k)=gm(0,2,i,j,k)*tenr(0,0,i,j,k)*dt &
                   +gm(2,1,i,j,k)*tenr(2,1,i,j,k)*dt &
                   -gm(1,2,i,j,k)*tenr(1,1,i,j,k)*dt &
                   +gm(2,3,i,j,k)*tenr(2,3,i,j,k)*dt &
                   -gm(3,2,i,j,k)*tenr(3,3,i,j,k)*dt &
                   -( sgk(1,2,i,j,k)-wok(1,i,j,k)*gm(1,2,i,j,k) &
                   +wok(2,i,j,k)*gm(2,1,i,j,k) )*tenr(0,1,i,j,k)*dt &
                   -( sgk(2,2,i,j,k)-wok(2,i,j,k)*gm(2,2,i,j,k) &
                   +wok(2,i,j,k)*gm(2,2,i,j,k) )*tenr(0,2,i,j,k)*dt &
                   -( sgk(3,2,i,j,k)-wok(3,i,j,k)*gm(3,2,i,j,k) &
                   +wok(2,i,j,k)*gm(2,3,i,j,k) )*tenr(0,3,i,j,k)*dt
!
        sf(4,i,j,k)=gm(0,3,i,j,k)*tenr(0,0,i,j,k)*dt &
                   +gm(3,1,i,j,k)*tenr(3,1,i,j,k)*dt &
                   -gm(1,3,i,j,k)*tenr(1,1,i,j,k)*dt &
                   +gm(3,2,i,j,k)*tenr(3,2,i,j,k)*dt &
                   -gm(2,3,i,j,k)*tenr(2,2,i,j,k)*dt &
                   -( sgk(1,3,i,j,k)-wok(1,i,j,k)*gm(1,3,i,j,k) &
                   +wok(3,i,j,k)*gm(3,1,i,j,k) )*tenr(0,1,i,j,k)*dt &
                   -( sgk(2,3,i,j,k)-wok(2,i,j,k)*gm(2,3,i,j,k) &
                   +wok(3,i,j,k)*gm(3,2,i,j,k) )*tenr(0,2,i,j,k)*dt &
                   -( sgk(3,3,i,j,k)-wok(3,i,j,k)*gm(3,3,i,j,k) &
                   +wok(3,i,j,k)*gm(3,3,i,j,k) )*tenr(0,3,i,j,k)*dt
!
!  sf(5,*,*,*) recalculate
!
        sf(5,i,j,k)=sf(5,i,j,k) &
                   +c0*gm(0,1,i,j,k)*tenr(0,1,i,j,k)*dt &
                   +c0*gm(0,2,i,j,k)*tenr(0,2,i,j,k)*dt &
                   +c0*gm(0,3,i,j,k)*tenr(0,3,i,j,k)*dt &
                   -wok(1,i,j,k)*sfo(2,i,j,k)*c0 &
                   -wok(2,i,j,k)*sfo(3,i,j,k)*c0 &
                   -wok(3,i,j,k)*sfo(4,i,j,k)*c0 &
                   -c0*sgk(1,1,i,j,k)*tenr(1,1,i,j,k)*dt &
                   -c0*sgk(1,2,i,j,k)*tenr(1,2,i,j,k)*dt &
                   -c0*sgk(1,3,i,j,k)*tenr(1,3,i,j,k)*dt &
                   -c0*sgk(2,1,i,j,k)*tenr(2,1,i,j,k)*dt &
                   -c0*sgk(2,2,i,j,k)*tenr(2,2,i,j,k)*dt &
                   -c0*sgk(2,3,i,j,k)*tenr(2,3,i,j,k)*dt &
                   -c0*sgk(3,1,i,j,k)*tenr(3,1,i,j,k)*dt &
                   -c0*sgk(3,2,i,j,k)*tenr(3,2,i,j,k)*dt &
                   -c0*sgk(3,3,i,j,k)*tenr(3,3,i,j,k)*dt
!
      enddo
    enddo
  enddo
!
  deallocate( sfo, stat=merr ) 
!
  return
end subroutine kaddsf1
