!--------------------------------------------------------------------
subroutine gravp(pg,dpg,pgi,pgj,pgk,x1,x2,x3,x1a,x2a,x3a, &
                 is1,ie1,js1,je1,ks1,ke1) 
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax, metric, rbh
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: pg(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pgi(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pgj(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pgk(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: dpg(is1:ie1,js1:je1,ks1:ke1)
 
  real(8) :: x1(imax), x2(jmax), x3(kmax), x1a(imax), x2a(jmax), x3a(kmax)

  real(8) :: gcm, bb, rmin, rsp, rspi, rspj, rspk, rcy, rcyi, rcyj, rcyk
!
!  Parameter
!
  bb=0.d0
  rmin=0.d0
!
  gcm=0.5*rbh

  if(metric.ne.1) then
    do k=ks1,ke1
      do j=js1,je1
        do i=is1,ie1
          if( metric.eq.102 .or. metric.eq.2 ) then
           rsp=sqrt(x1(i)*x1(i)+x3(k)*x3(k))
           rspi=sqrt(x1a(i)*x1a(i)+x3(k)*x3(k))
           rspj=sqrt(x1(i)*x1(i)+x3(k)*x3(k))
           rspk=sqrt(x1(i)*x1(i)+x3a(k)*x3a(k))
          
           rcy=x1(i)
           rcyi=x1a(i)
           rcyj=x1(i)
           rcyk=x1(i)
          elseif( metric.eq.203 .or. metric.eq.103 &
                 .or. metric.eq.3 ) then
           rsp=x1(i)
           rspi=x1a(i)
           rspj=x1(i)
           rspk=x1(i)
          
           rcy=x1(i)*sin(x3(k))
           rcyi=x1a(i)*sin(x3(k))
           rcyj=x1(i)*sin(x3(k))
           rcyk=x1(i)*sin(x3a(k))
          else

           rsp=sqrt(x1(i)*x1(i)+x2(j)*x2(j)+x3(k)*x3(k))
           rspi=sqrt(x1a(i)*x1a(i)+x2(j)*x2(j)+x3(k)*x3(k))
           rspj=sqrt(x1(i)*x1(i)+x2a(j)*x2a(j)+x3(k)*x3(k))
           rspk=sqrt(x1(i)*x1(i)+x2(j)*x2(j)+x3a(k)*x3a(k))
          
           rcy=sqrt(x1(i)*x1(i)+x2(j)*x2(j))
           rcyi=sqrt(x1a(i)*x1a(i)+x2(j)*x2(j))
           rcyj=sqrt(x1(i)*x1(i)+x2a(j)*x2a(j))
           rcyk=sqrt(x1(i)*x1(i)+x2(j)*x2(j))
          endif  

          if( rsp.le.bb ) then
            if( bb.lt.rmin ) then
              pg(i,j,k)=gcm*(1.0-1.0/bb)-gcm
              pgi(i,j,k)=gcm*(1.0-1.0/bb)-gcm
              pgj(i,j,k)=gcm*(1.0-1.0/bb)-gcm
              pgk(i,j,k)=gcm*(1.0-1.0/bb)-gcm
              dpg(i,j,k)=0.d0
!
            elseif( bb.ge.rmin ) then
              pg(i,j,k)=gcm*(1.0-1.5/bb+rsp*rsp*0.5/bb**3)-gcm
              pgi(i,j,k)=gcm*(1.0-1.5/bb+rspi*rspi*0.5/bb**3)-gcm
              pgj(i,j,k)=gcm*(1.0-1.5/bb+rspj*rspj*0.5/bb**3)-gcm
              pgk(i,j,k)=gcm*(1.0-1.5/bb+rspk*rspk*0.5/bb**3)-gcm
              dpg(i,j,k)=gcm*rsp/bb**3
            endif
          else
            pg(i,j,k)=gcm*(1.0-1.0/rsp)-gcm
            pgi(i,j,k)=gcm*(1.0-1.0/rspi)-gcm
            pgj(i,j,k)=gcm*(1.0-1.0/rspj)-gcm
            pgk(i,j,k)=gcm*(1.0-1.0/rspk)-gcm
            dpg(i,j,k)=gcm/rsp**2
          endif          

        enddo
      enddo
    enddo
!
  endif
!
  return
end subroutine gravp
