!---------------------------------------------------------------------@
subroutine hll(ww,x1,x2,x3,uri, &
               uriir,uriil,urijr,urijl,urikr,urikl, &
               uuir,uujr,uukr,uuil,uujl,uukl, &
               wwir,wwjr,wwkr,wwil,wwjl,wwkl, &
               cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0, &
               is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate numerical flux by Approximate Riemann Solver 
!
  use pram, only : imax, jmax, kmax, nv, ihll
  implicit none

  integer :: nm0, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uuir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uuil(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujl(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukl(nv,is1:ie1,js1:je1,ks1:ke1)
     
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1), &
             uriir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uriil(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijl(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikl(nv,is1:ie1,js1:je1,ks1:ke1)
     
  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             wwir(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwil(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjl(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkl(nv,is1:ie1,js1:je1,ks1:ke1)
      
  real(8) :: cmaxi(is1:ie1,js1:je1,ks1:ke1), cmini(is1:ie1,js1:je1,ks1:ke1), &
             cmaxj(is1:ie1,js1:je1,ks1:ke1), cminj(is1:ie1,js1:je1,ks1:ke1), &
             cmaxk(is1:ie1,js1:je1,ks1:ke1), cmink(is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: x1(imax), x2(jmax), x3(kmax)
!
!-------------------
      
  if(ihll .eq. 1) then
    call hlle(ww,uuir,uujr,uukr,uuil,uujl,uukl, &
              wwir,wwjr,wwkr,wwil,wwjl,wwkl, &
              cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0, &
              is1,ie1,js1,je1,ks1,ke1)
!
  elseif(ihll .eq. 2) then
    call hllc(ww,uriir,urijr,urikr,uriil,urijl,urikl, &
              uuir,uujr,uukr,uuil,uujl,uukl, &
              wwir,wwjr,wwkr,wwil,wwjl,wwkl, &
              cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0, &
              is1,ie1,js1,je1,ks1,ke1)
!
  elseif(ihll .eq. 3) then
    call hllc2(ww,x1,x2,x3,uriir,urijr,urikr,uriil,urijl,urikl, &
               uuir,uujr,uukr,uuil,uujl,uukl, &
               wwir,wwjr,wwkr,wwil,wwjl,wwkl, &
               cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0, &
               is1,ie1,js1,je1,ks1,ke1)
!       
  elseif(ihll .eq. 4) then
    call hlld2(ww,x1,x2,x3,uri,uriir,uriil,urijr,urijl,urikr,urikl, &
               uuir,uuil,uujr,uujl,uukr,uukl, &
               wwir,wwil,wwjr,wwjl,wwkr,wwkl, &
               cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0, &
               is1,ie1,js1,je1,ks1,ke1)
  endif  

  return
end subroutine hll  
!
!---------------------------------------------------------------------@
subroutine hlle(ww,uuir,uujr,uukr,uuil,uujl,uukl, &
                wwir,wwjr,wwkr,wwil,wwjl,wwkl, &
                cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0, &
                is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate numerical flux by HLLE method
!
  use pram, only : imax, jmax, kmax, nv
  implicit none

  integer :: i, j, k, n
  integer :: nm0, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uuir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uuil(nv,is1:ie1,js1:je1,ks1:ke1), & 
             uujr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujl(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukl(nv,is1:ie1,js1:je1,ks1:ke1)
     
  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             wwir(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwil(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjl(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: cmaxi(is1:ie1,js1:je1,ks1:ke1), cmini(is1:ie1,js1:je1,ks1:ke1), &
             cmaxj(is1:ie1,js1:je1,ks1:ke1), cminj(is1:ie1,js1:je1,ks1:ke1), &
             cmaxk(is1:ie1,js1:je1,ks1:ke1), cmink(is1:ie1,js1:je1,ks1:ke1)
!
!=====================================================================@

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        do n=1,nv
          
          if(cmini(i,j,k) .gt. 0.d0) then
            ww(1,n,i,j,k)=wwil(n,i,j,k)
          elseif(cmini(i,j,k) .le. 0.d0 .and. cmaxi(i,j,k) .gt. 0.d0) then
            ww(1,n,i,j,k)=(cmaxi(i,j,k)*wwil(n,i,j,k) &
                         -cmini(i,j,k)*wwir(n,i,j,k) &
                         +cmaxi(i,j,k)*cmini(i,j,k) &
                         *(uuir(n,i,j,k)-uuil(n,i,j,k))) &
                         /(cmaxi(i,j,k)-cmini(i,j,k)) 
          elseif(cmaxi(i,j,k) .le. 0.d0) then
            ww(1,n,i,j,k)=wwir(n,i,j,k)
          endif
     
!         if(abs(ww(1,n,i,j,k)) .lt. 1.0e-5) then
!          ww(1,n,i,j,k)=0.0
!         endif

          if(cminj(i,j,k) .gt. 0.d0) then
            ww(2,n,i,j,k)=wwjl(n,i,j,k)
          elseif(cminj(i,j,k) .le. 0.d0 .and. cmaxj(i,j,k) .gt. 0.d0) then
            ww(2,n,i,j,k)=(cmaxj(i,j,k)*wwjl(n,i,j,k) &
                         -cminj(i,j,k)*wwjr(n,i,j,k) &
                         +cmaxj(i,j,k)*cminj(i,j,k) &
                         *(uujr(n,i,j,k)-uujl(n,i,j,k))) &
                         /(cmaxj(i,j,k)-cminj(i,j,k))
          elseif(cmaxj(i,j,k) .le. 0.d0) then
            ww(2,n,i,j,k)=wwjr(n,i,j,k)
          endif
     
!         if(abs(ww(2,n,i,j,k)) .lt. 1.0e-5) then
!          ww(2,n,i,j,k)=0.0
!         endif

          if(cmink(i,j,k) .gt. 0.d0) then
            ww(3,n,i,j,k)=wwkl(n,i,j,k)
          elseif(cmink(i,j,k) .le. 0.d0 .and. cmaxk(i,j,k) .gt. 0.d0) then    
            ww(3,n,i,j,k)=(cmaxk(i,j,k)*wwkl(n,i,j,k) &
                         -cmink(i,j,k)*wwkr(n,i,j,k) &
                         +cmaxk(i,j,k)*cmink(i,j,k) &
                         *(uukr(n,i,j,k)-uukl(n,i,j,k))) &
                         /(cmaxk(i,j,k)-cmink(i,j,k))
          elseif(cmaxk(i,j,k) .le. 0.d0) then
            ww(3,n,i,j,k)=wwkr(n,i,j,k)
          endif

!         if(abs(ww(3,n,i,j,k)) .lt. 1.0e-5) then
!          ww(3,n,i,j,k)=0.0
!         endif
!         
        enddo
      enddo
    enddo
  enddo
   
  return
end subroutine hlle
!
!---------------------------------------------------------------------@
subroutine hllc(ww,uriir,urijr,urikr,uriil,urijl,urikl, &
                uuir,uujr,uukr,uuil,uujl,uukl, &
                wwir,wwjr,wwkr,wwil,wwjl,wwkl, &
                cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0, &
                is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate numerical flux by HLLC method
!
  use pram, only : imax, jmax, kmax, nv
  implicit none

  integer :: i, j, k, n
  integer :: nm0, is1, ie1, js1, je1, ks1, ke1, merr  

  real(8) :: uuir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uuil(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujl(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: uuih(:,:,:,:), uujh(:,:,:,:), uukh(:,:,:,:)

  real(8), allocatable:: uuir1(:,:,:,:), uuil1(:,:,:,:), &
           uujr1(:,:,:,:), uujl1(:,:,:,:), uukr1(:,:,:,:), uukl1(:,:,:,:)

  real(8) :: uriir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uriil(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijl(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikl(nv,is1:ie1,js1:je1,ks1:ke1)
     
  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             wwir(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwil(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjl(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: wwih(:,:,:,:), wwjh(:,:,:,:), wwkh(:,:,:,:)

  real(8), allocatable :: wwir1(:,:,:,:), wwil1(:,:,:,:), &
           wwjr1(:,:,:,:), wwjl1(:,:,:,:), wwkr1(:,:,:,:),  wwkl1(:,:,:,:)
      
  real(8) :: cmaxi(is1:ie1,js1:je1,ks1:ke1), cmini(is1:ie1,js1:je1,ks1:ke1), &
             cmaxj(is1:ie1,js1:je1,ks1:ke1), cminj(is1:ie1,js1:je1,ks1:ke1), &
             cmaxk(is1:ie1,js1:je1,ks1:ke1), cmink(is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: cmidi(:,:,:), cmidj(:,:,:), cmidk(:,:,:)

  real(8) :: sxih, eeih, byih, bzih, fsxih, feeih, fbyih, fbzih, &
             syjh, eejh, bxjh, bzjh, fsyjh, feejh, fbxjh, fbzjh, &
             szkh, eekh, bxkh, bykh, fszkh, feekh, fbxkh, fbykh, &
             aa, bb, cc, bx1, by1, bz1, vx1, vy1, vz1, gfsq, vb1, pp1
!
  allocate( uuih(nv,is1:ie1,js1:je1,ks1:ke1), &
            uujh(nv,is1:ie1,js1:je1,ks1:ke1), &
            uukh(nv,is1:ie1,js1:je1,ks1:ke1), & 
            uuir1(nv,is1:ie1,js1:je1,ks1:ke1), &
            uuil1(nv,is1:ie1,js1:je1,ks1:ke1), &
            uujr1(nv,is1:ie1,js1:je1,ks1:ke1), &
            uujl1(nv,is1:ie1,js1:je1,ks1:ke1), &
            uukr1(nv,is1:ie1,js1:je1,ks1:ke1), &
            uukl1(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwih(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwjh(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwkh(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwir1(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwil1(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwjr1(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwjl1(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwkr1(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwkl1(nv,is1:ie1,js1:je1,ks1:ke1), &
            cmidi(is1:ie1,js1:je1,ks1:ke1), cmidj(is1:ie1,js1:je1,ks1:ke1), &
            cmidk(is1:ie1,js1:je1,ks1:ke1), stat=merr ) 
!
!=====================================================================@
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
!
!   new difinition for energy, E = tau + D, F_E= F_tau + Dv
!
        uuir(5,i,j,k)=uuir(5,i,j,k)+uuir(1,i,j,k)
        uujr(5,i,j,k)=uujr(5,i,j,k)+uujr(1,i,j,k)
        uukr(5,i,j,k)=uukr(5,i,j,k)+uukr(1,i,j,k)
        uuil(5,i,j,k)=uuil(5,i,j,k)+uuil(1,i,j,k)
        uujl(5,i,j,k)=uujl(5,i,j,k)+uujl(1,i,j,k)
        uukl(5,i,j,k)=uukl(5,i,j,k)+uukl(1,i,j,k)

        wwir(5,i,j,k)=wwir(5,i,j,k)+wwir(1,i,j,k)
        wwjr(5,i,j,k)=wwjr(5,i,j,k)+wwjr(1,i,j,k)
        wwkr(5,i,j,k)=wwkr(5,i,j,k)+wwkr(1,i,j,k)
        wwil(5,i,j,k)=wwil(5,i,j,k)+wwil(1,i,j,k)
        wwjl(5,i,j,k)=wwjl(5,i,j,k)+wwjl(1,i,j,k)
        wwkl(5,i,j,k)=wwkl(5,i,j,k)+wwkl(1,i,j,k)

      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        do n=1,nv
!
!   Calculatetion of U_hll F_hll
!
          uuih(n,i,j,k)=(cmaxi(i,j,k)*uuir(n,i,j,k) &
                       -cmini(i,j,k)*uuil(n,i,j,k) &
                       -wwir(n,i,j,k)+wwil(n,i,j,k)) &
                       /(cmaxi(i,j,k)-cmini(i,j,k)) 

          uujh(n,i,j,k)=(cmaxj(i,j,k)*uujr(n,i,j,k) &
                       -cminj(i,j,k)*uujl(n,i,j,k) &
                       -wwjr(n,i,j,k)+wwjl(n,i,j,k)) &
                       /(cmaxj(i,j,k)-cminj(i,j,k))

          uukh(n,i,j,k)=(cmaxk(i,j,k)*uukr(n,i,j,k) &
                       -cmink(i,j,k)*uukl(n,i,j,k) &
                       -wwkr(n,i,j,k)+wwkl(n,i,j,k)) &
                       /(cmaxk(i,j,k)-cmink(i,j,k))

          wwih(n,i,j,k)=(cmaxi(i,j,k)*wwil(n,i,j,k) &
                       -cmini(i,j,k)*wwir(n,i,j,k) &
                       +cmaxi(i,j,k)*cmini(i,j,k) &
                       *(uuir(n,i,j,k)-uuil(n,i,j,k))) &
                       /(cmaxi(i,j,k)-cmini(i,j,k))

          wwjh(n,i,j,k)=(cmaxj(i,j,k)*wwjl(n,i,j,k) &
                       -cminj(i,j,k)*wwjr(n,i,j,k) &
                       +cmaxj(i,j,k)*cminj(i,j,k) &
                       *(uujr(n,i,j,k)-uujl(n,i,j,k))) &
                       /(cmaxj(i,j,k)-cminj(i,j,k))

          wwkh(n,i,j,k)=(cmaxk(i,j,k)*wwkl(n,i,j,k) &
                       -cmink(i,j,k)*wwkr(n,i,j,k) &
                       +cmaxk(i,j,k)*cmink(i,j,k) &
                       *(uukr(n,i,j,k)-uukl(n,i,j,k))) &
                       /(cmaxk(i,j,k)-cmink(i,j,k))
!
        enddo
      enddo
    enddo
  enddo     
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
!
!   x-direction
!
        if (uriir(7,i,j,k) .ne. 0.d0 .or. uriil(7,i,j,k) .ne. 0.d0) then
         
          sxih=uuih(2,i,j,k)
          eeih=uuih(5,i,j,k)
          byih=uuih(8,i,j,k)
          bzih=uuih(9,i,j,k)
         
          bx1=uriir(7,i,j,k)
          by1=byih
          bz1=bzih
         
          fsxih=wwih(2,i,j,k)
          feeih=wwih(5,i,j,k)
          fbyih=wwih(8,i,j,k)
          fbzih=wwih(9,i,j,k)
          
          aa= feeih-(byih*fbyih+bzih*fbzih)
          bb= -fsxih-eeih+(byih*byih+bzih*bzih)+(fbyih*fbyih+fbzih*fbzih)
          cc= sxih-(byih*fbyih+bzih*fbzih)
  
          if(aa .eq. 0.d0) then
            vx1=0.d0
          else
            vx1=(-bb-sqrt(bb**2-4.0*aa*cc))/(2.0*aa)
          endif
           
          vy1=(by1*vx1-fbyih)/bx1
          vz1=(bz1*vx1-fbzih)/bx1
          
          cmidi(i,j,k)=vx1
          
          gfsq=1.0-(vx1**2+vy1**2+vz1**2)
          vb1=vx1*bx1+vy1*by1+vz1*bz1
 
          pp1=fsxih-(feeih-bx1*vb1)*vx1+gfsq*bx1**2
  
          uuir1(1,i,j,k)=((cmaxi(i,j,k)-uriir(2,i,j,k))*uuir(1,i,j,k)) &
                        /(cmaxi(i,j,k)-vx1)
          uuir1(3,i,j,k)=(-bx1*(gfsq*by1+vb1*vy1) &
                        +cmaxi(i,j,k)*uuir(3,i,j,k)-wwir(3,i,j,k)) &
                        /(cmaxi(i,j,k)-vx1) 
          uuir1(4,i,j,k)=(-bx1*(gfsq*bz1+vb1*vz1) &
                        +cmaxi(i,j,k)*uuir(4,i,j,k)-wwir(4,i,j,k)) &
                        /(cmaxi(i,j,k)-vx1)
          uuir1(5,i,j,k)=(cmaxi(i,j,k)*uuir(5,i,j,k) &
                        -uuir(2,i,j,k)+pp1*vx1-vb1*bx1) &
                        /(cmaxi(i,j,k)-vx1)
          uuir1(2,i,j,k)=(uuir1(5,i,j,k)+pp1)*vx1-vb1*bx1
          
          uuir1(6,i,j,k)=uuih(6,i,j,k)
          
          uuir1(7,i,j,k)=bx1
          uuir1(8,i,j,k)=by1
          uuir1(9,i,j,k)=bz1
!
          uuil1(1,i,j,k)=((cmini(i,j,k)-uriil(2,i,j,k))*uuil(1,i,j,k)) &
                        /(cmini(i,j,k)-vx1)
          uuil1(3,i,j,k)=(-bx1*(gfsq*by1+vb1*vy1) &
                        +cmini(i,j,k)*uuil(3,i,j,k)-wwil(3,i,j,k)) &
                        /(cmini(i,j,k)-vx1)
          uuil1(4,i,j,k)=(-bx1*(gfsq*bz1+vb1*vz1) &
                        +cmini(i,j,k)*uuil(4,i,j,k)-wwil(4,i,j,k)) &
                        /(cmini(i,j,k)-vx1)
          uuil1(5,i,j,k)=(cmini(i,j,k)*uuil(5,i,j,k) &
                        -uuil(2,i,j,k)+pp1*vx1-vb1*bx1) &
                        /(cmini(i,j,k)-vx1)
          uuil1(2,i,j,k)=(uuil1(5,i,j,k)+pp1)*vx1-vb1*bx1
         
          uuil1(6,i,j,k)=uuih(6,i,j,k)
          
          uuil1(7,i,j,k)=bx1
          uuil1(8,i,j,k)=by1
          uuil1(9,i,j,k)=bz1
          
        else
          
          sxih=uuih(2,i,j,k)
          eeih=uuih(5,i,j,k)
          fsxih=wwih(2,i,j,k)
          feeih=wwih(5,i,j,k)
         
          aa=feeih
          bb=-fsxih-eeih
          cc=sxih

          if(aa .eq. 0.d0) then
            vx1=0.d0
          else
            vx1=(-bb-sqrt(bb**2-4.0*aa*cc))/(2.0*aa)
          endif
          
          pp1=-feeih*vx1+fsxih
          
          cmidi(i,j,k)=vx1
          
          uuir1(1,i,j,k)=((cmaxi(i,j,k)-uriir(2,i,j,k))*uuir(1,i,j,k)) &
                        /(cmaxi(i,j,k)-vx1)
          uuir1(3,i,j,k)=((cmaxi(i,j,k)-uriir(2,i,j,k))*uuir(3,i,j,k)) &
                        /(cmaxi(i,j,k)-vx1)
          uuir1(4,i,j,k)=((cmaxi(i,j,k)-uriir(2,i,j,k))*uuir(4,i,j,k)) &
                        /(cmaxi(i,j,k)-vx1)
          uuir1(5,i,j,k)=(cmaxi(i,j,k)*uuir(5,i,j,k)-uuir(2,i,j,k)+pp1*vx1) &
                         /(cmaxi(i,j,k)-vx1)
          uuir1(2,i,j,k)=(uuir1(5,i,j,k)+pp1)*vx1
        
          uuir1(6,i,j,k)=uuih(6,i,j,k)
         
          uuir1(7,i,j,k)=0.d0
         
          uuir1(8,i,j,k)=((cmaxi(i,j,k)-uriir(2,i,j,k))*uuir(8,i,j,k)) &
                        /(cmaxi(i,j,k)-vx1)
          uuir1(9,i,j,k)=((cmaxi(i,j,k)-uriir(2,i,j,k))*uuir(9,i,j,k)) &
                        /(cmaxi(i,j,k)-vx1)
!
          uuil1(1,i,j,k)=((cmini(i,j,k)-uriil(2,i,j,k))*uuil(1,i,j,k)) &
                        /(cmini(i,j,k)-vx1)
          uuil1(3,i,j,k)=((cmini(i,j,k)-uriil(2,i,j,k))*uuil(3,i,j,k)) &
                        /(cmini(i,j,k)-vx1)
          uuil1(4,i,j,k)=((cmini(i,j,k)-uriil(2,i,j,k))*uuil(4,i,j,k)) &
                        /(cmini(i,j,k)-vx1)
          uuil1(5,i,j,k)=(cmini(i,j,k)*uuil(5,i,j,k)-uuil(2,i,j,k)+pp1*vx1) &
                        /(cmini(i,j,k)-vx1)
          uuil1(2,i,j,k)=(uuil1(5,i,j,k)+pp1)*vx1
          
          uuil1(6,i,j,k)=uuih(6,i,j,k)
          
          uuil1(7,i,j,k)=0.d0
          
          uuil1(8,i,j,k)=((cmini(i,j,k)-uriil(2,i,j,k))*uuil(8,i,j,k)) &
                        /(cmini(i,j,k)-vx1)
          uuil1(9,i,j,k)=((cmini(i,j,k)-uriil(2,i,j,k))*uuil(9,i,j,k)) &
                        /(cmini(i,j,k)-vx1)
     
        endif
!
!   y-direction
!
        if (urijr(8,i,j,k) .ne. 0.d0 .or. urijl(8,i,j,k) .ne. 0.d0) then
         
          syjh=uujh(3,i,j,k)
          eejh=uujh(5,i,j,k)
          bxjh=uujh(7,i,j,k)
          bzjh=uujh(9,i,j,k)
         
          bx1=bxjh
          by1=urijr(8,i,j,k)
          bz1=bzjh
          
          fsyjh=wwjh(3,i,j,k)
          feejh=wwjh(5,i,j,k)
          fbxjh=wwjh(7,i,j,k)
          fbzjh=wwjh(9,i,j,k)
          
          aa= feejh-(bxjh*fbxjh+bzjh*fbzjh)
          bb= -fsyjh-eejh+(bxjh*bxjh+bzjh*bzjh)+(fbxjh*fbxjh+fbzjh*fbzjh)
          cc= syjh-(bxjh*fbxjh+bzjh*fbzjh)
  
          if(aa .eq. 0.d0) then
            vy1=0.d0
          else
            vy1=(-bb-sqrt(bb**2-4.0*aa*cc))/(2.0*aa)
          endif
          
          vx1=(bx1*vy1-fbxjh)/by1
          vz1=(bz1*vy1-fbzjh)/by1
         
          cmidj(i,j,k)=vy1
          
          gfsq=1.0-(vx1**2+vy1**2+vz1**2)
          vb1=vx1*bx1+vy1*by1+vz1*bz1
  
          pp1=fsyjh-(feejh-by1*vb1)*vy1+gfsq*by1**2
  
          uujr1(1,i,j,k)=((cmaxj(i,j,k)-urijr(3,i,j,k))*uujr(1,i,j,k)) &
                        /(cmaxj(i,j,k)-vy1)
          uujr1(2,i,j,k)=(-by1*(gfsq*bx1+vb1*vx1) &
                        +cmaxj(i,j,k)*uujr(2,i,j,k)-wwjr(2,i,j,k)) &
                        /(cmaxj(i,j,k)-vy1)
          uujr1(4,i,j,k)=(-by1*(gfsq*bz1+vb1*vz1) &
                        +cmaxj(i,j,k)*uujr(4,i,j,k)-wwjr(4,i,j,k)) &
                        /(cmaxj(i,j,k)-vy1)
          uujr1(5,i,j,k)=(cmaxj(i,j,k)*uujr(5,i,j,k) &
                        -uujr(3,i,j,k)+pp1*vy1-vb1*by1) &
                        /(cmaxj(i,j,k)-vy1)
          uujr1(3,i,j,k)=(uujr1(5,i,j,k)+pp1)*vy1-vb1*by1
         
          uujr1(6,i,j,k)=uujh(6,i,j,k)
         
          uujr1(7,i,j,k)=bx1
          uujr1(8,i,j,k)=by1
          uujr1(9,i,j,k)=bz1
         
          uujl1(1,i,j,k)=((cminj(i,j,k)-urijl(3,i,j,k))*uujl(1,i,j,k)) &
                        /(cminj(i,j,k)-vy1)
          uujl1(2,i,j,k)=(-by1*(gfsq*bx1+vb1*vx1) &
                        +cminj(i,j,k)*uujl(2,i,j,k)-wwjl(2,i,j,k)) &
                        /(cminj(i,j,k)-vy1)
          uujl1(4,i,j,k)=(-by1*(gfsq*bz1+vb1*vz1) &
                        +cminj(i,j,k)*uujl(4,i,j,k)-wwjl(4,i,j,k)) &
                        /(cminj(i,j,k)-vy1)
          uujl1(5,i,j,k)=(cminj(i,j,k)*uujl(5,i,j,k) &
                        -uujl(3,i,j,k)+pp1*vy1-vb1*by1) &
                        /(cminj(i,j,k)-vy1)
          uujl1(3,i,j,k)=(uujl1(5,i,j,k)+pp1)*vy1-vb1*by1
         
          uujl1(6,i,j,k)=uujh(6,i,j,k)
         
          uujl1(7,i,j,k)=bx1
          uujl1(8,i,j,k)=by1
          uujl1(9,i,j,k)=bz1
         
        else
          
          syjh=uujh(3,i,j,k)
          eejh=uujh(5,i,j,k)
          fsyjh=wwjh(3,i,j,k)
          feejh=wwjh(5,i,j,k)
          
          aa=feejh
          bb=-fsyjh-eejh
          cc=syjh

          if(aa .eq. 0.d0) then 
            vy1=0.d0
          else
            vy1=(-bb-sqrt(bb**2-4.0*aa*cc))/(2.0*aa)
          endif
         
          pp1=-feejh*vy1+fsyjh
          
          cmidj(i,j,k)=vy1
          
          uujr1(1,i,j,k)=((cmaxj(i,j,k)-urijr(3,i,j,k))*uujr(1,i,j,k)) &
                        /(cmaxj(i,j,k)-vy1)
          uujr1(2,i,j,k)=((cmaxj(i,j,k)-urijr(3,i,j,k))*uujr(2,i,j,k)) &
                        /(cmaxj(i,j,k)-vy1)
          uujr1(4,i,j,k)=((cmaxj(i,j,k)-urijr(3,i,j,k))*uujr(4,i,j,k)) &
                        /(cmaxj(i,j,k)-vy1)
          uujr1(5,i,j,k)=(cmaxj(i,j,k)*uujr(5,i,j,k)-uujr(3,i,j,k)+pp1*vy1) &
                        /(cmaxj(i,j,k)-vy1)
          uujr1(3,i,j,k)=(uujr1(5,i,j,k)+pp1)*vy1
         
          uujr1(6,i,j,k)=uujh(6,i,j,k)
         
          uujr1(7,i,j,k)=((cmaxj(i,j,k)-urijr(3,i,j,k))*uujr(7,i,j,k)) &
                        /(cmaxj(i,j,k)-vy1)
          uujr1(8,i,j,k)=0.d0
          
          uujr1(9,i,j,k)=((cmaxj(i,j,k)-urijr(3,i,j,k))*uujr(9,i,j,k)) &
                        /(cmaxj(i,j,k)-vy1)
!
          uujl1(1,i,j,k)=((cminj(i,j,k)-urijl(3,i,j,k))*uujl(1,i,j,k)) &
                        /(cminj(i,j,k)-vy1)
          uujl1(2,i,j,k)=((cminj(i,j,k)-urijl(3,i,j,k))*uujl(2,i,j,k)) &
                        /(cminj(i,j,k)-vy1)
          uujl1(4,i,j,k)=((cminj(i,j,k)-urijl(3,i,j,k))*uujl(4,i,j,k)) &
                        /(cminj(i,j,k)-vy1)
          uujl1(5,i,j,k)=(cminj(i,j,k)*uujl(5,i,j,k)-uujl(3,i,j,k)+pp1*vy1) &
                        /(cminj(i,j,k)-vy1)
          uujl1(3,i,j,k)=(uujl1(5,i,j,k)+pp1)*vy1
         
          uujl1(6,i,j,k)=uujh(6,i,j,k)
          
          uujl1(7,i,j,k)=((cminj(i,j,k)-urijl(3,i,j,k))*uujl(7,i,j,k)) &
                        /(cminj(i,j,k)-vy1)
          uujl1(8,i,j,k)=0.d0
          uujl1(9,i,j,k)=((cminj(i,j,k)-urijl(3,i,j,k))*uujl(9,i,j,k)) &
                        /(cminj(i,j,k)-vy1)
        
        endif
!
!   z-direction
!
        if (urikr(9,i,j,k) .ne. 0.d0 .or. urikl(9,i,j,k) .ne. 0.d0) then
         
          szkh=uukh(4,i,j,k)
          eekh=uukh(5,i,j,k)
          bxkh=uukh(7,i,j,k)
          bykh=uukh(8,i,j,k)
         
          bx1=bxkh
          by1=bykh
          by1=urikr(9,i,j,k)
          
          fszkh=wwkh(4,i,j,k)
          feekh=wwkh(5,i,j,k)
          fbxkh=wwkh(7,i,j,k)
          fbykh=wwkh(8,i,j,k)
         
          aa= feekh-(bxkh*fbxkh+bykh*fbykh)
          bb= -fszkh-eekh+(bxkh*bxkh+bykh*bykh)+(fbxkh*fbxkh+fbykh*fbykh)
          cc= szkh-(bxkh*fbxkh+bykh*fbykh)
  
          if(aa .eq. 0.d0) then
            vz1=0.d0
          else
            vz1=(-bb-sqrt(bb**2-4.0*aa*cc))/(2.0*aa)
          endif
          
          vx1=(bx1*vz1-fbxkh)/bz1
          vy1=(by1*vz1-fbykh)/bz1
         
          cmidk(i,j,k)=vz1
          
          gfsq=1.0-(vx1**2+vy1**2+vz1**2)
          vb1=vx1*bx1+vy1*by1+vz1*bz1
  
          pp1=fszkh-(feekh-bz1*vb1)*vz1+gfsq*bz1**2
  
          uukr1(1,i,j,k)=((cmaxk(i,j,k)-urikr(4,i,j,k))*uukr(1,i,j,k)) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(2,i,j,k)=(-bz1*(gfsq*bx1+vb1*vx1) &
                        +cmaxk(i,j,k)*uukr(2,i,j,k)-wwkr(2,i,j,k)) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(3,i,j,k)=(-bz1*(gfsq*by1+vb1*vy1) &
                        +cmaxk(i,j,k)*uukr(3,i,j,k)-wwkr(3,i,j,k)) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(5,i,j,k)=(cmaxk(i,j,k)*uukr(5,i,j,k) &
                        -uukr(4,i,j,k)+pp1*vz1-vb1*bz1) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(4,i,j,k)=(uukr1(5,i,j,k)+pp1)*vz1-vb1*bz1
         
          uukr1(6,i,j,k)=uukh(6,i,j,k)
          
          uukr1(7,i,j,k)=bx1
          uukr1(8,i,j,k)=by1
          uukr1(9,i,j,k)=bz1
          
          uukl1(1,i,j,k)=((cmink(i,j,k)-urikl(4,i,j,k))*uukl(1,i,j,k)) &
                        /(cmink(i,j,k)-vz1)
          uukl1(2,i,j,k)=(-bz1*(gfsq*bx1+vb1*vx1) &
                        +cmink(i,j,k)*uukl(2,i,j,k)-wwkl(2,i,j,k)) &
                        /(cmink(i,j,k)-vz1)
          uukl1(3,i,j,k)=(-bz1*(gfsq*by1+vb1*vz1) &
                        +cmink(i,j,k)*uukl(3,i,j,k)-wwkl(3,i,j,k)) &
                        /(cmink(i,j,k)-vz1)
          uukl1(5,i,j,k)=(cmink(i,j,k)*uukl(5,i,j,k) &
                        -uukl(4,i,j,k)+pp1*vz1-vb1*bz1) &
                        /(cmink(i,j,k)-vz1)
          uukl1(4,i,j,k)=(uukl1(5,i,j,k)+pp1)*vy1-vb1*bz1
         
          uukl1(6,i,j,k)=uukh(6,i,j,k)
         
          uukl1(7,i,j,k)=bx1
          uukl1(8,i,j,k)=by1
          uukl1(9,i,j,k)=bz1
         
        else
          
          szkh=uukh(4,i,j,k)
          eekh=uukh(5,i,j,k)
          fszkh=wwkh(4,i,j,k)
          feekh=wwkh(5,i,j,k)
         
          aa=feekh
          bb=-fszkh-eekh
          cc=szkh
          
          if(aa .eq. 0.d0) then
            vz1=0.d0
          else
            vz1=(-bb-sqrt(bb**2-4.0*aa*cc))/(2.0*aa)
          endif
          
          pp1=-feekh*vz1+fszkh
          
          cmidk(i,j,k)=vz1
          
          uukr1(1,i,j,k)=((cmaxk(i,j,k)-urikr(4,i,j,k))*uukr(1,i,j,k)) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(2,i,j,k)=((cmaxk(i,j,k)-urikr(4,i,j,k))*uukr(2,i,j,k)) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(3,i,j,k)=((cmaxk(i,j,k)-urikr(4,i,j,k))*uukr(3,i,j,k)) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(5,i,j,k)=(cmaxk(i,j,k)*uukr(5,i,j,k)-uukr(4,i,j,k)+pp1*vz1) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(4,i,j,k)=(uukr1(5,i,j,k)+pp1)*vz1
         
          uukr1(6,i,j,k)=uukh(6,i,j,k)
          
          uukr1(7,i,j,k)=((cmaxk(i,j,k)-urikr(4,i,j,k))*uukr(7,i,j,k)) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(8,i,j,k)=((cmaxk(i,j,k)-urikr(4,i,j,k))*uukr(8,i,j,k)) &
                        /(cmaxk(i,j,k)-vz1)
          uukr1(9,i,j,k)=0.d0
!
          uukl1(1,i,j,k)=((cmink(i,j,k)-urikl(4,i,j,k))*uukl(1,i,j,k)) &
                        /(cmink(i,j,k)-vz1)
          uukl1(2,i,j,k)=((cmink(i,j,k)-urikl(4,i,j,k))*uukl(2,i,j,k)) &
                        /(cmink(i,j,k)-vz1)
          uukl1(3,i,j,k)=((cmink(i,j,k)-urikl(4,i,j,k))*uukl(3,i,j,k)) &
                        /(cmink(i,j,k)-vz1)
          uukl1(5,i,j,k)=(cmink(i,j,k)*uukl(5,i,j,k)-uukl(4,i,j,k)+pp1*vz1) &
                        /(cmink(i,j,k)-vz1)
          uukl1(4,i,j,k)=(uukl1(5,i,j,k)+pp1)*vz1
         
          uukl1(6,i,j,k)=uukh(6,i,j,k)
          uukl1(7,i,j,k)=((cmink(i,j,k)-urikl(4,i,j,k))*uukl(7,i,j,k)) &
                        /(cmink(i,j,k)-vz1)
          uukl1(8,i,j,k)=((cmink(i,j,k)-urikl(4,i,j,k))*uukl(8,i,j,k)) &
                        /(cmink(i,j,k)-vz1)
          uukl1(9,i,j,k)=0.d0
        
        endif
!
      enddo
    enddo
  enddo
 
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        do n=1,nv
          
          wwir1(n,i,j,k)=wwir(n,i,j,k)+cmaxi(i,j,k)*uuir1(n,i,j,k) &
                        -cmaxi(i,j,k)*uuir(n,i,j,k)
          wwil1(n,i,j,k)=wwil(n,i,j,k)+cmini(i,j,k)*uuil1(n,i,j,k) &
                        -cmini(i,j,k)*uuil(n,i,j,k)
  
          wwjr1(n,i,j,k)=wwjr(n,i,j,k)+cmaxj(i,j,k)*uujr1(n,i,j,k) &
                        -cmaxj(i,j,k)*uujr(n,i,j,k)
          wwjl1(n,i,j,k)=wwjl(n,i,j,k)+cminj(i,j,k)*uujl1(n,i,j,k) &
                        -cminj(i,j,k)*uujl(n,i,j,k)
     
          wwkr1(n,i,j,k)=wwkr(n,i,j,k)+cmaxk(i,j,k)*uukr1(n,i,j,k) &
                        -cmaxk(i,j,k)*uukr(n,i,j,k)
          wwkl1(n,i,j,k)=wwkl(n,i,j,k)+cmink(i,j,k)*uukl1(n,i,j,k) &
                        -cmink(i,j,k)*uukl(n,i,j,k)
  
        enddo
      enddo
    enddo
  enddo
  
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
!
!   recover difinition of energy, tau = E - D, F_tau= F_E - Dv
!
        wwir1(5,i,j,k)=wwir1(5,i,j,k)-wwir1(1,i,j,k)
        wwjr1(5,i,j,k)=wwjr1(5,i,j,k)-wwjr1(1,i,j,k)
        wwkr1(5,i,j,k)=wwkr1(5,i,j,k)-wwkr1(1,i,j,k)
        wwil1(5,i,j,k)=wwil1(5,i,j,k)-wwil1(1,i,j,k)
        wwjl1(5,i,j,k)=wwjl1(5,i,j,k)-wwjl1(1,i,j,k)
        wwkl1(5,i,j,k)=wwkl1(5,i,j,k)-wwkl1(1,i,j,k)
!
      enddo
    enddo
  enddo
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        do n=1,nv
         
          if(cmini(i,j,k) .gt. 0.d0) then
            ww(1,n,i,j,k)=wwil(n,i,j,k)
          elseif(cmini(i,j,k) .le. 0.d0 .and. cmidi(i,j,k) .gt. 0.d0) then
            ww(1,n,i,j,k)=wwil1(n,i,j,k)
          elseif(cmidi(i,j,k) .le. 0.d0 .and. cmaxi(i,j,k) .gt. 0.d0) then
            ww(1,n,i,j,k)=wwir1(n,i,j,k)
          elseif(cmaxi(i,j,k) .le. 0.d0) then
            ww(1,n,i,j,k)=wwir(n,i,j,k)
          endif
          
          if(cminj(i,j,k) .gt. 0.d0) then
            ww(2,n,i,j,k)=wwjl(n,i,j,k)
          elseif(cminj(i,j,k) .le. 0.d0 .and. cmidj(i,j,k) .gt. 0.d0) then
            ww(2,n,i,j,k)=wwjl1(n,i,j,k)
          elseif(cmidj(i,j,k) .le. 0.d0 .and. cmaxj(i,j,k) .gt. 0.d0) then
            ww(2,n,i,j,k)=wwjr1(n,i,j,k)
          elseif(cmaxj(i,j,k) .le. 0.d0) then
            ww(2,n,i,j,k)=wwjr(n,i,j,k)
          endif
          
          if(cmink(i,j,k) .gt. 0.d0) then
            ww(3,n,i,j,k)=wwkl(n,i,j,k)
          elseif(cmink(i,j,k) .le. 0.d0 .and. cmidk(i,j,k) .gt. 0.d0) then
            ww(3,n,i,j,k)=wwkl1(n,i,j,k)
          elseif(cmidk(i,j,k) .le. 0.d0 .and. cmaxk(i,j,k) .gt. 0.d0) then
            ww(3,n,i,j,k)=wwkr1(n,i,j,k)
          elseif(cmaxk(i,j,k) .le. 0.d0) then
            ww(3,n,i,j,k)=wwkr(n,i,j,k)
          endif
          
        enddo
      enddo
    enddo
  enddo
!
  deallocate( uuih, uujh, uukh, uuir1, uuil1, uujr1, uujl1, uukr1, uukl1, &
              wwih, wwjh, wwkh, wwir1, wwil1, wwjr1, wwjl1, wwkr1, wwkl1, &
              cmidi, cmidj, cmidk, stat=merr )
!
  return
end subroutine hllc
!
!---------------------------------------------------------------------@
subroutine hllc2(ww,x1,x2,x3,uriir,urijr,urikr,uriil,urijl,urikl, &
                 uuir,uujr,uukr,uuil,uujl,uukl, &
                 wwir,wwjr,wwkr,wwil,wwjl,wwkl, &
                 cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0, &
                 is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate numerical flux by HLLC scheme 
!    (Honkkila & Janhunen 2007)
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, ieos, iwvec, &
                   iter, iflag
  implicit none

  integer :: i, j, k, n
  integer :: nm0, is1, ie1, js1, je1, ks1, ke1, merr

  real(8) :: uuir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uuil(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujl(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: uuih(:,:,:,:), uujh(:,:,:,:), uukh(:,:,:,:)

  real(8), allocatable :: uuihr(:,:,:,:), uuihl(:,:,:,:), &
           uujhr(:,:,:,:), uujhl(:,:,:,:), uukhr(:,:,:,:), uukhl(:,:,:,:)
     
  real(8) :: uriir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uriil(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijl(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: uriih(:,:,:,:), urijh(:,:,:,:), urikh(:,:,:,:)
     
  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             wwir(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwil(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjl(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkl(nv,is1:ie1,js1:je1,ks1:ke1)
      
  real(8) :: cmaxi(is1:ie1,js1:je1,ks1:ke1), cmini(is1:ie1,js1:je1,ks1:ke1), &
             cmaxj(is1:ie1,js1:je1,ks1:ke1), cminj(is1:ie1,js1:je1,ks1:ke1), &
             cmaxk(is1:ie1,js1:je1,ks1:ke1), cmink(is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: cmidi(:,:,:), cmidj(:,:,:), cmidk(:,:,:)

  real(8) :: x1(imax), x2(jmax), x3(kmax)

  integer, allocatable :: iflxi(:,:,:), iflxj(:,:,:), iflxk(:,:,:)      
   
  real(8) :: clmdi, crmdi, vvih, bbih, vbih, b2ih, ptih, &
             roihl, vxihl, vyihl, vzihl, ppihl, bxihl, byihl, bzihl, &
             vvil, gfil, vvihl, gfihl, rohihl, roeihl, bbihl, vbihl, &
             denrihl, eemihl, cil, tauil, ftauil, gil, cyil, czil, &
             syil, szil, fsyil, fszil, b2ihl, tauihl, &
             roihr, vxihr, vyihr, vzihr, ppihr, bxihr, byihr, bzihr, &
             vvir, gfir, vvihr, gfihr, rohihr, roeihr, bbihr, vbihr, &
             denrihr, eemihr, cir, tauir, ftauir, gir, cyir, czir, &
             syir, szir, fsyir, fszir, b2ihr, tauihr, &
             clmdj, crmdj, vvjh, bbjh, vbjh, b2jh, ptjh, &
             rojhl, vxjhl, vyjhl, vzjhl, ppjhl, bxjhl, byjhl, bzjhl, &
             vvjl, gfjl, vvjhl, gfjhl, rohjhl, roejhl, bbjhl, vbjhl, &
             denrjhl, eemjhl, cjl, taujl, ftaujl, gjl, cxjl, czjl, &
             sxjl, szjl, fsxjl, fszjl, b2jhl, taujhl, &
             rojhr, vxjhr, vyjhr, vzjhr, ppjhr, bxjhr, byjhr, bzjhr, &
             vvjr, gfjr, vvjhr, gfjhr, rohjhr, roejhr, bbjhr, vbjhr, &
             denrjhr, eemjhr, cjr, taujr, ftaujr, gjr, cxjr, czjr, &
             sxjr, szjr, fsxjr, fszjr, b2jhr, taujhr, &
             clmdk, crmdk, vvkh, bbkh, vbkh, b2kh, ptkh, &
             rokhl, vxkhl, vykhl, vzkhl, ppkhl, bxkhl, bykhl, bzkhl, &
             vvkl, gfkl, vvkhl, gfkhl, rohkhl, roekhl, bbkhl, vbkhl, &
             denrkhl, eemkhl, ckl, taukl, ftaukl, gkl, cxkl, cykl, &
             sxkl, sykl, fsxkl, fsykl, b2khl, taukhl, &
             rokhr, vxkhr, vykhr, vzkhr, ppkhr, bxkhr, bykhr, bzkhr, &
             vvkr, gfkr, vvkhr, gfkhr, rohkhr, roekhr, bbkhr, vbkhr, &
             denrkhr, eemkhr, ckr, taukr, ftaukr, gkr, cxkr, cykr, &
             sxkr, sykr, fsxkr, fsykr, b2khr, taukhr
!
  allocate( uuih(nv,is1:ie1,js1:je1,ks1:ke1), &
            uujh(nv,is1:ie1,js1:je1,ks1:ke1), &
            uukh(nv,is1:ie1,js1:je1,ks1:ke1), &
            uuihr(nv,is1:ie1,js1:je1,ks1:ke1), &
            uuihl(nv,is1:ie1,js1:je1,ks1:ke1), &
            uujhr(nv,is1:ie1,js1:je1,ks1:ke1), &
            uujhl(nv,is1:ie1,js1:je1,ks1:ke1), &
            uukhr(nv,is1:ie1,js1:je1,ks1:ke1), &
            uukhl(nv,is1:ie1,js1:je1,ks1:ke1), &
            uriih(nv,is1:ie1,js1:je1,ks1:ke1), &
            urijh(nv,is1:ie1,js1:je1,ks1:ke1), &
            urikh(nv,is1:ie1,js1:je1,ks1:ke1), &
            cmidi(is1:ie1,js1:je1,ks1:ke1), cmidj(is1:ie1,js1:je1,ks1:ke1), &
            cmidk(is1:ie1,js1:je1,ks1:ke1), &
            iflxi(is1:ie1,js1:je1,ks1:ke1), iflxj(is1:ie1,js1:je1,ks1:ke1), &
            iflxk(is1:ie1,js1:je1,ks1:ke1), stat=merr )
!
!=====================================================================@

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        do n=1,nv
!
!  Check state & Calculatetion of U_hll
!        
          iflxi(i,j,k)=0
          if(cmini(i,j,k) .gt. 0.d0) then
            ww(1,n,i,j,k)=wwil(n,i,j,k)
            iflxi(i,j,k)=1
          elseif(cmaxi(i,j,k) .le. 0.d0) then 
            ww(1,n,i,j,k)=wwir(n,i,j,k)
            iflxi(i,j,k)=1
          else
            uuih(n,i,j,k)=(cmaxi(i,j,k)*uuir(n,i,j,k) &
                         -cmini(i,j,k)*uuil(n,i,j,k) &
                         -wwir(n,i,j,k)+wwil(n,i,j,k)) &
                         /(cmaxi(i,j,k)-cmini(i,j,k))
          endif
!
          iflxj(i,j,k)=0
          if(cminj(i,j,k) .gt. 0.d0) then
            ww(2,n,i,j,k)=wwjl(n,i,j,k)
            iflxj(i,j,k)=1
          elseif(cmaxj(i,j,k) .le. 0.d0) then 
            ww(2,n,i,j,k)=wwjr(n,i,j,k)
            iflxj(i,j,k)=1
          else
            uujh(n,i,j,k)=(cmaxj(i,j,k)*uujr(n,i,j,k) &
                         -cminj(i,j,k)*uujl(n,i,j,k) &
                         -wwjr(n,i,j,k)+wwjl(n,i,j,k)) &
                         /(cmaxj(i,j,k)-cminj(i,j,k))
          endif

          iflxk(i,j,k)=0
          if(cmink(i,j,k) .gt. 0.d0) then
            ww(3,n,i,j,k)=wwkl(n,i,j,k)
            iflxk(i,j,k)=1
          elseif(cmaxk(i,j,k) .le. 0.d0) then 
            ww(3,n,i,j,k)=wwkr(n,i,j,k)
            iflxk(i,j,k)=1
          else
            uukh(n,i,j,k)=(cmaxk(i,j,k)*uukr(n,i,j,k) &
                         -cmink(i,j,k)*uukl(n,i,j,k) &
                         -wwkr(n,i,j,k)+wwkl(n,i,j,k)) &
                         /(cmaxk(i,j,k)-cmink(i,j,k))
          endif

        enddo
      enddo
    enddo
  enddo
!
! Calculation of premitive 1-state HLL variables
!
  if( iwvec.eq.6 ) then
    call recov1d(uuih,uriih,x1,x2,x3,nm0,is1,ie1,js1,je1,ks1,ke1)
    call recov1d(uujh,urijh,x1,x2,x3,nm0,is1,ie1,js1,je1,ks1,ke1)
    call recov1d(uukh,urikh,x1,x2,x3,nm0,is1,ie1,js1,je1,ks1,ke1)
  elseif( iwvec.eq.7 ) then
    call recov2da(uuih,uriih,x1,x2,x3,nm0,iflxi,is1,ie1,js1,je1,ks1,ke1)
    call recov2da(uujh,urijh,x1,x2,x3,nm0,iflxj,is1,ie1,js1,je1,ks1,ke1)
    call recov2da(uukh,urikh,x1,x2,x3,nm0,iflxk,is1,ie1,js1,je1,ks1,ke1)
  endif
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
!
!   x-direction
!
        if(iflxi(i,j,k) .eq. 0) then
!
          if(uriih(7,i,j,k) .ne. 0.d0) then
            cmidi(i,j,k)=uriih(2,i,j,k)
          
            clmdi=cmini(i,j,k)-cmidi(i,j,k)
            crmdi=cmaxi(i,j,k)-cmidi(i,j,k)
          
            vxihl=uriih(2,i,j,k)
            vyihl=uriih(3,i,j,k)
            vzihl=uriih(4,i,j,k)
            ppihl=uriih(5,i,j,k)
            bxihl=uriih(7,i,j,k)
            byihl=uriih(8,i,j,k)
            bzihl=uriih(9,i,j,k)
          
            vxihr=uriih(2,i,j,k)
            vyihr=uriih(3,i,j,k)
            vzihr=uriih(4,i,j,k)
            ppihr=uriih(5,i,j,k)
            bxihr=uriih(7,i,j,k)
            byihr=uriih(8,i,j,k)
            bzihr=uriih(9,i,j,k)
!
! Cal rho*_a
!
            vvil=uriil(2,i,j,k)**2+uriil(3,i,j,k)**2+uriil(4,i,j,k)**2
            gfil=1./sqrt(1.-vvil)
            vvihl=vxihl**2+vyihl**2+vzihl**2
            gfihl=1./sqrt(1.-vvihl)
            roihl=gfil*uriil(1,i,j,k)*(cmini(i,j,k)-vxihl)/(gfihl*clmdi)
          
            vvir=uriir(2,i,j,k)**2+uriir(3,i,j,k)**2+uriir(4,i,j,k)**2
            gfir=1./sqrt(1.-vvir)
            vvihr=vxihr**2+vyihr**2+vzihr**2
            gfihr=1./sqrt(1.-vvihr)
            roihr=gfir*uriir(1,i,j,k)*(cmaxi(i,j,k)-vxihr)/(gfihr*crmdi)
!cc
            if(ieos .eq. 0) then
              rohihl=roihl+(gam/(gam-1.0))*ppihl
              rohihr=roihr+(gam/(gam-1.0))*ppihr
            elseif(ieos .eq. 1) then
              rohihl=(5./2.)*ppihl+sqrt((9./4.)*ppihl**2+roihl**2)
              rohihr=(5./2.)*ppihr+sqrt((9./4.)*ppihr**2+roihr**2)
            elseif(ieos .eq. 2) then
              roeihl=(3./2.)*(ppihl+((3.*ppihl**2)/(2.0*roihl &
                    +sqrt(2.*ppihl**2+4.*roihl**2)) ))
              roeihr=(3./2.)*(ppihr+((3.*ppihr**2)/(2.0*roihr &
                    +sqrt(2.*ppihr**2+4.*roihr**2)) ))
              rohihl=roihl+roeihl+ppihl
              rohihr=roihl+roeihr+ppihr
            endif
          
            bbihl=bxihl**2+byihl**2+bzihl**2
            bbihr=bxihr**2+byihr**2+bzihr**2
            vbihl=vxihl*bxihl+vyihl*byihl+vzihl*bzihl
            vbihr=vxihr*bxihr+vyihr*byihr+vzihr*bzihr
!
            denrihl=gfihl**2*rohihl
            denrihr=gfihr**2*rohihr
            eemihl=0.5*(bbihl+vvihl*bbihl-vbihl**2)
            eemihr=0.5*(bbihr+vvihr*bbihr-vbihr**2)
          
            uuihl(1,i,j,k)=gfihl*roihl
            uuihl(2,i,j,k)=(denrihl+bbihl)*vxihl-vbihl*bxihl
            uuihl(3,i,j,k)=(denrihl+bbihl)*vyihl-vbihl*byihl
            uuihl(4,i,j,k)=(denrihl+bbihl)*vzihl-vbihl*bzihl
            uuihl(5,i,j,k)=denrihl-ppihl+eemihl-gfihl*roihl
          
            if( iflag(6).le.1 ) then
              uuihl(6,i,j,k)=gfihl*roihl*x1(i)
            elseif( iflag(6).le.3 ) then
              uuihl(6,i,j,k)=gfihl*ppihl/roihl**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uuihl(6,i,j,k)=gfihl*roihl*log(ppihl/roihl**gam)
            endif         
           
            uuihl(7,i,j,k)=bxihl
            uuihl(8,i,j,k)=byihl
            uuihl(9,i,j,k)=bzihl
          
            uuihr(1,i,j,k)=gfihr*roihr
            uuihr(2,i,j,k)=(denrihr+bbihr)*vxihr-vbihr*bxihr
            uuihr(3,i,j,k)=(denrihr+bbihr)*vyihr-vbihr*byihr
            uuihr(4,i,j,k)=(denrihr+bbihr)*vzihr-vbihr*bzihr
            uuihr(5,i,j,k)=denrihr-ppihr+eemihr-gfihr*roihr
          
            if( iflag(6).le.1 ) then
              uuihr(6,i,j,k)=gfihr*roihr*x1(i)
            elseif( iflag(6).le.3 ) then
              uuihr(6,i,j,k)=gfihr*ppihr/roihr**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uuihr(6,i,j,k)=gfihr*roihr*log(ppihr/roihr**gam)
            endif         
           
            uuihr(7,i,j,k)=bxihr
            uuihr(8,i,j,k)=byihr
            uuihr(9,i,j,k)=bzihr
          
          else
            bxihl=0.d0
            bxihr=0.d0
! 
! intremediate wave speed
!          
            cmidi(i,j,k)=uriih(2,i,j,k)
          
            clmdi=cmini(i,j,k)-cmidi(i,j,k)
            crmdi=cmaxi(i,j,k)-cmidi(i,j,k)
          
            vxihl=uriih(2,i,j,k)
            vxihr=uriih(2,i,j,k)
!
! Cal total pressure
!
            vvih=uriih(2,i,j,k)**2+uriih(3,i,j,k)**2+uriih(4,i,j,k)**2
            bbih=uriih(7,i,j,k)**2+uriih(8,i,j,k)**2+uriih(9,i,j,k)**2
            vbih=uriih(2,i,j,k)*uriih(7,i,j,k) &
                +uriih(3,i,j,k)*uriih(8,i,j,k) &
                +uriih(4,i,j,k)*uriih(9,i,j,k) 
            b2ih=bbih*(1.-vvih)+vbih**2
            ptih=uriih(5,i,j,k)+0.5*b2ih
!
! Cal By*_a, Bz*_a 
!
            byihl=uriil(8,i,j,k)*(cmini(i,j,k)-uriil(2,i,j,k))/clmdi
            byihr=uriir(8,i,j,k)*(cmaxi(i,j,k)-uriir(2,i,j,k))/crmdi
            bzihl=uriil(9,i,j,k)*(cmini(i,j,k)-uriil(2,i,j,k))/clmdi
            bzihr=uriir(9,i,j,k)*(cmaxi(i,j,k)-uriir(2,i,j,k))/crmdi
!
! Cal C_a
!
            cil=-clmdi*byihl*bzihl
            cir=-crmdi*byihr*bzihr
!
! Cal G_a
!
            bbihl=bxihl**2+byihl**2+bzihl**2
            bbihr=bxihr**2+byihr**2+bzihr**2
          
            tauil=uuil(5,i,j,k)+uuil(1,i,j,k)
            tauir=uuir(5,i,j,k)+uuir(1,i,j,k)
            ftauil=wwil(5,i,j,k)+wwil(1,i,j,k)
            ftauir=wwir(5,i,j,k)+wwir(1,i,j,k)
          
            gil=(cmini(i,j,k)*tauil-ftauil+cmini(i,j,k)*ptih)/clmdi-bbihl
            gir=(cmaxi(i,j,k)*tauir-ftauir+cmaxi(i,j,k)*ptih)/crmdi-bbihr
!
! Cal Cy,z_a
!
            cyil=clmdi*(gil+byihl**2)
            cyir=crmdi*(gir+byihr**2)
            czil=clmdi*(gil+bzihl**2)
            czir=crmdi*(gir+bzihr**2)
!
! Cal vy,z*_a
!
            syil=uuil(3,i,j,k)
            szil=uuil(4,i,j,k)
            syir=uuir(3,i,j,k)
            szir=uuir(4,i,j,k)
          
            fsyil=wwil(3,i,j,k)
            fszil=wwil(4,i,j,k)
            fsyir=wwir(3,i,j,k)
            fszir=wwir(4,i,j,k)
          
            vyihl=(cyil*(cmini(i,j,k)*syil-fsyil) &
                 -cil*(cmini(i,j,k)*szil-fszil))/(cyil*czil-cil**2)
            vyihr=(cyir*(cmaxi(i,j,k)*syir-fsyir) &
                 -cir*(cmaxi(i,j,k)*szir-fszir))/(cyir*czir-cir**2)
          
            vzihl=(czil*(cmini(i,j,k)*szil-fszil) &
                 -cil*(cmini(i,j,k)*syil-fsyil))/(cyil*czil-cil**2)
            vzihr=(czir*(cmaxi(i,j,k)*szir-fszir) &
                 -cir*(cmaxi(i,j,k)*syir-fsyir))/(cyir*czir-cir**2)
!
! Cal rho*_a
!
            vvil=uriil(2,i,j,k)**2+uriil(3,i,j,k)**2+uriil(4,i,j,k)**2
            gfil=1./sqrt(1.-vvil)
            vvihl=vxihl**2+vyihl**2+vzihl**2
            gfihl=1./sqrt(1.-vvihl)
            roihl=gfil*uriil(1,i,j,k)*(cmini(i,j,k)-vxihl)/(gfihl*clmdi)
          
            vvir=uriir(2,i,j,k)**2+uriir(3,i,j,k)**2+uriir(4,i,j,k)**2
            gfir=1./sqrt(1.-vvir)
            vvihr=vxihr**2+vyihr**2+vzihr**2
            gfihr=1./sqrt(1.-vvihr)
            roihr=gfir*uriir(1,i,j,k)*(cmaxi(i,j,k)-vxihr)/(gfihr*crmdi)
!
! Cal p*_a
!
            vbihl=vxihl*bxihl+vyihl*byihl+vzihl*bzihl
            vbihr=vxihr*bxihr+vyihr*byihr+vzihr*bzihr
          
            b2ihl=bbihl*(1.-vvihl)+vbihl**2
            b2ihr=bbihr*(1.-vvihr)+vbihr**2
          
            ppihl=ptih-0.5*b2ihl
            ppihr=ptih-0.5*b2ihr
          
            uuihl(1,i,j,k)=gfihl*roihl
            tauihl=(cmini(i,j,k)*tauil-ftauil+ptih*cmidi(i,j,k))/clmdi

            uuihl(2,i,j,k)=(tauihl+ptih)*vxihl-vbihl*bxihl
            uuihl(3,i,j,k)=(tauihl+ptih)*vyihl-vbihl*byihl
            uuihl(4,i,j,k)=(tauihl+ptih)*vzihl-vbihl*bzihl
            uuihl(5,i,j,k)=tauihl-uuihl(1,i,j,k)
                    
            if( iflag(6).le.1 ) then
              uuihl(6,i,j,k)=gfihl*roihl*x1(i)
            elseif( iflag(6).le.3 ) then
              uuihl(6,i,j,k)=gfihl*ppihl/roihl**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uuihl(6,i,j,k)=gfihl*roihl*log(ppihl/roihl**gam)
            endif         
           
            uuihl(7,i,j,k)=bxihl
            uuihl(8,i,j,k)=byihl
            uuihl(9,i,j,k)=bzihl
!
            uuihr(1,i,j,k)=gfihr*roihr
            tauihr=(cmaxi(i,j,k)*tauir-ftauir+ptih*cmidi(i,j,k))/crmdi

            uuihr(2,i,j,k)=(tauihr+ptih)*vxihr-vbihr*bxihr
            uuihr(3,i,j,k)=(tauihr+ptih)*vyihr-vbihr*byihr
            uuihr(4,i,j,k)=(tauihr+ptih)*vzihr-vbihr*bzihr
            uuihr(5,i,j,k)=tauihr-uuihr(1,i,j,k)
          
            if( iflag(6).le.1 ) then
              uuihr(6,i,j,k)=gfihr*roihr*x1(i)
            elseif( iflag(6).le.3 ) then
              uuihr(6,i,j,k)=gfihr*ppihr/roihr**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uuihr(6,i,j,k)=gfihr*roihr*log(ppihr/roihr**gam)
            endif
           
            uuihr(7,i,j,k)=bxihr
            uuihr(8,i,j,k)=byihr
            uuihr(9,i,j,k)=bzihr
          
          endif
!
        endif
!
!   y-direction
!
        if(iflxj(i,j,k) .eq. 0) then
!
          if(urijh(8,i,j,k) .ne. 0.d0) then
            cmidj(i,j,k)=urijh(3,i,j,k)
          
            clmdj=cminj(i,j,k)-cmidj(i,j,k)
            crmdj=cmaxj(i,j,k)-cmidj(i,j,k)
          
            vxjhl=urijh(2,i,j,k)
            vyjhl=urijh(3,i,j,k)
            vzjhl=urijh(4,i,j,k)
            ppjhl=urijh(5,i,j,k)
            bxjhl=urijh(7,i,j,k)
            byjhl=urijh(8,i,j,k)
            bzjhl=urijh(9,i,j,k)
          
            vxjhr=urijh(2,i,j,k)
            vyjhr=urijh(3,i,j,k)
            vzjhr=urijh(4,i,j,k)
            ppjhr=urijh(5,i,j,k)
            bxjhr=urijh(7,i,j,k)
            byjhr=urijh(8,i,j,k)
            bzjhr=urijh(9,i,j,k)
!
! Cal rho*_a
!
            vvjl=urijl(2,i,j,k)**2+urijl(3,i,j,k)**2+urijl(4,i,j,k)**2
            gfjl=1./sqrt(1.-vvjl)
            vvjhl=vxjhl**2+vyjhl**2+vzjhl**2
            gfjhl=1./sqrt(1.-vvjhl)
            rojhl=gfjl*urijl(1,i,j,k)*(cminj(i,j,k)-vyjhl)/(gfjhl*clmdj)
          
            vvjr=urijr(2,i,j,k)**2+urijr(3,i,j,k)**2+urijr(4,i,j,k)**2
            gfjr=1./sqrt(1.-vvjr)
            vvjhr=vxjhr**2+vyjhr**2+vzjhr**2
            gfjhr=1./sqrt(1.-vvjhr)
            rojhr=gfjr*urijr(1,i,j,k)*(cmaxj(i,j,k)-vyjhr)/(gfjhr*crmdj)
!cc
            if(ieos .eq. 0) then
              rohjhl=rojhl+(gam/(gam-1.0))*ppjhl
              rohjhr=rojhr+(gam/(gam-1.0))*ppjhr
            elseif(ieos .eq. 1) then
              rohjhl=(5./2.)*ppjhl+sqrt((9./4.)*ppjhl**2+rojhl**2)
              rohjhr=(5./2.)*ppjhr+sqrt((9./4.)*ppjhr**2+rojhr**2)
            elseif(ieos .eq. 2) then
              roejhl=(3./2.)*(ppjhl+((3.*ppjhl**2)/(2.0*rojhl &
                    +sqrt(2.*ppjhl**2+4.*rojhl**2)) ))
              roejhr=(3./2.)*(ppjhr+((3.*ppjhr**2)/(2.0*rojhr &
                    +sqrt(2.*ppjhr**2+4.*rojhr**2)) ))
              rohjhl=rojhl+roejhl+ppjhl
              rohjhr=rojhl+roejhr+ppjhr
            endif
          
            bbjhl=bxjhl**2+byjhl**2+bzjhl**2
            bbjhr=bxjhr**2+byjhr**2+bzjhr**2
            vbjhl=vxjhl*bxjhl+vyjhl*byjhl+vzjhl*bzjhl
            vbjhr=vxjhr*bxjhr+vyjhr*byjhr+vzjhr*bzjhr
!
            denrjhl=gfjhl**2*rohjhl
            denrjhr=gfjhr**2*rohjhr
            eemjhl=0.5*(bbjhl+vvjhl*bbjhl-vbjhl**2)
            eemjhr=0.5*(bbjhr+vvjhr*bbjhr-vbjhr**2)
          
            uujhl(1,i,j,k)=gfjhl*rojhl
            uujhl(2,i,j,k)=(denrjhl+bbjhl)*vxjhl-vbjhl*bxjhl
            uujhl(3,i,j,k)=(denrjhl+bbjhl)*vyjhl-vbjhl*byjhl
            uujhl(4,i,j,k)=(denrjhl+bbjhl)*vzjhl-vbjhl*bzjhl
            uujhl(5,i,j,k)=denrjhl-ppjhl+eemjhl-gfjhl*rojhl
          
            if( iflag(6).le.1 ) then
              uujhl(6,i,j,k)=gfjhl*rojhl*x1(i)
            elseif( iflag(6).le.3 ) then
              uujhl(6,i,j,k)=gfjhl*ppjhl/rojhl**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uujhl(6,i,j,k)=gfjhl*rojhl*log(ppjhl/rojhl**gam)
            endif         
           
            uujhl(7,i,j,k)=bxjhl
            uujhl(8,i,j,k)=byjhl
            uujhl(9,i,j,k)=bzjhl
!
            uujhr(1,i,j,k)=gfjhr*rojhr
            uujhr(2,i,j,k)=(denrjhr+bbjhr)*vxjhr-vbjhr*bxjhr
            uujhr(3,i,j,k)=(denrjhr+bbjhr)*vyjhr-vbjhr*byjhr
            uujhr(4,i,j,k)=(denrjhr+bbjhr)*vzjhr-vbjhr*bzjhr
            uujhr(5,i,j,k)=denrjhr-ppjhr+eemjhr-gfjhr*rojhr
            
            if( iflag(6).le.1 ) then
              uujhr(6,i,j,k)=gfjhr*rojhr*x1(i)
            elseif( iflag(6).le.3 ) then
              uujhr(6,i,j,k)=gfjhr*ppjhr/rojhr**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uujhr(6,i,j,k)=gfjhr*rojhr*log(ppjhr/rojhr**gam)
            endif         
           
            uujhr(7,i,j,k)=bxjhr
            uujhr(8,i,j,k)=byjhr
            uujhr(9,i,j,k)=bzjhr
          
          else
         
            byjhl=0.d0
            byjhr=0.d0
! 
! intremediate wave speed
!          
            cmidj(i,j,k)=urijh(3,i,j,k)
            
            clmdj=cminj(i,j,k)-cmidj(i,j,k)
            crmdj=cmaxj(i,j,k)-cmidj(i,j,k)
            
            vyjhl=urijh(3,i,j,k)
            vyjhr=urijh(3,i,j,k)
!
! Cal total pressure
!
            vvjh=urijh(2,i,j,k)**2+urijh(3,i,j,k)**2+urijh(4,i,j,k)**2
            bbjh=urijh(7,i,j,k)**2+urijh(8,i,j,k)**2+urijh(9,i,j,k)**2
            vbjh=urijh(2,i,j,k)*urijh(7,i,j,k) &
                +urijh(3,i,j,k)*urijh(8,i,j,k) &
                +urijh(4,i,j,k)*urijh(9,i,j,k)
            b2jh=bbjh*(1.-vvjh)+vbjh**2
            ptjh=urijh(5,i,j,k)+0.5*b2jh
!
! Cal Bx*_a, Bz*_a 
!
            bxjhl=urijl(7,i,j,k)*(cminj(i,j,k)-urijl(3,i,j,k))/clmdj
            bxjhr=urijr(7,i,j,k)*(cmaxj(i,j,k)-urijr(3,i,j,k))/crmdj
            bzjhl=urijl(9,i,j,k)*(cminj(i,j,k)-urijl(3,i,j,k))/clmdj
            bzjhr=urijr(9,i,j,k)*(cmaxj(i,j,k)-urijr(3,i,j,k))/crmdj
!
! Cal C_a
!
            cjl=-clmdj*bxjhl*bzjhl
            cjr=-crmdj*bxjhr*bzjhr
!
! Cal G_a
!
            bbjhl=bxjhl**2+byjhl**2+bzjhl**2
            bbjhr=bxjhr**2+byjhr**2+bzjhr**2
          
            taujl=uujl(5,i,j,k)+uujl(1,i,j,k)
            taujr=uujr(5,i,j,k)+uujr(1,i,j,k)
            ftaujl=wwjl(5,i,j,k)+wwjl(1,i,j,k)
            ftaujr=wwjr(5,i,j,k)+wwjr(1,i,j,k)
          
            gjl=(cminj(i,j,k)*taujl-ftaujl+cminj(i,j,k)*ptjh)/clmdj-bbjhl
            gjr=(cmaxj(i,j,k)*taujr-ftaujr+cmaxj(i,j,k)*ptjh)/crmdj-bbjhr
!
! Cal Cx,z_a
!
            cxjl=clmdj*(gjl+bxjhl**2)
            cxjr=crmdj*(gjr+bxjhr**2)
            czjl=clmdj*(gjl+bzjhl**2)
            czjr=crmdj*(gjr+bzjhr**2)
!
! Cal vx,z*_a
!
            sxjl=uujl(2,i,j,k)
            szjl=uujl(4,i,j,k)
            sxjr=uujr(2,i,j,k)
            szjr=uujr(4,i,j,k)
          
            fsxjl=wwjl(2,i,j,k)
            fszjl=wwjl(4,i,j,k)
            fsxjr=wwjr(2,i,j,k)
            fszjr=wwjr(4,i,j,k)
           
            vxjhl=(cxjl*(cminj(i,j,k)*sxjl-fsxjl) &
                 -cjl*(cminj(i,j,k)*szjl-fszjl))/(cxjl*czjl-cjl**2)
            vxjhr=(cxjr*(cmaxj(i,j,k)*sxjr-fsxjr) &
                 -cjr*(cmaxj(i,j,k)*szjr-fszjr))/(cxjr*czjr-cjr**2)
     
            vzjhl=(czjl*(cminj(i,j,k)*szjl-fszjl) &
                 -cjl*(cminj(i,j,k)*sxjl-fsxjl))/(cxjl*czjl-cjl**2)
            vzjhr=(czjr*(cmaxj(i,j,k)*szjr-fszjr) &
                 -cjr*(cmaxj(i,j,k)*sxjr-fsxjr))/(cxjr*czjr-cjr**2)
!
! Cal rho*_a
!
            vvjl=urijl(2,i,j,k)**2+urijl(3,i,j,k)**2+urijl(4,i,j,k)**2
            gfjl=1./sqrt(1.-vvjl)
            vvjhl=vxjhl**2+vyjhl**2+vzjhl**2
            gfjhl=1./sqrt(1.-vvjhl)
            rojhl=gfjl*urijl(1,i,j,k)*(cminj(i,j,k)-vyjhl)/(gfjhl*clmdj)
          
            vvjr=urijr(2,i,j,k)**2+urijr(3,i,j,k)**2+urijr(4,i,j,k)**2
            gfjr=1./sqrt(1.-vvjr)
            vvjhr=vxjhr**2+vyjhr**2+vzjhr**2
            gfjhr=1./sqrt(1.-vvjhr)
            rojhr=gfjr*urijr(1,i,j,k)*(cmaxj(i,j,k)-vyjhr)/(gfjhr*crmdj)
!
! Cal p*_a
!
            vbjhl=vxjhl*bxjhl+vyjhl*byjhl+vzjhl*bzjhl
            vbjhr=vxjhr*bxjhr+vyjhr*byjhr+vzjhr*bzjhr
          
            b2jhl=bbjhl*(1.-vvjhl)+vbjhl**2
            b2jhr=bbjhr*(1.-vvjhr)+vbjhr**2
          
            ppjhl=ptjh-0.5*b2jhl
            ppjhr=ptjh-0.5*b2jhr
         
            uujhl(1,i,j,k)=gfjhl*rojhl
            taujhl=(cminj(i,j,k)*taujl-ftaujl+ptjh*cmidj(i,j,k))/clmdj

            uujhl(2,i,j,k)=(taujhl+ptjh)*vxjhl-vbjhl*bxjhl
            uujhl(3,i,j,k)=(taujhl+ptjh)*vyjhl-vbjhl*byjhl
            uujhl(4,i,j,k)=(taujhl+ptjh)*vzjhl-vbjhl*bzjhl
            uujhl(5,i,j,k)=taujhl-uujhl(1,i,j,k)
          
            if( iflag(6).le.1 ) then
              uujhl(6,i,j,k)=gfjhl*rojhl*x1(i)
            elseif( iflag(6).le.3 ) then
              uujhl(6,i,j,k)=gfjhl*ppjhl/rojhl**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uujhl(6,i,j,k)=gfjhl*rojhl*log(ppjhl/rojhl**gam)
            endif
           
            uujhl(7,i,j,k)=bxjhl
            uujhl(8,i,j,k)=byjhl
            uujhl(9,i,j,k)=bzjhl
!
            uujhr(1,i,j,k)=gfjhr*rojhr
            taujhr=(cmaxj(i,j,k)*taujr-ftaujr+ptjh*cmidj(i,j,k))/crmdj

            uujhr(2,i,j,k)=(taujhr+ptjh)*vxjhr-vbjhr*bxjhr
            uujhr(3,i,j,k)=(taujhr+ptjh)*vyjhr-vbjhr*byjhr
            uujhr(4,i,j,k)=(taujhr+ptjh)*vzjhr-vbjhr*bzjhr
            uujhr(5,i,j,k)=taujhr-uujhr(1,i,j,k)
          
            if( iflag(6).le.1 ) then
              uujhr(6,i,j,k)=gfjhr*rojhr*x1(i)
            elseif( iflag(6).le.3 ) then
              uujhr(6,i,j,k)=gfjhr*ppjhr/rojhr**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uujhr(6,i,j,k)=gfjhr*rojhr*log(ppjhr/rojhr**gam)
            endif
           
            uujhr(7,i,j,k)=bxjhr
            uujhr(8,i,j,k)=byjhr
            uujhr(9,i,j,k)=bzjhr
         
          endif
!
        endif
!
!   z-direction
!
        if(iflxk(i,j,k) .eq. 0) then
!
          if(urikh(9,i,j,k) .ne. 0.d0) then
            cmidk(i,j,k)=urikh(4,i,j,k)
          
            clmdk=cmink(i,j,k)-cmidk(i,j,k)
            crmdk=cmaxk(i,j,k)-cmidk(i,j,k)
          
            vxkhl=urikh(2,i,j,k)
            vykhl=urikh(3,i,j,k)
            vzkhl=urikh(4,i,j,k)
            ppkhl=urikh(5,i,j,k)
            bxkhl=urikh(7,i,j,k)
            bykhl=urikh(8,i,j,k)
            bzkhl=urikh(9,i,j,k)
          
            vxkhr=urikh(2,i,j,k)
            vykhr=urikh(3,i,j,k)
            vzkhr=urikh(4,i,j,k)
            ppkhr=urikh(5,i,j,k)
            bxkhr=urikh(7,i,j,k)
            bykhr=urikh(8,i,j,k)
            bzkhr=urikh(9,i,j,k)
!
! Cal rho*_a
!
            vvkl=urikl(2,i,j,k)**2+urikl(3,i,j,k)**2+urikl(4,i,j,k)**2
            gfkl=1./sqrt(1.-vvkl)
            vvkhl=vxkhl**2+vykhl**2+vzkhl**2
            gfkhl=1./sqrt(1.-vvkhl)
            rokhl=gfkl*urikl(1,i,j,k)*(cmink(i,j,k)-vzkhl)/(gfkhl*clmdk)
          
            vvkr=urikr(2,i,j,k)**2+urikr(3,i,j,k)**2+urikr(4,i,j,k)**2
            gfkr=1./sqrt(1.-vvkr)
            vvkhr=vxkhr**2+vykhr**2+vzkhr**2
            gfkhr=1./sqrt(1.-vvkhr)
            rokhr=gfkr*urikr(1,i,j,k)*(cmaxk(i,j,k)-vzkhr)/(gfkhr*crmdk)
!cc
            if(ieos .eq. 0) then
              rohkhl=rokhl+(gam/(gam-1.0))*ppkhl
              rohkhr=rokhr+(gam/(gam-1.0))*ppkhr
            elseif(ieos .eq. 1) then
              rohkhl=(5./2.)*ppkhl+sqrt((9./4.)*ppkhl**2+rokhl**2)
              rohkhr=(5./2.)*ppkhr+sqrt((9./4.)*ppkhr**2+rokhr**2)
            elseif(ieos .eq. 2) then
              roekhl=(3./2.)*(ppkhl+((3.*ppkhl**2)/(2.0*rokhl &
                    +sqrt(2.*ppkhl**2+4.*rokhl**2)) ))
              roekhr=(3./2.)*(ppkhr+((3.*ppkhr**2)/(2.0*rokhr &
                    +sqrt(2.*ppkhr**2+4.*rokhr**2)) ))
              rohkhl=rokhl+roekhl+ppkhl
              rohkhr=rokhl+roekhr+ppkhr
            endif
          
            bbkhl=bxkhl**2+bykhl**2+bzkhl**2
            bbkhr=bxkhr**2+bykhr**2+bzkhr**2
            vbkhl=vxkhl*bxkhl+vykhl*bykhl+vzkhl*bzkhl
            vbkhr=vxkhr*bxkhr+vykhr*bykhr+vzkhr*bzkhr
!
            denrkhl=gfkhl**2*rohkhl
            denrkhr=gfkhr**2*rohkhr
            eemkhl=0.5*(bbkhl+vvkhl*bbkhl-vbkhl**2)
            eemkhr=0.5*(bbkhr+vvkhr*bbkhr-vbkhr**2)
          
            uukhl(1,i,j,k)=gfkhl*rokhl
            uukhl(2,i,j,k)=(denrkhl+bbkhl)*vxkhl-vbkhl*bxkhl
            uukhl(3,i,j,k)=(denrkhl+bbkhl)*vykhl-vbkhl*bykhl
            uukhl(4,i,j,k)=(denrkhl+bbkhl)*vzkhl-vbkhl*bzkhl
            uukhl(5,i,j,k)=denrkhl-ppkhl+eemkhl-gfkhl*rokhl
          
            if( iflag(6).le.1 ) then
              uukhl(6,i,j,k)=gfkhl*rokhl*x1(i)
            elseif( iflag(6).le.3 ) then
              uukhl(6,i,j,k)=gfkhl*ppkhl/rokhl**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uukhl(6,i,j,k)=gfkhl*rokhl*log(ppkhl/rokhl**gam)
            endif         
           
            uukhl(7,i,j,k)=bxkhl
            uukhl(8,i,j,k)=bykhl
            uukhl(9,i,j,k)=bzkhl
          
            uukhr(1,i,j,k)=gfkhr*rokhr
            uukhr(2,i,j,k)=(denrkhr+bbkhr)*vxkhr-vbkhr*bxkhr
            uukhr(3,i,j,k)=(denrkhr+bbkhr)*vykhr-vbkhr*bykhr
            uukhr(4,i,j,k)=(denrkhr+bbkhr)*vzkhr-vbkhr*bzkhr
            uukhr(5,i,j,k)=denrkhr-ppkhr+eemkhr-gfkhr*rokhr
          
            if( iflag(6).le.1 ) then
              uukhr(6,i,j,k)=gfkhr*rokhr*x1(i)
            elseif( iflag(6).le.3 ) then
              uukhr(6,i,j,k)=gfkhr*ppkhr/rokhr**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uukhr(6,i,j,k)=gfkhr*rokhr*log(ppkhr/rokhr**gam)
            endif         
           
            uukhr(7,i,j,k)=bxkhr
            uukhr(8,i,j,k)=bykhr
            uukhr(9,i,j,k)=bzkhr
             
          else
         
            bzkhl=0.d0
            bzkhr=0.d0
!  
! intremediate wave speed
!          
            cmidk(i,j,k)=urikh(4,i,j,k)
          
            clmdk=cmink(i,j,k)-cmidk(i,j,k)
            crmdk=cmaxk(i,j,k)-cmidk(i,j,k)
          
            vzkhl=urikh(4,i,j,k)
            vzkhr=urikh(4,i,j,k)
!
! Cal total pressure
!
            vvkh=urikh(2,i,j,k)**2+urikh(3,i,j,k)**2+urikh(4,i,j,k)**2
            bbkh=urikh(7,i,j,k)**2+urikh(8,i,j,k)**2+urikh(9,i,j,k)**2
            vbkh=urikh(2,i,j,k)*urikh(7,i,j,k) &
                +urikh(3,i,j,k)*urikh(8,i,j,k) &
                +urikh(4,i,j,k)*urikh(9,i,j,k)
            b2kh=bbkh*(1.-vvkh)+vbkh**2
            ptkh=urikh(5,i,j,k)+0.5*b2kh
!
! Cal Bx*_a, By*_a 
!
            bxkhl=urikl(7,i,j,k)*(cmink(i,j,k)-urikl(4,i,j,k))/clmdk
            bxkhr=urikr(7,i,j,k)*(cmaxk(i,j,k)-urikr(4,i,j,k))/crmdk
            bykhl=urikl(8,i,j,k)*(cmink(i,j,k)-urikl(4,i,j,k))/clmdk
            bykhr=urikr(8,i,j,k)*(cmaxk(i,j,k)-urikr(4,i,j,k))/crmdk
!
! Cal C_a
!
            ckl=-clmdk*bxkhl*bykhl
            ckr=-crmdk*bxkhr*bykhr
!
! Cal G_a
!
            bbkhl=bxkhl**2+bykhl**2+bzkhl**2
            bbkhr=bxkhr**2+bykhr**2+bzkhr**2
          
            taukl=uukl(5,i,j,k)+uukl(1,i,j,k)
            taukr=uukr(5,i,j,k)+uukr(1,i,j,k)
            ftaukl=wwkl(5,i,j,k)+wwkl(1,i,j,k)
            ftaukr=wwkr(5,i,j,k)+wwkr(1,i,j,k)
          
            gkl=(cmink(i,j,k)*taukl-ftaukl+cmink(i,j,k)*ptkh)/clmdk-bbkhl
            gkr=(cmaxk(i,j,k)*taukr-ftaukr+cmaxk(i,j,k)*ptkh)/crmdk-bbkhr
!
! Cal Cx,y_a
!
            cxkl=clmdk*(gkl+bxkhl**2)
            cxkr=crmdk*(gkr+bxkhr**2)
            cykl=clmdk*(gkl+bykhl**2)
            cykr=crmdk*(gkr+bykhr**2)
!
! Cal vx,y*_a
!
            sxkl=uukl(2,i,j,k)
            sykl=uukl(3,i,j,k)
            sxkr=uukr(2,i,j,k)
            sykr=uukr(3,i,j,k)
          
            fsxkl=wwkl(2,i,j,k)
            fsykl=wwkl(3,i,j,k)
            fsxkr=wwkr(2,i,j,k)
            fsykr=wwkr(3,i,j,k)
          
            vxkhl=(cxkl*(cmink(i,j,k)*sxkl-fsxkl) &
                 -ckl*(cmink(i,j,k)*sykl-fsykl))/(cxkl*cykl-ckl**2)
            vxkhr=(cxkr*(cmaxk(i,j,k)*sxkr-fsxkr) &
                 -ckr*(cmaxk(i,j,k)*sykr-fsykr))/(cxkr*cykr-ckr**2)
     
            vykhl=(cykl*(cmink(i,j,k)*sykl-fsykl) &
                 -ckl*(cmink(i,j,k)*sxkl-fsxkl))/(cxkl*cykl-ckl**2)
            vykhr=(cykr*(cmaxk(i,j,k)*sykr-fsykr) &
                 -ckr*(cmaxk(i,j,k)*sxkr-fsxkr))/(cxkr*cykr-ckr**2)
!
! Cal rho*_a
!
            vvkl=urikl(2,i,j,k)**2+urikl(3,i,j,k)**2+urikl(4,i,j,k)**2
            gfkl=1./sqrt(1.-vvkl)
            vvkhl=vxkhl**2+vykhl**2+vzkhl**2
            gfkhl=1./sqrt(1.-vvkhl)
            rokhl=gfkl*urikl(1,i,j,k)*(cmink(i,j,k)-vzkhl)/(gfkhl*clmdk)
          
            vvkr=urikr(2,i,j,k)**2+urikr(3,i,j,k)**2+urikr(4,i,j,k)**2
            gfkr=1./sqrt(1.-vvkr)
            vvkhr=vxkhr**2+vykhr**2+vzkhr**2
            gfkhr=1./sqrt(1.-vvkhr)
            rokhr=gfkr*urikr(1,i,j,k)*(cmaxk(i,j,k)-vzkhr)/(gfkhr*crmdk)
!
! Cal p*_a
!
            vbkhl=vxkhl*bxkhl+vykhl*bykhl+vzkhl*bzkhl
            vbkhr=vxkhr*bxkhr+vykhr*bykhr+vzkhr*bzkhr
          
            b2khl=bbkhl*(1.-vvkhl)+vbkhl**2
            b2khr=bbkhr*(1.-vvkhr)+vbkhr**2
          
            ppkhl=ptkh-0.5*b2khl
            ppkhr=ptkh-0.5*b2khr
!
! Cal uu
!
            uukhl(1,i,j,k)=gfkhl*rokhl
            taukhl=(cmink(i,j,k)*taukl-ftaukl+ptkh*cmidk(i,j,k))/clmdk

            uukhl(2,i,j,k)=(taukhl+ptkh)*vxkhl-vbkhl*bxkhl
            uukhl(3,i,j,k)=(taukhl+ptkh)*vykhl-vbkhl*bykhl
            uukhl(4,i,j,k)=(taukhl+ptkh)*vzkhl-vbkhl*bzkhl
            uukhl(5,i,j,k)=taukhl-uukhl(1,i,j,k)
          
            if( iflag(6).le.1 ) then
              uukhl(6,i,j,k)=gfkhl*rokhl*x1(i)
            elseif( iflag(6).le.3 ) then
              uukhl(6,i,j,k)=gfkhl*ppkhl/rokhl**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uukhl(6,i,j,k)=gfkhl*rokhl*log(ppkhl/rokhl**gam)
            endif
           
            uukhl(7,i,j,k)=bxkhl
            uukhl(8,i,j,k)=bykhl
            uukhl(9,i,j,k)=bzkhl
          
            uukhr(1,i,j,k)=gfkhr*rokhr
            taukhr=(cmaxk(i,j,k)*taukr-ftaukr+ptkh*cmidk(i,j,k))/crmdk

            uukhr(2,i,j,k)=(taukhr+ptkh)*vxkhr-vbkhr*bxkhr
            uukhr(3,i,j,k)=(taukhr+ptkh)*vykhr-vbkhr*bykhr
            uukhr(4,i,j,k)=(taukhr+ptkh)*vzkhr-vbkhr*bzkhr
            uukhr(5,i,j,k)=taukhr-uukhr(1,i,j,k)
          
            if( iflag(6).le.1 ) then
              uukhr(6,i,j,k)=gfkhr*rokhr*x1(i)
            elseif( iflag(6).le.3 ) then
              uukhr(6,i,j,k)=gfkhr*ppkhr/rokhr**(gam-1.0)
            elseif( iflag(6).eq.4 ) then
              uukhr(6,i,j,k)=gfkhr*rokhr*log(ppkhr/rokhr**gam)
            endif
           
            uukhr(7,i,j,k)=bxkhr
            uukhr(8,i,j,k)=bykhr
            uukhr(9,i,j,k)=bzkhr
          
          endif
!
        endif
!         
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        do n=1,nv
     
          if(iflxi(i,j,k) .eq. 0) then
            if(cmini(i,j,k) .le. 0.d0 .and. cmidi(i,j,k) .gt. 0.d0) then
              ww(1,n,i,j,k)=cmini(i,j,k) &
                           *(uuihl(n,i,j,k)-uuil(n,i,j,k))+wwil(n,i,j,k)
            elseif(cmidi(i,j,k) .le. 0.d0 .and. cmaxi(i,j,k) .gt. 0.d0) then
               ww(1,n,i,j,k)=cmaxi(i,j,k) &
                            *(uuihr(n,i,j,k)-uuir(n,i,j,k))+wwir(n,i,j,k)
            endif
          endif     
!          
          if(iflxj(i,j,k) .eq. 0) then
            if(cminj(i,j,k) .le. 0.d0 .and. cmidj(i,j,k) .gt. 0.d0) then
              ww(2,n,i,j,k)=cminj(i,j,k) &
                           *(uujhl(n,i,j,k)-uujl(n,i,j,k))+wwjl(n,i,j,k)
            elseif(cmidj(i,j,k) .le. 0.d0 .and. cmaxj(i,j,k) .gt. 0.d0) then
              ww(2,n,i,j,k)=cmaxj(i,j,k) &
                           *(uujhr(n,i,j,k)-uujr(n,i,j,k))+wwjr(n,i,j,k)
            endif
          endif
!        
          if(iflxk(i,j,k) .eq. 0) then
            if(cmink(i,j,k) .le. 0.d0 .and. cmidk(i,j,k) .gt. 0.d0) then
              ww(3,n,i,j,k)=cmink(i,j,k) &
                           *(uukhl(n,i,j,k)-uukl(n,i,j,k))+wwkl(n,i,j,k)
            elseif(cmidk(i,j,k) .le. 0.d0 .and. cmaxk(i,j,k) .gt. 0.d0) then
              ww(3,n,i,j,k)=cmaxk(i,j,k) &
                           *(uukhr(n,i,j,k)-uukr(n,i,j,k))+wwkr(n,i,j,k)
            endif
          endif
!
        enddo
      enddo
    enddo
  enddo
!
  deallocate( uuih, uujh, uukh, uuihr, uuihl, uujhr, uujhl, uukhr, uukhl, &
              uriih, urijh, urikh, cmidi, cmidj, cmidk, &
              iflxi, iflxj, iflxk, stat=merr )
!     
  return
end subroutine hllc2
!
!---------------------------------------------------------------------@
subroutine hlld2(ww,x1,x2,x3,uri,uriir,uriil,urijr,urijl,urikr,urikl, &
                 uuir,uuil,uujr,uujl,uukr,uukl, &
                 wwir,wwil,wwjr,wwjl,wwkr,wwkl, &
                 cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0, &
                 is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate numerical flux by HLLD scheme 
!    (Mignone et al. 2010)
!
  use pram, only : imax, jmax, kmax, nv
  implicit none      

  integer :: nm0, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uuir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uuil(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujl(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukl(nv,is1:ie1,js1:je1,ks1:ke1)
     
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1), &
             uriir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uriil(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijl(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikl(nv,is1:ie1,js1:je1,ks1:ke1)
     
  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwir(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwil(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjl(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkl(nv,is1:ie1,js1:je1,ks1:ke1)
      
  real(8) :: cmaxi(is1:ie1,js1:je1,ks1:ke1), cmini(is1:ie1,js1:je1,ks1:ke1), &
             cmaxj(is1:ie1,js1:je1,ks1:ke1), cminj(is1:ie1,js1:je1,ks1:ke1), &
             cmaxk(is1:ie1,js1:je1,ks1:ke1), cmink(is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: x1(imax),x2(jmax),x3(kmax)
!
!=====================================================================@
!
  call hlldsi(ww,x1,x2,x3,uri,uriir,uriil,uuir,uuil, &
              wwir,wwil,cmaxi,cmini,nm0,is1,ie1,js1,je1,ks1,ke1)
  call hlldsj(ww,x1,x2,x3,uri,urijr,urijl,uujr,uujl, &
              wwjr,wwjl,cmaxj,cminj,nm0,is1,ie1,js1,je1,ks1,ke1)
  call hlldsk(ww,x1,x2,x3,uri,urikr,urikl,uukr,uukl, &
              wwkr,wwkl,cmaxk,cmink,nm0,is1,ie1,js1,je1,ks1,ke1)
     
  return
end subroutine hlld2
!     
!---------------------------------------------------------------------@
subroutine hlldsi(ww,x1,x2,x3,uri,uriir,uriil,uuir,uuil, &
                  wwir,wwil,cmaxi,cmini,nm0,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate numerical flux by HLLD scheme 
!    (Mignone et al. 2010)
!     x-direction
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, iwvec, iter, iflag
  implicit none

  integer :: i, j, k, n, nnn
  integer :: nm0, is1, ie1, js1, je1, ks1, ke1, merr

  real(8) :: uuir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uuil(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: uuih(:,:,:,:), uuic(:,:,:,:), &
                          uuiar(:,:,:,:), uuial(:,:,:,:) 
     
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uriir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uriil(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: uriih(:,:,:,:)
     
  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwir(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwil(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: wwih(:,:,:,:)
      
  real(8), allocatable :: rrir(:,:,:,:), rril(:,:,:,:)
      
  real(8) :: cmaxi(is1:ie1,js1:je1,ks1:ke1), &
             cmini(is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: cmidi(:,:,:), csari(:,:,:), csali(:,:,:)

  real(8), allocatable :: ptir(:,:,:), ptil(:,:,:), ptih(:,:,:), &
           pti(:,:,:)
!
  real(8), allocatable :: vxiar(:,:,:), vxial(:,:,:), &
           vyiar(:,:,:), vyial(:,:,:), vziar(:,:,:), vzial(:,:,:)

  real(8), allocatable :: bxiar(:,:,:), bxial(:,:,:), &
           byiar(:,:,:), byial(:,:,:), bziar(:,:,:), bzial(:,:,:)

  real(8), allocatable :: akxiar(:,:,:), akxial(:,:,:), &
           akyiar(:,:,:), akyial(:,:,:), akziar(:,:,:), akzial(:,:,:), &
           ak2iar(:,:,:), ak2ial(:,:,:)

  real(8), allocatable :: swiar(:,:,:), swial(:,:,:)

  real(8) :: x1(imax), x2(jmax), x3(kmax)
      
  integer, allocatable :: iflxi(:,:,:), ihlldi(:,:,:)
!
  real(8) :: bxi, sir, sil, &
             rrirmx, rrirmy, rrirmz, rriren,  rrirbx, rrirby, rrirbz, &
             rrilmx, rrilmy, rrilmz, rrilen,  rrilbx, rrilby, rrilbz, &
             pti0, a, b, c, temp1ba, aa1, gg1, cc1, qq1, xx1, &
             vxiar1, vyiar1, vziar1, temp1a, temp1b, temp2a, wiar, & 
             bxiar1, byiar1, bziar1, swiar1, temp3a, &
             akxiar1, akyiar1, akziar1, ak2iar1, &
             aa2, gg2, cc2, qq2, xx2, &
             vxial1, vyial1, vzial1, temp2b, wial, & 
             bxial1, byial1, bzial1, swial1, temp3b, & 
             akxial1, akyial1, akzial1, ak2ial1, &
             dkxi, bxic1, byic1, bzic1, aklbci, akrbci, vxicl1, vxicr1, &
             csali1, csari1, cmidi1, fi0, pti1, fi, dpti

  real(8) :: ddial, vbial, enial, pxial, pyial, pzial, &
             ddiar, vbiar, eniar, pxiar, pyiar, pziar, &
             bxic, byic, bzic, scrhli, scrhri, &
             vxicl, vxicr, vyicl, vyicr, vzicl, vzicr, & 
             vxic, vyic, vzic, ddiaa, pxiaa, pyiaa, pziaa, eniaa, &
             csaai, vxiaa, vbic, enic
!
  allocate( uuih(nv,is1:ie1,js1:je1,ks1:ke1), &
            uuic(nv,is1:ie1,js1:je1,ks1:ke1), &
            uuiar(nv,is1:ie1,js1:je1,ks1:ke1), &
            uuial(nv,is1:ie1,js1:je1,ks1:ke1), &
            uriih(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwih(nv,is1:ie1,js1:je1,ks1:ke1), &
            rrir(nv,is1:ie1,js1:je1,ks1:ke1), &
            rril(nv,is1:ie1,js1:je1,ks1:ke1), &
            cmidi(is1:ie1,js1:je1,ks1:ke1), &
            csari(is1:ie1,js1:je1,ks1:ke1), csali(is1:ie1,js1:je1,ks1:ke1), &
            ptir(is1:ie1,js1:je1,ks1:ke1), ptil(is1:ie1,js1:je1,ks1:ke1), &
            ptih(is1:ie1,js1:je1,ks1:ke1), pti(is1:ie1,js1:je1,ks1:ke1), &
            vxiar(is1:ie1,js1:je1,ks1:ke1), vxial(is1:ie1,js1:je1,ks1:ke1), &
            vyiar(is1:ie1,js1:je1,ks1:ke1), vyial(is1:ie1,js1:je1,ks1:ke1), &
            vziar(is1:ie1,js1:je1,ks1:ke1), vzial(is1:ie1,js1:je1,ks1:ke1), &
            bxiar(is1:ie1,js1:je1,ks1:ke1), bxial(is1:ie1,js1:je1,ks1:ke1), &
            byiar(is1:ie1,js1:je1,ks1:ke1), byial(is1:ie1,js1:je1,ks1:ke1), &
            bziar(is1:ie1,js1:je1,ks1:ke1), bzial(is1:ie1,js1:je1,ks1:ke1), &
            akxiar(is1:ie1,js1:je1,ks1:ke1), akxial(is1:ie1,js1:je1,ks1:ke1), &
            akyiar(is1:ie1,js1:je1,ks1:ke1), akyial(is1:ie1,js1:je1,ks1:ke1), &
            akziar(is1:ie1,js1:je1,ks1:ke1), akzial(is1:ie1,js1:je1,ks1:ke1), &
            ak2iar(is1:ie1,js1:je1,ks1:ke1), ak2ial(is1:ie1,js1:je1,ks1:ke1), &
            swiar(is1:ie1,js1:je1,ks1:ke1), swial(is1:ie1,js1:je1,ks1:ke1), &
            iflxi(is1:ie1,js1:je1,ks1:ke1), ihlldi(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr ) 
!
!=====================================================================@
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        do n=1,nv
!
!   Check state
!
          iflxi(i,j,k)=0
          
          if(cmini(i,j,k) .gt. 0.d0) then
            ww(1,n,i,j,k)=wwil(n,i,j,k)
            iflxi(i,j,k)=1
          elseif(cmaxi(i,j,k) .le. 0.d0) then
            ww(1,n,i,j,k)=wwir(n,i,j,k)
            iflxi(i,j,k)=1
          else
!
!   Calculatetion of U_hll, F_hll (HLL state)
!
            uuih(n,i,j,k)=(cmaxi(i,j,k)*uuir(n,i,j,k) &
                         -cmini(i,j,k)*uuil(n,i,j,k) &
                         -wwir(n,i,j,k)+wwil(n,i,j,k)) &
                         /(cmaxi(i,j,k)-cmini(i,j,k))

            wwih(n,i,j,k)=(cmaxi(i,j,k)*wwil(n,i,j,k) &
                         -cmini(i,j,k)*wwir(n,i,j,k) &
                         -cmaxi(i,j,k)*cmini(i,j,k) &
                         *(uriir(n,i,j,k)-uriil(n,i,j,k))) &
                          /(cmaxi(i,j,k)-cmini(i,j,k))
!
!  Calculation of R_L,R
!
            rrir(n,i,j,k)=cmaxi(i,j,k)*uuir(n,i,j,k)-wwir(n,i,j,k)
            rril(n,i,j,k)=cmini(i,j,k)*uuil(n,i,j,k)-wwil(n,i,j,k)
          endif
          
        enddo
      enddo
    enddo
  enddo

!
! Calculation of premitive 1-state HLL variables
!
  if( iwvec.eq.6 ) then
    call recov1d(uuih,uriih,x1,x2,x3,iflag,nm0,is1,ie1,js1,je1,ks1,ke1)
  elseif( iwvec.eq.7 ) then
    call recov2da(uuih,uriih,x1,x2,x3,nm0,iflxi,is1,ie1,js1,je1,ks1,ke1)
  endif
!
! Calculation of total pressure
!
  call calpt(uriir,ptir,nm0,iflxi,is1,ie1,js1,je1,ks1,ke1)
  call calpt(uriil,ptil,nm0,iflxi,is1,ie1,js1,je1,ks1,ke1)
  call calpt(uriih,ptih,nm0,iflxi,is1,ie1,js1,je1,ks1,ke1)
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
!
        if(iflxi(i,j,k) .eq. 0) then
!
! Parameter
!
          bxi=uri(7,i,j,k)
          sir=cmaxi(i,j,k)
          sil=cmini(i,j,k)
!
! tau=taun+D
          rrirmx=rrir(2,i,j,k)
          rrirmy=rrir(3,i,j,k)
          rrirmz=rrir(4,i,j,k)
          rriren=rrir(5,i,j,k)+rrir(1,i,j,k)
          rrirbx=rrir(7,i,j,k)
          rrirby=rrir(8,i,j,k)
          rrirbz=rrir(9,i,j,k)
!
          rrilmx=rril(2,i,j,k)
          rrilmy=rril(3,i,j,k)
          rrilmz=rril(4,i,j,k)
          rrilen=rril(5,i,j,k)+rril(1,i,j,k)
          rrilbx=rril(7,i,j,k)
          rrilby=rril(8,i,j,k)
          rrilbz=rril(9,i,j,k)
!
          ihlldi(i,j,k)=0
!
! Calculation of initial guess
!
! Eq. (53)
          pti0=ptih(i,j,k)

          temp1a=max(ptir(i,j,k),ptil(i,j,k))
 
          if((bxi**2)/temp1a .le. 0.01d0) then
!
! Try B->0 limit Eq. (55)
!
!            a=1.0d0
!            b=uuih(5,i,j,k)-wwih(2,i,j,k)
!            c=uuih(2,i,j,k)*wwih(5,i,j,k)-wwih(2,i,j,k)*uuih(5,i,j,k)
            a=sir-sil
            b=rriren-rrilen+sir*rrilmx-sil*rrirmx
            c=rrilmx*rriren-rrirmx*rrilen
            temp1ba=b*b-4.0*a*c
            temp1b=max(temp1ba,0.d0)
            pti0=0.5*(-b+sqrt(temp1b))/a
          endif
!
! Calculate initial f0
!
! Right state across Fast wave
!
! Eq.(26)-(30)
          aa1=rrirmx+pti0*(1.0-sir*sir)-sir*rriren
          gg1=0.0+rrirby*rrirby+rrirbz*rrirbz
          cc1=0.0+rrirmy*rrirby+rrirmz*rrirbz
          qq1=-(aa1+gg1-bxi*bxi*(1.0-sir*sir))
          xx1=bxi*(aa1*sir*bxi+cc1)-(aa1+gg1)*(sir*pti0+rriren)
! Eq. (23)-(25)       
          vxiar1=(bxi*(aa1*bxi+cc1*sir)-(rrirmx+pti0)*(gg1+aa1))/xx1
          vyiar1=(qq1*rrirmy+rrirby*(cc1+bxi*(sir*rrirmx-rriren)))/xx1
          vziar1=(qq1*rrirmz+rrirbz*(cc1+bxi*(sir*rrirmx-rriren)))/xx1
! Eq. (31)
          temp2a=rriren-(vxiar1*rrirmx+vyiar1*rrirmy+vziar1*rrirmz)
          wiar=pti0+temp2a/(sir-vxiar1)

          if(wiar .lt. 0.d0) then
            ihlldi(i,j,k)=1
            wiar=abs(wiar)
          endif
! Eq. (21)
          bxiar1=bxi
          byiar1=(rrirby-bxi*vyiar1)/(sir-vxiar1)
          bziar1=(rrirbz-bxi*vziar1)/(sir-vxiar1)
! Eq. (35)
          if(bxi .lt. 0.d0) then
            swiar1=-bxi*sqrt(wiar)
!            swiar1=-1.0*sqrt(wiar)
          else
            swiar1=bxi*sqrt(wiar)
!            swiar1=sqrt(wiar)
          endif
! Eq. (36)
          temp3a=1.0/(sir*pti0+rriren+bxi*swiar1)
          akxiar1=temp3a*(rrirmx+pti0+rrirbx*swiar1)
          akyiar1=temp3a*(rrirmy+rrirby*swiar1)
          akziar1=temp3a*(rrirmz+rrirbz*swiar1)
     
          ak2iar1=akxiar1*akxiar1+akyiar1*akyiar1+akziar1*akziar1
!
! Left state across Fast wave
!
! Eq.(26)-(30)
          aa2=rrilmx+pti0*(1.0-sil*sil)-sil*rrilen
          gg2=0.0+rrilby*rrilby+rrilbz*rrilbz
          cc2=0.0+rrilmy*rrilby+rrilmz*rrilbz
          qq2=-(aa2+gg2-bxi*bxi*(1.0-sil*sil))
          xx2=bxi*(aa2*sil*bxi+cc2)-(aa2+gg2)*(sil*pti0+rrilen)
! Eq. (23)-(25)
          vxial1=(bxi*(aa2*bxi+cc2*sil)-(rrilmx+pti0)*(gg2+aa2))/xx2
          vyial1=(qq2*rrilmy+rrilby*(cc2+bxi*(sil*rrilmx-rrilen)))/xx2
          vzial1=(qq2*rrilmz+rrilbz*(cc2+bxi*(sil*rrilmx-rrilen)))/xx2
! Eq. (31)      
          temp2b=rrilen-(vxial1*rrilmx+vyial1*rrilmy+vzial1*rrilmz)
          wial=pti0+temp2b/(sil-vxial1)
      
          if(wial .lt. 0.d0) then
            ihlldi(i,j,k)=1
            wial=abs(wial)
          endif
! Eq. (21)      
          bxial1=bxi
          byial1=(rrilby-bxi*vyial1)/(sil-vxial1)
          bzial1=(rrilbz-bxi*vzial1)/(sil-vxial1)
! Eq. (35)
          if(bxi .lt. 0.d0) then
            swial1=bxi*sqrt(wial)
!            swial1=sqrt(wial)   
          else
            swial1=-bxi*sqrt(wial)
!            swial1=-1.0*sqrt(wial)
          endif
! Eq. (36)
          temp3b=1.0/(sil*pti0+rrilen+bxi*swial1)
          akxial1=temp3b*(rrilmx+pti0+rrilbx*swial1)
          akyial1=temp3b*(rrilmy+rrilby*swial1)
          akzial1=temp3b*(rrilmz+rrilbz*swial1)
     
          ak2ial1=akxial1*akxial1+akyial1*akyial1+akzial1*akzial1
!
! Jump condiiton across Alfven wave
!
! Eq. (45)
          dkxi=akxiar1-akxial1+1.0d-12
      
          bxic1=bxi*dkxi
          byic1=byiar1*(akxiar1-vxiar1)-byial1*(akxial1-vxial1) &
               +bxi*(vyiar1-vyial1)
          bzic1=bziar1*(akxiar1-vxiar1)-bzial1*(akxial1-vxial1) &
               +bxi*(vziar1-vzial1)
! Eq. (47)
          aklbci=akxial1*bxic1+akyial1*byic1+akzial1*bzic1
          akrbci=akxiar1*bxic1+akyiar1*byic1+akziar1*bzic1
      
          vxicl1=akxial1-dkxi*bxi*(1.0-ak2ial1)/(swial1*dkxi-aklbci)
          vxicr1=akxiar1-dkxi*bxi*(1.0-ak2iar1)/(swiar1*dkxi-akrbci)
      
          csali1=akxial1
          csari1=akxiar1
          cmidi1=0.5*(vxicl1+vxicr1)
          fi0=vxicl1-vxicr1
!
! Physically check of result
!
! Eq. (54)
          if(vxicl1-akxial1 .lt. 0.d0 .or. akxiar1-vxicr1 .lt. 0.d0) then
            ihlldi(i,j,k)=1
          endif
          if(sil-vxicl1 .gt. 0.d0 .or. sir-vxicr1 .lt. 0.d0) then
            ihlldi(i,j,k)=1
          endif
          if(wial-pti0 .lt. 0.d0 .or. wiar-pti0 .lt. 0.d0) then
            ihlldi(i,j,k)=1
          endif
          if(csali1-sil .lt. 0.d0 .or. sir-csari1 .lt. 0.d0) then
            ihlldi(i,j,k)=1
          endif
!
! Iteration
!
          if(abs(fi0) .gt. 1.0d-12 .and. ihlldi(i,j,k) .eq. 0) then
            pti1= 1.025*pti0
            fi=fi0
          
            nnn=0
            dpti=1.d0
        
            do nnn=1, iter
              if(abs(dpti) .gt. 1.0d-5*pti1 .or. abs(fi) .gt. 1.0d-6) then
           
                if(nnn .eq. iter) then
                  ihlldi(i,j,k)=1
            
                else

! Right state across Fast wave
!
! Eq. (26)-(30)
                  aa1=rrirmx+pti1*(1.0-sir*sir)-sir*rriren
                  gg1=0.0+rrirby*rrirby+rrirbz*rrirbz
                  cc1=0.0+rrirmy*rrirby+rrirmz*rrirbz
                  qq1=-(aa1+gg1-bxi*bxi*(1.0-sir*sir))
                  xx1=bxi*(aa1*sir*bxi+cc1)-(aa1+gg1)*(sir*pti1+rriren)
! Eq. (23)-(25)
                  vxiar1=(bxi*(aa1*bxi+cc1*sir)-(rrirmx+pti1)*(gg1+aa1))/xx1
                  vyiar1=(qq1*rrirmy+rrirby*(cc1+bxi*(sir*rrirmx-rriren)))/xx1
                  vziar1=(qq1*rrirmz+rrirbz*(cc1+bxi*(sir*rrirmx-rriren)))/xx1
! Eq. (31)
                  temp2a=rriren-(vxiar1*rrirmx+vyiar1*rrirmy+vziar1*rrirmz)
                  wiar=pti1+temp2a/(sir-vxiar1)
      
                  if(wiar .lt. 0.d0) then
                    ihlldi(i,j,k)=1
                    wiar=abs(wiar)
                  endif
! Eq. (21)
                  bxiar1=bxi
                  byiar1=(rrirby-bxi*vyiar1)/(sir-vxiar1)
                  bziar1=(rrirbz-bxi*vziar1)/(sir-vxiar1)
! Eq. (35)
                  if(bxi .lt. 0.d0) then
!                    swiar1=-bxi*sqrt(wiar)
                    swiar1=-1.0*sqrt(wiar)              
                  else
!                    swiar1=bxi*sqrt(wiar)
                    swiar1=sqrt(wiar)
                  endif
! Eq. (36)
                  temp3a=1.0/(sir*pti1+rriren+bxi*swiar1)
                  akxiar1=temp3a*(rrirmx+pti1+rrirbx*swiar1)
                  akyiar1=temp3a*(rrirmy+rrirby*swiar1)
                  akziar1=temp3a*(rrirmz+rrirbz*swiar1)
      
                  ak2iar1=akxiar1*akxiar1+akyiar1*akyiar1+akziar1*akziar1
!
! Left state across Fast wave
!
! Eq. (26)-(30)
                  aa2=rrilmx+pti1*(1.0-sil*sil)-sil*rrilen
                  gg2=0.0+rrilby*rrilby+rrilbz*rrilbz
                  cc2=0.0+rrilmy*rrilby+rrilmz*rrilbz
                  qq2=-(aa2+gg2-bxi*bxi*(1.0-sil*sil))
                  xx2=bxi*(aa2*sil*bxi+cc2)-(aa2+gg2)*(sil*pti1+rrilen)
! Eq. (23)-(25)
                  vxial1=(bxi*(aa2*bxi+cc2*sil)-(rrilmx+pti1)*(gg2+aa2))/xx2
                  vyial1=(qq2*rrilmy+rrilby*(cc2+bxi*(sil*rrilmx-rrilen)))/xx2
                  vzial1=(qq2*rrilmz+rrilbz*(cc2+bxi*(sil*rrilmx-rrilen)))/xx2
! Eq. (31)
                  temp2b=rrilen-(vxial1*rrilmx+vyial1*rrilmy+vzial1*rrilmz)
                  wial=pti1+temp2b/(sil-vxial1)
       
                  if(wial .lt. 0.d0) then
                    ihlldi(i,j,k)=1
                    wial=abs(wial)
                  endif
! Eq. (21)
                  bxial1=bxi
                  byial1=(rrilby-bxi*vyial1)/(sil-vxial1)
                  bzial1=(rrilbz-bxi*vzial1)/(sil-vxial1)
! Eq. (35)
                  if(bxi .lt. 0.d0) then
!                    swial1=bxi*sqrt(wial)
                    swial1=sqrt(wial)
                  else
!                    swial1=-bxi*sqrt(wial)
                    swial1=-1.0*sqrt(wial)
                  endif
! Eq. (36)
                  temp3b=1.0/(sil*pti1+rrilen+bxi*swial1)
                  akxial1=temp3b*(rrilmx+pti1+rrilbx*swial1)
                  akyial1=temp3b*(rrilmy+rrilby*swial1)
                  akzial1=temp3b*(rrilmz+rrilbz*swial1)
      
                  ak2ial1=akxial1*akxial1+akyial1*akyial1+akzial1*akzial1

! Jump condiiton across Alfven wave
!
! Eq. (45)
                  dkxi=akxiar1-akxial1+1.0d-12
       
                  bxic1=bxi*dkxi
                  byic1=byiar1*(akxiar1-vxiar1)-byial1*(akxial1-vxial1) &
                       +bxi*(vyiar1-vyial1)
                  bzic1=bziar1*(akxiar1-vxiar1)-bzial1*(akxial1-vxial1) &
                       +bxi*(vziar1-vzial1)
! Eq. (47)
                  aklbci=akxial1*bxic1+akyial1*byic1+akzial1*bzic1
                  akrbci=akxiar1*bxic1+akyiar1*byic1+akziar1*bzic1
     
                  vxicl1=akxial1-dkxi*bxi*(1.0-ak2ial1)/(swial1*dkxi-aklbci)
                  vxicr1=akxiar1-dkxi*bxi*(1.0-ak2iar1)/(swiar1*dkxi-akrbci)
      
                  csali1=akxial1
                  csari1=akxiar1
                  cmidi1=0.5*(vxicl1+vxicr1)
                  fi=vxicl1-vxicr1
!
! Physically check of result
!
! Eq. (54)
                  if(vxicl1-akxial1.lt.0.d0 .or. akxiar1-vxicr1.lt.0.d0) then 
                    ihlldi(i,j,k)=1
                  endif
                  if(sil-vxial1 .gt. 0.d0 .or. sir-vxiar1 .lt. 0.d0) then
                    ihlldi(i,j,k)=1
                  endif
                  if(wial-pti1 .lt. 0.d0 .or. wiar-pti1 .lt. 0.d0) then
                    ihlldi(i,j,k)=1
                  endif
                  if(csali1-sil .lt. 0.d0 .or. sir-csari1 .lt. 0.d0) then
                    ihlldi(i,j,k)=1
                  endif
!           
                  dpti=(pti1-pti0)/(fi-fi0)*fi
            
                  pti0=pti1
                  fi0=fi
                  pti1=pti1-dpti
            
                  if(pti1 .lt. 0.d0) then
                    pti1=1.0d-6
                  endif
           
                endif
              endif

            enddo
          
          else
            pti1=pti0
          endif
         
          if(ihlldi(i,j,k) .eq. 0) then
            pti(i,j,k)=pti1
        
            vxiar(i,j,k)=vxiar1
            vyiar(i,j,k)=vyiar1
            vziar(i,j,k)=vziar1
            bxiar(i,j,k)=bxiar1
            byiar(i,j,k)=byiar1
            bziar(i,j,k)=bziar1
         
            vxial(i,j,k)=vxial1
            vyial(i,j,k)=vyial1
            vzial(i,j,k)=vzial1
            bxial(i,j,k)=bxial1
            byial(i,j,k)=byial1
            bzial(i,j,k)=bzial1
         
            swiar(i,j,k)=swiar1
            swial(i,j,k)=swial1
        
            akxiar(i,j,k)=akxiar1
            akyiar(i,j,k)=akyiar1
            akziar(i,j,k)=akziar1
            ak2iar(i,j,k)=ak2iar1
         
            akxial(i,j,k)=akxial1
            akyial(i,j,k)=akyial1
            akzial(i,j,k)=akzial1
            ak2ial(i,j,k)=ak2ial1
         
            csali(i,j,k)=csali1
            csari(i,j,k)=csari1
            cmidi(i,j,k)=cmidi1
          endif
!         
        endif
!
      enddo
    enddo
  enddo
!
! Calculation of Numerical Flux
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
         
        if(iflxi(i,j,k) .eq. 0) then
          
          if(ihlldi(i,j,k) .eq. 1) then
!
            ww(1,1,i,j,k)=wwih(1,i,j,k)
            ww(1,2,i,j,k)=wwih(2,i,j,k)
            ww(1,3,i,j,k)=wwih(3,i,j,k)
            ww(1,4,i,j,k)=wwih(4,i,j,k)
            ww(1,5,i,j,k)=wwih(5,i,j,k)
            ww(1,6,i,j,k)=wwih(6,i,j,k)
            ww(1,7,i,j,k)=wwih(7,i,j,k)
            ww(1,8,i,j,k)=wwih(8,i,j,k)
            ww(1,9,i,j,k)=wwih(9,i,j,k)
!
          else
            bxi=uri(7,i,j,k)
!          
            if(csali(i,j,k) .gt. 0.d0) then
!
!  Calculate state behind aL
!
! Eq. (21), (32)-(34)
              temp1a=1.0/(cmini(i,j,k)-vxial(i,j,k))
              ddial=rril(1,i,j,k)*temp1a
              bxial(i,j,k)=bxi
              byial(i,j,k)=(rril(8,i,j,k)-bxi*vyial(i,j,k))*temp1a
              bzial(i,j,k)=(rril(9,i,j,k)-bxi*vzial(i,j,k))*temp1a
              vbial=vxial(i,j,k)*bxial(i,j,k) &
                   +vyial(i,j,k)*byial(i,j,k) &
                   +vzial(i,j,k)*bzial(i,j,k)
              rrilen=rril(5,i,j,k)+rril(1,i,j,k)
              enial=(rrilen+pti(i,j,k)*vxial(i,j,k)-vbial*bxi)*temp1a
              pxial=(enial+pti(i,j,k))*vxial(i,j,k)-vbial*bxial(i,j,k)
              pyial=(enial+pti(i,j,k))*vyial(i,j,k)-vbial*byial(i,j,k)
              pzial=(enial+pti(i,j,k))*vzial(i,j,k)-vbial*bzial(i,j,k)

              uuial(1,i,j,k)=ddial
              uuial(2,i,j,k)=pxial
              uuial(3,i,j,k)=pyial
              uuial(4,i,j,k)=pzial
              uuial(5,i,j,k)=enial-ddial
              uuial(6,i,j,k)=1.0d-12
              uuial(7,i,j,k)=bxial(i,j,k)
              uuial(8,i,j,k)=byial(i,j,k)
              uuial(9,i,j,k)=bzial(i,j,k)
! Eq. (16)
              ww(1,1,i,j,k)=wwil(1,i,j,k)+cmini(i,j,k) &
                           *(uuial(1,i,j,k)-uuil(1,i,j,k))
              ww(1,2,i,j,k)=wwil(2,i,j,k)+cmini(i,j,k) &
                           *(uuial(2,i,j,k)-uuil(2,i,j,k))
              ww(1,3,i,j,k)=wwil(3,i,j,k)+cmini(i,j,k) &
                           *(uuial(3,i,j,k)-uuil(3,i,j,k))
              ww(1,4,i,j,k)=wwil(4,i,j,k)+cmini(i,j,k) &
                           *(uuial(4,i,j,k)-uuil(4,i,j,k))
              ww(1,5,i,j,k)=wwil(5,i,j,k)+cmini(i,j,k) &
                           *(uuial(5,i,j,k)-uuil(5,i,j,k))
              ww(1,7,i,j,k)=wwil(7,i,j,k)+cmini(i,j,k) &
                           *(uuial(7,i,j,k)-uuil(7,i,j,k))
              ww(1,8,i,j,k)=wwil(8,i,j,k)+cmini(i,j,k) &
                           *(uuial(8,i,j,k)-uuil(8,i,j,k))
              ww(1,9,i,j,k)=wwil(9,i,j,k)+cmini(i,j,k) &
                           *(uuial(9,i,j,k)-uuil(9,i,j,k))
!
              ww(1,6,i,j,k)=wwih(6,i,j,k)
!
            elseif(csari(i,j,k) .le. 0.d0) then
!
!  Calculate state behind aR
!
! Eq. (21), (32)-(34)
              temp1b=1.0/(cmaxi(i,j,k)-vxiar(i,j,k))
              ddiar=rrir(1,i,j,k)*temp1b
              bxiar(i,j,k)=bxi
              byiar(i,j,k)=(rrir(8,i,j,k)-bxi*vyiar(i,j,k))*temp1b
              bziar(i,j,k)=(rrir(9,i,j,k)-bxi*vziar(i,j,k))*temp1b
              vbiar=vxiar(i,j,k)*bxiar(i,j,k) &
                   +vyiar(i,j,k)*byiar(i,j,k) &
                   +vziar(i,j,k)*bziar(i,j,k)
              rriren=rrir(5,i,j,k)+rrir(1,i,j,k)
              eniar=(rriren+pti(i,j,k)*vxiar(i,j,k)-vbiar*bxi)*temp1b
              pxiar=(eniar+pti(i,j,k))*vxiar(i,j,k)-vbiar*bxiar(i,j,k)
              pyiar=(eniar+pti(i,j,k))*vyiar(i,j,k)-vbiar*byiar(i,j,k)
              pziar=(eniar+pti(i,j,k))*vziar(i,j,k)-vbiar*bziar(i,j,k)

              uuiar(1,i,j,k)=ddiar
              uuiar(2,i,j,k)=pxiar
              uuiar(3,i,j,k)=pyiar
              uuiar(4,i,j,k)=pziar
              uuiar(5,i,j,k)=eniar-ddiar
              uuiar(6,i,j,k)=1.0d-12
              uuiar(7,i,j,k)=bxiar(i,j,k)
              uuiar(8,i,j,k)=byiar(i,j,k)
              uuiar(9,i,j,k)=bziar(i,j,k)
! Eq. (16)
              ww(1,1,i,j,k)=wwir(1,i,j,k)+cmaxi(i,j,k) &
                           *(uuiar(1,i,j,k)-uuir(1,i,j,k))
              ww(1,2,i,j,k)=wwir(2,i,j,k)+cmaxi(i,j,k) &
                           *(uuiar(2,i,j,k)-uuir(2,i,j,k))
              ww(1,3,i,j,k)=wwir(3,i,j,k)+cmaxi(i,j,k) &
                           *(uuiar(3,i,j,k)-uuir(3,i,j,k))
              ww(1,4,i,j,k)=wwir(4,i,j,k)+cmaxi(i,j,k) &
                           *(uuiar(4,i,j,k)-uuir(4,i,j,k))
              ww(1,5,i,j,k)=wwir(5,i,j,k)+cmaxi(i,j,k) &
                           *(uuiar(5,i,j,k)-uuir(5,i,j,k))
              ww(1,7,i,j,k)=wwir(7,i,j,k)+cmaxi(i,j,k) &
                           *(uuiar(7,i,j,k)-uuir(7,i,j,k))
              ww(1,8,i,j,k)=wwir(8,i,j,k)+cmaxi(i,j,k) &
                           *(uuiar(8,i,j,k)-uuir(8,i,j,k))
              ww(1,9,i,j,k)=wwir(9,i,j,k)+cmaxi(i,j,k) &
                           *(uuiar(9,i,j,k)-uuir(9,i,j,k))
!
              ww(1,6,i,j,k)=wwih(6,i,j,k)
!
            else
!
!  Calculate state cL across contact mode
!
!  Calculate state behind aL
! Eq. (21), (32)-(34) 
              temp1a=1.0/(cmini(i,j,k)-vxial(i,j,k))
              bxial(i,j,k)=bxi
              byial(i,j,k)=(rril(8,i,j,k)-bxi*vyial(i,j,k))*temp1a
              bzial(i,j,k)=(rril(9,i,j,k)-bxi*vzial(i,j,k))*temp1a
              vbial=vxial(i,j,k)*bxial(i,j,k) &
                   +vyial(i,j,k)*byial(i,j,k) &
                   +vzial(i,j,k)*bzial(i,j,k) 
              rrilen=rril(5,i,j,k)+rril(1,i,j,k)
              enial=(rrilen+pti(i,j,k)*vxial(i,j,k)-vbial*bxi)*temp1a
              pxial=(enial+pti(i,j,k))*vxial(i,j,k)-vbial*bxial(i,j,k)
              pyial=(enial+pti(i,j,k))*vyial(i,j,k)-vbial*byial(i,j,k)
              pzial=(enial+pti(i,j,k))*vzial(i,j,k)-vbial*bzial(i,j,k)

              uuial(1,i,j,k)=ddial
              uuial(2,i,j,k)=pxial
              uuial(3,i,j,k)=pyial
              uuial(4,i,j,k)=pzial
              uuial(5,i,j,k)=enial-ddial
              uuial(6,i,j,k)=1.0d-12
              uuial(7,i,j,k)=bxial(i,j,k)
              uuial(8,i,j,k)=byial(i,j,k)
              uuial(9,i,j,k)=bzial(i,j,k)
!
!  Calculate state behind aR
! Eq. (21), (32)-(34)           
              temp1b=1.0/(cmaxi(i,j,k)-vxiar(i,j,k))
              bxiar(i,j,k)=bxi
              byiar(i,j,k)=(rrir(8,i,j,k)-bxi*vyiar(i,j,k))*temp1b
              bziar(i,j,k)=(rrir(9,i,j,k)-bxi*vziar(i,j,k))*temp1b
              vbiar=vxiar(i,j,k)*bxiar(i,j,k) &
                   +vyiar(i,j,k)*byiar(i,j,k) &
                   +vziar(i,j,k)*bziar(i,j,k)
              rriren=rrir(5,i,j,k)+rrir(1,i,j,k)
              eniar=(rriren+pti(i,j,k)*vxiar(i,j,k)-vbiar*bxi)*temp1b
              pxiar=(eniar+pti(i,j,k))*vxiar(i,j,k)-vbiar*bxiar(i,j,k)
              pyiar=(eniar+pti(i,j,k))*vyiar(i,j,k)-vbiar*byiar(i,j,k)
              pziar=(eniar+pti(i,j,k))*vziar(i,j,k)-vbiar*bziar(i,j,k)

              uuiar(1,i,j,k)=ddiar
              uuiar(2,i,j,k)=pxiar
              uuiar(3,i,j,k)=pyiar
              uuiar(4,i,j,k)=pziar
              uuiar(5,i,j,k)=eniar-ddiar
              uuiar(6,i,j,k)=1.0d-12
              uuiar(7,i,j,k)=bxiar(i,j,k)
              uuiar(8,i,j,k)=byiar(i,j,k)
              uuiar(9,i,j,k)=bziar(i,j,k)
! Eq. (45)
              dkxi=akxiar(i,j,k)-akxial(i,j,k)+1.0d-12
      
              bxic=bxi*dkxi
              byic=byiar(i,j,k)*(akxiar(i,j,k)-vxiar(i,j,k)) &
                  -byial(i,j,k)*(akxial(i,j,k)-vxial(i,j,k)) &
                  +bxi*(vyiar(i,j,k)-vyial(i,j,k))
              bzic=bziar(i,j,k)*(akxiar(i,j,k)-vxiar(i,j,k)) &
                  -bzial(i,j,k)*(akxial(i,j,k)-vxial(i,j,k)) &
                  +bxi*(vziar(i,j,k)-vzial(i,j,k))
!
              bxic=bxi
              byic=byic/dkxi
              bzic=bzic/dkxi
! Eq. (47)
              aklbci=akxial(i,j,k)*bxic+akyial(i,j,k)*byic+akzial(i,j,k)*bzic
              akrbci=akxiar(i,j,k)*bxic+akyiar(i,j,k)*byic+akziar(i,j,k)*bzic

              scrhli=(1.0-ak2ial(i,j,k))/(swial(i,j,k)-aklbci)
              scrhri=(1.0-ak2iar(i,j,k))/(swiar(i,j,k)-akrbci)
          
              vxicl=akxial(i,j,k)-bxic*scrhli
              vxicr=akxiar(i,j,k)-bxic*scrhri
          
              vyicl=akyial(i,j,k)-byic*scrhli
              vyicr=akyiar(i,j,k)-byic*scrhri
          
              vzicl=akzial(i,j,k)-bzic*scrhli
              vzicr=akziar(i,j,k)-bzic*scrhri

              vxic=0.5*(vxicl+vxicr)
              vyic=0.5*(vyicl+vyicr)
              vzic=0.5*(vzicl+vzicr)
            
              if(vxic .gt. 0.d0) then
                ddiaa=uuial(1,i,j,k)
                pxiaa=uuial(2,i,j,k)
                pyiaa=uuial(3,i,j,k)
                pziaa=uuial(4,i,j,k)
                eniaa=uuial(5,i,j,k)+uuial(1,i,j,k)
                csaai=csali(i,j,k)
                vxiaa=vxial(i,j,k)
              else
                ddiaa=uuiar(1,i,j,k)
                pxiaa=uuiar(2,i,j,k)
                pyiaa=uuiar(3,i,j,k)
                pziaa=uuiar(4,i,j,k)
                eniaa=uuiar(5,i,j,k)+uuiar(1,i,j,k)
                csaai=csari(i,j,k)
                vxiaa=vxiar(i,j,k)
              endif
! Eq. (50)-(52)
              vbic=vxic*bxic+vyic*byic+vzic*bzic
           
              uuic(1,i,j,k)=ddiaa*(csaai-vxiaa)/(csaai-vxic)
!
              enic=(csaai*eniaa-pxiaa+pti(i,j,k)*vxic &
                        -vbic*bxic)/(csaai-vxic)
              uuic(2,i,j,k)=(enic+pti(i,j,k))*vxic-vbic*bxic
              uuic(3,i,j,k)=(enic+pti(i,j,k))*vyic-vbic*byic
              uuic(4,i,j,k)=(enic+pti(i,j,k))*vzic-vbic*bzic
              uuic(5,i,j,k)=enic-uuic(1,i,j,k)
              uuic(6,i,j,k)=1.0d-12
              uuic(7,i,j,k)=bxic
              uuic(8,i,j,k)=byic
              uuic(9,i,j,k)=bzic
           
              if(cmidi(i,j,k) .gt. 0.d0) then
            
                ww(1,1,i,j,k)=wwil(1,i,j,k)+cmini(i,j,k) &
                             *(uuial(1,i,j,k)-uuil(1,i,j,k))+csali(i,j,k) &
                             *(uuic(1,i,j,k)-uuial(1,i,j,k))
                ww(1,2,i,j,k)=wwil(2,i,j,k)+cmini(i,j,k) &
                             *(uuial(2,i,j,k)-uuil(2,i,j,k))+csali(i,j,k) &
                             *(uuic(2,i,j,k)-uuial(2,i,j,k))
                ww(1,3,i,j,k)=wwil(3,i,j,k)+cmini(i,j,k) &
                             *(uuial(3,i,j,k)-uuil(3,i,j,k))+csali(i,j,k) &
                             *(uuic(3,i,j,k)-uuial(3,i,j,k))
                ww(1,4,i,j,k)=wwil(4,i,j,k)+cmini(i,j,k) &
                             *(uuial(4,i,j,k)-uuil(4,i,j,k))+csali(i,j,k) &
                             *(uuic(4,i,j,k)-uuial(4,i,j,k))
                ww(1,5,i,j,k)=wwil(5,i,j,k)+cmini(i,j,k) &
                             *(uuial(5,i,j,k)-uuil(5,i,j,k))+csali(i,j,k) &
                             *(uuic(5,i,j,k)-uuial(5,i,j,k))
                ww(1,7,i,j,k)=wwil(7,i,j,k)+cmini(i,j,k) &
                             *(uuial(7,i,j,k)-uuil(7,i,j,k))+csali(i,j,k) &
                             *(uuic(7,i,j,k)-uuial(7,i,j,k))
                ww(1,8,i,j,k)=wwil(8,i,j,k)+cmini(i,j,k) &
                             *(uuial(8,i,j,k)-uuil(8,i,j,k))+csali(i,j,k) &
                             *(uuic(8,i,j,k)-uuial(8,i,j,k))
                ww(1,9,i,j,k)=wwil(9,i,j,k)+cmini(i,j,k) &
                             *(uuial(9,i,j,k)-uuil(9,i,j,k))+csali(i,j,k) &
                             *(uuic(9,i,j,k)-uuial(9,i,j,k))
!
                ww(1,6,i,j,k)=wwih(6,i,j,k)
!
              else

                ww(1,1,i,j,k)=wwir(1,i,j,k)+cmaxi(i,j,k) &
                             *(uuiar(1,i,j,k)-uuir(1,i,j,k))+csari(i,j,k) &
                             *(uuic(1,i,j,k)-uuiar(1,i,j,k))
                ww(1,2,i,j,k)=wwir(2,i,j,k)+cmaxi(i,j,k) &
                             *(uuiar(2,i,j,k)-uuir(2,i,j,k))+csari(i,j,k) &
                             *(uuic(2,i,j,k)-uuiar(2,i,j,k))
                ww(1,3,i,j,k)=wwir(3,i,j,k)+cmaxi(i,j,k) &
                             *(uuiar(3,i,j,k)-uuir(3,i,j,k))+csari(i,j,k) &
                             *(uuic(3,i,j,k)-uuiar(3,i,j,k)) 
                ww(1,4,i,j,k)=wwir(4,i,j,k)+cmaxi(i,j,k) &
                             *(uuiar(4,i,j,k)-uuir(4,i,j,k))+csari(i,j,k) &
                             *(uuic(4,i,j,k)-uuiar(4,i,j,k))
                ww(1,5,i,j,k)=wwir(5,i,j,k)+cmaxi(i,j,k) &
                             *(uuiar(5,i,j,k)-uuir(5,i,j,k))+csari(i,j,k) &
                             *(uuic(5,i,j,k)-uuiar(5,i,j,k))
                ww(1,7,i,j,k)=wwir(7,i,j,k)+cmaxi(i,j,k) &
                             *(uuiar(7,i,j,k)-uuir(7,i,j,k))+csari(i,j,k) &
                             *(uuic(7,i,j,k)-uuiar(7,i,j,k))
                ww(1,8,i,j,k)=wwir(8,i,j,k)+cmaxi(i,j,k) &
                             *(uuiar(8,i,j,k)-uuir(8,i,j,k))+csari(i,j,k) &
                             *(uuic(8,i,j,k)-uuiar(8,i,j,k))
                ww(1,9,i,j,k)=wwir(9,i,j,k)+cmaxi(i,j,k) &
                             *(uuial(9,i,j,k)-uuir(9,i,j,k))+csari(i,j,k) &
                             *(uuic(9,i,j,k)-uuiar(9,i,j,k))
!
                ww(1,6,i,j,k)=wwih(6,i,j,k)
!
              endif
            endif
!
          endif
!
        endif
!
      enddo
    enddo
  enddo
 
!==========================
  deallocate( uuih, uuic, uuiar, uuial, uriih, wwih, rrir, rril, &
              cmidi, csari, csali, ptir, ptil, ptih, pti, &
              vxiar, vxial, vyiar, vyial, vziar, vzial, &
              bxiar, bxial, byiar, byial, bziar, bzial, &
              akxiar, akxial, akyiar, akyial, akziar, akzial, &
              ak2iar, ak2ial, swiar, swial, iflxi, ihlldi, stat=merr ) 
!
  return
end subroutine hlldsi  
!
!---------------------------------------------------------------------@
subroutine hlldsj(ww,x1,x2,x3,uri,urijr,urijl,uujr,uujl, &
                  wwjr,wwjl,cmaxj,cminj,nm0,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate numerical flux by HLLD scheme 
!    (Mignone et al. 2010)
!     y-direction
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, iwvec, iter, iflag
  implicit none

  integer :: i, j, k, n, nnn
  integer :: nm0, is1, ie1, js1, je1, ks1, ke1, merr

  real(8) :: uujr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: uujh(:,:,:,:), uujc(:,:,:,:), &
           uujar(:,:,:,:), uujal(:,:,:,:)
     
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: urijr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: urijh(:,:,:,:)
     
  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwjr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: wwjh(:,:,:,:)
      
  real(8), allocatable :: rrjr(:,:,:,:), rrjl(:,:,:,:)
      
  real(8) :: cmaxj(is1:ie1,js1:je1,ks1:ke1), &
             cminj(is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: cmidj(:,:,:), csarj(:,:,:), csalj(:,:,:)

  real(8), allocatable :: ptjr(:,:,:), ptjl(:,:,:), &
           ptjh(:,:,:), ptj(:,:,:)

  real(8), allocatable :: vxjar(:,:,:), vxjal(:,:,:), &
           vyjar(:,:,:), vyjal(:,:,:), vzjar(:,:,:), vzjal(:,:,:)

  real(8), allocatable :: bxjar(:,:,:), bxjal(:,:,:), &
           byjar(:,:,:), byjal(:,:,:), bzjar(:,:,:),  bzjal(:,:,:)

  real(8), allocatable :: akxjar(:,:,:), akxjal(:,:,:), &
           akyjar(:,:,:), akyjal(:,:,:), akzjar(:,:,:), akzjal(:,:,:), &
           ak2jar(:,:,:), ak2jal(:,:,:)

  real(8), allocatable :: swjar(:,:,:), swjal(:,:,:)

  real(8) :: x1(imax),x2(jmax),x3(kmax)
  
  integer, allocatable :: iflxj(:,:,:), ihlldj(:,:,:)
      
  real(8) ::  byj, sjr, sjl, &
              rrjrmx, rrjrmy, rrjrmz, rrjren,  rrjrbx, rrjrby, rrjrbz, &
              rrjlmx, rrjlmy, rrjlmz, rrjlen,  rrjlbx, rrjlby, rrjlbz, &
              ptj0, a, b, c, temp1ba, aa1, gg1, cc1, qq1, xx1, &
              vxjar1, vyjar1, vzjar1, temp1a, temp1b, temp2a, wjar, & 
              bxjar1, byjar1, bzjar1, swjar1, temp3a, &
              akxjar1, akyjar1, akzjar1, ak2jar1, &
              aa2, gg2, cc2, qq2, xx2, &
              vxjal1, vyjal1, vzjal1, temp2b, wjal, & 
              bxjal1, byjal1, bzjal1, swjal1, temp3b, & 
              akxjal1, akyjal1, akzjal1, ak2jal1, &
              dkyj, bxjc1, byjc1, bzjc1, aklbcj, akrbcj, vyjcl1, vyjcr1, &
              csalj1, csarj1, cmidj1, fj0, ptj1, fj, dptj

  real(8) :: ddjal, vbjal, enjal, pxjal, pyjal, pzjal, &
             ddjar, vbjar, enjar, pxjar, pyjar, pzjar, &
             bxjc, byjc, bzjc, scrhlj, scrhrj, &
             vxjcl, vxjcr, vyjcl, vyjcr, vzjcl, vzjcr, & 
             vxjc, vyjc, vzjc, ddjaa, pxjaa, pyjaa, pzjaa, enjaa, &
             csaaj, vyjaa, vbjc, enjc
!
  allocate( uujh(nv,is1:ie1,js1:je1,ks1:ke1), &
            uujc(nv,is1:ie1,js1:je1,ks1:ke1), &
            uujar(nv,is1:ie1,js1:je1,ks1:ke1), &
            uujal(nv,is1:ie1,js1:je1,ks1:ke1), &
            urijh(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwjh(nv,is1:ie1,js1:je1,ks1:ke1), &
            rrjr(nv,is1:ie1,js1:je1,ks1:ke1), &
            rrjl(nv,is1:ie1,js1:je1,ks1:ke1), &
            cmidj(is1:ie1,js1:je1,ks1:ke1), csarj(is1:ie1,js1:je1,ks1:ke1), &
            csalj(is1:ie1,js1:je1,ks1:ke1), &
            ptjr(is1:ie1,js1:je1,ks1:ke1), ptjl(is1:ie1,js1:je1,ks1:ke1), &
            ptjh(is1:ie1,js1:je1,ks1:ke1), ptj(is1:ie1,js1:je1,ks1:ke1), &
            vxjar(is1:ie1,js1:je1,ks1:ke1), vxjal(is1:ie1,js1:je1,ks1:ke1), &
            vyjar(is1:ie1,js1:je1,ks1:ke1), vyjal(is1:ie1,js1:je1,ks1:ke1), &
            vzjar(is1:ie1,js1:je1,ks1:ke1), vzjal(is1:ie1,js1:je1,ks1:ke1), &
            bxjar(is1:ie1,js1:je1,ks1:ke1), bxjal(is1:ie1,js1:je1,ks1:ke1), &
            byjar(is1:ie1,js1:je1,ks1:ke1), byjal(is1:ie1,js1:je1,ks1:ke1), &
            bzjar(is1:ie1,js1:je1,ks1:ke1),  bzjal(is1:ie1,js1:je1,ks1:ke1), &
            akxjar(is1:ie1,js1:je1,ks1:ke1), akxjal(is1:ie1,js1:je1,ks1:ke1), &
            akyjar(is1:ie1,js1:je1,ks1:ke1), akyjal(is1:ie1,js1:je1,ks1:ke1), &
            akzjar(is1:ie1,js1:je1,ks1:ke1), akzjal(is1:ie1,js1:je1,ks1:ke1), &
            ak2jar(is1:ie1,js1:je1,ks1:ke1), ak2jal(is1:ie1,js1:je1,ks1:ke1), &
            swjar(is1:ie1,js1:je1,ks1:ke1), swjal(is1:ie1,js1:je1,ks1:ke1), &
            iflxj(is1:ie1,js1:je1,ks1:ke1), ihlldj(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr )
!
!=====================================================================@
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        do n=1,nv
!
!   Check state
!
          iflxj(i,j,k)=0
          
          if(cminj(i,j,k) .gt. 0.d0) then
            ww(2,n,i,j,k)=wwjl(n,i,j,k)
            iflxj(i,j,k)=1
          elseif(cmaxj(i,j,k) .le. 0.d0) then
            ww(2,n,i,j,k)=wwjr(n,i,j,k)
            iflxj(i,j,k)=1
          else
!
!   Calculatetion of U_hll, F_hll (HLL state)
!
            uujh(n,i,j,k)=(cmaxj(i,j,k)*uujr(n,i,j,k) &
                         -cminj(i,j,k)*uujl(n,i,j,k) &
                         -wwjr(n,i,j,k)+wwjl(n,i,j,k)) &
                         /(cmaxj(i,j,k)-cminj(i,j,k)) 

            wwjh(n,i,j,k)=(cmaxj(i,j,k)*wwjl(n,i,j,k) &
                         -cminj(i,j,k)*wwjr(n,i,j,k) &
                         -cmaxj(i,j,k)*cminj(i,j,k) &
                         *(urijr(n,i,j,k)-urijl(n,i,j,k))) &
                          /(cmaxj(i,j,k)-cminj(i,j,k))
!
!  Calculation of R_L,R
!
            rrjr(n,i,j,k)=cmaxj(i,j,k)*uujr(n,i,j,k)-wwjr(n,i,j,k)
            rrjl(n,i,j,k)=cminj(i,j,k)*uujl(n,i,j,k)-wwjl(n,i,j,k)
          endif
          
        enddo
      enddo
    enddo
  enddo
!
! Calculation of premitive 1-state HLL variables
!
  if( iwvec.eq.6 ) then
    call recov1d(uujh,urijh,x1,x2,x3,nm0,is1,ie1,js1,je1,ks1,ke1)
  elseif( iwvec.eq.7 ) then
    call recov2da(uujh,urijh,x1,x2,x3,nm0,iflxj,is1,ie1,js1,je1,ks1,ke1)
  endif
!
! Calculation of total pressure
!
  call calpt(urijr,ptjr,nm0,iflxj,is1,ie1,js1,je1,ks1,ke1)
  call calpt(urijl,ptjl,nm0,iflxj,is1,ie1,js1,je1,ks1,ke1)
  call calpt(urijh,ptjh,nm0,iflxj,is1,ie1,js1,je1,ks1,ke1)
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
!
        if(iflxj(i,j,k) .eq. 0) then
!
! Parameter
!
          byj=uri(8,i,j,k)
          sjr=cmaxj(i,j,k)
          sjl=cminj(i,j,k)
!
! tau=taun+D
          rrjrmx=rrjr(2,i,j,k)
          rrjrmy=rrjr(3,i,j,k)
          rrjrmz=rrjr(4,i,j,k)
          rrjren=rrjr(5,i,j,k)+rrjr(1,i,j,k)
          rrjrbx=rrjr(7,i,j,k)
          rrjrby=rrjr(8,i,j,k)
          rrjrbz=rrjr(9,i,j,k)
!
          rrjlmx=rrjl(2,i,j,k)
          rrjlmy=rrjl(3,i,j,k)
          rrjlmz=rrjl(4,i,j,k)
          rrjlen=rrjl(5,i,j,k)+rrjl(1,i,j,k)
          rrjlbx=rrjl(7,i,j,k)
          rrjlby=rrjl(8,i,j,k)
          rrjlbz=rrjl(9,i,j,k)
!
          ihlldj(i,j,k)=0
! 
! Calculation of initial guess
!
! Eq. (53)
          ptj0=ptjh(i,j,k)

          temp1a=max(ptjr(i,j,k),ptjl(i,j,k))
 
          if((byj**2)/temp1a .le. 0.01d0) then
!
! Try B->0 limit Eq. (55)
!
!            a=1.0
!            b=uujh(5,i,j,k)-wwjh(2,i,j,k)
!            c=uujh(2,i,j,k)*wwjh(5,i,j,k)-wwjh(2,i,j,k)*uujh(5,i,j,k)
            a=sjr-sjl
            b=rrjren-rrjlen+sjr*rrjlmy-sjl*rrjrmy
            c=rrjlmy*rrjren-rrjrmy*rrjlen
            temp1ba=b*b-4.0*a*c
            temp1b=max(temp1ba,0.d0)
            ptj0=0.5*(-b+sqrt(temp1b))/a
          endif
!
! Calculate initial f0
!
! Right state across Fast wave
!
! Eq.(26)-(30)
          aa1=rrjrmy+ptj0*(1.0-sjr*sjr)-sjr*rrjren
          gg1=0.0+rrjrbx*rrjrbx+rrjrbz*rrjrbz
          cc1=0.0+rrjrmx*rrjrbx+rrjrmz*rrjrbz
          qq1=-(aa1+gg1-byj*byj*(1.0-sjr*sjr))
          xx1=byj*(aa1*sjr*byj+cc1)-(aa1+gg1)*(sjr*ptj0+rrjren)
! Eq. (23)-(25)       
          vyjar1=(byj*(aa1*byj+cc1*sjr)-(rrjrmy+ptj0)*(gg1+aa1))/xx1
          vxjar1=(qq1*rrjrmx+rrjrbx*(cc1+byj*(sjr*rrjrmy-rrjren)))/xx1
          vzjar1=(qq1*rrjrmz+rrjrbz*(cc1+byj*(sjr*rrjrmy-rrjren)))/xx1
! Eq. (31)
          temp2a=rrjren-(vxjar1*rrjrmx+vyjar1*rrjrmy+vzjar1*rrjrmz)
          wjar=ptj0+temp2a/(sjr-vyjar1)

          if(wjar .lt. 0.d0) then
            ihlldj(i,j,k)=1
            wjar=abs(wjar)
          endif
! Eq. (21)
          byjar1=byj
          bxjar1=(rrjrbx-byj*vxjar1)/(sjr-vyjar1)
          bzjar1=(rrjrbz-byj*vzjar1)/(sjr-vyjar1)
! Eq. (35)
          if(byj .lt. 0.d0) then
!            swjar1=-byj*sqrt(wjar)
            swjar1=-1.0*sqrt(wjar)
          else
!            swjar1=byj*sqrt(wjar)
            swjar1=sqrt(wjar)
          endif
! Eq. (36)
          temp3a=1.0/(sjr*ptj0+rrjren+byj*swjar1)
          akyjar1=temp3a*(rrjrmy+ptj0+rrjrby*swjar1)
          akxjar1=temp3a*(rrjrmx+rrjrbx*swjar1)
          akzjar1=temp3a*(rrjrmz+rrjrbz*swjar1)
      
          ak2jar1=akxjar1*akxjar1+akyjar1*akyjar1+akzjar1*akzjar1
!
! Left state across Fast wave
!
! Eq.(26)-(30)
          aa2=rrjlmy+ptj0*(1.0-sjl*sjl)-sjl*rrjlen
          gg2=0.0+rrjlbx*rrjlbx+rrjlbz*rrjlbz
          cc2=0.0+rrjlmx*rrjlbx+rrjlmz*rrjlbz
          qq2=-(aa2+gg2-byj*byj*(1.0-sjl*sjl))
          xx2=byj*(aa2*sjl*byj+cc2)-(aa2+gg2)*(sjl*ptj0+rrjlen)
! Eq. (23)-(25)
          vyjal1=(byj*(aa2*byj+cc2*sjl)-(rrjlmy+ptj0)*(gg2+aa2))/xx2
          vxjal1=(qq2*rrjlmx+rrjlbx*(cc2+byj*(sjl*rrjlmy-rrjlen)))/xx2
          vzjal1=(qq2*rrjlmz+rrjlbz*(cc2+byj*(sjl*rrjlmy-rrjlen)))/xx2
! Eq. (31)      
          temp2b=rrjlen-(vxjal1*rrjlmx+vyjal1*rrjlmy+vzjal1*rrjlmz)
          wjal=ptj0+temp2b/(sjl-vyjal1)
      
          if(wjal .lt. 0.d0) then
            ihlldj(i,j,k)=1
            wjal=abs(wjal)
          endif
! Eq. (21)      
          byjal1=byj
          bxjal1=(rrjlbx-byj*vxjal1)/(sjl-vyjal1)
          bzjal1=(rrjlbz-byj*vzjal1)/(sjl-vyjal1)
! Eq. (35)
          if(byj .lt. 0.d0) then
!            swjal1=byj*sqrt(wjal)
            swjal1=sqrt(wjal)
          else
!            swjal1=-byj*sqrt(wjal)
            swjal1=-1.0*sqrt(wjal)
          endif
! Eq. (36)
          temp3b=1.0/(sjl*ptj0+rrjlen+byj*swjal1)
          akyjal1=temp3b*(rrjlmy+ptj0+rrjlby*swjal1)
          akxjal1=temp3b*(rrjlmx+rrjlbx*swjal1)
          akzjal1=temp3b*(rrjlmz+rrjlbz*swjal1)
      
          ak2jal1=akxjal1*akxjal1+akyjal1*akyjal1+akzjal1*akzjal1
!
! Jump condiiton across Alfven wave
!
! Eq. (45)
          dkyj=akyjar1-akyjal1+1.0d-12
      
          byjc1=byj*dkyj
          bxjc1=bxjar1*(akyjar1-vyjar1)-bxjal1*(akyjal1-vyjal1) &
               +byj*(vxjar1-vxjal1)
          bzjc1=bzjar1*(akyjar1-vyjar1)-bzjal1*(akyjal1-vyjal1) &
               +byj*(vzjar1-vzjal1)
! Eq. (47)
          aklbcj=akxjal1*bxjc1+akyjal1*byjc1+akzjal1*bzjc1
          akrbcj=akxjar1*bxjc1+akyjar1*byjc1+akzjar1*bzjc1
      
          vyjcl1=akyjal1-dkyj*byj*(1.0-ak2jal1)/(swjal1*dkyj-aklbcj)
          vyjcr1=akyjar1-dkyj*byj*(1.0-ak2jar1)/(swjar1*dkyj-akrbcj)
      
          csalj1=akyjal1
          csarj1=akyjar1
          cmidj1=0.5*(vyjcl1+vyjcr1)
          fj0=vyjcl1-vyjcr1
!
! Physically check of result
!
! Eq. (54)
          if(vyjcl1-akyjal1 .lt. 0.d0 .or. akyjar1-vyjcr1 .lt. 0.d0) then
            ihlldj(i,j,k)=1
          endif
          if(sjl-vyjcl1 .gt. 0.d0 .or. sjr-vyjcr1 .lt. 0.d0) then
            ihlldj(i,j,k)=1
          endif
          if(wjal-ptj0 .lt. 0.d0 .or. wjar-ptj0 .lt. 0.d0) then
            ihlldj(i,j,k)=1
          endif
          if(csalj1-sjl .lt. 0.d0 .or. sjr-csarj1 .lt. 0.d0) then
            ihlldj(i,j,k)=1
          endif
!
! Iteration
!
          if(abs(fj0) .gt. 1.0d-12 .and. ihlldj(i,j,k) .eq. 0) then
            ptj1= 1.025*ptj0
            fj=fj0
           
            nnn=0
            dptj=1.d0
         
            do nnn=1, iter
              if(abs(dptj) .gt. 1.0d-5*ptj1 .or. abs(fj) .gt. 1.0d-6) then
            
                if(nnn .eq. iter) then
                  ihlldj(i,j,k)=1
             
                else
!
! Right state across Fast wave
!
! Eq. (26)-(30)
                  aa1=rrjrmy+ptj1*(1.0-sjr*sjr)-sjr*rrjren
                  gg1=0.0+rrjrbx*rrjrbx+rrjrbz*rrjrbz
                  cc1=0.0+rrjrmx*rrjrbx+rrjrmz*rrjrbz
                  qq1=-(aa1+gg1-byj*byj*(1.0-sjr*sjr))
                  xx1=byj*(aa1*sjr*byj+cc1)-(aa1+gg1)*(sjr*ptj1+rrjren)
! Eq. (23)-(25)
                  vyjar1=(byj*(aa1*byj+cc1*sjr)-(rrjrmy+ptj1)*(gg1+aa1))/xx1
                  vxjar1=(qq1*rrjrmx+rrjrbx*(cc1+byj*(sjr*rrjrmy-rrjren)))/xx1
                  vzjar1=(qq1*rrjrmz+rrjrbz*(cc1+byj*(sjr*rrjrmy-rrjren)))/xx1
! Eq. (31)
                  temp2a=rrjren-(vxjar1*rrjrmx+vyjar1*rrjrmy+vzjar1*rrjrmz)
                  wjar=ptj1+temp2a/(sjr-vyjar1)
      
                  if(wjar .lt. 0.d0) then
                    ihlldj(i,j,k)=1
                    wjar=abs(wjar)
                  endif
! Eq. (21)
                  byjar1=byj
                  bxjar1=(rrjrbx-byj*vxjar1)/(sjr-vyjar1)
                  bzjar1=(rrjrbz-byj*vzjar1)/(sjr-vyjar1)
! Eq. (35)
                  if(byj .lt. 0.d0) then
!                    swjar1=-byj*sqrt(wjar)
                    swjar1=-1.0*sqrt(wjar)
                  else
!                    swjar1=byj*sqrt(wjar)
                    swjar1=sqrt(wjar)
                  endif
! Eq. (36)
                  temp3a=1.0/(sjr*ptj1+rrjren+byj*swjar1)
                  akyjar1=temp3a*(rrjrmy+ptj1+rrjrby*swjar1)
                  akxjar1=temp3a*(rrjrmx+rrjrbx*swjar1)
                  akzjar1=temp3a*(rrjrmz+rrjrbz*swjar1)
      
                  ak2jar1=akxjar1*akxjar1+akyjar1*akyjar1+akzjar1*akzjar1
!
! Left state across Fast wave
!
! Eq. (26)-(30)
                  aa2=rrjlmy+ptj1*(1.0-sjl*sjl)-sjl*rrjlen
                  gg2=0.0+rrjlbx*rrjlbx+rrjlbz*rrjlbz
                  cc2=0.0+rrjlmx*rrjlbx+rrjlmz*rrjlbz
                  qq2=-(aa2+gg2-byj*byj*(1.0-sjl*sjl))
                  xx2=byj*(aa2*sjl*byj+cc2)-(aa2+gg2)*(sjl*ptj1+rrjlen)
! Eq. (23)-(25)
                  vyjal1=(byj*(aa2*byj+cc2*sjl)-(rrjlmy+ptj1)*(gg2+aa2))/xx2
                  vxjal1=(qq2*rrjlmx+rrjlbx*(cc2+byj*(sjl*rrjlmy-rrjlen)))/xx2
                  vzjal1=(qq2*rrjlmz+rrjlbz*(cc2+byj*(sjl*rrjlmy-rrjlen)))/xx2
! Eq. (31)
                  temp2b=rrjlen-(vxjal1*rrjlmx+vyjal1*rrjlmy+vzjal1*rrjlmz)
                  wjal=ptj1+temp2b/(sjl-vyjal1)
      
                  if(wjal .lt. 0.d0) then
                    ihlldj(i,j,k)=1
                    wjal=abs(wjal)
                  endif
! Eq. (21)
                  byjal1=byj
                  bxjal1=(rrjlbx-byj*vxjal1)/(sjl-vyjal1)
                  bzjal1=(rrjlbz-byj*vzjal1)/(sjl-vyjal1)
! Eq. (35)
                  if(byj .lt. 0.d0) then
!                    swjal1=byj*sqrt(wjal)
                    swjal1=sqrt(wjal)
                  else
!                    swjal1=byj*sqrt(wjal)
                    swjal1=-1.0*sqrt(wjal)
                  endif
! Eq. (36)
                  temp3b=1.0/(sjl*ptj1+rrjlen+byj*swjal1)
                  akyjal1=temp3b*(rrjlmy+ptj1+rrjlby*swjal1)
                  akxjal1=temp3b*(rrjlmx+rrjlbx*swjal1)
                  akzjal1=temp3b*(rrjlmz+rrjlbz*swjal1)
      
                  ak2jal1=akxjal1*akxjal1+akyjal1*akyjal1+akzjal1*akzjal1
!
! Jump condiiton across Alfven wave
!
! Eq. (45)
                  dkyj=akyjar1-akyjal1+1.0d-12
      
                  byjc1=byj*dkyj
                  bxjc1=bxjar1*(akyjar1-vyjar1)-bxjal1*(akyjal1-vyjal1) &
                       +byj*(vxjar1-vxjal1)
                  bzjc1=bzjar1*(akyjar1-vyjar1)-bzjal1*(akyjal1-vyjal1) &
                       +byj*(vzjar1-vzjal1)
! Eq. (47)
                  aklbcj=akxjal1*bxjc1+akyjal1*byjc1+akzjal1*bzjc1
                  akrbcj=akxjar1*bxjc1+akyjar1*byjc1+akzjar1*bzjc1
      
                  vyjcl1=akyjal1-dkyj*byj*(1.0-ak2jal1)/(swjal1*dkyj-aklbcj)
                  vyjcr1=akyjar1-dkyj*byj*(1.0-ak2jar1)/(swjar1*dkyj-akrbcj)
      
                  csalj1=akyjal1
                  csarj1=akyjar1
                  cmidj1=0.5*(vyjcl1+vyjcr1)
                  fj=vyjcl1-vyjcr1
!
! Physically check of result
!
! Eq. (54)
                  if(vyjcl1-akyjal1 .lt. 0.d0 .or. & 
                    akyjar1-vyjcr1 .lt. 0.d0) then
                    ihlldj(i,j,k)=1
                  endif
                  if(sjl-vyjal1 .gt. 0.d0 .or. sjr-vyjar1 .lt. 0.d0) then
                    ihlldj(i,j,k)=1
                  endif
                  if(wjal-ptj1 .lt. 0.d0 .or. wjar-ptj1 .lt. 0.d0) then
                    ihlldj(i,j,k)=1
                  endif
                  if(csalj1-sjl .lt. 0.d0 .or. sjr-csarj1 .lt. 0.d0) then
                    ihlldj(i,j,k)=1
                  endif
!           
                  dptj=(ptj1-ptj0)/(fj-fj0)*fj
             
                  ptj0=ptj1
                  fj0=fj
                  ptj1=ptj1-dptj
            
                  if(ptj1 .lt. 0.d0) then
                    ptj1=1.0d-6
                  endif
            
                endif
              endif
           
            enddo
          
          else
            ptj1=ptj0
          endif
         
          if(ihlldj(i,j,k) .eq. 0) then
            ptj(i,j,k)=ptj1
         
            vxjar(i,j,k)=vxjar1
            vyjar(i,j,k)=vyjar1
            vzjar(i,j,k)=vzjar1
            bxjar(i,j,k)=bxjar1
            byjar(i,j,k)=byjar1
            bzjar(i,j,k)=bzjar1
         
            vxjal(i,j,k)=vxjal1
            vyjal(i,j,k)=vyjal1
            vzjal(i,j,k)=vzjal1
            bxjal(i,j,k)=bxjal1
            byjal(i,j,k)=byjal1
            bzjal(i,j,k)=bzjal1
         
            swjar(i,j,k)=swjar1
            swjal(i,j,k)=swjal1
         
            akxjar(i,j,k)=akxjar1
            akyjar(i,j,k)=akyjar1
            akzjar(i,j,k)=akzjar1
            ak2jar(i,j,k)=ak2jar1
         
            akxjal(i,j,k)=akxjal1
            akyjal(i,j,k)=akyjal1
            akzjal(i,j,k)=akzjal1
            ak2jal(i,j,k)=ak2jal1
         
            csalj(i,j,k)=csalj1
            csarj(i,j,k)=csarj1
            cmidj(i,j,k)=cmidj1
          endif
!         
        endif
!
      enddo
    enddo
  enddo
!
! Calculation of Numerical Flux
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
         
        if(iflxj(i,j,k) .eq. 0) then
          
          if(ihlldj(i,j,k) .eq. 1) then
!
            ww(2,1,i,j,k)=wwjh(1,i,j,k)
            ww(2,2,i,j,k)=wwjh(2,i,j,k)
            ww(2,3,i,j,k)=wwjh(3,i,j,k)
            ww(2,4,i,j,k)=wwjh(4,i,j,k)
            ww(2,5,i,j,k)=wwjh(5,i,j,k)
            ww(2,6,i,j,k)=wwjh(6,i,j,k)
            ww(2,7,i,j,k)=wwjh(7,i,j,k)
            ww(2,8,i,j,k)=wwjh(8,i,j,k)
            ww(2,9,i,j,k)=wwjh(9,i,j,k)
!
          else
            byj=uri(8,i,j,k)
!          
            if(csalj(i,j,k) .gt. 0.d0) then
!
!  Calculate state behind aL
!
! Eq. (21), (32)-(34)
              temp1a=1.0/(cminj(i,j,k)-vyjal(i,j,k))
              ddjal=rrjl(1,i,j,k)*temp1a
              byjal(i,j,k)=byj
              bxjal(i,j,k)=(rrjl(7,i,j,k)-byj*vxjal(i,j,k))*temp1a
              bzjal(i,j,k)=(rrjl(9,i,j,k)-byj*vzjal(i,j,k))*temp1a
              vbjal=vxjal(i,j,k)*bxjal(i,j,k) &
                   +vyjal(i,j,k)*byjal(i,j,k) &
                   +vzjal(i,j,k)*bzjal(i,j,k)
              rrjlen=rrjl(5,i,j,k)+rrjl(1,i,j,k)
              enjal=(rrjlen+ptj(i,j,k)*vyjal(i,j,k)-vbjal*byj)*temp1a
              pxjal=(enjal+ptj(i,j,k))*vxjal(i,j,k)-vbjal*bxjal(i,j,k)
              pyjal=(enjal+ptj(i,j,k))*vyjal(i,j,k)-vbjal*byjal(i,j,k)
              pzjal=(enjal+ptj(i,j,k))*vzjal(i,j,k)-vbjal*bzjal(i,j,k)

              uujal(1,i,j,k)=ddjal
              uujal(2,i,j,k)=pxjal
              uujal(3,i,j,k)=pyjal
              uujal(4,i,j,k)=pzjal
              uujal(5,i,j,k)=enjal-ddjal
              uujal(6,i,j,k)=1.0d-12
              uujal(7,i,j,k)=bxjal(i,j,k)
              uujal(8,i,j,k)=byjal(i,j,k)
              uujal(9,i,j,k)=bzjal(i,j,k)
! Eq. (16)
              ww(2,1,i,j,k)=wwjl(1,i,j,k)+cminj(i,j,k) &
                           *(uujal(1,i,j,k)-uujl(1,i,j,k))
              ww(2,2,i,j,k)=wwjl(2,i,j,k)+cminj(i,j,k) &
                           *(uujal(2,i,j,k)-uujl(2,i,j,k))
              ww(2,3,i,j,k)=wwjl(3,i,j,k)+cminj(i,j,k) &
                           *(uujal(3,i,j,k)-uujl(3,i,j,k))
              ww(2,4,i,j,k)=wwjl(4,i,j,k)+cminj(i,j,k) &
                           *(uujal(4,i,j,k)-uujl(4,i,j,k))
              ww(2,5,i,j,k)=wwjl(5,i,j,k)+cminj(i,j,k) &
                           *(uujal(5,i,j,k)-uujl(5,i,j,k))
              ww(2,7,i,j,k)=wwjl(7,i,j,k)+cminj(i,j,k) &
                           *(uujal(7,i,j,k)-uujl(7,i,j,k))
              ww(2,8,i,j,k)=wwjl(8,i,j,k)+cminj(i,j,k) &
                           *(uujal(8,i,j,k)-uujl(8,i,j,k))
              ww(2,9,i,j,k)=wwjl(9,i,j,k)+cminj(i,j,k) &
                           *(uujal(9,i,j,k)-uujl(9,i,j,k))
!
              ww(2,6,i,j,k)=wwjh(6,i,j,k)
!
            elseif(csarj(i,j,k) .le. 0.d0) then
!
!  Calculate state behind aR
!
! Eq. (21), (32)-(34)
              temp1b=1.0/(cmaxj(i,j,k)-vyjar(i,j,k))
              ddjar=rrjr(1,i,j,k)*temp1b
              byjar(i,j,k)=byj
              bxjar(i,j,k)=(rrjr(7,i,j,k)-byj*vxjar(i,j,k))*temp1b
              bzjar(i,j,k)=(rrjr(9,i,j,k)-byj*vzjar(i,j,k))*temp1b
              vbjar=vxjar(i,j,k)*bxjar(i,j,k) &
                   +vyjar(i,j,k)*byjar(i,j,k) &
                   +vzjar(i,j,k)*bzjar(i,j,k)
              rrjren=rrjr(5,i,j,k)+rrjr(1,i,j,k)
              enjar=(rrjren+ptj(i,j,k)*vyjar(i,j,k)-vbjar*byj)*temp1b
              pxjar=(enjar+ptj(i,j,k))*vxjar(i,j,k)-vbjar*bxjar(i,j,k)
              pyjar=(enjar+ptj(i,j,k))*vyjar(i,j,k)-vbjar*byjar(i,j,k)
              pzjar=(enjar+ptj(i,j,k))*vzjar(i,j,k)-vbjar*bzjar(i,j,k)

              uujar(1,i,j,k)=ddjar
              uujar(2,i,j,k)=pxjar
              uujar(3,i,j,k)=pyjar
              uujar(4,i,j,k)=pzjar
              uujar(5,i,j,k)=enjar-ddjar
              uujar(6,i,j,k)=1.0d-12
              uujar(7,i,j,k)=bxjar(i,j,k)
              uujar(8,i,j,k)=byjar(i,j,k)
              uujar(9,i,j,k)=bzjar(i,j,k)
! Eq. (16)
              ww(2,1,i,j,k)=wwjr(1,i,j,k)+cmaxj(i,j,k) &
                           *(uujar(1,i,j,k)-uujr(1,i,j,k))
              ww(2,2,i,j,k)=wwjr(2,i,j,k)+cmaxj(i,j,k) &
                           *(uujar(2,i,j,k)-uujr(2,i,j,k))
              ww(2,3,i,j,k)=wwjr(3,i,j,k)+cmaxj(i,j,k) &
                           *(uujar(3,i,j,k)-uujr(3,i,j,k))
              ww(2,4,i,j,k)=wwjr(4,i,j,k)+cmaxj(i,j,k) &
                           *(uujar(4,i,j,k)-uujr(4,i,j,k))
              ww(2,5,i,j,k)=wwjr(5,i,j,k)+cmaxj(i,j,k) &
                           *(uujar(5,i,j,k)-uujr(5,i,j,k))
              ww(2,7,i,j,k)=wwjr(7,i,j,k)+cmaxj(i,j,k) &
                           *(uujar(7,i,j,k)-uujr(7,i,j,k))
              ww(2,8,i,j,k)=wwjr(8,i,j,k)+cmaxj(i,j,k) &
                           *(uujar(8,i,j,k)-uujr(8,i,j,k))
              ww(2,9,i,j,k)=wwjr(9,i,j,k)+cmaxj(i,j,k) &
                           *(uujar(9,i,j,k)-uujr(9,i,j,k))
!
              ww(2,6,i,j,k)=wwjh(6,i,j,k)
!
            else
!
!  Calculate state cL across contact mode
!
!  Calculate state behind aL
! Eq. (21), (32)-(34) 
              temp1a=1.0/(cminj(i,j,k)-vyjal(i,j,k))
              byjal(i,j,k)=byj
              bxjal(i,j,k)=(rrjl(7,i,j,k)-byj*vxjal(i,j,k))*temp1a
              bzjal(i,j,k)=(rrjl(9,i,j,k)-byj*vzjal(i,j,k))*temp1a
              vbjal=vxjal(i,j,k)*bxjal(i,j,k) &
                   +vyjal(i,j,k)*byjal(i,j,k) &
                   +vzjal(i,j,k)*bzjal(i,j,k)
              rrjlen=rrjl(5,i,j,k)+rrjl(1,i,j,k)
              enjal=(rrjlen+ptj(i,j,k)*vyjal(i,j,k)-vbjal*byj)*temp1a
              pxjal=(enjal+ptj(i,j,k))*vxjal(i,j,k)-vbjal*bxjal(i,j,k)
              pyjal=(enjal+ptj(i,j,k))*vyjal(i,j,k)-vbjal*byjal(i,j,k)
              pzjal=(enjal+ptj(i,j,k))*vzjal(i,j,k)-vbjal*bzjal(i,j,k)

              uujal(1,i,j,k)=ddjal
              uujal(2,i,j,k)=pxjal
              uujal(3,i,j,k)=pyjal
              uujal(4,i,j,k)=pzjal
              uujal(5,i,j,k)=enjal-ddjal
              uujal(6,i,j,k)=1.0d-12
              uujal(7,i,j,k)=bxjal(i,j,k)
              uujal(8,i,j,k)=byjal(i,j,k)
              uujal(9,i,j,k)=bzjal(i,j,k)
!
!  Calculate state behind aR
! Eq. (21), (32)-(34)           
              temp1b=1.0/(cmaxj(i,j,k)-vyjar(i,j,k))
              byjar(i,j,k)=byj
              bxjar(i,j,k)=(rrjr(7,i,j,k)-byj*vxjar(i,j,k))*temp1b
              bzjar(i,j,k)=(rrjr(9,i,j,k)-byj*vzjar(i,j,k))*temp1b
              vbjar=vxjar(i,j,k)*bxjar(i,j,k) &
                   +vyjar(i,j,k)*byjar(i,j,k) &
                   +vzjar(i,j,k)*bzjar(i,j,k)
              rrjren=rrjr(5,i,j,k)+rrjr(1,i,j,k)
              enjar=(rrjren+ptj(i,j,k)*vyjar(i,j,k)-vbjar*byj)*temp1b
              pxjar=(enjar+ptj(i,j,k))*vxjar(i,j,k)-vbjar*bxjar(i,j,k)
              pyjar=(enjar+ptj(i,j,k))*vyjar(i,j,k)-vbjar*byjar(i,j,k)
              pzjar=(enjar+ptj(i,j,k))*vzjar(i,j,k)-vbjar*bzjar(i,j,k)

              uujar(1,i,j,k)=ddjar
              uujar(2,i,j,k)=pxjar
              uujar(3,i,j,k)=pyjar
              uujar(4,i,j,k)=pzjar
              uujar(5,i,j,k)=enjar-ddjar
              uujar(6,i,j,k)=1.0d-12
              uujar(7,i,j,k)=bxjar(i,j,k)
              uujar(8,i,j,k)=byjar(i,j,k)
              uujar(9,i,j,k)=bzjar(i,j,k)
! Eq. (45)
              dkyj=akyjar(i,j,k)-akyjal(i,j,k)+1.0d-12
      
              byjc=byj*dkyj
              bxjc=bxjar(i,j,k)*(akyjar(i,j,k)-vyjar(i,j,k)) &
                  -bxjal(i,j,k)*(akyjal(i,j,k)-vyjal(i,j,k)) &
                  +byj*(vxjar(i,j,k)-vxjal(i,j,k))
              bzjc=bzjar(i,j,k)*(akyjar(i,j,k)-vyjar(i,j,k)) &
                  -bzjal(i,j,k)*(akyjal(i,j,k)-vyjal(i,j,k)) &
                  +byj*(vzjar(i,j,k)-vzjal(i,j,k))
!
              byjc=byj
              bxjc=bxjc/dkyj
              bzjc=bzjc/dkyj
! Eq. (47)
              aklbcj=akxjal(i,j,k)*bxjc+akyjal(i,j,k)*byjc+akzjal(i,j,k)*bzjc
              akrbcj=akxjar(i,j,k)*bxjc+akyjar(i,j,k)*byjc+akzjar(i,j,k)*bzjc

              scrhlj=(1.0-ak2jal(i,j,k))/(swjal(i,j,k)-aklbcj)
              scrhrj=(1.0-ak2jar(i,j,k))/(swjar(i,j,k)-akrbcj)
          
              vxjcl=akxjal(i,j,k)-bxjc*scrhlj
              vxjcr=akxjar(i,j,k)-bxjc*scrhrj
          
              vyjcl=akyjal(i,j,k)-byjc*scrhlj
              vyjcr=akyjar(i,j,k)-byjc*scrhrj
          
              vzjcl=akzjal(i,j,k)-bzjc*scrhlj
              vzjcr=akzjar(i,j,k)-bzjc*scrhrj

              vxjc=0.5*(vxjcl+vxjcr)
              vyjc=0.5*(vyjcl+vyjcr)
              vzjc=0.5*(vzjcl+vzjcr)
           
              if(vyjc .gt. 0.d0) then
                ddjaa=uujal(1,i,j,k)
                pxjaa=uujal(2,i,j,k)
                pyjaa=uujal(3,i,j,k)
                pzjaa=uujal(4,i,j,k)
                enjaa=uujal(5,i,j,k)+uujal(1,i,j,k)
                csaaj=csalj(i,j,k)
                vyjaa=vyjal(i,j,k)
              else
                ddjaa=uujar(1,i,j,k)
                pxjaa=uujar(2,i,j,k)
                pyjaa=uujar(3,i,j,k)
                pzjaa=uujar(4,i,j,k)
                enjaa=uujar(5,i,j,k)+uujar(1,i,j,k)
                csaaj=csarj(i,j,k)
                vyjaa=vyjar(i,j,k)
              endif
! Eq. (50)-(52)
              vbjc=vxjc*bxjc+vyjc*byjc+vzjc*bzjc
           
              uujc(1,i,j,k)=ddjaa*(csaaj-vyjaa)/(csaaj-vyjc)
!
              enjc=(csaaj*enjaa-pyjaa+ptj(i,j,k)*vyjc-vbjc*byjc)/(csaaj-vyjc)
              uujc(2,i,j,k)=(enjc+ptj(i,j,k))*vxjc-vbjc*bxjc
              uujc(3,i,j,k)=(enjc+ptj(i,j,k))*vyjc-vbjc*byjc
              uujc(4,i,j,k)=(enjc+ptj(i,j,k))*vzjc-vbjc*bzjc
              uujc(5,i,j,k)=enjc-uujc(1,i,j,k)
              uujc(6,i,j,k)=1.0d-12
              uujc(7,i,j,k)=bxjc
              uujc(8,i,j,k)=byjc
              uujc(9,i,j,k)=bzjc
            
              if(cmidj(i,j,k) .gt. 0.d0) then
            
                ww(2,1,i,j,k)=wwjl(1,i,j,k)+cminj(i,j,k) &
                             *(uujal(1,i,j,k)-uujl(1,i,j,k))+csalj(i,j,k) &
                             *(uujc(1,i,j,k)-uujal(1,i,j,k))
                ww(2,2,i,j,k)=wwjl(2,i,j,k)+cminj(i,j,k) &
                             *(uujal(2,i,j,k)-uujl(2,i,j,k))+csalj(i,j,k) &
                             *(uujc(2,i,j,k)-uujal(2,i,j,k))
                ww(2,3,i,j,k)=wwjl(3,i,j,k)+cminj(i,j,k) &
                             *(uujal(3,i,j,k)-uujl(3,i,j,k))+csalj(i,j,k) &
                             *(uujc(3,i,j,k)-uujal(3,i,j,k))
                ww(2,4,i,j,k)=wwjl(4,i,j,k)+cminj(i,j,k) &
                             *(uujal(4,i,j,k)-uujl(4,i,j,k))+csalj(i,j,k) &
                             *(uujc(4,i,j,k)-uujal(4,i,j,k))
                ww(2,5,i,j,k)=wwjl(5,i,j,k)+cminj(i,j,k) &
                             *(uujal(5,i,j,k)-uujl(5,i,j,k))+csalj(i,j,k) &
                             *(uujc(5,i,j,k)-uujal(5,i,j,k))
                ww(2,7,i,j,k)=wwjl(7,i,j,k)+cminj(i,j,k) &
                             *(uujal(7,i,j,k)-uujl(7,i,j,k))+csalj(i,j,k) &
                             *(uujc(7,i,j,k)-uujal(7,i,j,k))
                ww(2,8,i,j,k)=wwjl(8,i,j,k)+cminj(i,j,k) &
                             *(uujal(8,i,j,k)-uujl(8,i,j,k))+csalj(i,j,k) &
                             *(uujc(8,i,j,k)-uujal(8,i,j,k))
                ww(2,9,i,j,k)=wwjl(9,i,j,k)+cminj(i,j,k) &
                             *(uujal(9,i,j,k)-uujl(9,i,j,k))+csalj(i,j,k) &
                             *(uujc(9,i,j,k)-uujal(9,i,j,k))
!
                ww(2,6,i,j,k)=wwjh(6,i,j,k)
!
              else

                ww(2,1,i,j,k)=wwjr(1,i,j,k)+cmaxj(i,j,k) &
                             *(uujar(1,i,j,k)-uujr(1,i,j,k))+csarj(i,j,k) &
                             *(uujc(1,i,j,k)-uujar(1,i,j,k))
                ww(2,2,i,j,k)=wwjr(2,i,j,k)+cmaxj(i,j,k) &
                             *(uujar(2,i,j,k)-uujr(2,i,j,k))+csarj(i,j,k) &
                             *(uujc(2,i,j,k)-uujar(2,i,j,k))
                ww(2,3,i,j,k)=wwjr(3,i,j,k)+cmaxj(i,j,k) &
                             *(uujar(3,i,j,k)-uujr(3,i,j,k))+csarj(i,j,k) &
                             *(uujc(3,i,j,k)-uujar(3,i,j,k))
                ww(2,4,i,j,k)=wwjr(4,i,j,k)+cmaxj(i,j,k) &
                             *(uujar(4,i,j,k)-uujr(4,i,j,k))+csarj(i,j,k) &
                             *(uujc(4,i,j,k)-uujar(4,i,j,k))
                ww(2,5,i,j,k)=wwjr(5,i,j,k)+cmaxj(i,j,k) &
                             *(uujar(5,i,j,k)-uujr(5,i,j,k))+csarj(i,j,k) &
                             *(uujc(5,i,j,k)-uujar(5,i,j,k))
                ww(2,7,i,j,k)=wwjr(7,i,j,k)+cmaxj(i,j,k) &
                             *(uujar(7,i,j,k)-uujr(7,i,j,k))+csarj(i,j,k) &
                             *(uujc(7,i,j,k)-uujar(7,i,j,k))
                ww(2,8,i,j,k)=wwjr(8,i,j,k)+cmaxj(i,j,k) &
                             *(uujar(8,i,j,k)-uujr(8,i,j,k))+csarj(i,j,k) &
                             *(uujc(8,i,j,k)-uujar(8,i,j,k))
                ww(2,9,i,j,k)=wwjr(9,i,j,k)+cmaxj(i,j,k) &
                             *(uujal(9,i,j,k)-uujr(9,i,j,k))+csarj(i,j,k) &
                             *(uujc(9,i,j,k)-uujar(9,i,j,k))
!
                ww(2,6,i,j,k)=wwjh(6,i,j,k)
!
              endif
            endif
!
          endif
!
        endif
!
      enddo
    enddo
  enddo
 
!==========================
!
  deallocate( uujh, uujc, uujar, uujal, urijh, wwjh, &
              rrjr, rrjl, cmidj, csarj, csalj, ptjr, ptjl, ptjh, ptj, &
              vxjar, vxjal, vyjar, vyjal, vzjar, vzjal, &
              bxjar, bxjal, byjar, byjal, bzjar,  bzjal, &
              akxjar, akxjal, akyjar, akyjal, akzjar, akzjal, &
              ak2jar, ak2jal, swjar, swjal, iflxj, ihlldj, stat=merr )
!
  return
end subroutine hlldsj
!  
!---------------------------------------------------------------------@
subroutine hlldsk(ww,x1,x2,x3,uri,urikr,urikl,uukr,uukl, &
                  wwkr,wwkl,cmaxk,cmink,nm0,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate numerical flux by HLLD scheme 
!    (Mignone et al. 2010)
!     z-direction
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, iwvec, iter, iflag
  implicit none

  integer :: i, j, k, n, nnn
  integer :: nm0, is1, ie1, js1, je1, ks1, ke1, merr

  real(8) :: uukr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: uukh(:,:,:,:), uukc(:,:,:,:), &
           uukar(:,:,:,:), uukal(:,:,:,:)
     
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: urikr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: urikh(:,:,:,:)
     
  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwkr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkl(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: wwkh(:,:,:,:)
      
  real(8), allocatable :: rrkr(:,:,:,:), rrkl(:,:,:,:)
      
  real(8) :: cmaxk(is1:ie1,js1:je1,ks1:ke1), cmink(is1:ie1,js1:je1,ks1:ke1)
  real(8), allocatable :: cmidk(:,:,:), csark(:,:,:), csalk(:,:,:)

  real(8), allocatable :: ptkr(:,:,:), ptkl(:,:,:), &
           ptkh(:,:,:), ptk(:,:,:)
!
  real(8), allocatable :: vxkar(:,:,:), vxkal(:,:,:), &
           vykar(:,:,:), vykal(:,:,:), vzkar(:,:,:), vzkal(:,:,:)

  real(8), allocatable :: bxkar(:,:,:), bxkal(:,:,:), &
           bykar(:,:,:), bykal(:,:,:), bzkar(:,:,:), bzkal(:,:,:)

  real(8), allocatable :: akxkar(:,:,:), akxkal(:,:,:), &
           akykar(:,:,:), akykal(:,:,:), akzkar(:,:,:), akzkal(:,:,:), &
           ak2kar(:,:,:), ak2kal(:,:,:)
              
  real(8), allocatable :: swkar(:,:,:), swkal(:,:,:)

  real(8) :: x1(imax), x2(jmax), x3(kmax)

  integer, allocatable :: iflxk(:,:,:), ihlldk(:,:,:)
      
  real(8) :: bzk, skr, skl, &
             rrkrmx, rrkrmy, rrkrmz, rrkren, rrkrbx, rrkrby, rrkrbz, &
             rrklmx, rrklmy, rrklmz, rrklen, rrklbx, rrklby, rrklbz, &
             ptk0, a, b, c, temp1ba, aa1, gg1, cc1, qq1, xx1, &
             vxkar1, vykar1, vzkar1, temp1a, temp1b, temp2a, wkar, & 
             bxkar1, bykar1, bzkar1, swkar1, temp3a, &
             akxkar1, akykar1, akzkar1, ak2kar1, &
             aa2, gg2, cc2, qq2, xx2, &
             vxkal1, vykal1, vzkal1, temp2b, wkal, &
             bxkal1, bykal1, bzkal1, swkal1, temp3b, &
             akxkal1, akykal1, akzkal1, ak2kal1, &
             dkzk, bxkc1, bykc1, bzkc1, aklbck, akrbck, vzkcl1, vzkcr1, &
             csalk1, csark1, cmidk1, fk0, ptk1, fk, dptk

  real(8) ::  ddkal, vbkal, enkal, pxkal, pykal, pzkal, &
              ddkar, vbkar, enkar, pxkar, pykar, pzkar, &
              bxkc, bykc, bzkc, scrhlk, scrhrk, &
              vxkcl, vxkcr, vykcl, vykcr, vzkcl, vzkcr, & 
              vxkc, vykc, vzkc, ddkaa, pxkaa, pykaa, pzkaa, enkaa, &
              csaak, vzkaa, vbkc, enkc
!
  allocate( uukh(nv,is1:ie1,js1:je1,ks1:ke1), &
            uukc(nv,is1:ie1,js1:je1,ks1:ke1), &
            uukar(nv,is1:ie1,js1:je1,ks1:ke1), &
            uukal(nv,is1:ie1,js1:je1,ks1:ke1), &
            urikh(nv,is1:ie1,js1:je1,ks1:ke1), &
            wwkh(nv,is1:ie1,js1:je1,ks1:ke1), &
            rrkr(nv,is1:ie1,js1:je1,ks1:ke1), &
            rrkl(nv,is1:ie1,js1:je1,ks1:ke1), &
            cmidk(is1:ie1,js1:je1,ks1:ke1), &
            csark(is1:ie1,js1:je1,ks1:ke1), csalk(is1:ie1,js1:je1,ks1:ke1), & 
            ptkr(is1:ie1,js1:je1,ks1:ke1), ptkl(is1:ie1,js1:je1,ks1:ke1), &
            ptkh(is1:ie1,js1:je1,ks1:ke1), ptk(is1:ie1,js1:je1,ks1:ke1), &
            vxkar(is1:ie1,js1:je1,ks1:ke1), vxkal(is1:ie1,js1:je1,ks1:ke1), &
            vykar(is1:ie1,js1:je1,ks1:ke1), vykal(is1:ie1,js1:je1,ks1:ke1), &
            vzkar(is1:ie1,js1:je1,ks1:ke1), vzkal(is1:ie1,js1:je1,ks1:ke1), &
            bxkar(is1:ie1,js1:je1,ks1:ke1), bxkal(is1:ie1,js1:je1,ks1:ke1), &
            bykar(is1:ie1,js1:je1,ks1:ke1), bykal(is1:ie1,js1:je1,ks1:ke1), &
            bzkar(is1:ie1,js1:je1,ks1:ke1), bzkal(is1:ie1,js1:je1,ks1:ke1), &
            akxkar(is1:ie1,js1:je1,ks1:ke1), akxkal(is1:ie1,js1:je1,ks1:ke1), &
            akykar(is1:ie1,js1:je1,ks1:ke1), akykal(is1:ie1,js1:je1,ks1:ke1), &
            akzkar(is1:ie1,js1:je1,ks1:ke1), akzkal(is1:ie1,js1:je1,ks1:ke1), &
            ak2kar(is1:ie1,js1:je1,ks1:ke1), ak2kal(is1:ie1,js1:je1,ks1:ke1), &
            swkar(is1:ie1,js1:je1,ks1:ke1), swkal(is1:ie1,js1:je1,ks1:ke1), &
            iflxk(is1:ie1,js1:je1,ks1:ke1), ihlldk(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr )
!
!=====================================================================@
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        do n=1,nv
!
!   Check state
!
          iflxk(i,j,k)=0
          
          if(cmink(i,j,k) .gt. 0.d0) then
            ww(3,n,i,j,k)=wwkl(n,i,j,k)
            iflxk(i,j,k)=1
          elseif(cmaxk(i,j,k) .le. 0.d0) then
            ww(3,n,i,j,k)=wwkr(n,i,j,k)
            iflxk(i,j,k)=1
          else
!
!   Calculatetion of U_hll, F_hll (HLL state)
!
            uukh(n,i,j,k)=(cmaxk(i,j,k)*uukr(n,i,j,k) &
                         -cmink(i,j,k)*uukl(n,i,j,k) &
                         -wwkr(n,i,j,k)+wwkl(n,i,j,k)) &
                         /(cmaxk(i,j,k)-cmink(i,j,k))

            wwkh(n,i,j,k)=(cmaxk(i,j,k)*wwkl(n,i,j,k) &
                         -cmink(i,j,k)*wwkr(n,i,j,k) &
                         -cmaxk(i,j,k)*cmink(i,j,k) &
                         *(urikr(n,i,j,k)-urikl(n,i,j,k))) &
                          /(cmaxk(i,j,k)-cmink(i,j,k))
!
!  Calculation of R_L,R
!
            rrkr(n,i,j,k)=cmaxk(i,j,k)*uukr(n,i,j,k)-wwkr(n,i,j,k)
            rrkl(n,i,j,k)=cmink(i,j,k)*uukl(n,i,j,k)-wwkl(n,i,j,k)
          endif

        enddo  
      enddo
    enddo
  enddo
!
! Calculation of premitive 1-state HLL variables
!
  if( iwvec.eq.6 ) then
    call recov1d(uukh,urikh,x1,x2,x3,nm0,is1,ie1,js1,je1,ks1,ke1)
  elseif( iwvec.eq.7 ) then
    call recov2da(uukh,urikh,x1,x2,x3,nm0,iflxk,is1,ie1,js1,je1,ks1,ke1)
  endif
!
! Calculation of total pressure
!
  call calpt(urikr,ptkr,nm0,iflxk,is1,ie1,js1,je1,ks1,ke1)
  call calpt(urikl,ptkl,nm0,iflxk,is1,ie1,js1,je1,ks1,ke1)
  call calpt(urikh,ptkh,nm0,iflxk,is1,ie1,js1,je1,ks1,ke1)
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
!
        if(iflxk(i,j,k) .eq. 0) then
!
! Parameter
!
          bzk=uri(9,i,j,k)
          skr=cmaxk(i,j,k)
          skl=cmink(i,j,k)
!
! tau=taun+D
          rrkrmx=rrkr(2,i,j,k)
          rrkrmy=rrkr(3,i,j,k)
          rrkrmz=rrkr(4,i,j,k)
          rrkren=rrkr(5,i,j,k)+rrkr(1,i,j,k)
          rrkrbx=rrkr(7,i,j,k)
          rrkrby=rrkr(8,i,j,k)
          rrkrbz=rrkr(9,i,j,k)
!
          rrklmx=rrkl(2,i,j,k)
          rrklmy=rrkl(3,i,j,k)
          rrklmz=rrkl(4,i,j,k)
          rrklen=rrkl(5,i,j,k)+rrkl(1,i,j,k)
          rrklbx=rrkl(7,i,j,k)
          rrklby=rrkl(8,i,j,k)
          rrklbz=rrkl(9,i,j,k)
!
          ihlldk(i,j,k)=0
!
! Calculation of initial guess
!
! Eq. (53)
          ptk0=ptkh(i,j,k)

          temp1a=max(ptkr(i,j,k),ptkl(i,j,k))
 
          if((bzk**2)/temp1a .le. 0.01d0) then
!
! Try B->0 limit Eq. (55)
!
!            a=1.0
!            b=uukh(5,i,j,k)-wwkh(2,i,j,k)
!            c=uukh(2,i,j,k)*wwkh(5,i,j,k)-wwkh(2,i,j,k)*uukh(5,i,j,k)
            a=skr-skl
            b=rrkren-rrklen+skr*rrklmz-skl*rrkrmz
            c=rrklmz*rrkren-rrkrmz*rrklen
            temp1ba=b*b-4.0*a*c
            temp1b=max(temp1ba,0.d0)
            ptk0=0.5*(-b+sqrt(temp1b))/a
          endif
!
! Calculate initial f0
!
! Right state across Fast wave
!
! Eq.(26)-(30)
          aa1=rrkrmz+ptk0*(1.0-skr*skr)-skr*rrkren
          gg1=0.0+rrkrbx*rrkrbx+rrkrby*rrkrby
          cc1=0.0+rrkrmx*rrkrbx+rrkrmy*rrkrby
          qq1=-(aa1+gg1-bzk*bzk*(1.0-skr*skr))
          xx1=bzk*(aa1*skr*bzk+cc1)-(aa1+gg1)*(skr*ptk0+rrkren)
! Eq. (23)-(25)       
          vzkar1=(bzk*(aa1*bzk+cc1*skr)-(rrkrmz+ptk0)*(gg1+aa1))/xx1
          vxkar1=(qq1*rrkrmx+rrkrbx*(cc1+bzk*(skr*rrkrmz-rrkren)))/xx1
          vykar1=(qq1*rrkrmy+rrkrby*(cc1+bzk*(skr*rrkrmz-rrkren)))/xx1
! Eq. (31)
          temp2a=rrkren-(vxkar1*rrkrmx+vykar1*rrkrmy+vzkar1*rrkrmz)
          wkar=ptk0+temp2a/(skr-vzkar1)

          if(wkar .lt. 0.d0) then
            ihlldk(i,j,k)=1
            wkar=abs(wkar)
          endif
! Eq. (21)
          bzkar1=bzk
          bxkar1=(rrkrbx-bzk*vxkar1)/(skr-vzkar1)
          bykar1=(rrkrby-bzk*vykar1)/(skr-vzkar1)
! Eq. (35)
          if(bzk .lt. 0.d0) then
!            swkar1=-bzk*sqrt(wkar)
            swkar1=-1.0*sqrt(wkar)
          else
!            swkar1=bzk*sqrt(wkar)
            swkar1=sqrt(wkar)
          endif
! Eq. (36)
          temp3a=1.0/(skr*ptk0+rrkren+bzk*swkar1)
          akzkar1=temp3a*(rrkrmz+ptk0+rrkrbz*swkar1)
          akxkar1=temp3a*(rrkrmx     +rrkrbx*swkar1)
          akykar1=temp3a*(rrkrmy     +rrkrby*swkar1)
      
          ak2kar1=akxkar1*akxkar1+akykar1*akykar1+akzkar1*akzkar1
!
! Left state across Fast wave
!
! Eq.(26)-(30)
          aa2=rrklmz+ptk0*(1.0-skl*skl)-skl*rrklen
          gg2=0.0+rrklbx*rrklbx+rrklby*rrklby
          cc2=0.0+rrklmx*rrklbx+rrklmy*rrklby
          qq2=-(aa2+gg2-bzk*bzk*(1.0-skl*skl))
          xx2=bzk*(aa2*skl*bzk+cc2)-(aa2+gg2)*(skl*ptk0+rrklen)
! Eq. (23)-(25)
          vzkal1=(bzk*(aa2*bzk+cc2*skl)-(rrklmz+ptk0)*(gg2+aa2))/xx2
          vxkal1=(qq2*rrklmx+rrklbx*(cc2+bzk*(skl*rrklmz-rrklen)))/xx2
          vykal1=(qq2*rrklmy+rrklby*(cc2+bzk*(skl*rrklmz-rrklen)))/xx2
! Eq. (31)      
          temp2b=rrklen-(vxkal1*rrklmx+vykal1*rrklmy+vzkal1*rrklmz)
          wkal=ptk0+temp2b/(skl-vzkal1)
      
          if(wkal .lt. 0.d0) then
            ihlldk(i,j,k)=1
            wkal=abs(wkal)
          endif
! Eq. (21)      
          bzkal1=bzk
          bxkal1=(rrklbx-bzk*vxkal1)/(skl-vzkal1)
          bykal1=(rrklby-bzk*vykal1)/(skl-vzkal1)
! Eq. (35)
          if(bzk .lt. 0.d0) then
!            swkal1=bzk*sqrt(wkal)
            swkal1=sqrt(wkal)
          else
!            swkal1=-bzk*sqrt(wkal)
            swkal1=-1.0*sqrt(wkal)
          endif
! Eq. (36)
          temp3b=1.0/(skl*ptk0+rrklen+bzk*swkal1)
          akzkal1=temp3b*(rrklmz+ptk0+rrklbz*swkal1)
          akxkal1=temp3b*(rrklmx     +rrklbx*swkal1)
          akykal1=temp3b*(rrklmy     +rrklby*swkal1)
      
          ak2kal1=akxkal1*akxkal1+akykal1*akykal1+akzkal1*akzkal1
!
! Jump condiiton across Alfven wave
!
! Eq. (45)
          dkzk=akzkar1-akzkal1+1.0d-12
      
          bzkc1=bzk*dkzk
          bxkc1=bxkar1*(akzkar1-vzkar1)-bxkal1*(akzkal1-vzkal1) &
               +bzk*(vxkar1-vxkal1)
          bykc1=bykar1*(akzkar1-vzkar1)-bykal1*(akzkal1-vzkal1) &
               +bzk*(vykar1-vykal1)
! Eq. (47)
          aklbck=akxkal1*bxkc1+akykal1*bykc1+akzkal1*bzkc1
          akrbck=akxkar1*bxkc1+akykar1*bykc1+akzkar1*bzkc1
      
          vzkcl1=akzkal1-dkzk*bzk*(1.0-ak2kal1)/(swkal1*dkzk-aklbck)
          vzkcr1=akzkar1-dkzk*bzk*(1.0-ak2kar1)/(swkar1*dkzk-akrbck)
      
          csalk1=akykal1
          csark1=akykar1
          cmidk1=0.5*(vzkcl1+vzkcr1)
          fk0=vzkcl1-vzkcr1
!
! Physically check of result
!
! Eq. (54)
          if(vzkcl1-akzkal1 .lt. 0.d0 .or. akzkar1-vzkcr1 .lt. 0.d0) then
            ihlldk(i,j,k)=1
          endif
          if(skl-vzkcl1 .gt. 0.d0 .or. skr-vzkcr1 .lt. 0.d0) then
            ihlldk(i,j,k)=1
          endif
          if(wkal-ptk0 .lt. 0.d0 .or. wkar-ptk0 .lt. 0.d0) then
            ihlldk(i,j,k)=1
          endif
          if(csalk1-skl .lt. 0.d0 .or. skr-csark1 .lt. 0.d0) then
            ihlldk(i,j,k)=1
          endif
!
! Iteration
!
          if(abs(fk0) .gt. 1.0d-12 .and. ihlldk(i,j,k) .eq. 0) then
            ptk1= 1.025*ptk0
            fk=fk0
           
            nnn=0
            dptk=1.d0
         
            do nnn=1, iter
              if(abs(dptk) .gt. 1.0d-5*ptk1 .or. abs(fk) .gt. 1.0d-6) then
            
                if(nnn .eq. iter) then
                  ihlldk(i,j,k)=1
             
                else
!
! Right state across Fast wave
!
! Eq. (26)-(30)
                  aa1=rrkrmz+ptk1*(1.0-skr*skr)-skr*rrkren
                  gg1=0.0+rrkrbx*rrkrbx+rrkrby*rrkrby
                  cc1=0.0+rrkrmx*rrkrbx+rrkrmy*rrkrby
                  qq1=-(aa1+gg1-bzk*bzk*(1.0-skr*skr))
                  xx1=bzk*(aa1*skr*bzk+cc1)-(aa1+gg1)*(skr*ptk1+rrkren)
! Eq. (23)-(25)
                  vzkar1=(bzk*(aa1*bzk+cc1*skr)-(rrkrmz+ptk1)*(gg1+aa1))/xx1
                  vxkar1=(qq1*rrkrmx+rrkrbx*(cc1+bzk*(skr*rrkrmz-rrkren)))/xx1
                  vykar1=(qq1*rrkrmy+rrkrby*(cc1+bzk*(skr*rrkrmz-rrkren)))/xx1
! Eq. (31)
                  temp2a=rrkren-(vxkar1*rrkrmx+vykar1*rrkrmy+vzkar1*rrkrmz)
                  wkar=ptk1+temp2a/(skr-vzkar1)
      
                  if(wkar .lt. 0.d0) then
                    ihlldk(i,j,k)=1
                    wkar=abs(wkar)
                  endif
! Eq. (21)
                  bzkar1=bzk
                  bxkar1=(rrkrbx-bzk*vxkar1)/(skr-vzkar1)
                  bykar1=(rrkrby-bzk*vykar1)/(skr-vzkar1)
! Eq. (35)
                  if(bzk .lt. 0.d0) then
!                    swkar1=-bzk*sqrt(wkar)
                    swkar1=-1.0*sqrt(wkar)
                  else
!                    swkar1=bzk*sqrt(wkar)
                    swkar1=sqrt(wkar)
                  endif
! Eq. (36)
                  temp3a=1.0/(skr*ptk1+rrkren+bzk*swkar1)
                  akzkar1=temp3a*(rrkrmz+ptk1+rrkrbz*swkar1)
                  akxkar1=temp3a*(rrkrmx     +rrkrbx*swkar1)
                  akykar1=temp3a*(rrkrmy     +rrkrby*swkar1)
      
                  ak2kar1=akxkar1*akxkar1+akykar1*akykar1+akzkar1*akzkar1
!
! Left state across Fast wave
!
! Eq. (26)-(30)
                  aa2=rrklmz+ptk1*(1.0-skl*skl)-skl*rrklen
                  gg2=0.0+rrklbx*rrklbx+rrklby*rrklby
                  cc2=0.0+rrklmx*rrklbx+rrklmy*rrklby
                  qq2=-(aa2+gg2-bzk*bzk*(1.0-skl*skl))
                  xx2=bzk*(aa2*skl*bzk+cc2)-(aa2+gg2)*(skl*ptk1+rrklen)
! Eq. (23)-(25)
                  vzkal1=(bzk*(aa2*bzk+cc2*skl)-(rrklmz+ptk1)*(gg2+aa2))/xx2
                  vxkal1=(qq2*rrklmx+rrklbx*(cc2+bzk*(skl*rrklmz-rrklen)))/xx2
                  vykal1=(qq2*rrklmy+rrklby*(cc2+bzk*(skl*rrklmz-rrklen)))/xx2
! Eq. (31)
                  temp2b=rrklen-(vxkal1*rrklmx+vykal1*rrklmy+vzkal1*rrklmz)
                  wkal=ptk1+temp2b/(skl-vzkal1)

                  if(wkal .lt. 0.d0) then
                    ihlldk(i,j,k)=1
                    wkal=abs(wkal)
                  endif
! Eq. (21)
                  bzkal1=bzk
                  bxkal1=(rrklbx-bzk*vxkal1)/(skl-vzkal1)
                  bykal1=(rrklby-bzk*vykal1)/(skl-vzkal1)
! Eq. (35)
                  if(bzk .lt. 0.d0) then
!                    swkal1=bzk*sqrt(wkal)
                    swkal1=sqrt(wkal)
                  else
!                    swkal1=bzk*sqrt(wkal)
                    swkal1=-1.0*sqrt(wkal)
                  endif
! Eq. (36)
                  temp3b=1.0/(skl*ptk1+rrklen+bzk*swkal1)
                  akzkal1=temp3b*(rrklmz+ptk1+rrklbz*swkal1)
                  akxkal1=temp3b*(rrklmx     +rrklbx*swkal1)
                  akykal1=temp3b*(rrklmy     +rrklby*swkal1)
      
                  ak2kal1=akxkal1*akxkal1+akykal1*akykal1+akzkal1*akzkal1
!
! Jump condiiton across Alfven wave
!
! Eq. (45)
                  dkzk=akzkar1-akzkal1+1.0d-12
      
                  bzkc1=bzk*dkzk
                  bxkc1=bxkar1*(akzkar1-vzkar1)-bxkal1*(akzkal1-vzkal1) &
                       +bzk*(vxkar1-vxkal1)
                  bykc1=bykar1*(akzkar1-vzkar1)-bykal1*(akzkal1-vzkal1) &
                       +bzk*(vykar1-vykal1)
! Eq. (47)
                  aklbck=akxkal1*bxkc1+akykal1*bykc1+akzkal1*bzkc1
                  akrbck=akxkar1*bxkc1+akykar1*bykc1+akzkar1*bzkc1
      
                  vzkcl1=akzkal1-dkzk*bzk*(1.0-ak2kal1)/(swkal1*dkzk-aklbck)
                  vzkcr1=akzkar1-dkzk*bzk*(1.0-ak2kar1)/(swkar1*dkzk-akrbck)
      
                  csalk1=akzkal1
                  csark1=akzkar1
                  cmidk1=0.5*(vzkcl1+vzkcr1)
                  fk=vzkcl1-vzkcr1
!
! Physically check of result
!
! Eq. (54)
                  if(vzkcl1-akzkal1 .lt. 0.d0 & 
                    .or. akzkar1-vzkcr1 .lt. 0.d0) then
                    ihlldk(i,j,k)=1
                  endif
                  if(skl-vzkal1 .gt. 0.d0 .or. skr-vzkar1 .lt. 0.d0) then
                    ihlldk(i,j,k)=1
                  endif
                  if(wkal-ptk1 .lt. 0.d0 .or. wkar-ptk1 .lt. 0.d0) then
                    ihlldk(i,j,k)=1
                  endif
                  if(csalk1-skl .lt. 0.d0 .or. skr-csark1 .lt. 0.d0) then
                    ihlldk(i,j,k)=1
                  endif
!           
                  dptk=(ptk1-ptk0)/(fk-fk0)*fk
            
                  ptk0=ptk1
                  fk0=fk
                  ptk1=ptk1-dptk
            
                  if(ptk1 .lt. 0.d0) then
                    ptk1=1.0d-6
                  endif
            
                endif
              endif
           
            enddo
          
          else
            ptk1=ptk0
          endif
         
          if(ihlldk(i,j,k) .eq. 0) then
            ptk(i,j,k)=ptk1
         
            vxkar(i,j,k)=vxkar1
            vykar(i,j,k)=vykar1
            vzkar(i,j,k)=vzkar1
            bxkar(i,j,k)=bxkar1
            bykar(i,j,k)=bykar1
            bzkar(i,j,k)=bzkar1
         
            vxkal(i,j,k)=vxkal1
            vykal(i,j,k)=vykal1
            vzkal(i,j,k)=vzkal1
            bxkal(i,j,k)=bxkal1
            bykal(i,j,k)=bykal1
            bzkal(i,j,k)=bzkal1
         
            swkar(i,j,k)=swkar1
            swkal(i,j,k)=swkal1
         
            akxkar(i,j,k)=akxkar1
            akykar(i,j,k)=akykar1
            akzkar(i,j,k)=akzkar1
            ak2kar(i,j,k)=ak2kar1
         
            akxkal(i,j,k)=akxkal1
            akykal(i,j,k)=akykal1
            akzkal(i,j,k)=akzkal1
            ak2kal(i,j,k)=ak2kal1
         
            csalk(i,j,k)=csalk1
            csark(i,j,k)=csark1
            cmidk(i,j,k)=cmidk1
          endif
!         
        endif
!
      enddo
    enddo
  enddo
!
! Calculation of Numerical Flux
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
         
        if(iflxk(i,j,k) .eq. 0) then
          
          if(ihlldk(i,j,k) .eq. 1) then
!
            ww(3,1,i,j,k)=wwkh(1,i,j,k)
            ww(3,2,i,j,k)=wwkh(2,i,j,k)
            ww(3,3,i,j,k)=wwkh(3,i,j,k)
            ww(3,4,i,j,k)=wwkh(4,i,j,k)
            ww(3,5,i,j,k)=wwkh(5,i,j,k)
            ww(3,6,i,j,k)=wwkh(6,i,j,k)
            ww(3,7,i,j,k)=wwkh(7,i,j,k)
            ww(3,8,i,j,k)=wwkh(8,i,j,k)
            ww(3,9,i,j,k)=wwkh(9,i,j,k)
!
          else
            bzk=uri(9,i,j,k)
!          
            if(csalk(i,j,k) .gt. 0.d0) then
!
!  Calculate state behind aL
!
! Eq. (21), (32)-(34)
              temp1a=1.0/(cmink(i,j,k)-vzkal(i,j,k))
              ddkal=rrkl(1,i,j,k)*temp1a
              bzkal(i,j,k)=bzk
              bxkal(i,j,k)=(rrkl(7,i,j,k)-bzk*vxkal(i,j,k))*temp1a
              bykal(i,j,k)=(rrkl(8,i,j,k)-bzk*vykal(i,j,k))*temp1a
              vbkal=vxkal(i,j,k)*bxkal(i,j,k) &
                   +vykal(i,j,k)*bykal(i,j,k) &
                   +vzkal(i,j,k)*bzkal(i,j,k)
              rrklen=rrkl(5,i,j,k)+rrkl(1,i,j,k)
              enkal=(rrklen+ptk(i,j,k)*vzkal(i,j,k)-vbkal*bzk)*temp1a
              pxkal=(enkal+ptk(i,j,k))*vxkal(i,j,k)-vbkal*bxkal(i,j,k)
              pykal=(enkal+ptk(i,j,k))*vykal(i,j,k)-vbkal*bykal(i,j,k)
              pzkal=(enkal+ptk(i,j,k))*vzkal(i,j,k)-vbkal*bzkal(i,j,k)

              uukal(1,i,j,k)=ddkal
              uukal(2,i,j,k)=pxkal
              uukal(3,i,j,k)=pykal
              uukal(4,i,j,k)=pzkal
              uukal(5,i,j,k)=enkal-ddkal
              uukal(6,i,j,k)=1.0d-12
              uukal(7,i,j,k)=bxkal(i,j,k)
              uukal(8,i,j,k)=bykal(i,j,k)
              uukal(9,i,j,k)=bzkal(i,j,k)
! Eq. (16)
              ww(3,1,i,j,k)=wwkl(1,i,j,k)+cmink(i,j,k) &
                           *(uukal(1,i,j,k)-uukl(1,i,j,k))
              ww(3,2,i,j,k)=wwkl(2,i,j,k)+cmink(i,j,k) &
                           *(uukal(2,i,j,k)-uukl(2,i,j,k))
              ww(3,3,i,j,k)=wwkl(3,i,j,k)+cmink(i,j,k) &
                           *(uukal(3,i,j,k)-uukl(3,i,j,k))
              ww(3,4,i,j,k)=wwkl(4,i,j,k)+cmink(i,j,k) &
                           *(uukal(4,i,j,k)-uukl(4,i,j,k))
              ww(3,5,i,j,k)=wwkl(5,i,j,k)+cmink(i,j,k) &
                           *(uukal(5,i,j,k)-uukl(5,i,j,k))
              ww(3,7,i,j,k)=wwkl(7,i,j,k)+cmink(i,j,k) &
                           *(uukal(7,i,j,k)-uukl(7,i,j,k))
              ww(3,8,i,j,k)=wwkl(8,i,j,k)+cmink(i,j,k) &
                           *(uukal(8,i,j,k)-uukl(8,i,j,k))
              ww(3,9,i,j,k)=wwkl(9,i,j,k)+cmink(i,j,k) &
                           *(uukal(9,i,j,k)-uukl(9,i,j,k))
!
              ww(3,6,i,j,k)=wwkh(6,i,j,k)
!
            elseif(csark(i,j,k) .le. 0.d0) then
!
!  Calculate state behind aR
!
! Eq. (21), (32)-(34)
              temp1b=1.0/(cmaxk(i,j,k)-vzkar(i,j,k))
              ddkar=rrkr(1,i,j,k)*temp1b
              bzkar(i,j,k)=bzk
              bxkar(i,j,k)=(rrkr(7,i,j,k)-bzk*vxkar(i,j,k))*temp1b
              bykar(i,j,k)=(rrkr(8,i,j,k)-bzk*vykar(i,j,k))*temp1b
              vbkar=vxkar(i,j,k)*bxkar(i,j,k) &
                   +vykar(i,j,k)*bykar(i,j,k) &
                   +vzkar(i,j,k)*bzkar(i,j,k)
              rrkren=rrkr(5,i,j,k)+rrkr(1,i,j,k)
              enkar=(rrkren+ptk(i,j,k)*vzkar(i,j,k)-vbkar*bzk)*temp1b
              pxkar=(enkar+ptk(i,j,k))*vxkar(i,j,k)-vbkar*bxkar(i,j,k)
              pykar=(enkar+ptk(i,j,k))*vykar(i,j,k)-vbkar*bykar(i,j,k)
              pzkar=(enkar+ptk(i,j,k))*vzkar(i,j,k)-vbkar*bzkar(i,j,k)

              uukar(1,i,j,k)=ddkar
              uukar(2,i,j,k)=pxkar
              uukar(3,i,j,k)=pykar
              uukar(4,i,j,k)=pzkar
              uukar(5,i,j,k)=enkar-ddkar
              uukar(6,i,j,k)=1.0d-12
              uukar(7,i,j,k)=bxkar(i,j,k)
              uukar(8,i,j,k)=bykar(i,j,k)
              uukar(9,i,j,k)=bzkar(i,j,k)
! Eq. (16)
              ww(3,1,i,j,k)=wwkr(1,i,j,k)+cmaxk(i,j,k) &
                           *(uukar(1,i,j,k)-uukr(1,i,j,k))
              ww(3,2,i,j,k)=wwkr(2,i,j,k)+cmaxk(i,j,k) &
                           *(uukar(2,i,j,k)-uukr(2,i,j,k))
              ww(3,3,i,j,k)=wwkr(3,i,j,k)+cmaxk(i,j,k) &
                           *(uukar(3,i,j,k)-uukr(3,i,j,k))
              ww(3,4,i,j,k)=wwkr(4,i,j,k)+cmaxk(i,j,k) &
                           *(uukar(4,i,j,k)-uukr(4,i,j,k))
              ww(3,5,i,j,k)=wwkr(5,i,j,k)+cmaxk(i,j,k) &
                           *(uukar(5,i,j,k)-uukr(5,i,j,k))
              ww(3,7,i,j,k)=wwkr(7,i,j,k)+cmaxk(i,j,k) &
                           *(uukar(7,i,j,k)-uukr(7,i,j,k))
              ww(3,8,i,j,k)=wwkr(8,i,j,k)+cmaxk(i,j,k) &
                           *(uukar(8,i,j,k)-uukr(8,i,j,k))
              ww(3,9,i,j,k)=wwkr(9,i,j,k)+cmaxk(i,j,k) &
                           *(uukar(9,i,j,k)-uukr(9,i,j,k))
!
              ww(3,6,i,j,k)=wwkh(6,i,j,k)
!
            else
!
!  Calculate state cL across contact mode
!
!  Calculate state behind aL
! Eq. (21), (32)-(34) 
              temp1a=1.0/(cmink(i,j,k)-vzkal(i,j,k))
              bzkal(i,j,k)=bzk
              bxkal(i,j,k)=(rrkl(7,i,j,k)-bzk*vxkal(i,j,k))*temp1a
              bykal(i,j,k)=(rrkl(8,i,j,k)-bzk*vykal(i,j,k))*temp1a
              vbkal=vxkal(i,j,k)*bxkal(i,j,k) &
                   +vykal(i,j,k)*bykal(i,j,k) &
                   +vzkal(i,j,k)*bzkal(i,j,k) 
              rrklen=rrkl(5,i,j,k)+rrkl(1,i,j,k)
              enkal=(rrklen+ptk(i,j,k)*vzkal(i,j,k)-vbkal*bzk)*temp1a
              pxkal=(enkal+ptk(i,j,k))*vxkal(i,j,k)-vbkal*bxkal(i,j,k)
              pykal=(enkal+ptk(i,j,k))*vykal(i,j,k)-vbkal*bykal(i,j,k)
              pzkal=(enkal+ptk(i,j,k))*vzkal(i,j,k)-vbkal*bzkal(i,j,k)

              uukal(1,i,j,k)=ddkal
              uukal(2,i,j,k)=pxkal
              uukal(3,i,j,k)=pykal
              uukal(4,i,j,k)=pzkal
              uukal(5,i,j,k)=enkal-ddkal
              uukal(6,i,j,k)=1.0d-12
              uukal(7,i,j,k)=bxkal(i,j,k)
              uukal(8,i,j,k)=bykal(i,j,k)
              uukal(9,i,j,k)=bzkal(i,j,k)
!
!  Calculate state behind aR
! Eq. (21), (32)-(34)           
              temp1b=1.0/(cmaxk(i,j,k)-vzkar(i,j,k))
              bzkar(i,j,k)=bzk
              bxkar(i,j,k)=(rrkr(7,i,j,k)-bzk*vxkar(i,j,k))*temp1b
              bykar(i,j,k)=(rrkr(8,i,j,k)-bzk*vykar(i,j,k))*temp1b
              vbkar=vxkar(i,j,k)*bxkar(i,j,k) &
                   +vykar(i,j,k)*bykar(i,j,k) &
                   +vzkar(i,j,k)*bzkar(i,j,k)
              rrkren=rrkr(5,i,j,k)+rrkr(1,i,j,k)
              enkar=(rrkren+ptk(i,j,k)*vzkar(i,j,k)-vbkar*bzk)*temp1b
              pxkar=(enkar+ptk(i,j,k))*vxkar(i,j,k)-vbkar*bxkar(i,j,k)
              pykar=(enkar+ptk(i,j,k))*vykar(i,j,k)-vbkar*bykar(i,j,k)
              pzkar=(enkar+ptk(i,j,k))*vzkar(i,j,k)-vbkar*bzkar(i,j,k)

              uukar(1,i,j,k)=ddkar
              uukar(2,i,j,k)=pxkar
              uukar(3,i,j,k)=pykar
              uukar(4,i,j,k)=pzkar
              uukar(5,i,j,k)=enkar-ddkar
              uukar(6,i,j,k)=1.0d-12
              uukar(7,i,j,k)=bxkar(i,j,k)
              uukar(8,i,j,k)=bykar(i,j,k)
              uukar(9,i,j,k)=bzkar(i,j,k)
! Eq. (45)
              dkzk=akzkar(i,j,k)-akzkal(i,j,k)+1.0d-12
      
              bzkc=bzk*dkzk
              bxkc=bxkar(i,j,k)*(akzkar(i,j,k)-vzkar(i,j,k)) &
                  -bxkal(i,j,k)*(akzkal(i,j,k)-vzkal(i,j,k)) &
                  +bzk*(vxkar(i,j,k)-vxkal(i,j,k))
              bykc=bykar(i,j,k)*(akzkar(i,j,k)-vzkar(i,j,k)) &
                  -bykal(i,j,k)*(akzkal(i,j,k)-vzkal(i,j,k)) &
                  +bzk*(vykar(i,j,k)-vykal(i,j,k))
!
              bzkc=bzk
              bxkc=bxkc/dkzk
              bykc=bykc/dkzk
! Eq. (47)
              aklbck=akxkal(i,j,k)*bxkc+akykal(i,j,k)*bykc+akzkal(i,j,k)*bzkc
              akrbck=akxkar(i,j,k)*bxkc+akykar(i,j,k)*bykc+akzkar(i,j,k)*bzkc

              scrhlk=(1.0-ak2kal(i,j,k))/(swkal(i,j,k)-aklbck)
              scrhrk=(1.0-ak2kar(i,j,k))/(swkar(i,j,k)-akrbck)
          
              vxkcl=akxkal(i,j,k)-bxkc*scrhlk
              vxkcr=akxkar(i,j,k)-bxkc*scrhrk
          
              vykcl=akykal(i,j,k)-bykc*scrhlk
              vykcr=akykar(i,j,k)-bykc*scrhrk
          
              vzkcl=akzkal(i,j,k)-bzkc*scrhlk
              vzkcr=akzkar(i,j,k)-bzkc*scrhrk

              vxkc=0.5*(vxkcl+vxkcr)
              vykc=0.5*(vykcl+vykcr)
              vzkc=0.5*(vzkcl+vzkcr)
           
              if(vzkc .gt. 0.d0) then
                ddkaa=uukal(1,i,j,k)
                pxkaa=uukal(2,i,j,k)
                pykaa=uukal(3,i,j,k)
                pzkaa=uukal(4,i,j,k)
                enkaa=uukal(5,i,j,k)+uukal(1,i,j,k)
                csaak=csalk(i,j,k)
                vzkaa=vzkal(i,j,k)
              else
                ddkaa=uukar(1,i,j,k)
                pxkaa=uukar(2,i,j,k)
                pykaa=uukar(3,i,j,k)
                pzkaa=uukar(4,i,j,k)
                enkaa=uukar(5,i,j,k)+uukar(1,i,j,k)
                csaak=csark(i,j,k)
                vzkaa=vzkar(i,j,k)
              endif
! Eq. (50)-(52)
              vbkc=vxkc*bxkc+vykc*bykc+vzkc*bzkc
           
              uukc(1,i,j,k)=ddkaa*(csaak-vzkaa)/(csaak-vzkc)
!
              enkc=(csaak*enkaa-pzkaa+ptk(i,j,k)*vzkc-vbkc*bzkc)/(csaak-vzkc)
              uukc(2,i,j,k)=(enkc+ptk(i,j,k))*vxkc-vbkc*bxkc
              uukc(3,i,j,k)=(enkc+ptk(i,j,k))*vykc-vbkc*bykc
              uukc(4,i,j,k)=(enkc+ptk(i,j,k))*vzkc-vbkc*bzkc
              uukc(5,i,j,k)=enkc-uukc(1,i,j,k)
              uukc(6,i,j,k)=1.0d-12
              uukc(7,i,j,k)=bxkc
              uukc(8,i,j,k)=bykc
              uukc(9,i,j,k)=bzkc
           
              if(cmidk(i,j,k) .gt. 0.d0) then
            
                ww(3,1,i,j,k)=wwkl(1,i,j,k)+cmink(i,j,k) &
                             *(uukal(1,i,j,k)-uukl(1,i,j,k))+csalk(i,j,k) &
                             *(uukc(1,i,j,k)-uukal(1,i,j,k))
                ww(3,2,i,j,k)=wwkl(2,i,j,k)+cmink(i,j,k) &
                             *(uukal(2,i,j,k)-uukl(2,i,j,k))+csalk(i,j,k) &
                             *(uukc(2,i,j,k)-uukal(2,i,j,k))
                ww(3,3,i,j,k)=wwkl(3,i,j,k)+cmink(i,j,k) &
                             *(uukal(3,i,j,k)-uukl(3,i,j,k))+csalk(i,j,k) &
                             *(uukc(3,i,j,k)-uukal(3,i,j,k))
                ww(3,4,i,j,k)=wwkl(4,i,j,k)+cmink(i,j,k) &
                             *(uukal(4,i,j,k)-uukl(4,i,j,k))+csalk(i,j,k) &
                             *(uukc(4,i,j,k)-uukal(4,i,j,k))
                ww(3,5,i,j,k)=wwkl(5,i,j,k)+cmink(i,j,k) &
                             *(uukal(5,i,j,k)-uukl(5,i,j,k))+csalk(i,j,k) &
                             *(uukc(5,i,j,k)-uukal(5,i,j,k))
                ww(3,7,i,j,k)=wwkl(7,i,j,k)+cmink(i,j,k) &
                             *(uukal(7,i,j,k)-uukl(7,i,j,k))+csalk(i,j,k) &
                             *(uukc(7,i,j,k)-uukal(7,i,j,k))
                ww(3,8,i,j,k)=wwkl(8,i,j,k)+cmink(i,j,k) &
                             *(uukal(8,i,j,k)-uukl(8,i,j,k))+csalk(i,j,k) &
                             *(uukc(8,i,j,k)-uukal(8,i,j,k))
                ww(3,9,i,j,k)=wwkl(9,i,j,k)+cmink(i,j,k) &
                             *(uukal(9,i,j,k)-uukl(9,i,j,k))+csalk(i,j,k) &
                             *(uukc(9,i,j,k)-uukal(9,i,j,k))

                ww(3,6,i,j,k)=wwkh(6,i,j,k)
!
              else

                ww(3,1,i,j,k)=wwkr(1,i,j,k)+cmaxk(i,j,k) &
                             *(uukar(1,i,j,k)-uukr(1,i,j,k))+csark(i,j,k) &
                             *(uukc(1,i,j,k)-uukar(1,i,j,k))
                ww(3,2,i,j,k)=wwkr(2,i,j,k)+cmaxk(i,j,k) &
                             *(uukar(2,i,j,k)-uukr(2,i,j,k))+csark(i,j,k) &
                             *(uukc(2,i,j,k)-uukar(2,i,j,k))
                ww(3,3,i,j,k)=wwkr(3,i,j,k)+cmaxk(i,j,k) &
                             *(uukar(3,i,j,k)-uukr(3,i,j,k))+csark(i,j,k) &
                             *(uukc(3,i,j,k)-uukar(3,i,j,k))
                ww(3,4,i,j,k)=wwkr(4,i,j,k)+cmaxk(i,j,k) &
                             *(uukar(4,i,j,k)-uukr(4,i,j,k))+csark(i,j,k) &
                             *(uukc(4,i,j,k)-uukar(4,i,j,k))
                ww(3,5,i,j,k)=wwkr(5,i,j,k)+cmaxk(i,j,k) &
                             *(uukar(5,i,j,k)-uukr(5,i,j,k))+csark(i,j,k) &
                             *(uukc(5,i,j,k)-uukar(5,i,j,k))
                ww(3,7,i,j,k)=wwkr(7,i,j,k)+cmaxk(i,j,k) &
                             *(uukar(7,i,j,k)-uukr(7,i,j,k))+csark(i,j,k) &
                             *(uukc(7,i,j,k)-uukar(7,i,j,k))
                ww(3,8,i,j,k)=wwkr(8,i,j,k)+cmaxk(i,j,k) &
                             *(uukar(8,i,j,k)-uukr(8,i,j,k))+csark(i,j,k) &
                             *(uukc(8,i,j,k)-uukar(8,i,j,k))
                ww(3,9,i,j,k)=wwkr(9,i,j,k)+cmaxk(i,j,k) &
                             *(uukal(9,i,j,k)-uukr(9,i,j,k))+csark(i,j,k) &
                             *(uukc(9,i,j,k)-uukar(9,i,j,k))
!
                ww(3,6,i,j,k)=wwkh(6,i,j,k)
!
              endif
            endif
!
          endif
!
        endif
!
      enddo
    enddo
  enddo
 
!==========================
!
  deallocate( uukh, uukc, uukar, uukal, urikh, wwkh, rrkr, rrkl, &
              cmidk, csark, csalk, ptkr, ptkl, ptkh, ptk, &
              vxkar, vxkal, vykar, vykal, vzkar, vzkal, &
              bxkar, bxkal, bykar, bykal, bzkar, bzkal, &
              akxkar, akxkal, akykar, akykal, akzkar, akzkal, &
              ak2kar, ak2kal, swkar, swkal, iflxk, ihlldk, stat=merr )
!
  return
end subroutine hlldsk
!
!---------------------------------------------------------------------@
subroutine calpt(uri,pt,nm0,iflx,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!     Calculation of total pressure
!     (for HLLD riemann solver)
!
  use pram, only : imax, jmax, kmax, nv
  implicit none

  integer :: i, j, k
  integer :: nm0, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pt(is1:ie1,js1:je1,ks1:ke1)
      
  integer :: iflx(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: vx, vy, vz, pp, bx, by, bz, vt2, bt2, vb
!
!=====================================================================@
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
         
        if(iflx(i,j,k) .eq. 0) then
          vx=uri(2,i,j,k)
          vy=uri(3,i,j,k)
          vz=uri(4,i,j,k)
          pp=uri(5,i,j,k)
          bx=uri(7,i,j,k)
          by=uri(8,i,j,k)
          bz=uri(9,i,j,k)
         
          vt2=vx*vx+vy*vy+vz*vz
          bt2=bx*bx+by*by+bz*bz
          vb=vx*bx+vy*by+vz*bz
         
          pt(i,j,k)=pp+0.5*(bt2*(1.0-vt2)+vb*vb)
        endif
         
      enddo
    enddo
  enddo  

  return
end subroutine calpt 
!
