!--------------------------------------------------------------------
subroutine md2dblast(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                     is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 23; 2D Blast Wave Test
  use pram, only : imax, jmax, kmax,  gam, c0
  implicit none

  integer :: i, j, k, is1 ,ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)

  real(8) :: rex, de1, de2, pr1, pr2, b0, rr
  real(8) :: ffjump

!--------------------------------------------------------------------
!  Parameter
!
  rex=0.8d0
  de1=0.01d0 
  de2=1.0d-4
  pr1=1.0d0
  pr2=1.0d-4
  b0=0.1d0
  
!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
          
        rr=sqrt(x1(i)**2+x3(k)**2)
          
        de(i,j,k)=ffjump(rr,de1,de2,rex,0.2d0,0.2d0)
        pr(i,j,k)=ffjump(rr,pr1,pr2,rex,0.2d0,0.2d0)
        v1(i,j,k)=0.d0
        v2(i,j,k)=0.d0
        v3(i,j,k)=0.d0
        b1(i,j,k)=b0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0

     enddo
    enddo
  enddo

  return
end subroutine md2dblast
!
!--------------------------------------------------------------------
subroutine md2dmagadv(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                      is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 26; 2D Magnetic Loop Advection Test
  use pram, only : imax, jmax, kmax, gam, c0, xmax
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: merr

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pom2(imax,jmax,kmax), &
             b1a(imax,jmax,kmax), b2a(imax,jmax,kmax), b3a(imax,jmax,kmax)
  real(8) :: x1(imax), x2(jmax), x3(kmax) 
!
  real(8) :: xmax1, a0, r0, r1, a2, a1, rr
!
!--------------------------------------------------------------------
!  Parameter
!
  xmax1=0.3d0
  a0=1.0d-3
  r0=0.3*xmax1
  r1=0.2*r0
  a2=-0.5*a0/r1
  a1=a0*(r0-r1)-a2*r1**2

!--------------------------------------------------------------------

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
          
        rr=sqrt(x1(i)**2+x3(k)**2)
          
        de(i,j,k)=1.d0
        pr(i,j,k)=0.37272727d0
        v1(i,j,k)=2.0*xmax1
        v2(i,j,k)=0.d0
        v3(i,j,k)=xmax1
          
        b1(i,j,k)=0.d0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0
          
      enddo
    enddo
  enddo

  do k=1,kmax
    do j=1,jmax
      do i=1,imax
        rr=sqrt(x1(i)**2+x3(k)**2)
!          
!        if(rr .le. r0) then
!          pom2(i,j,k)=a0*(r0-rr)
!        else
!          pom2(i,j,k)=0.d0
!        endif
!
        if(rr .ge. 0.d0 .and. rr .le. r1) then
          pom2(i,j,k)=a1+a2*rr**2
        elseif(rr .gt. r1 .and. rr .le. r0) then
          pom2(i,j,k)=a0*(r0-rr)
        else
          pom2(i,j,k)=0.d0
        endif
      enddo
    enddo
  enddo
         
  do k=2,kmax-1
    do j=1,jmax
      do i=2,imax-1
          
        b1a(i,j,k)=-(pom2(i,j,k-1)-pom2(i,j,k+1))/(x3(k-1)-x3(k+1))
        b2a(i,j,k)=0.d0
        b3a(i,j,k)=(pom2(i-1,j,k)-pom2(i+1,j,k))/(x1(i-1)-x1(i+1))
 
      enddo
    enddo
  enddo         
        
  do k=1,kmax
    do j=1,jmax
          
      b1a(1,j,k)=b1a(2,j,k)
      b1a(imax,j,k)=b1a(imax-1,j,k)
      b2a(1,j,k)=b2a(2,j,k)
      b2a(imax,j,k)=b2a(imax-1,j,k)
      b3a(1,j,k)=b3a(2,j,k)
      b3a(imax,j,k)=b3a(imax-1,j,k)

    enddo
  enddo

  do j=1,jmax
    do i=1,imax
          
      b1a(i,j,1)=b1a(i,j,2)
      b1a(i,j,kmax)=b1a(i,j,kmax-1)
      b2a(i,j,1)=b2a(i,j,2)
      b2a(i,j,kmax)=b2a(i,j,kmax-1)
      b3a(i,j,1)=b3a(i,j,2)
      b3a(i,j,kmax)=b3a(i,j,kmax-1)

    enddo
  enddo
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        b1(i,j,k)=b1a(i,j,k)
        b2(i,j,k)=b2a(i,j,k)
        b3(i,j,k)=b3a(i,j,k)
      enddo
    enddo
  enddo


  return
end subroutine md2dmagadv
!
!--------------------------------------------------------------------
subroutine md3dmagadv(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                      is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 29; 3D Magnetic Loop Advection Test
  use pram, only : imax, jmax, kmax, gam, c0, xmax
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: merr

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pom3(imax,jmax,kmax), &
             b1a(imax,jmax,kmax), b2a(imax,jmax,kmax), b3a(imax,jmax,kmax)
  real(8) :: x1(imax), x2(jmax), x3(kmax) 
!
  real(8) ::  xmax1, zmax1, xmax2, zmax2, a0, r0, r1, a2, a1, rr, alp1, &
             gam2, sina2, cosa2, amda, x1a, x2a, x3a
!
!--------------------------------------------------------------------
!  Parameter
!
!  xmax1=0.3d0
  zmax1=0.3d0
  xmax1=0.50*zmax1
  zmax2=2.0*zmax1
  xmax2=2.0*xmax1

  a0=1.0d-3
  r0=0.3*xmax2
  r1=0.2*r0
  a2=-0.5*a0/r1
  a1=a0*(r0-r1)-a2*r1**2

  alp1=0.0
!  gam2=atan(0.5*xmax1)
  gam2=atan(xmax2/zmax2)
  sina2=sin(gam2)
  cosa2=cos(gam2)
  if (cosa2 .ge. sina2) then
    amda=xmax2*cosa2
   else
    amda=zmax2*sina2
   endif
!   write(*,*) 'gam2, amda=', gam2, amda
!--------------------------------------------------------------------

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        de(i,j,k)=1.d0
!        pr(i,j,k)=0.070589d0  
!        pr(i,j,k)=0.1714d0
        pr(i,j,k)=0.327272727d0
!        pr(i,j,k)=0.6d0

!        v1(i,j,k)=0.0
!        v2(i,j,k)=0.0
!        v3(i,j,k)=0.0

        v1(i,j,k)=zmax1
        v2(i,j,k)=zmax1
        v3(i,j,k)=2.0*zmax1
          
        b1(i,j,k)=0.d0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0

!        if(rr .le. r0) then
!          pom2(i,j,k)=a0*(r0-rr)
!        else
!          pom2(i,j,k)=0.d0
!        endif

!        x1a=cos(gam2)*cos(alp1)*x1(i)
!            -sin(alp1)*x2(j) 
!            -sin(gam2)*cos(alp1)*x3(k)
!        x2a=cos(gam2)*sin(alp1)*x1(i)
!            +cos(alp1)*x2(j)
!            -sin(gam2)*sin(alp1)*x3(k)
!        x3a=sin(gam2)*x1(i)+cos(gam2)*x3(k)

        x1a=cosa2*x1(i)-sina2*x3(k)
        x2a=x2(j)
        x3a=sina2*x1(i)+cosa2*x3(k)
!        x1a=cos(gam2)*x1(i)+sin(gam2)*x3(k)
!        x2a=x2(j)
!        x3a=-sin(gam2)*x1(i)+cos(gam2)*x3(k)

        if(x1a .gt. 0.5*amda) then
          x1a=x1a-amda
        elseif(x1a .lt. -0.5*amda) then
          x1a=x1a+amda
        endif

        rr=sqrt(x1a**2+x2a**2)

!        if(rr .le. r0) then
!          pom2(i,j,k)=a0*(r0-rr)
!        else
!          pom2(i,j,k)=0.d0
!        endif
!
        if(rr .ge. 0.d0 .and. rr .le. r1) then
          pom3(i,j,k)=a1+a2*rr**2
        elseif(rr .gt. r1 .and. rr .le. r0) then
          pom3(i,j,k)=a0*(r0-rr)
        else
          pom3(i,j,k)=0.d0
        endif
  
      enddo
    enddo
  enddo
         
  do k=1,kmax
    do j=2,jmax-1
      do i=2,imax-1
          
        b1a(i,j,k)=-(pom3(i,j-1,k)-pom3(i,j+1,k))/(x2(j-1)-x2(j+1))
        b2a(i,j,k)=(pom3(i-1,j,k)-pom3(i+1,j,k))/(x1(i-1)-x1(i+1))
        b3a(i,j,k)=0.0
 
      enddo
    enddo
  enddo         
        
  do k=1,kmax
    do j=1,jmax
          
      b1a(1,j,k)=b1a(2,j,k)
      b1a(imax,j,k)=b1a(imax-1,j,k)
      b2a(1,j,k)=b2a(2,j,k)
      b2a(imax,j,k)=b2a(imax-1,j,k)
      b3a(1,j,k)=b3a(2,j,k)
      b3a(imax,j,k)=b3a(imax-1,j,k)

    enddo
  enddo

  do k=1,kmax
    do i=1,imax
          
      b1a(i,1,k)=b1a(i,2,k)
      b1a(i,jmax,k)=b1a(i,jmax-1,k)
      b2a(i,1,k)=b2a(i,2,k)
      b2a(i,jmax,k)=b2a(i,jmax-1,k)
      b3a(i,1,k)=b3a(i,2,k)
      b3a(i,jmax,k)=b3a(i,jmax-1,k)

    enddo
  enddo
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        b1(i,j,k)=b1a(i,j,k)
        b2(i,j,k)=b2a(i,j,k)
        b3(i,j,k)=b3a(i,j,k)
      enddo
    enddo
  enddo


  return
end subroutine md3dmagadv
!
!--------------------------------------------------------------------
subroutine md2drotor(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                     is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 27; 2D(3D) Rotor test problem
  use pram, only : imax, jmax, kmax, kmax, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)

  real(8) :: rc, rt1, rt2, de1, de2, p0, omega0, b0, rr, v1t, v3t
  real(8) :: ffjump
!--------------------------------------------------------------------
!  Parameter
!
!  gam=5.d0/3.d0
  rc=0.1d0
  rt1=0.001d0
  rt2=0.01d0
  de1=10.d0
  de2=1.d0
  p0=1.d0
  omega0=9.95d0
  b0=1.d0

!--------------------------------------------------------------------
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

! 2D          
        rr=sqrt(x1(i)**2+x3(k)**2)
! 3D
!        rr=sqrt(x1(i)**2+x2(j)**2+x3(k)**2)
!          
        de(i,j,k)=ffjump(rr,de1,de2,rc,rt1,rt2)
         
        v1t=-omega0*x3(k)
        v3t=omega0*x1(i)
        v1(i,j,k)=ffjump(rr,v1t,0.0d0,rc,rt1,rt2)
        v2(i,j,k)=0.d0
        v3(i,j,k)=ffjump(rr,v3t,0.0d0,rc,rt1,rt2)
                
!        if(rr .le. rc) then
!          de(i,j,k)=de1
!          v1(i,j,k)=-1.*omega0*x3(k)
!          v2(i,j,k)=0.d0
!          v3(i,j,k)=omega0*x1(i)
!        else
!          de(i,j,k)=de2
!          v1(i,j,k)=0.d0
!          v2(i,j,k)=0.d0
!          v3(i,j,k)=0.d0
!        endif
          
        pr(i,j,k)=p0
          
        b1(i,j,k)=b0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0

      enddo
    enddo
  enddo

  return
end subroutine md2drotor
!
!--------------------------------------------------------------------
subroutine mdshoctub(de,pr,v1,v2,v3,b1,b2,b3,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 50; 1D Shock Tube Test Problem

  use pram, only : imax, jmax, kmax, kmax, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)

!--------------------------------------------------------------------
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
  
!        gam=2.d0
        if(k .le. kmax/2) then
          de(i,j,k)=1.d0
          pr(i,j,k)=1.d0
          v1(i,j,k)=0.d0
          v2(i,j,k)=0.d0
          v3(i,j,k)=0.d0
          b1(i,j,k)=0.d0
          b2(i,j,k)=1.d0
!          b1(i,j,k)=0.d0
!          b2(i,j,k)=0.d0 
          b3(i,j,k)=0.5d0
        else
          de(i,j,k)=0.125d0
          pr(i,j,k)=0.1d0
          v1(i,j,k)=0.d0
          v2(i,j,k)=0.d0
          v3(i,j,k)=0.d0
          b1(i,j,k)=0.d0
          b2(i,j,k)=-1.d0
!          b1(i,j,k)=0.d0
!          b2(i,j,k)=0.d0
          b3(i,j,k)=0.5d0
        endif

      enddo
    enddo
  enddo

  return
end subroutine mdshoctub
!
!--------------------------------------------------------------------
subroutine mdalfvenpro(de,pr,v1,v2,v3,b1,b2,b3,x1,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 50; 1D Shock Tube Test Problem
!
  use pram, only : imax, jmax, kmax, kmax, gam, c0, pi
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax)

  real(8) :: eta1, amp, akap, b0, pp0, dd0, va
!
!--------------------------------------------------------------------
!  Parameter
!
!  gam=4.0/3.0
  eta1=1.d0
  b0=1.1547d0
!  b0=0.46188d0
  akap=2.d0*pi
  amp=eta1*b0
!  amp=1.0d-2
  pp0=1.d0
  dd0=1.d0
!  va=b0/sqrt(dd0+(gam/(gam-1.0))*pp0+b0**2)
  va=0.5d0
!  va=0.25d0

!--------------------------------------------------------------------
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
 

        de(i,j,k)=dd0
        pr(i,j,k)=pp0
        b1(i,j,k)=b0
        b2(i,j,k)=amp*cos(akap*x1(i))
        b3(i,j,k)=amp*sin(akap*x1(i))
        v1(i,j,k)=0.d0
        v2(i,j,k)=-(va/b0)*b2(i,j,k)
        v3(i,j,k)=-(va/b0)*b3(i,j,k)
    
!        v1(i,j,k)=0.d0
!        v2(i,j,k)=amp*cos(akap*x1(i))
!        v2(i,j,k)=0.d0
!        v3(i,j,k)=0.d0
!        b1(i,j,k)=b0
!        b2(i,j,k)=-b0*(amp/va)*cos(akap*x1(i))
!        b2(i,j,k)=0.d0
!        b3(i,j,k)=0.d0

      enddo
    enddo
  enddo

  return
end subroutine mdalfvenpro
!
!--------------------------------------------------------------------
subroutine md2dkh(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                 is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 31; 2D KH unstable flow Test
  use pram, only : imax, jmax, kmax,  gam, c0, pi
  implicit none

  integer :: i, j, k, is1 ,ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x2(jmax), x3(kmax)
  real(8) :: dd0, pp0, sigp, sigt, beta, tmp1

!--------------------------------------------------------------------
!  Parameter
!
  dd0=1.d0
  pp0=20.d0
  sigp=0.01d0
  sigt=1.d0
  beta=1.d0/10.d0

!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
          
        de(i,j,k)=dd0
        pr(i,j,k)=pp0

        tmp1=(x3(k)/beta)**2
        v1(i,j,k)=-0.25*tanh(100.0*x3(k))
        v2(i,j,k)=0.d0
        v3(i,j,k)=(1./400.)*sin(2.*pi*x1(i))*exp(-tmp1)        
        b1(i,j,k)=sqrt(2.*sigp*pp0)
        b2(i,j,k)=sqrt(2.*sigt*pp0)
        b3(i,j,k)=0.d0
!
     enddo
    enddo
  enddo

  return
end subroutine md2dkh

