!--------------------------------------------------------------------
subroutine caluu1(uri,uu,x1,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, gam, c0, ieos, iflag  
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
       
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax)      

  real(8) :: de, v1, v2, v3, pr, b1, b2, b3 
  real(8) :: roh, roe, vsq, bsq, vb, gfl, denr, eem
!      
!=====================================================================

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        de=uri(1,i,j,k)
        v1=uri(2,i,j,k)
        v2=uri(3,i,j,k)
        v3=uri(4,i,j,k)
        pr=uri(5,i,j,k)
        b1=uri(7,i,j,k)
        b2=uri(8,i,j,k)
        b3=uri(9,i,j,k)
        
        if(ieos .eq. 0) then
          roh=de+(gam/(gam-1.0))*pr
        elseif(ieos .eq. 1) then
          roh=(5./2.)*pr+sqrt((9./4.)*pr**2+de**2)
        elseif(ieos .eq. 2) then
          roe=(3./2.)*(pr+((3.*pr**2)/(2.0*de+sqrt(2.*pr**2+4.*de**2)) ))
          roh=de+roe+pr
        endif
         
        vsq=v1*v1+v2*v2+v3*v3
        bsq=(b1*b1+b2*b2+b3*b3)
        vb=(v1*b1+v2*b2+v3*b3)
        gfl=1.0/sqrt(1.0-vsq)
 
        denr=roh*(gfl**2)
        eem=0.5*(bsq+vsq*bsq-vb**2)
          
        uu(1,i,j,k)=gfl*de
        uu(2,i,j,k)=(denr+bsq)*v1-vb*b1
        uu(3,i,j,k)=(denr+bsq)*v2-vb*b2
        uu(4,i,j,k)=(denr+bsq)*v3-vb*b3
        uu(5,i,j,k)=denr-pr-gfl*de+eem
           
        if( iflag(6).le.1 ) then
          uu(6,i,j,k)=gfl*de*x1(i)
        elseif( iflag(6).le.3 ) then
          uu(6,i,j,k)=gfl*pr/de**(gam-1.0)
        elseif( iflag(6).eq.4 ) then
          uu(6,i,j,k)=gfl*de*log(pr/de**gam)
        endif         
           
        uu(7,i,j,k)=b1
        uu(8,i,j,k)=b2
        uu(9,i,j,k)=b3
!
      enddo
    enddo
  enddo
      
  return
end subroutine caluu1
!
!--------------------------------------------------------------------@
subroutine caluu2(uri,uu,x1,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0, ieos, iflag  
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
       
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax)      

  real(8) :: de, v1, v2, v3, pr, b1, b2, b3 
  real(8) :: roh, roe, vsq, bsq, vb, gfl, denr, eem
      
!=====================================================================

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        de=uri(1,i,j,k)
        v1=uri(2,i,j,k)
        v2=uri(3,i,j,k)
        v3=uri(4,i,j,k)
        pr=uri(5,i,j,k)
        b1=uri(7,i,j,k)
        b2=uri(8,i,j,k)
        b3=uri(9,i,j,k)
         
        if(ieos .eq. 0) then
          roh=de+(gam/(gam-1.0))*pr
        elseif(ieos .eq. 1) then
          roh=(5./2.)*pr+sqrt((9./4.)*pr**2+de**2)
        elseif(ieos .eq. 2) then
          roe=(3./2.)*(pr+((3.*pr**2)/(2.0*de+sqrt(2.*pr**2+4.*de**2)) ))
          roh=de+roe+pr
        endif
          
        vsq=v1*v1+v2*v2+v3*v3
        bsq=(b1*b1+b2*b2+b3*b3)
        vb=(v1*b1+v2*b2+v3*b3)
        gfl=1.0/sqrt(1.0-vsq)
!
        denr=gfl**2*roh
        eem=0.5*(bsq+vsq*bsq-vb**2)
          
        uu(1,i,j,k)=gfl*de
        uu(2,i,j,k)=(denr+bsq)*v1-vb*b1
        uu(3,i,j,k)=(denr+bsq)*v2-vb*b2
        uu(4,i,j,k)=(denr+bsq)*v3-vb*b3
        uu(5,i,j,k)=denr-pr-gfl*de+eem
           
        if( iflag(6).le.1 ) then
          uu(6,i,j,k)=gfl*de*x1(i)
        elseif( iflag(6).le.3 ) then
          uu(6,i,j,k)=gfl*pr/de**(gam-1.0)
        elseif( iflag(6).eq.4 ) then
          uu(6,i,j,k)=gfl*de*log(pr/de**gam)
        endif         
           
        uu(7,i,j,k)=b1
        uu(8,i,j,k)=b2
        uu(9,i,j,k)=b3
      enddo
    enddo
  enddo
      
   return
end subroutine caluu2
!
!--------------------------------------------------------------------@
subroutine caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, metric, gam, c0, ieos
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
       
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: de, v1, v2, v3, pr, b1, b2, b3 
  real(8) :: roh, roe, vsq, bsq, vb, gfl, denr, eem
      
!=====================================================================

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        de=uri(1,i,j,k)
        v1=uri(2,i,j,k)
        v2=uri(3,i,j,k)
        v3=uri(4,i,j,k)
        pr=uri(5,i,j,k)
        b1=uri(7,i,j,k)
        b2=uri(8,i,j,k)
        b3=uri(9,i,j,k)
         
        if(ieos .eq. 0) then
          roh=de+(gam/(gam-1.0))*pr
        elseif(ieos .eq. 1) then
          roh=(5./2.)*pr+sqrt((9./4.)*pr**2+de**2)
        elseif(ieos .eq. 2) then
          roe=(3./2.)*(pr+((3.*pr**2)/(2.0*de+sqrt(2.*pr**2+4.*de**2)) ))
          roh=de+roe+pr
        endif
          
        vsq=v1*v1+v2*v2+v3*v3
        bsq=(b1*b1+b2*b2+b3*b3)
        vb=(v1*b1+v2*b2+v3*b3)
        gfl=1.0/sqrt(1.0-vsq)

        denr=gfl**2*roh
        eem=0.5*(bsq+vsq*bsq-vb**2)
          
        uu(1,i,j,k)=gfl*de
        uu(2,i,j,k)=(denr+bsq)*v1-vb*b1
        uu(3,i,j,k)=(denr+bsq)*v2-vb*b2
        uu(4,i,j,k)=(denr+bsq)*v3-vb*b3
        uu(5,i,j,k)=denr-pr-gfl*de+eem
           
        uu(7,i,j,k)=b1
        uu(8,i,j,k)=b2
        uu(9,i,j,k)=b3
      enddo
    enddo
  enddo
      
  return
end subroutine caluu2a
!
!--------------------------------------------------------------------
subroutine caluu3(uri,uu,x1,nm0,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, gam, c0, ieos, iflag  
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0
       
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax)

  real(8) :: de, v1, v2, v3, pr, b1, b2, b3 
  real(8) :: roh, roe, vsq, bsq, vb, gfl, denr, eem
!
!=====================================================================

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0

        de=uri(1,i,j,k)
        v1=uri(2,i,j,k)
        v2=uri(3,i,j,k)
        v3=uri(4,i,j,k)
        pr=uri(5,i,j,k)
        b1=uri(7,i,j,k)
        b2=uri(8,i,j,k)
        b3=uri(9,i,j,k)
         
        if(ieos .eq. 0) then
          roh=de+(gam/(gam-1.0))*pr
        elseif(ieos .eq. 1) then
          roh=(5./2.)*pr+sqrt((9./4.)*pr**2+de**2)
        elseif(ieos .eq. 2) then
          roe=(3./2.)*(pr+((3.*pr**2)/(2.0*de+sqrt(2.*pr**2+4.*de**2)) ))
          roh=de+roe+pr
        endif
          
        vsq=v1*v1+v2*v2+v3*v3
        bsq=(b1*b1+b2*b2+b3*b3)
        vb=(v1*b1+v2*b2+v3*b3)
        gfl=1.0/sqrt(1.0-vsq)
!
        denr=gfl**2*roh
        eem=0.5*(bsq+vsq*bsq-vb**2)
          
        uu(1,i,j,k)=gfl*de
        uu(2,i,j,k)=(denr+bsq)*v1-vb*b1
        uu(3,i,j,k)=(denr+bsq)*v2-vb*b2
        uu(4,i,j,k)=(denr+bsq)*v3-vb*b3
        uu(5,i,j,k)=denr-pr-gfl*de+eem
           
        if( iflag(6).le.1 ) then
          uu(6,i,j,k)=gfl*de*x1(i)
        elseif( iflag(6).le.3 ) then
          uu(6,i,j,k)=gfl*pr/de**(gam-1.0)
        elseif( iflag(6).eq.4 ) then
          uu(6,i,j,k)=gfl*de*log(pr/de**gam)
        endif         
           
        uu(7,i,j,k)=b1
        uu(8,i,j,k)=b2
        uu(9,i,j,k)=b3
      enddo
    enddo
  enddo
      
  return
end subroutine caluu3

