!***********************************************************************
!      for GENERAL ORTHOGONAL COORDINATES CALCULATION
!***********************************************************************
!
!     Cartesian Coordinates
!
!--------------------------------------------------------------------
subroutine carmet(hh,hhi,hhj,hhk,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        hh(0,i,j,k)=1.d0
        hh(1,i,j,k)=1.d0
        hh(2,i,j,k)=1.d0
        hh(3,i,j,k)=1.d0
        
        hhi(0,i,j,k)=1.d0
        hhi(1,i,j,k)=1.d0
        hhi(2,i,j,k)=1.d0
        hhi(3,i,j,k)=1.d0
         
        hhj(0,i,j,k)=1.d0
        hhj(1,i,j,k)=1.d0
        hhj(2,i,j,k)=1.d0
        hhj(3,i,j,k)=1.d0
         
        hhk(0,i,j,k)=1.d0
        hhk(1,i,j,k)=1.d0
        hhk(2,i,j,k)=1.d0
        hhk(3,i,j,k)=1.d0
      enddo
    enddo
  enddo
!
  return
end subroutine carmet
!--------------------------------------------------------------------
subroutine cargeo(gm,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax 
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        gm(0,1,i,j,k)=0.d0
        gm(0,2,i,j,k)=0.d0
        gm(0,3,i,j,k)=0.d0
        gm(1,1,i,j,k)=0.d0
        gm(1,2,i,j,k)=0.d0
        gm(1,3,i,j,k)=0.d0
        gm(2,1,i,j,k)=0.d0
        gm(2,2,i,j,k)=0.d0
        gm(2,3,i,j,k)=0.d0
        gm(3,1,i,j,k)=0.d0
        gm(3,2,i,j,k)=0.d0
        gm(3,3,i,j,k)=0.d0
      enddo
    enddo
  enddo
!
  return
end subroutine cargeo
!
!      Cylindrical Coordinates
!
!--------------------------------------------------------------------
subroutine cylmet(hh,x1,hhi,hhj,hhk,x1a,is1,ie1,js1,je1,ks1,ke1) 
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
 
  real(8) :: x1(imax), x1a(imax)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        hh(0,i,j,k)=1.d0
        hh(1,i,j,k)=1.d0
        hh(2,i,j,k)=x1(i)
        hh(3,i,j,k)=1.d0
         
        hhi(0,i,j,k)=1.d0
        hhi(1,i,j,k)=1.d0
        hhi(2,i,j,k)=x1a(i)
        hhi(3,i,j,k)=1.d0
         
        hhj(0,i,j,k)=1.d0
        hhj(1,i,j,k)=1.d0
        hhj(2,i,j,k)=x1(i)
        hhj(3,i,j,k)=1.d0
         
        hhk(0,i,j,k)=1.d0
        hhk(1,i,j,k)=1.d0
        hhk(2,i,j,k)=x1(i)
        hhk(3,i,j,k)=1.d0
      enddo
    enddo
  enddo
!
  return
end subroutine cylmet
!
!--------------------------------------------------------------------
subroutine cylgeo(gm,hh,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax  
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        gm(0,1,i,j,k)=0.d0
        gm(0,2,i,j,k)=0.d0
        gm(0,3,i,j,k)=0.d0
        gm(1,1,i,j,k)=0.d0
        gm(1,2,i,j,k)=0.d0
        gm(1,3,i,j,k)=0.d0
        gm(2,1,i,j,k)=-1.0/hh(2,i,j,k)
        gm(2,2,i,j,k)=0.d0
        gm(2,3,i,j,k)=0.d0
        gm(3,1,i,j,k)=0.d0
        gm(3,2,i,j,k)=0.d0
        gm(3,3,i,j,k)=0.d0
      enddo
    enddo
  enddo
!
  return
end subroutine cylgeo
!
!      Spherical Coordinates
!
!--------------------------------------------------------------------
subroutine sphmet(hh,x1,x3,hhi,hhj,hhk,x1a,x3a,is1,ie1,js1,je1,ks1,ke1) 
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
 
  real(8) :: x1(imax), x3(kmax), x1a(imax), x3a(kmax)

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        hh(0,i,j,k)=1.d0
        hh(1,i,j,k)=1.d0
        hh(2,i,j,k)=x1(i)*sin(x3(k))
        hh(3,i,j,k)=x1(i)
         
        hhi(0,i,j,k)=1.d0
        hhi(1,i,j,k)=1.d0
        hhi(2,i,j,k)=x1a(i)*sin(x3(k))
        hhi(3,i,j,k)=x1a(i)
         
        hhj(0,i,j,k)=1.d0
        hhj(1,i,j,k)=1.d0
        hhj(2,i,j,k)=x1(i)*sin(x3(k))
        hhj(3,i,j,k)=x1(i)
         
        hhk(0,i,j,k)=1.d0
        hhk(1,i,j,k)=1.d0
        hhk(2,i,j,k)=x1(i)*sin(x3a(k))
        hhk(3,i,j,k)=x1(i)
      enddo
    enddo
  enddo
!
  return
end subroutine sphmet
!--------------------------------------------------------------------
subroutine sphgeo(gm,x3,hh,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x3(kmax)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
!
!    First  -1/h_j *dh_i/dx^j
!
        gm(0,1,i,j,k)=0.d0
        gm(0,2,i,j,k)=0.d0
        gm(0,3,i,j,k)=0.d0
        gm(1,1,i,j,k)=0.d0
        gm(1,2,i,j,k)=0.d0
        gm(1,3,i,j,k)=0.d0
        gm(2,1,i,j,k)=-sin(x3(k))
        gm(2,2,i,j,k)=0.d0
        gm(2,3,i,j,k)=-cos(x3(k))
        gm(3,1,i,j,k)=-1.d0
        gm(3,2,i,j,k)=0.d0
        gm(3,3,i,j,k)=0.d0
      enddo
    enddo
  enddo
!
!     Second h_0 *gm(i,j)/h_i
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        gm(1,1,i,j,k)=hh(0,i,j,k)*gm(1,1,i,j,k)/hh(1,i,j,k)
        gm(1,2,i,j,k)=hh(0,i,j,k)*gm(1,2,i,j,k)/hh(1,i,j,k)
        gm(1,3,i,j,k)=hh(0,i,j,k)*gm(1,3,i,j,k)/hh(1,i,j,k)
        gm(2,1,i,j,k)=hh(0,i,j,k)*gm(2,1,i,j,k)/hh(2,i,j,k)
        gm(2,2,i,j,k)=hh(0,i,j,k)*gm(2,2,i,j,k)/hh(2,i,j,k)
        gm(2,3,i,j,k)=hh(0,i,j,k)*gm(2,3,i,j,k)/hh(2,i,j,k)
        gm(3,1,i,j,k)=hh(0,i,j,k)*gm(3,1,i,j,k)/hh(3,i,j,k)
        gm(3,2,i,j,k)=hh(0,i,j,k)*gm(3,2,i,j,k)/hh(3,i,j,k)
        gm(3,3,i,j,k)=hh(0,i,j,k)*gm(3,3,i,j,k)/hh(3,i,j,k)
      enddo
    enddo
  enddo
!
  return
end subroutine sphgeo
!
!   Cylindrical Coordinates in General Relativity (Schwarzschild)
!
!--------------------------------------------------------------------
subroutine grcmet(hh,x1,hhi,hhj,hhk,x1a, &
                  pg,pgi,pgj,pgk,is1,ie1,js1,je1,ks1,ke1 )
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
  
  real(8) :: pg(is1:ie1,js1:je1,ks1:ke1) 
  real(8) :: pgi(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pgj(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pgk(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x1a(imax)

  real(8) :: qsr, qsri, qsrj, qsrk
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
!
        qsr=1.+2.*pg(i,j,k)
        qsri=1.+2.*pgi(i,j,k)
        qsrj=1.+2.*pgj(i,j,k)
        qsrk=1.+2.*pgk(i,j,k)
!
        if(qsr .gt. 0.d0) then
          qsr=sqrt(qsr)
        else
          write(*,*) 'Error: qq =< 0; qq =',qsr
          write(*,*) 'at i=',i,',  j=',j,',  k=',k
        endif
        if(qsri.gt.0.d0) then
          qsri=sqrt(qsri)
        endif
        if(qsrj.gt.0.d0) then
          qsrj=sqrt(qsrj)
        endif
        if(qsrk.gt.0.d0) then
          qsrk=sqrt(qsrk)
        endif
!
        hh(0,i,j,k)=qsr
        hh(1,i,j,k)=1./qsr
        hh(2,i,j,k)=x1(i)
        hh(3,i,j,k)=1./qsr
         
        hhi(0,i,j,k)=qsri
        hhi(1,i,j,k)=1./qsri
        hhi(2,i,j,k)=x1a(i)
        hhi(3,i,j,k)=1./qsri
         
        hhj(0,i,j,k)=qsrj
        hhj(1,i,j,k)=1./qsrj
        hhj(2,i,j,k)=x1(i)
        hhj(3,i,j,k)=1./qsrj
         
        hhk(0,i,j,k)=qsrk
        hhk(1,i,j,k)=1./qsrk
        hhk(2,i,j,k)=x1(i)
        hhk(3,i,j,k)=1./qsrk 
!
      enddo
    enddo
  enddo
!
  return
end subroutine grcmet
!
!--------------------------------------------------------------------
subroutine grcgeo(gm,x1,x3,hh,pg,dpg,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pg(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: dpg(is1:ie1,js1:je1,ks1:ke1)
! 
  real(8) :: x1(imax), x3(kmax)
!
  real(8) :: qq, ppp, rr, zz, rrr 
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        qq=1.+2.*pg(i,j,k)
        ppp=dpg(i,j,k)
        rr=x1(i)
        zz=x3(k)
        rrr=sqrt(x1(i)**2+x3(k)**2)
!
        gm(0,1,i,j,k)=-ppp*rr/rrr
        gm(0,2,i,j,k)=0.d0
        gm(0,3,i,j,k)=-ppp*zz/rrr
        gm(1,1,i,j,k)=0.d0
        gm(1,2,i,j,k)=0.d0
        gm(1,3,i,j,k)=ppp*zz/(qq*rrr)
        gm(2,1,i,j,k)=-sqrt(qq)
        gm(2,2,i,j,k)=0.d0
        gm(2,3,i,j,k)=0.d0
        gm(3,1,i,j,k)=ppp*rr/(qq*rrr)
        gm(3,2,i,j,k)=0.d0
        gm(3,3,i,j,k)=0.d0
!
      enddo
    enddo
  enddo
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        gm(1,1,i,j,k)=hh(0,i,j,k)*gm(1,1,i,j,k)/hh(1,i,j,k)
        gm(1,2,i,j,k)=hh(0,i,j,k)*gm(1,2,i,j,k)/hh(1,i,j,k)
        gm(1,3,i,j,k)=hh(0,i,j,k)*gm(1,3,i,j,k)/hh(1,i,j,k)
        gm(2,1,i,j,k)=hh(0,i,j,k)*gm(2,1,i,j,k)/hh(2,i,j,k)
        gm(2,2,i,j,k)=hh(0,i,j,k)*gm(2,2,i,j,k)/hh(2,i,j,k)
        gm(2,3,i,j,k)=hh(0,i,j,k)*gm(2,3,i,j,k)/hh(2,i,j,k)
        gm(3,1,i,j,k)=hh(0,i,j,k)*gm(3,1,i,j,k)/hh(3,i,j,k)
        gm(3,2,i,j,k)=hh(0,i,j,k)*gm(3,2,i,j,k)/hh(3,i,j,k)
        gm(3,3,i,j,k)=hh(0,i,j,k)*gm(3,3,i,j,k)/hh(3,i,j,k)
      enddo
    enddo
  enddo
!    
  return
end subroutine grcgeo
!
!   Spherical Coordinates in General Relativity (Schwarzschild)   
!
!--------------------------------------------------------------------
subroutine grpmet(hh,x1,x3,hhi,hhj,hhk,x1a,x3a,&
                  pg,pgi,pgj,pgk,is1,ie1,js1,je1,ks1,ke1 )
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
  
  real(8) :: pg(is1:ie1,js1:je1,ks1:ke1) 
  real(8) :: pgi(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pgj(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pgk(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x3(kmax), x1a(imax), x3a(kmax)

  real(8) :: qsr, qsri, qsrj, qsrk
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        qsr=1.+2.*pg(i,j,k)
        qsri=1.+2.*pgi(i,j,k)
        qsrj=1.+2.*pgj(i,j,k)
        qsrk=1.+2.*pgk(i,j,k)
!
        if(qsr .gt. 0.d0) then
          qsr=sqrt(qsr)
        else
          write(*,*) 'Error: qq =< 0; qq =',qsr
          write(*,*) 'at i=',i,',  j=',j,',  k=',k
        endif
        if(qsri.gt.0.d0) then
          qsri=sqrt(qsri)
        endif
        if(qsrj.gt.0.d0) then
          qsrj=sqrt(qsrj)
        endif
        if(qsrk.gt.0.d0) then
          qsrk=sqrt(qsrk)
        endif  
!
        hh(0,i,j,k)=qsr
        hh(1,i,j,k)=1./qsr
        hh(2,i,j,k)=x1(i)*sin(x3(k))
        hh(3,i,j,k)=x1(i)
         
        hhi(0,i,j,k)=qsri
        hhi(1,i,j,k)=1./qsri
        hhi(2,i,j,k)=x1a(i)*sin(x3(k))
        hhi(3,i,j,k)=x1a(i)
         
        hhj(0,i,j,k)=qsrj
        hhj(1,i,j,k)=1./qsrj
        hhj(2,i,j,k)=x1(i)*sin(x3(k))
        hhj(3,i,j,k)=x1(i)
         
        hhk(0,i,j,k)=qsrk
        hhk(1,i,j,k)=1./qsrk
        hhk(2,i,j,k)=x1(i)*sin(x3a(k))
        hhk(3,i,j,k)=x1(i)
!
      enddo
    enddo
  enddo

  return
end subroutine grpmet
!
!--------------------------------------------------------------------
subroutine grpgeo(gm,x1,x3,hh,pg,dpg,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pg(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: dpg(is1:ie1,js1:je1,ks1:ke1)
! 
  real(8) :: x1(imax), x3(kmax)
!
  real(8) :: qq, ppp, rrr 
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
!
        qq=1.+2.*pg(i,j,k)
        ppp=dpg(i,j,k)
        rrr=x1(i)
!
!    gm(1,1),gm(2,2) can not use in the source term calculation 
!    therefore we set gm(1,1)=0.0 and gm(2,2)=0.0
!
!    First   1/h_j*dh_0/dx^j
!           -1/h_j *dh_i/dx^j
!
        gm(0,1,i,j,k)=-ppp
        gm(0,2,i,j,k)=0.d0
        gm(0,3,i,j,k)=0.d0
        gm(1,1,i,j,k)=0.d0
        gm(1,2,i,j,k)=0.d0
        gm(1,3,i,j,k)=0.d0
        gm(2,1,i,j,k)=-sqrt(qq)*sin(x3(k))
        gm(2,2,i,j,k)=0.d0
        gm(2,3,i,j,k)=-cos(x3(k))
        gm(3,1,i,j,k)=-sqrt(qq)
        gm(3,2,i,j,k)=0.d0
        gm(3,3,i,j,k)=0.d0
!
      enddo
    enddo
  enddo
!
!    Second h_0 *gm(i,j)/h_i
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        gm(1,1,i,j,k)=hh(0,i,j,k)*gm(1,1,i,j,k)/hh(1,i,j,k)
        gm(1,2,i,j,k)=hh(0,i,j,k)*gm(1,2,i,j,k)/hh(1,i,j,k)
        gm(1,3,i,j,k)=hh(0,i,j,k)*gm(1,3,i,j,k)/hh(1,i,j,k)
        gm(2,1,i,j,k)=hh(0,i,j,k)*gm(2,1,i,j,k)/hh(2,i,j,k)
        gm(2,2,i,j,k)=hh(0,i,j,k)*gm(2,2,i,j,k)/hh(2,i,j,k)
        gm(2,3,i,j,k)=hh(0,i,j,k)*gm(2,3,i,j,k)/hh(2,i,j,k)
        gm(3,1,i,j,k)=hh(0,i,j,k)*gm(3,1,i,j,k)/hh(3,i,j,k)
        gm(3,2,i,j,k)=hh(0,i,j,k)*gm(3,2,i,j,k)/hh(3,i,j,k)
        gm(3,3,i,j,k)=hh(0,i,j,k)*gm(3,3,i,j,k)/hh(3,i,j,k)
      enddo
    enddo
  enddo
!
  return
end subroutine grpgeo 
!
!    Kerr Black Hole Spacetime (Boyer-Lindquist coordinates)
!
!--------------------------------------------------------------------
subroutine kermet(hh,x1,x3,hhi,hhj,hhk,x1a,x3a,is1,ie1,js1,je1,ks1,ke1 )
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax, rbh, akm
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x3(kmax), x1a(imax), x3a(kmax)

  real(8) :: rg, arg, rr, rri, qq, qqk, del, sig, alp, deli, sigi, alpi, &
             delj, sigj, alpj, delk, sigk, alpk, qsr
!
!  Parameter
!
  rg=0.5*rbh
  arg=akm*rg
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1         
!
        rr=x1(i)
        rri=x1a(i)
        qq=x3(k)
        qqk=x3a(k)
!
        del=rr**2-2.0*rg*rr+(arg)**2
        sig=rr**2+(arg*cos(qq))**2
        alp=(rr**2+arg**2)**2-del*(arg*sin(qq))**2
!
        deli=rri**2-2.0*rg*rri+(arg)**2
        sigi=rri**2+(arg*cos(qq))**2
        alpi=(rri**2+arg**2)**2-del*(arg*sin(qq))**2
!
        delj=rr**2-2.0*rg*rr+(arg)**2
        sigj=rr**2+(arg*cos(qq))**2
        alpj=(rr**2+arg**2)**2-del*(arg*sin(qq))**2
!
        delk=rr**2-2.0*rg*rr+(arg)**2
        sigk=rr**2+(arg*cos(qqk))**2
        alpk=(rr**2+arg**2)**2-del*(arg*sin(qqk))**2
!
        qsr=del
!
        if(qsr .le. 0.d0) then
          write(*,*) 'Error: qq =< 0; qq =',qsr
          write(*,*) 'at i=',i,',  j=',j,',  k=',k
        endif
!
        hh(0,i,j,k)=sqrt(del*sig/alp)
        hh(1,i,j,k)=sqrt(sig/del)
        hh(2,i,j,k)=sqrt(alp/sig)*sin(x3(k))
        hh(3,i,j,k)=sqrt(sig)
         
        hhi(0,i,j,k)=sqrt(deli*sigi/alpi)
        hhi(1,i,j,k)=sqrt(sigi/deli)
        hhi(2,i,j,k)=sqrt(alpi/sigi)*sin(x3(k))
        hhi(3,i,j,k)=sqrt(sigi)
         
        hhj(0,i,j,k)=sqrt(delj*sigj/alpj)
        hhj(1,i,j,k)=sqrt(sigj/delj)
        hhj(2,i,j,k)=sqrt(alpj/sigj)*sin(x3(k))
        hhj(3,i,j,k)=sqrt(sigj)
         
        hhk(0,i,j,k)=sqrt(delk*sigk/alpk)
        hhk(1,i,j,k)=sqrt(sigk/delk)
        hhk(2,i,j,k)=sqrt(alpk/sigk)*sin(x3a(k))
        hhk(3,i,j,k)=sqrt(sigk)
!
      enddo
    enddo
  enddo
!
  return
end subroutine kermet
!
!--------------------------------------------------------------------
subroutine kergeo(gm,x1,x3,hh,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax, rbh, akm
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
! 
  real(8) :: x1(imax), x3(kmax)
!
  real(8) :: rg, arg, rr, qq, del, sig, alp, h0s, h1, h2, h3
!
  rg=0.5*rbh
  arg=akm*rg
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        rr=x1(i)
        qq=x3(k)
!
        del=rr**2-2.0*rg*rr+(arg)**2
        sig=rr**2+(arg*cos(qq))**2
        alp=(rr**2+arg**2)**2-del*(arg*sin(qq))**2        
!
        h0s=hh(0,i,j,k)**2
        h1=hh(1,i,j,k)
        h2=hh(2,i,j,k)
        h3=hh(3,i,j,k)                
!
        gm(0,1,i,j,k)=-rg*(rr**2-(arg*cos(qq))**2)/(h1*h0s*sig**2)
        gm(0,2,i,j,k)=0.d0
        gm(0,3,i,j,k)=arg**2*rg*rr*sin(2.0*qq)/(h3*h0s*sig**2)
        gm(1,1,i,j,k)=(rg*rr**2-arg**2*(rr*sin(qq)**2+rg*cos(qq)**2)) &
                      /(h1*del*sig)
        gm(1,2,i,j,k)=0.d0
        gm(1,3,i,j,k)=arg**2*sin(2.0*qq)/(2.0*sig*h3)
        gm(2,1,i,j,k)=-(rr-rg+rg*((rr**2-arg**2)*rr**2 &
                      +(3.0*rr**2+arg**2)*(arg*cos(qq))**2)/sig**2) &
                      *sig/(h1*alp)
        gm(2,2,i,j,k)=0.d0
        gm(2,3,i,j,k)=-sig*cos(qq)/(h3*alp*sin(qq)) &
                      *(2.0*rg*rr*(rr**2+arg**2)**2/sig**2+del)
        gm(3,1,i,j,k)=-rr/(sig*h1)
        gm(3,2,i,j,k)=0.d0
        gm(3,3,i,j,k)=0.5*arg**2*sin(2.0*qq)/h3**3         
!
      enddo
    enddo
  enddo
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        gm(1,1,i,j,k)=hh(0,i,j,k)*gm(1,1,i,j,k)/hh(1,i,j,k)
        gm(1,2,i,j,k)=hh(0,i,j,k)*gm(1,2,i,j,k)/hh(1,i,j,k)
        gm(1,3,i,j,k)=hh(0,i,j,k)*gm(1,3,i,j,k)/hh(1,i,j,k)
        gm(2,1,i,j,k)=hh(0,i,j,k)*gm(2,1,i,j,k)/hh(2,i,j,k)
        gm(2,2,i,j,k)=hh(0,i,j,k)*gm(2,2,i,j,k)/hh(2,i,j,k)
        gm(2,3,i,j,k)=hh(0,i,j,k)*gm(2,3,i,j,k)/hh(2,i,j,k)
        gm(3,1,i,j,k)=hh(0,i,j,k)*gm(3,1,i,j,k)/hh(3,i,j,k)
        gm(3,2,i,j,k)=hh(0,i,j,k)*gm(3,2,i,j,k)/hh(3,i,j,k)
        gm(3,3,i,j,k)=hh(0,i,j,k)*gm(3,3,i,j,k)/hh(3,i,j,k)
      enddo
    enddo
  enddo
!
  return
end subroutine kergeo
!
!--------------------------------------------------------------------
subroutine kershr(wok,sgk,x1,x3,hh,gm,hhi,hhj,hhk,x1a,x3a,woki,wokj,wokk, &
                  is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax, rbh, akm
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: wok(3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: woki(3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wokj(3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wokk(3,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: sgk(3,3,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x3(kmax), x1a(imax), x3a(kmax)

  real(8) :: rg, arg, rr, rri, qq, qqk, del, sig, alp, deli, sigi, alpi, &
             delj, sigj, alpj, delk, sigk, alpk, h1, h2, h3, h2i, h2j, h2k, &
             wok2, wok2i, wok2j, wok2k 
!
  rg=0.5*rbh
  arg=akm*rg
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1  

        rr=x1(i)
        rri=x1a(i)
        qq=x3(k)
        qqk=x3a(k)
!
        del=rr**2-2.0*rg*rr+(arg)**2
        sig=rr**2+(arg*cos(qq))**2
        alp=(rr**2+arg**2)**2-del*(arg*sin(qq))**2

        deli=rri**2-2.0*rg*rri+(arg)**2
        sigi=rri**2+(arg*cos(qq))**2
        alpi=(rri**2+arg**2)**2-del*(arg*sin(qq))**2
         
        delj=rr**2-2.0*rg*rr+(arg)**2
        sigj=rr**2+(arg*cos(qq))**2
        alpj=(rr**2+arg**2)**2-del*(arg*sin(qq))**2
         
        delk=rr**2-2.0*rg*rr+(arg)**2
        sigk=rr**2+(arg*cos(qqk))**2
        alpk=(rr**2+arg**2)**2-del*(arg*sin(qqk))**2
!
!        h0=sqrt(1.0-2.0*rg*rr/sig)
        h1=hh(1,i,j,k)
        h2=hh(2,i,j,k)
        h2i=hhi(2,i,j,k)
        h2j=hhj(2,i,j,k)
        h2k=hhk(2,i,j,k)
        h3=hh(3,i,j,k)
!
        wok2=2.0*arg*rg*rr*sin(qq)**2/(sig*hh(0,i,j,k)*h2)
        wok(1,i,j,k)=0.d0
        wok(2,i,j,k)=wok2
        wok(3,i,j,k)=0.d0

        wok2i=2.0*arg*rg*rri*sin(qq)**2/(sigi*hhi(0,i,j,k)*h2i)
        wok2j=2.0*arg*rg*rr*sin(qq)**2/(sigj*hhj(0,i,j,k)*h2j)
        wok2k=2.0*arg*rg*rr*sin(qqk)**2/(sigk*hhk(0,i,j,k)*h2k)

        woki(1,i,j,k)=0.d0
        woki(2,i,j,k)=wok2i
        woki(3,i,j,k)=0.d0

        wokj(1,i,j,k)=0.d0
        wokj(2,i,j,k)=wok2j
        wokj(3,i,j,k)=0.d0

        wokk(1,i,j,k)=0.d0
        wokk(2,i,j,k)=wok2k
        wokk(3,i,j,k)=0.d0
!
        sgk(1,1,i,j,k)=0.d0
        sgk(1,2,i,j,k)=0.d0
        sgk(1,3,i,j,k)=0.d0
        sgk(2,1,i,j,k)=wok2*( &
                      -hh(0,i,j,k)*(rr**2-(arg*cos(qq))**2)/(rr*h1*sig) &
                      +gm(2,1,i,j,k))
        sgk(2,2,i,j,k)=0.d0
        sgk(2,3,i,j,k)=2.0*arg*rg*rr/(sig*sqrt(del)) &
                      *(2.0*hh(0,i,j,k)*cos(qq)*(rr**2+arg**2)/(h3*sig) &
                      +gm(2,3,i,j,k)*sin(qq))
        sgk(3,1,i,j,k)=0.d0
        sgk(3,2,i,j,k)=0.d0
        sgk(3,3,i,j,k)=0.d0        

      enddo
    enddo
  enddo
!
  return
end subroutine kershr
!
!--------------------------------------------------------------------
subroutine nrbhshr(wok,sgk,woki,wokj,wokk,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: wok(3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: woki(3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wokj(3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wokk(3,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: sgk(3,3,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1 
!
        wok(1,i,j,k)=0.d0
        wok(2,i,j,k)=0.d0
        wok(3,i,j,k)=0.d0
         
        woki(1,i,j,k)=0.d0
        woki(2,i,j,k)=0.d0
        woki(3,i,j,k)=0.d0
         
        wokj(1,i,j,k)=0.d0
        wokj(2,i,j,k)=0.d0
        wokj(3,i,j,k)=0.d0
         
        wokk(1,i,j,k)=0.d0
        wokk(2,i,j,k)=0.d0
        wokk(3,i,j,k)=0.d0
!
        sgk(1,1,i,j,k)=0.d0
        sgk(1,2,i,j,k)=0.d0
        sgk(1,3,i,j,k)=0.d0
        sgk(2,1,i,j,k)=0.d0
        sgk(2,2,i,j,k)=0.d0
        sgk(2,3,i,j,k)=0.d0
        sgk(3,1,i,j,k)=0.d0
        sgk(3,2,i,j,k)=0.d0
        sgk(3,3,i,j,k)=0.d0
!
      enddo
    enddo
  enddo
!
  return
end subroutine nrbhshr
!
!--------------------------------------------------------------------
subroutine calhoi(hh,hi,ho,hhi,hhj,hhk,hii,hij,hik,hoi,hoj,hok, &
                  is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hi(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hii(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hij(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hik(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: ho(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hoi(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hoj(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hok(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: h0, h1, h2, h3, h123, h123a, h0i, h1i, h2i, h3i, h123i 
  real(8) :: h0j, h1j, h2j, h3j, h123j, h0k, h1k, h2k, h3k, h123k

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        h0=hh(0,i,j,k)
        h1=hh(1,i,j,k)
        h2=hh(2,i,j,k)
        h3=hh(3,i,j,k)
        h123=1.0/(h1*h2*h3)

        h123a=h1*h2*h3

        h0i=hhi(0,i,j,k)
        h1i=hhi(1,i,j,k)
        h2i=hhi(2,i,j,k)
        h3i=hhi(3,i,j,k)
        h123i=1.0/(h1i*h2i*h3i)

        h0j=hhj(0,i,j,k)
        h1j=hhj(1,i,j,k)
        h2j=hhj(2,i,j,k)
        h3j=hhj(3,i,j,k)
        h123j=1.0/(h1j*h2j*h3j)

        h0k=hhk(0,i,j,k)
        h1k=hhk(1,i,j,k)
        h2k=hhk(2,i,j,k)
        h3k=hhk(3,i,j,k)
        h123k=1.0/(h1k*h2k*h3k)
!
        ho(1,1,i,j,k)=h123
        ho(2,1,i,j,k)=h123
        ho(3,1,i,j,k)=h123
        ho(1,2,i,j,k)=h123
        ho(2,2,i,j,k)=h123
        ho(3,2,i,j,k)=h123
        ho(1,3,i,j,k)=h123
        ho(2,3,i,j,k)=h123
        ho(3,3,i,j,k)=h123
        ho(1,4,i,j,k)=h123
        ho(2,4,i,j,k)=h123
        ho(3,4,i,j,k)=h123
        ho(1,5,i,j,k)=h123
        ho(2,5,i,j,k)=h123
        ho(3,5,i,j,k)=h123
        ho(1,6,i,j,k)=h123
        ho(2,6,i,j,k)=h123
        ho(3,6,i,j,k)=h123
         
        hoi(1,i,j,k)=h123i
        hoi(2,i,j,k)=h123i
        hoi(3,i,j,k)=h123i
        hoi(4,i,j,k)=h123i
        hoi(5,i,j,k)=h123i
        hoi(6,i,j,k)=h123i

        hoj(1,i,j,k)=h123j
        hoj(2,i,j,k)=h123j
        hoj(3,i,j,k)=h123j 
        hoj(4,i,j,k)=h123j
        hoj(5,i,j,k)=h123j
        hoj(6,i,j,k)=h123j

        hok(1,i,j,k)=h123k 
        hok(2,i,j,k)=h123k
        hok(3,i,j,k)=h123k
        hok(4,i,j,k)=h123k
        hok(5,i,j,k)=h123k
        hok(6,i,j,k)=h123k
 
        hi(1,1,i,j,k)=h2*h3*h0
        hi(2,1,i,j,k)=h3*h1*h0
        hi(3,1,i,j,k)=h1*h2*h0
        hi(1,2,i,j,k)=h2*h3*h0
        hi(2,2,i,j,k)=h3*h1*h0
        hi(3,2,i,j,k)=h1*h2*h0
        hi(1,3,i,j,k)=h2*h3*h0
        hi(2,3,i,j,k)=h3*h1*h0
        hi(3,3,i,j,k)=h1*h2*h0
        hi(1,4,i,j,k)=h2*h3*h0
        hi(2,4,i,j,k)=h3*h1*h0
        hi(3,4,i,j,k)=h1*h2*h0
        hi(1,5,i,j,k)=h2*h3*h0
        hi(2,5,i,j,k)=h3*h1*h0
        hi(3,5,i,j,k)=h1*h2*h0
        hi(1,6,i,j,k)=h2*h3*h0
        hi(2,6,i,j,k)=h3*h1*h0
        hi(3,6,i,j,k)=h1*h2*h0
        
        hii(1,i,j,k)=h2i*h3i*h0i
        hii(2,i,j,k)=h2i*h3i*h0i
        hii(3,i,j,k)=h2i*h3i*h0i
        hii(4,i,j,k)=h2i*h3i*h0i
        hii(5,i,j,k)=h2i*h3i*h0i
        hii(6,i,j,k)=h2i*h3i*h0i
 
        hij(1,i,j,k)=h3j*h1j*h0j
        hij(2,i,j,k)=h3j*h1j*h0j
        hij(3,i,j,k)=h3j*h1j*h0j
        hij(4,i,j,k)=h3j*h1j*h0j
        hij(5,i,j,k)=h3j*h1j*h0j
        hij(6,i,j,k)=h3j*h1j*h0j
 
        hik(1,i,j,k)=h1k*h2k*h0k         
        hik(2,i,j,k)=h1k*h2k*h0k
        hik(3,i,j,k)=h1k*h2k*h0k
        hik(4,i,j,k)=h1k*h2k*h0k
        hik(5,i,j,k)=h1k*h2k*h0k
        hik(6,i,j,k)=h1k*h2k*h0k
!
        ho(1,7,i,j,k)=0.d0
        ho(2,7,i,j,k)=1.d0/(h2*h3)
        ho(3,7,i,j,k)=1.d0/(h2*h3)
        ho(1,8,i,j,k)=1.d0/(h3*h1)
        ho(2,8,i,j,k)=0.d0
        ho(3,8,i,j,k)=1.d0/(h3*h1)
        ho(1,9,i,j,k)=1.d0/(h1*h2)
        ho(2,9,i,j,k)=1.d0/(h1*h2)
        ho(3,9,i,j,k)=0.d0
        hi(1,7,i,j,k)=0.d0
        hi(2,7,i,j,k)=h3*h0
        hi(3,7,i,j,k)=h2*h0
        hi(1,8,i,j,k)=h3*h0
        hi(2,8,i,j,k)=0.d0
        hi(3,8,i,j,k)=h1*h0
        hi(1,9,i,j,k)=h2*h0
        hi(2,9,i,j,k)=h1*h0
        hi(3,9,i,j,k)=0.d0
!
        hoi(7,i,j,k)=0.d0
        hoi(8,i,j,k)=1.0/(h3i*h1i)
        hoi(9,i,j,k)=1.0/(h1i*h2i)
        hii(7,i,j,k)=0.d0
        hii(8,i,j,k)=h3i*h0i
        hii(9,i,j,k)=h2i*h0i

        hoj(7,i,j,k)=1.0/(h2j*h3j)
        hoj(8,i,j,k)=0.d0
        hoj(9,i,j,k)=1.0/(h1j*h2j)
        hij(7,i,j,k)=h3j*h0j
        hij(8,i,j,k)=0.d0
        hij(9,i,j,k)=h1j*h0j

        hok(7,i,j,k)=1.0/(h2k*h3k)
        hok(8,i,j,k)=1.0/(h3k*h1k)
        hok(9,i,j,k)=0.d0
        hik(7,i,j,k)=h2k*h0k
        hik(8,i,j,k)=h1k*h0k
        hik(9,i,j,k)=0.d0

      enddo
    enddo
  enddo
!
  return
end subroutine calhoi
