!----------------------------------------------------------------------
subroutine pminmax1a(uu,uri,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, pmin, pmax, dmin
  implicit none
!
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: pr, de
  integer :: isetp
!
  isetp=0
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
         
        pr=uri(5,i,j,k)
        de=uri(1,i,j,k)
         
        if( pr.lt.pmin .or. pr.gt.pmax .or. de.lt.dmin) then
!
          if( pr.lt.pmin ) then
            pr=pmin
            isetp=1
          endif
!
          if( pr.gt.pmax ) then
            pr=pmax
            isetp=2
          endif

          if( de.lt.dmin ) then
            de=dmin
            isetp=3
          endif
!
          uri(5,i,j,k)=pr
          uri(1,i,j,k)=de
!
        endif

      enddo
    enddo
  enddo  
!     
  if(isetp .eq. 1) then
    call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
  endif
!
  if( isetp .eq. 1 ) then
    write(6,*) 'Correction: pmin in pminmax'
    write(6,*) 'pmin =', pmin
  elseif( isetp .eq. 2) then
    write(6,*) 'Correction: pmax in pminmax'
    write(6,*) 'pmax =', pmax
  elseif( isetp .eq. 3) then
    write(6,*) 'Correction: dmin in pminmax'
    write(6,*) 'dmin =', dmin
  endif
!
  return
end subroutine pminmax1a
!
!----------------------------------------------------------------------
subroutine pminmax2a(uu,uri,x1,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
!     floor model for density and pressure                       
!
  use pram, only : imax, jmax, kmax, nv, pmax, dmin, gam
  implicit none
!
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax)
!
  real(8) :: pr, de, demin, uumin, prmin
  integer :: isetp
!
!
  isetp=0
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
         
        pr=uri(5,i,j,k)
        de=uri(1,i,j,k)
         
        demin=dmin*x1(i)**(-3./2.)
        uumin=0.01*dmin*x1(i)**(-5./2.)
        prmin=(gam-1.0)*demin*uumin
        if( pr.lt.prmin .or. pr.gt.pmax .or. de.lt.demin) then
!
          if( pr.lt.prmin ) then
            pr=prmin
            isetp=1
          endif
!
          if( pr.gt.pmax ) then
            pr=pmax
            isetp=1
          endif

          if( de.lt.demin ) then          
            de=dmin
            isetp=1
          endif          
!
          uri(5,i,j,k)=pr
          uri(1,i,j,k)=de
!
        endif
!
      enddo
    enddo
  enddo
!
  if(isetp .eq. 1) then
    call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
  endif
!
  if(isetp.ne.0) then
    write(6,*) 'Warning: p == pmin/pmax in pminmax'
  endif
!
  return
end subroutine pminmax2a
!
