!----------------------------------------------------------------------
  subroutine rk2fst(uh,ww,hi,ho,uu,hii,hij,hik,hoi,hoj,hok,nm1, &
                    akap1b,akap2b,akap3b,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
!
!      First step of 2nd order Runge-Kutta timeadvance step
!
!      Variables
!       uu: conserved variables
!       ww: numerical flux
!       ho, hi: metric variables
!
  use pram, only : imax, jmax, kmax, nv
  implicit none
!
  integer :: i, j, k, m, nm1, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1), &
             uh(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: hi(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             hii(nv,is1:ie1,js1:je1,ks1:ke1), & 
             hij(nv,is1:ie1,js1:je1,ks1:ke1), &
             hik(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: ho(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             hoi(nv,is1:ie1,js1:je1,ks1:ke1), &
             hoj(nv,is1:ie1,js1:je1,ks1:ke1), &
             hok(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: akap1b(imax-1),akap2b(jmax-1),akap3b(kmax-1)

!  real(8) akap1a, akap2a, akap3a
      
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        do m=1,nv

          uh(m,i,j,k)=uu(m,i,j,k) &
           -akap1b(i)*ho(1,m,i,j,k) &
             *(hii(m,i,j,k)*ww(1,m,i,j,k)-hii(m,i-1,j,k)*ww(1,m,i-1,j,k)) &
           -akap2b(j)*ho(2,m,i,j,k) &
             *(hij(m,i,j,k)*ww(2,m,i,j,k)-hij(m,i,j-1,k)*ww(2,m,i,j-1,k)) &
           -akap3b(k)*ho(3,m,i,j,k) &
             *(hik(m,i,j,k)*ww(3,m,i,j,k)-hik(m,i,j,k-1)*ww(3,m,i,j,k-1)) 
!
!              uh(m,i,j,k)=uu(m,i,j,k)
!          -akap1a*ho(1,m,i,j,k)
!            *(hi(1,m,i,j,k)*ww(1,m,i,j,k)
!             -hi(1,m,i-1,j,k)*ww(1,m,i-1,j,k))
!          -akap2a*ho(2,m,i,j,k)
!            *(hi(2,m,i,j,k)*ww(2,m,i,j,k)
!             -hi(2,m,i,j-1,k)*ww(2,m,i,j-1,k))
!          -akap3a*ho(3,m,i,j,k)
!            *(hi(3,m,i,j,k)*ww(3,m,i,j,k)
!             -hi(3,m,i,j,k-1)*ww(3,m,i,j,k-1))
!
        enddo
      enddo
    enddo
  enddo
 
  return
end subroutine rk2fst
!
!----------------------------------------------------------------------
subroutine rk2snd(uu,ww,hi,ho,uo,uh,hii,hij,hik,hoi,hoj,hok,nm1, &
                  akap1b,akap2b,akap3b,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
!
!      Second step of 2nd order Runge-Kutta timeadvance step
!
!      Variables
!       uu: conserved variables(new), 
!       uh: conserved variables(half-step)
!       uo: conserved variables(previous time)
!       ww: numerical flux
!       ho, hi: metric variables
!
  use pram, only : imax, jmax, kmax, nv
  implicit none
!
  integer :: i, j, k, m, nm1, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1), &
             uh(nv,is1:ie1,js1:je1,ks1:ke1), &
             uo(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: hi(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             hii(nv,is1:ie1,js1:je1,ks1:ke1), & 
             hij(nv,is1:ie1,js1:je1,ks1:ke1), &
             hik(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: ho(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             hoi(nv,is1:ie1,js1:je1,ks1:ke1), &
             hoj(nv,is1:ie1,js1:je1,ks1:ke1), &
             hok(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: akap1b(imax-1),akap2b(jmax-1),akap3b(kmax-1)

!  real(8) akap1a, akap2a, akap3a
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        do m=1,nv
!
          uu(m,i,j,k)=(uo(m,i,j,k)+uh(m,i,j,k))*0.5+ &
           (-akap1b(i)*ho(1,m,i,j,k) &
             *(hii(m,i,j,k)*ww(1,m,i,j,k)-hii(m,i-1,j,k)*ww(1,m,i-1,j,k)) &
            -akap2b(j)*ho(2,m,i,j,k) &
             *(hij(m,i,j,k)*ww(2,m,i,j,k)-hij(m,i,j-1,k)*ww(2,m,i,j-1,k)) &
            -akap3b(k)*ho(3,m,i,j,k) &
             *(hik(m,i,j,k)*ww(3,m,i,j,k)-hik(m,i,j,k-1)*ww(3,m,i,j,k-1)))*0.5
!
!          uu(m,i,j,k)=(uo(m,i,j,k)+uh(m,i,j,k))*0.5+
!          (-akap1a*ho(1,m,i,j,k)
!            *((hi(1,m,i,j,k)+hi(1,m,i+1,j,k))*0.5
!            *ww(1,m,i,j,k)
!             -(hi(1,m,i,j,k)+hi(1,m,i-1,j,k))*0.5
!            *ww(1,m,i-1,j,k))
!           -akap2a*ho(2,m,i,j,k)
!            *((hi(2,m,i,j,k)+hi(2,m,i,j+1,k))*0.5
!            *ww(2,m,i,j,k)
!             -(hi(2,m,i,j,k)+hi(2,m,i,j-1,k))*0.5
!            *ww(2,m,i,j-1,k))
!           -akap3a*ho(3,m,i,j,k)
!            *((hi(3,m,i,j,k)+hi(3,m,i,j,k+1))*0.5
!            *ww(3,m,i,j,k)
!             -(hi(3,m,i,j,k)+hi(3,m,i,j,k-1))*0.5
!            *ww(3,m,i,j,k-1)))*0.5
     
        enddo
      enddo
    enddo
  enddo 
!
  return
end subroutine rk2snd
!
!----------------------------------------------------------------------
subroutine rk3snd(uu,ww,hi,ho,uo,uh,hii,hij,hik,hoi,hoj,hok,nm1, &
                  akap1b,akap2b,akap3b,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
!
!      Second step of 3rd order Runge-Kutta timeadvance step
!
!      Variables
!       uu: conserved variables(new), 
!       uh: conserved variables(half-step)
!       uo: conserved variables(previous time)
!       ww: numerical flux
!       ho, hi: metric variables
!
  use pram, only : imax, jmax, kmax, nv
  implicit none
!
  integer :: i, j, k, m, nm1, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1), &
             uh(nv,is1:ie1,js1:je1,ks1:ke1), &
             uo(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: hi(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             hii(nv,is1:ie1,js1:je1,ks1:ke1), & 
             hij(nv,is1:ie1,js1:je1,ks1:ke1), &
             hik(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: ho(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             hoi(nv,is1:ie1,js1:je1,ks1:ke1), &
             hoj(nv,is1:ie1,js1:je1,ks1:ke1), &
             hok(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: akap1b(imax-1),akap2b(jmax-1),akap3b(kmax-1)

!  real(8) akap1a, akap2a, akap3a
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        do m=1,nv
!         
          uu(m,i,j,k)=(3.0*uo(m,i,j,k)+uh(m,i,j,k))*0.25+ &
            (-akap1b(i)*ho(1,m,i,j,k) &
             *(hii(m,i,j,k)*ww(1,m,i,j,k)-hii(m,i-1,j,k)*ww(1,m,i-1,j,k)) &
            -akap2b(j)*ho(2,m,i,j,k) &
             *(hij(m,i,j,k)*ww(2,m,i,j,k)-hij(m,i,j-1,k)*ww(2,m,i,j-1,k)) &
            -akap3b(k)*ho(3,m,i,j,k) &
             *(hik(m,i,j,k)*ww(3,m,i,j,k)-hik(m,i,j,k-1)*ww(3,m,i,j,k-1)))*0.25
!         
!          uu(m,i,j,k)=(3.0*uo(m,i,j,k)+uh(m,i,j,k))*0.25+
!          (-akap1a*ho(1,m,i,j,k)
!            *(hi(1,m,i,j,k)*ww(1,m,i,j,k)
!             -hi(1,m,i-1,j,k)*ww(1,m,i-1,j,k))
!           -akap2a*ho(2,m,i,j,k)
!            *(hi(2,m,i,j,k)*ww(2,m,i,j,k)
!             -hi(2,m,i,j-1,k)*ww(2,m,i,j-1,k))
!           -akap3a*ho(3,m,i,j,k)
!            *(hi(3,m,i,j,k)*ww(3,m,i,j,k)
!             -hi(3,m,i,j,k-1)*ww(3,m,i,j,k-1)))*0.25
 
        enddo
      enddo
    enddo
  enddo 
!
  return
end subroutine rk3snd
!
!----------------------------------------------------------------------
subroutine rk3trd(uu,ww,hi,ho,uo,us,hii,hij,hik,hoi,hoj,hok,nm1, &
                  akap1b,akap2b,akap3b,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
!
!      Third step of 3rd order Runge-Kutta timeadvance step
!
!      Variables
!       uu: conserved variables(new), 
!       us: conserved variables(second-step)
!       uo: conserved variables(previous time)
!       ww: numerical flux
!       ho, hi: metric variables
!
  use pram, only : imax, jmax, kmax, nv
  implicit none
!
  integer :: i, j, k, m, nm1, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1), &
             us(nv,is1:ie1,js1:je1,ks1:ke1), &
             uo(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: hi(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             hii(nv,is1:ie1,js1:je1,ks1:ke1), & 
             hij(nv,is1:ie1,js1:je1,ks1:ke1), &
             hik(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: ho(3,nv,is1:ie1,js1:je1,ks1:ke1), &
             hoi(nv,is1:ie1,js1:je1,ks1:ke1), &
             hoj(nv,is1:ie1,js1:je1,ks1:ke1), &
             hok(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: akap1b(imax-1),akap2b(jmax-1),akap3b(kmax-1)

!  real(8) akap1a, akap2a, akap3a
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        do m=1,nv

          uu(m,i,j,k)=(uo(m,i,j,k)+2.0*us(m,i,j,k))*(1.0/3.0)+ &
           (-akap1b(i)*ho(1,m,i,j,k) &
             *(hii(m,i,j,k)*ww(1,m,i,j,k)-hii(m,i-1,j,k)*ww(1,m,i-1,j,k)) &
            -akap2b(j)*ho(2,m,i,j,k) &
             *(hij(m,i,j,k)*ww(2,m,i,j,k)-hij(m,i,j-1,k)*ww(2,m,i,j-1,k)) &
            -akap3b(k)*ho(3,m,i,j,k) &
             *(hik(m,i,j,k)*ww(3,m,i,j,k)-hik(m,i,j,k-1)*ww(3,m,i,j,k-1))) &
             *(2./3.)
!     
!          uu(m,i,j,k)=(uo(m,i,j,k)+2.0*us(m,i,j,k))*(1.0/3.0)+
!          (-akap1a*ho(1,m,i,j,k)
!            *(hi(1,m,i,j,k)*ww(1,m,i,j,k)
!             -hi(1,m,i-1,j,k)*ww(1,m,i-1,j,k))
!           -akap2a*ho(2,m,i,j,k)
!            *(hi(2,m,i,j,k)*ww(2,m,i,j,k)
!             -hi(2,m,i,j-1,k)*ww(2,m,i,j-1,k))
!           -akap3a*ho(3,m,i,j,k)
!            *(hi(3,m,i,j,k)*ww(3,m,i,j,k)
!             -hi(3,m,i,j,k-1)*ww(3,m,i,j,k-1)))*(2.0/3.0)
     
        enddo
      enddo
    enddo
  enddo

  return
end subroutine rk3trd
!
!----------------------------------------------------------------------
subroutine rk2adsff(uu,sf,nm1,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
!
!      Add source term to conservec variables for first step
!
!      Variables
!       uh: conserved variables
!       sf, sou: source term
!
  use pram, only : imax, jmax, kmax, nv
  implicit none
!
  integer :: i, j, k, nm1, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: sf(2:5,is1:ie1,js1:je1,ks1:ke1)

!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
         
        uu(2,i,j,k)=uu(2,i,j,k)+sf(2,i,j,k)
        uu(3,i,j,k)=uu(3,i,j,k)+sf(3,i,j,k)
        uu(4,i,j,k)=uu(4,i,j,k)+sf(4,i,j,k)
        uu(5,i,j,k)=uu(5,i,j,k)+sf(5,i,j,k)
          
      enddo
    enddo
  enddo
!
  return
end subroutine rk2adsff
!
!----------------------------------------------------------------------
subroutine rk2adsfs(uu,sf,nm1,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
!
!      Add source term to conservec variables for second step
!
!      Variables
!       uh: conserved variables
!       sf, sou: source term
!
  use pram, only : imax, jmax, kmax, nv
  implicit none
!
  integer :: i, j, k, nm1, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: sf(2:5,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
          
        uu(2,i,j,k)=uu(2,i,j,k)+sf(2,i,j,k)*0.5
        uu(3,i,j,k)=uu(3,i,j,k)+sf(3,i,j,k)*0.5
        uu(4,i,j,k)=uu(4,i,j,k)+sf(4,i,j,k)*0.5
        uu(5,i,j,k)=uu(5,i,j,k)+sf(5,i,j,k)*0.5

      enddo
    enddo
  enddo
!
  return
end subroutine rk2adsfs
!
!----------------------------------------------------------------------
subroutine rk3adsfs(uu,sf,nm1,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
!
!      Add source term to conservec variables for second step
!
!      Variables
!       uh: conserved variables
!       sf, sou: source term
!
  use pram, only : imax, jmax, kmax, nv
  implicit none
!
  integer :: i, j, k, nm1, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: sf(2:5,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
          
        uu(2,i,j,k)=uu(2,i,j,k)+sf(2,i,j,k)*0.25
        uu(3,i,j,k)=uu(3,i,j,k)+sf(3,i,j,k)*0.25
        uu(4,i,j,k)=uu(4,i,j,k)+sf(4,i,j,k)*0.25
        uu(5,i,j,k)=uu(5,i,j,k)+sf(5,i,j,k)*0.25
     
      enddo
    enddo
  enddo
!
  return
end subroutine rk3adsfs
!
!----------------------------------------------------------------------
subroutine rk3adsft(uu,sf,nm1,is1,ie1,js1,je1,ks1,ke1)
!----------------------------------------------------------------------
!
!      Add source term to conservec variables for third step
!
!      Variables
!       uh: conserved variables
!       sf, sou: source term
!
  use pram, only : imax, jmax, kmax, nv
  implicit none
!
  integer :: i, j, k, nm1, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: sf(2:5,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
          
        uu(2,i,j,k)=uu(2,i,j,k)+sf(2,i,j,k)*(2.0/3.0)
        uu(3,i,j,k)=uu(3,i,j,k)+sf(3,i,j,k)*(2.0/3.0)
        uu(4,i,j,k)=uu(4,i,j,k)+sf(4,i,j,k)*(2.0/3.0)
        uu(5,i,j,k)=uu(5,i,j,k)+sf(5,i,j,k)*(2.0/3.0)
     
      enddo
    enddo
  enddo
!
  return
end subroutine rk3adsft
!
