!-----------------------------------------------------------------------
subroutine spdlia1(uri,uu,istop,ierror,is1,ie1,js1,je1,ks1,ke1)
!-----------------------------------------------------------------------
!     speed limiter by average for x- and z- direction        1996.12.25
!     speed limiter near light velocity                       1996.12.24
!
  use pram, only : imax, jmax, kmax, nv, vlim, c0, adamp
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: vsq, v1, v2, v3, vlimsq
  integer :: ichk, istop, ierror
!
  vlimsq=vlim**2
  ichk=0
!
!$OMP PARALLEL DO PRIVATE( k, j, i, vsq, v1, v2, v3 )

  do k = ks1+1, ke1-1
    do j = js1+1, je1-1
      do i = is1+1, ie1-1
        if(istop .ne. 1 .and. ierror .ne. 1) then
          vsq=(uri(2,i,j,k)**2+uri(3,i,j,k)**2+uri(4,i,j,k)**2)/c0**2
          if( vsq.ge.vlimsq ) then
            v1=(uri(2,i,j,k)+adamp*(uri(2,i+1,j,k)+uri(2,i-1,j,k)+ &
               uri(2,i,j,k+1)+uri(2,i,j,k-1)))/(1.0+4.0*adamp)
            v2=(uri(3,i,j,k)+adamp*(uri(3,i+1,j,k)+uri(3,i-1,j,k)+ &
               uri(3,i,j,k+1)+uri(3,i,j,k-1)))/(1.0+4.0*adamp)
            v3=(uri(4,i,j,k)+adamp*(uri(4,i+1,j,k)+uri(4,i-1,j,k)+ &
               uri(4,i,j,k+1)+uri(4,i,j,k-1)))/(1.0+4.0*adamp)
          
            vsq=(v1*v1+v2*v2+v3*v3)/c0**2
!                                                        2002.06.19
            ichk=1
            if( vsq.ge.1.d0 ) then
              istop=1
              ierror=1
!              write(4,*) 'Error in spdlia; (vsq/c0)^2 =',vsq &
!                     ,'at i, j, k:',i,j,k
            endif
          
            uri(2,i,j,k)=v1
            uri(3,i,j,k)=v2
            uri(4,i,j,k)=v3
         
          endif
        endif
      enddo
    enddo
  enddo
!
  if(istop .ne. 1 .and. ierror .ne. 1) then
    if(ichk .eq. 1) then
      call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
    endif
  endif
!
  return
end subroutine spdlia1
!
