! for Initial Condition of Black-hole accretion disk system
! 
!---------------------------------------------------------------------@
subroutine bhmodel(de,pr,v1,v2,v3,b1,b2,b3,pg,hh,wok,x1,x2,x3,&
                   is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, model, metric
  implicit none
  
  integer :: is1, ie1, js1, je1, ks1, ke1, merr
!
  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), b1(is1:ie1,js1:je1,ks1:ke1), &
             b2(is1:ie1,js1:je1,ks1:ke1), b3(is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: pg(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wok(3,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: x1(imax), x2(jmax), x3(kmax)
!
  real(8), allocatable :: vp2(:,:,:) 
  real(8) :: csd1, dd0, ee0, vp, rd, hrel, rc, rshock, tctd, vd, b0, qmag
  real(8) :: al0
  integer :: icor, idisk, ibhmag
!
  allocate(vp2(is1:ie1,js1:je1,ks1:ke1), stat=merr)
!
!  Parameter (generally used in several models)
!
  dd0=1.d0 ! density normalization unit
  ee0=0.1d0
  vp=1.d0 ! radial velocity strength (for Bondi accretion) 
  rd=100.d0    
  hrel=1.3d0 
  rc=-1.d0 ! position of critical point (for Bondi accretion flow) 
  rshock=-1.d0
!
  tctd=100.d0
  vd=1.d0
  b0=0.0d0
  qmag=0.d0
!
  al0=0.1d0 ! strength of angular moumentum
!
  icor=0
  idisk=3
  ibhmag=5
!
!    Black Hole Corona Model
!
  if(icor .eq. 0) then
    call mdffcor(de,pr,v1,v2,v3,x1,is1,ie1,js1,je1,ks1,ke1,&
                 dd0,ee0,vp,rd,hrel,rc,rshock)
  elseif(icor .eq. 1) then
    call mdcor1(de,pr,v1,v2,v3,is1,ie1,js1,je1,ks1,ke1)
  elseif(icor .eq. 2) then
    call mdeqcor3(de,pr,v1,v2,v3,x1,is1,ie1,js1,je1,ks1,ke1,dd0)
  elseif(icor .eq. 3) then
    call mdeqcor2(de,pr,v1,v2,v3,x1,is1,ie1,js1,je1,ks1,ke1,dd0,ee0)
  elseif(icor .eq. 4) then
    call mdeqcor1(de,pr,v1,v2,v3,pg,is1,ie1,js1,je1,ks1,ke1,dd0,ee0,rd)
  elseif(icor .eq. 5) then
    call mdffcor1(de,pr,v1,v2,v3,x1,x3,hh,is1,ie1,js1,je1,ks1,ke1,dd0,vp,rc)
  elseif(icor .eq. 6) then
    call mdffcor2(de,pr,v1,v2,v3,x1,x3,hh,is1,ie1,js1,je1,ks1,ke1,dd0,vp,rc,&
                  al0) 
  endif
!
!    Black Hole Disk Model
!
  if(idisk .eq. 0) then
    call mdthndsk(de,pr,v1,v2,v3,x1,x2,x3,wok,pg,is1,ie1,js1,je1,ks1,ke1, &
                  tctd,rd,vd)
  elseif(idisk .eq. 1) then
    call mdtkdsk1(de,pr,v1,v2,v3,x1,x2,x3,hh,vp2,is1,ie1,js1,je1,ks1,ke1, &
                  vd,csd1)
  elseif(idisk .eq. 2) then
    call mdtkdsk2(de,pr,v1,v2,v3,x1,x2,x3,hh,vp2,is1,ie1,js1,je1,ks1,ke1, &
                  vd,csd1)
  endif
!
!    Black Hole Magnetic Field Configuration
!
  if(metric .eq. 103) then
    if(ibhmag .eq. 1) then
      call mdmonomg1(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    elseif(ibhmag .eq. 2) then
      call mddipmg(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    elseif(ibhmag .eq. 3) then
      call mdpotmg(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    elseif(ibhmag .eq. 4) then
      call mdsmonmg(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    elseif(ibhmag .eq. 5) then
      call mdunimg1(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0,pg)
    elseif(ibhmag .eq. 6) then
      call mdvpmg1(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0,hh,vp2)
    elseif(ibhmag .eq. 7) then
      call mdloopmg(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    endif
  elseif(metric .eq. 203) then
    if(ibhmag .eq. 1) then
      call mdmonomg2(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    elseif(ibhmag .eq. 2) then
      call mddipmg(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    elseif(ibhmag .eq. 3) then
      call mdpotmg(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    elseif(ibhmag .eq. 4) then
      call mdsmonmg(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    elseif(ibhmag .eq. 5) then
      call mdunimg2(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    elseif(ibhmag .eq. 6) then
      call mdvpmg2(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0,vp2)
    elseif(ibhmag .eq. 7) then
      call mdloopmg(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,b0)
    endif

    if(qmag .ne. 0.d0) then
      call mdadmnmg(b1,b2,b3,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1,qmag)
    endif

  endif


  deallocate(vp2, stat=merr)
!
  return
end subroutine bhmodel
!
