module pram
!
! Input file
!
  implicit none

  character*65 :: jname='2D Bondi accretion'
  character*15 :: date='Jan. 20. 2014'

  integer, parameter :: imax=256, jmax=7, kmax=64 !Grid number
  integer, parameter :: nv=9 ! Number of variables
  integer, parameter :: nkmax=20 ! Wave number
  integer, parameter :: iprocs=2, jprocs=1, kprocs=2 !CPU number in i- and k- direcc

!  integer, parameter :: ncpu=2 ! Number of CPUs (=npe) for MPI
!  integer, parameter :: kkm= (kmax-1)/ncpu+16+1 ! modified grid number for MPI 
!  integer, parameter :: kkm=64

  integer, parameter :: icpu=20000 ! CPU time
  real(8), parameter :: dt0=0.01d0 !
  integer, parameter :: itmax=10000 ! Max number of iteration
  integer, parameter :: nshot=10 ! Number of Output
  integer, parameter :: icres=0 ! Researt parameter
  real(8), parameter :: dtmin=1.d-6 ! Minimum dt 
  real(8), parameter :: tmax=50.0d0 ! Maximum simulation time
  real(8), parameter :: cfl=0.3d0 ! CFL number
  integer, parameter :: isskip=1 ! Skip for researt data output
  integer, parameter :: iter=100 ! Maxmum iteration number for Newton-Raphson

  real(8), parameter :: pi=3.14159265358979323d0
  integer, parameter :: iseed=2012 ! seed number for random number generation

  real(8), parameter :: pmin=1.0d-20 ! limiter for minimum pressure
  real(8), parameter :: pmax=1.0d10 ! limiter for maximum pressure
  real(8), parameter :: dmin=1.0d-10 ! limiter for minimum density
  
  real(8), parameter :: c0=1.0d0 ! light speed
  real(8), parameter :: gam=4.0d0/3.0d0 ! adiabatic index
  real(8), parameter :: gam0=4.0d0/3.0d0
! for GRMHD
  real(8), parameter :: rbh=1.d0 ! black hole radius
  real(8), parameter :: akm=0.d0 ! black hole spin
! forGRMHD
  real(8), parameter :: vlim=1.d0 ! limiter for velocity/c
  real(8), parameter :: adampa=0.d0  ! parameter for damping 
  real(8), parameter :: adamp=0.d0 ! parameter for damping
  real(8), parameter :: rdamp=0.d0 ! parameter for damping

  real(8), parameter :: xmin=1.1d0, xmax=20.0d0
  real(8), parameter :: ymin=0.0d0, ymax=6.28318d0  
  real(8), parameter :: zmin=0.0d0, zmax=3.141592d0 

  real(8), parameter :: rr1=1.d0, rr2=1.d0, rr3=1.d0

  integer, parameter :: model=0 ! simulation model
  integer, parameter :: metric=103 ! metric
  integer, parameter :: ieos=0 ! EoS
  integer, parameter :: icha=1 ! calculation method for wave speed

  integer, parameter :: iwvec=7 ! inversion procedure
  integer, parameter :: irkt=3 ! time-advance
  integer, parameter :: irec=1 ! reconstruction scheme
  integer, parameter :: ihll=1 ! Approximate Riemann solver scheme
  integer, parameter :: ict=1  ! Constrained Transport scheme

  integer, parameter :: iflag(7)=(/0, 0, 0, 0, 0, 0, 0/)
  integer :: iboux1in(9)=(/7, 7, 7, 7, 7, 7, 7, 7, 7/) ! boundary cond.x1-in
  integer :: iboux1ot(9)=(/2, 2, 2, 2, 2, 2, 2, 2, 2/) ! boundary cond.x1out
  integer :: iboux2in(9)=(/1, 1, 1, 1, 1, 1, 1, 1, 1/) ! boundary cond.x2-in
  integer :: iboux2ot(9)=(/1, 1, 1, 1, 1, 1, 1, 1, 1/) ! boundary cond.x2-out
  integer :: iboux3in(9)=(/5, 5, 5, 5, 5, 5, 5, 5, 5/) ! boundary cond.x3-in
  integer :: iboux3ot(9)=(/5, 5, 5, 5, 5, 5, 5, 5, 5/) ! boundary cond.x3-out 
!
!!!!!!! Parameter explanation !!!!!!!
!
! Researt Option
!
!     icres = 0  : restart off
!     icres = 1  : restart on
!
! Simulation Model
!
!     model = 20 :  jet propagation model (RMHD)
!     model = 21 :  precessed jet model (RMHD)
!     model = 22 :  3D kink instability (RMHD)
!     model = 24 :  3D kink instability in periodic box 
!                   for cold static plasma (RMHD)
!     model = 25 :  3D kink instability in periodic box
!                   for hot static plasma (RMHD)
!     model = 28 :  3D kink instability in periodic box
!                   for cold rotating jet (RMHD)
!     model = 23 :  2D blast wave propagation test (RMHD)
!     model = 26 :  2D Relativistic Magnetic Loop Advection test (RMHD)
!     model = 29 :  3D Relativistic Magnetic Loop Advection test (RMHD)
!     model = 27 :  2D(3D) Rotor test (RMHD)
!     model = 30 :  3D Kelvin-Helmholtz instability in periodic box (RMHD)
!     model = 50 :  1D RMHD test problem (shock-tube)
!     model = 52 :  1D Relativistic shell expansion (RMHD)
!     model = 53 :  1D Relativistic shock reflection (RMHD)
!     model = 54 :  2D Relativistic shock reflection (RMHD)
!     model = 55 :  1D Relativistic blast wave propagation (RMHD)
!     model = 56 :  2D Relativistic blast wave propagation (RMHD)
!     model = 57 :  2D Relativistic shell collision (RMHD)
!
! Mertic (coordinates) 
!
!     metric =   1 :  Cartesian Coordinates
!     metric =   2 :  Cylindrical Coordinates
!     metric =   3 :  Spherical Coordinates
!
! Equation of State
!
!     ieos=0 : Gamma-law constant equation of state    
!     ieos=1 : TM variable equation of state (cal enthalpy)
!     ieos=2 : TM variable equation of state (cal internal energy)
!
! Reconstruction scheme
!
!     irec = 1 : MC slope-limiter reconstruction (2nd order)
!     irec = 2 : Minmod slope-limiter reconstruction (2nd order)
!     irec = 3 : MUSCL method (3rd order), not slope-limiter
!     irec = 4 : Convex ENO reconstruction method (3rd order)
!     irec = 5 : rPPM reconstruction method (4th order)
!     irec = 6 : Monotonicity-Preserving 5th reconstruction (5th order)
!     irec = 7 : Weighted ENO 5th reconstruction (5th order)
!     irec = 8 : MP-WENO reconstruction
!     irec = 9 : WENO-Z 5th reconstruction
!     irec = 10: Mapped WENO 5th reconstruction
!     irec = 11: Limited Reconstruction (3rd order)
!
! Approximate Riemann solver scheme
!
!     ihll = 1 : HLLE single-state approximate Riemann solver
!     ihll = 2 : HLLC two-state approximate Riemann solver
!                (Mignone & Bodo 200?)
!     ihll = 3 : HLLC two-state approximate Riemann solver
!                (Honkkila & Janhunen 2007)
!     ihll = 4 : HLLD multi-state approximate Riemann solver
!                (underconstruction)
!     ihll = 5 : HLLD multi-state approximate Riemann solver
!                (Mignone et al. 2010)
!
! Constrained Transport scheme
!
!     ict = 0 : No contrained transport
!     ict = 1 : Flux CT sheme (Toth 2000)
!     ict = 2 : Modified Flux CT scheme (Gardiner & Stone 2005)
!     ict = 3 : Upwind Flux CT scheme (Gardiner & Stone 2005)
!
! RK time advance scheme
!
!     irkt = 2 : 2nd order Runge-Kutta time advance method
!     irkt = 3 : 3rd order Runge-Kutta time advance method
!
! Inversion procedure scheme
!
!     iwvec=6 : new 2 variable newton-raphson (from Noble et al. 2005)
!     iwvec=7 : 1 variable newton-raphson with variable EOS
!               (from Mignone & McKinney 2007) 
!
! Boundary Condiiton
!
!               1   :    periodic boundary
!               2   :    fixed boundary
!               3   :    Neumann boundary
!               4   :    free boundary
!               5   :    u_0 = u_1       
!               7   :    radiative boundary without eigenvalue
!              12   :    anti-symmetric boundary condition (u_0=-u_1)
!              13   :    regid wall boundary condition (u_0=0.0)
!              15   :    special reflecting boundary 
!                        for jet propagation (z-direction only)
!              17   :    special radiative boundary without eigenvalue
!                        for jet propagation (z-direction only)
!              19   :    special boundary of u_0=u_1
!                        for jet propagation (z-direction only)
!
end module pram

