!***********************************************************************
!                   ARTIFICIAL DAMP  
!***********************************************************************
!-----------------------------------------------------------------------
subroutine damp4(uu,uri,uri0,x1,x3,is1,ie1,js1,je1,ks1,ke1)
!-----------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, metric, adamp, rdamp, &
                   xmin, xmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri0(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x3(kmax)
  real(8) :: rr, adt, de, v1, v2, v3, pr, b1, b2, b3
!
  real(8) :: drdamp, dx1a

  drdamp=0.4d0
  dx1a=(xmax-xmin)/float(imax)

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        if(rdamp .gt. 0.d0) then
          if(metric.eq.3 .or. metric.eq.103 .or. metric.eq.203) then
            rr=x1(i)
          else
            rr=sqrt(x1(i)**2+x3(k)**2)
          endif
            adt=adamp*0.5*(1.0+tanh((rdamp-rr)*(0.3/dx1a)))
!            adt=adamp*0.5*(1.0+tanh((rdamp-rr)/drdamp))

            de= uri(1,i,j,k)-adt*(uri(1,i,j,k)-uri0(1,i,j,k))
            v1= uri(2,i,j,k)-adt*(uri(2,i,j,k)-uri0(2,i,j,k))
            v2= uri(3,i,j,k)-adt*(uri(3,i,j,k)-uri0(3,i,j,k))
            v3= uri(4,i,j,k)-adt*(uri(4,i,j,k)-uri0(4,i,j,k))
            pr= uri(5,i,j,k)-adt*(uri(5,i,j,k)-uri0(5,i,j,k))
!            b1= uri(7,i,j,k)-adt*(uri(7,i,j,k)-uri0(7,i,j,k))
!            b2= uri(8,i,j,k)-adt*(uri(8,i,j,k)-uri0(8,i,j,k))
!            b3= uri(9,i,j,k)-adt*(uri(9,i,j,k)-uri0(9,i,j,k))
            b1=uri(7,i,j,k)
            b2=uri(8,i,j,k)
            b3=uri(9,i,j,k)
          
            uri(1,i,j,k)=de
            uri(2,i,j,k)=v1
            uri(3,i,j,k)=v2
            uri(4,i,j,k)=v3
            uri(5,i,j,k)=pr
            uri(7,i,j,k)=b1
            uri(8,i,j,k)=b2
            uri(9,i,j,k)=b3
          
        endif
      enddo
    enddo
  enddo
      
  if(rdamp .gt. 0.d0) then
    call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
  endif
!
  return
end subroutine damp4
!
!-----------------------------------------------------------------------
subroutine damp4a(uu,uri,uri0,x1,x3,is1,ie1,js1,je1,ks1,ke1)
!-----------------------------------------------------------------------
!    set damping zone in z-direction (for jet propagation simulation)
!
  use pram, only : imax, jmax, kmax, nv, metric, adamp, pi
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri0(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x3(kmax)
  real(8) :: zz, zz1, zz2, adt, de, v1, v2, v3, pr, b1, b2, b3, tmp1
!
  zz1=-0.95d0
  zz2=-0.025d0

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        if(adamp .gt. 0.d0) then
          if(metric.eq.3 .or. metric.eq.103 .or. metric.eq.203) then
            zz=x1(i)*cos(x3(k))
          else
            zz=x3(k)
          endif
            tmp1=(zz-zz1)/(zz2-zz1)
            adt=adamp*0.5*(cos(tmp1*pi)+1.0)

            de= uri(1,i,j,k)-adt*(uri(1,i,j,k)-uri0(1,i,j,k))
            v1= uri(2,i,j,k)-adt*(uri(2,i,j,k)-uri0(2,i,j,k))
            v2= uri(3,i,j,k)-adt*(uri(3,i,j,k)-uri0(3,i,j,k))
            v3= uri(4,i,j,k)-adt*(uri(4,i,j,k)-uri0(4,i,j,k))
            pr= uri(5,i,j,k)-adt*(uri(5,i,j,k)-uri0(5,i,j,k))
!            b1= uri(7,i,j,k)-adt*(uri(7,i,j,k)-uri0(7,i,j,k))
!            b2= uri(8,i,j,k)-adt*(uri(8,i,j,k)-uri0(8,i,j,k))
!            b3= uri(9,i,j,k)-adt*(uri(9,i,j,k)-uri0(9,i,j,k))
            b1=uri(7,i,j,k)
            b2=uri(8,i,j,k)
            b3=uri(9,i,j,k)
          
            uri(1,i,j,k)=de
            uri(2,i,j,k)=v1
            uri(3,i,j,k)=v2
            uri(4,i,j,k)=v3
            uri(5,i,j,k)=pr
            uri(7,i,j,k)=b1
            uri(8,i,j,k)=b2
            uri(9,i,j,k)=b3
          
        endif
      enddo
    enddo
  enddo
      
  if(adamp .gt. 0.d0) then      
    call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
  endif
  
  return
end subroutine damp4a
!
