!--------------------------------------------------------------------
subroutine kolspec(wkn,amdamax,amdamin,cl,pkn1d,pkn2d,pkn3d, &
                   totpkn1d,totpkn2d,totpkn3d,thetan,phin,thetan1,phin1, &
                   npe,myrank)
!--------------------------------------------------------------------
!      Subroutine for make Kolmogorov-like power-law spectrum
!      P(k) \propto 1/(1.0+kL**gamma) 
!
  use pram, only : iseed, nkmax, pi
  implicit none
  include 'mpif.h' ! for MPI

  integer :: n, iseed1
  integer :: myrank, npe, merr
     
  real(8) :: wkn(nkmax),dkn(nkmax),pkn1d(nkmax),pkn2d(nkmax),pkn3d(nkmax), &
             thetan(nkmax),phin(nkmax),thetan1(nkmax),phin1(nkmax)

  real(8) :: amdamax, amdamin, cl, ran1, ran0 
  real(8) :: totpkn1d, totpkn2d, totpkn3d
  real(8) :: wkmin, wkmax, tmp1a, tmp1b, tmp1c, tmp1d
  real(8) :: gam1d, gam2d, gam3d 
  real(8) :: temp1, temp2, temp3, temp4
!
!--------------------------------------------------------------------
!  Parameter
!
  iseed1=iseed+1000

  wkmin=2.0*pi/amdamax
  wkmax=2.0*pi/amdamin

!--------------------------------------------------------------------
!    Make logarithmic spacing of kn (wavenumber)
!
  tmp1a=log10(wkmin)
  tmp1b=(log10(wkmax)-log10(wkmin))/float(nkmax)

  wkn(1)=10.0**tmp1a

  do n=2,nkmax
    tmp1c=tmp1a+tmp1b*float(n-1)
    wkn(n)=10.0**tmp1c
  enddo

  do n=1,nkmax-1
    dkn(n)=wkn(n+1)-wkn(n)
  enddo
  
!  tmp1d=tmp1a+tmp1b*float(nkmax)
!  dkn(nkmax)=(10.0**tmp1d)-wkn(nkmax)
  dkn(nkmax)=dkn(nkmax-1)
!--------------------------------------------------------------------
!   Make Spectrum
!
  gam3d=11.d0/3.d0
  gam2d=8.d0/3.d0
  gam1d=5.d0/3.d0

  do n=1,nkmax
    pkn1d(n)=dkn(n)/(1.0+(wkn(n)*cl)**gam1d)
    pkn2d(n)=2.0*pi*dkn(n)*wkn(n)/(1.0+(wkn(n)*cl)**gam2d)
    pkn3d(n)=4.0*pi*dkn(n)*wkn(n)**2/(1.0+(wkn(n)*cl)**gam3d)
       
!    write(*,*) 'pkn1d=',pkn1d(n)
  enddo
      
  totpkn1d=0.d0
  totpkn2d=0.d0
  totpkn3d=0.d0

!$OMP PARALLEL DO PRIVATE(n) &
!$OMP&            REDUCTION(+:totpkn1d, totpkn2d, totpkn3d)

  do n=1,nkmax
    totpkn1d=totpkn1d+pkn1d(n)
    totpkn2d=totpkn2d+pkn2d(n)
    totpkn3d=totpkn3d+pkn3d(n)
  enddo

  if(myrank .eq. 0) then
    do n=1,nkmax
      call random_number(temp1)
      call random_number(temp2)
      call random_number(temp3)
      call random_number(temp4)
      thetan(n)=2.0*pi*temp1
      phin(n)=2.0*pi*temp2
      thetan1(n)=2.0*pi*temp3
      phin1(n)=2.0*pi*temp4

!      thetan(n)=2.0*pi*ran0(iseed+n)
!      phin(n)=2.0*pi*ran0(iseed+n)
!      thetan1(n)=2.0*pi*ran0(iseed1+n)
!      phin1(n)=2.0*pi*ran0(iseed1+n)
    enddo
  endif

  call mpi_barrier(mpi_comm_world,merr)

  call mpi_bcast(thetan,nkmax,mpi_double_precision,0,mpi_comm_world,merr)
  call mpi_bcast(phin,nkmax,mpi_double_precision,0,mpi_comm_world,merr)
  call mpi_bcast(thetan1,nkmax,mpi_double_precision,0,mpi_comm_world,merr)
  call mpi_bcast(phin1,nkmax,mpi_double_precision,0,mpi_comm_world,merr) 

  return
end subroutine kolspec
!
