!-----------------------------------------------------------------------
subroutine recov(uu,uri,x1,x2,x3,nm1,is1,ie1,js1,je1,ks1,ke1)
!-----------------------------------------------------------------------
!     Calculation of primitive variables from conserved variables
!     
  use pram, only : imax, jmax, kmax, nv, iwvec, iter
  implicit none
!
  integer :: nm1, is1, ie1, js1, je1, ks1, ke1
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
     
  real(8) :: x1(imax),x2(jmax),x3(kmax)
!
  if( iwvec.eq.6 ) then
    call recov1d(uu,uri,x1,x2,x3,nm1,is1,ie1,js1,je1,ks1,ke1)
  elseif( iwvec.eq.7 ) then
    call recov2d(uu,uri,x1,x2,x3,nm1,is1,ie1,js1,je1,ks1,ke1)
  endif
!
  return
end subroutine recov
!
!--------------------------------------------------------------------
subroutine calconv(uu,uri,x1,nm1,is1,ie1,js1,je1,ks1,ke1, &
                   myranki,myrankj,myrankk)
!--------------------------------------------------------------------
!
  use pram, only : imax, jmax, kmax, nv, iprocs, jprocs, kprocs, &
                   gam, c0, ieos, iflag
  implicit none

  integer :: i, j, k, n, nm1, n2
  integer :: is1, ie1, js1, je1, ks1, ke1, myranki, myrankj, myrankk 
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax)

  real(8) :: dei1, vxi1, vyi1, vzi1, pri1, bxi1, byi1, bzi1, &
             vti1, vbi1, bti1, gfli1, rohi1, roei1, denri1, eemi1, & 
             dei2, vxi2, vyi2, vzi2, pri2, bxi2, byi2, bzi2, &
             vti2, vbi2, bti2, gfli2, rohi2, roei2, denri2, eemi2, &
             dej1, vxj1, vyj1, vzj1, prj1, bxj1, byj1, bzj1, &
             vtj1, vbj1, btj1, gflj1, rohj1, roej1, denrj1, eemj1, & 
             dej2, vxj2, vyj2, vzj2, prj2, bxj2, byj2, bzj2, &
             vtj2, vbj2, btj2, gflj2, rohj2, roej2, denrj2, eemj2, &
             dek1, vxk1, vyk1, vzk1, prk1, bxk1, byk1, bzk1, &
             vtk1, vbk1, btk1, gflk1, rohk1, roek1, denrk1, eemk1, & 
             dek2, vxk2, vyk2, vzk2, prk2, bxk2, byk2, bzk2, &
             vtk2, vbk2, btk2, gflk2, rohk2, roek2, denrk2, eemk2  
!
!!!!
  do k=ks1+nm1,ke1-nm1
    do i=is1+nm1,ie1-nm1
      do n=1,nm1

        if(myrankj .eq. 0 .or. jprocs .eq. 1) then

          dej1=uri(1,i,n,k)
          vxj1=uri(2,i,n,k)
          vyj1=uri(3,i,n,k)
          vzj1=uri(4,i,n,k)
          prj1=uri(5,i,n,k)
          bxj1=uri(7,i,n,k)
          byj1=uri(8,i,n,k)
          bzj1=uri(9,i,n,k)
         
          vtj1=(vxj1**2+vyj1**2+vzj1**2)/c0**2
          vbj1=(vxj1*bxj1+vyj1*byj1+vzj1*bzj1)/c0**2
          btj1=(bxj1**2+byj1**2+bzj1**2)
          gflj1=1.0/sqrt(1.0-vtj1)

          if(ieos .eq. 0) then
            rohj1=dej1+(gam/(gam-1.0))*prj1
          elseif(ieos .eq. 1) then
            rohj1=(5./2.)*prj1+sqrt((9./4.)*prj1**2+dej1**2)
          elseif(ieos .eq. 2) then
            roej1=(3./2.)*(prj1+((3.*prj1**2) &
                  /(2.0*dej1+sqrt(2.*prj1**2+4.*dej1**2)) ))
            rohj1=dej1+roej1+prj1
          endif
          
          denrj1=gflj1**2*rohj1
          eemj1=0.5*(btj1+vtj1*btj1-vbj1)
!
          uu(1,i,n,k)=gflj1*dej1
          uu(2,i,n,k)=(denrj1+btj1)*vxj1-vbj1*bxj1
          uu(3,i,n,k)=(denrj1+btj1)*vyj1-vbj1*byj1
          uu(4,i,n,k)=(denrj1+btj1)*vzj1-vbj1*bzj1
          uu(5,i,n,k)=denrj1-prj1+eemj1-gflj1*dej1
      
          if( iflag(6).le.1 ) then
            uu(6,i,n,k)=gflj1*dej1*x1(i)
          elseif( iflag(6).le.3 ) then
            uu(6,i,n,k)=gflj1*prj1/dej1**(gam-1.0)
          elseif( iflag(6).eq.4 ) then
            uu(6,i,n,k)=gflj1*dej1*log(prj1/dej1**gam)
          endif
!
          uu(7,i,n,k)=bxj1
          uu(8,i,n,k)=byj1
          uu(9,i,n,k)=bzj1
        endif
!!!!
        if(myrankj .eq. jprocs-1 .or. jprocs .eq. 1) then
          n2=n-1

          dej2=uri(1,i,jmax-n2,k)
          vxj2=uri(2,i,jmax-n2,k)
          vyj2=uri(3,i,jmax-n2,k)
          vzj2=uri(4,i,jmax-n2,k)
          prj2=uri(5,i,jmax-n2,k)
          bxj2=uri(7,i,jmax-n2,k)
          byj2=uri(8,i,jmax-n2,k)
          bzj2=uri(9,i,jmax-n2,k)
         
          vtj2=(vxj2**2+vyj2**2+vzj2**2)/c0**2
          vbj2=(vxj2*bxj2+vyj2*byj2+vzj2*bzj2)/c0**2
          btj2=(bxj2**2+byj2**2+bzj2**2)
          gflj2=1.0/sqrt(1.0-vtj2)

          if(ieos .eq. 0) then
            rohj2=dej2+(gam/(gam-1.0))*prj2
          elseif(ieos .eq. 1) then
            rohj2=(5./2.)*prj2+sqrt((9./4.)*prj2**2+dej2**2)
          elseif(ieos .eq. 2) then
            roej2=(3./2.)*(prj2+((3.*prj2**2) &
                  /(2.0*dej2+sqrt(2.*prj2**2+4.*dej2**2)) ))
            rohj2=dej2+roej2+prj2
          endif
          
          denrj2=gflj2**2*rohj2
          eemj2=0.5*(btj2+vtj2*btj2-vbj2)
!
          uu(1,i,jmax-n2,k)=gflj2*dej2
          uu(2,i,jmax-n2,k)=(denrj2+btj2)*vxj2-vbj2*bxj2
          uu(3,i,jmax-n2,k)=(denrj2+btj2)*vyj2-vbj2*byj2
          uu(4,i,jmax-n2,k)=(denrj2+btj2)*vzj2-vbj2*bzj2
          uu(5,i,jmax-n2,k)=denrj2-prj2+eemj2-gflj2*dej2
!
          if( iflag(6).le.1 ) then
            uu(6,i,jmax-n2,k)=gflj2*dej2*x1(i)
          elseif( iflag(6).le.3 ) then
            uu(6,i,jmax-n2,k)=gflj2*prj2/dej2**(gam-1.0)
          elseif( iflag(6).eq.4 ) then
            uu(6,i,jmax-n2,k)=gflj2*dej2*log(prj2/dej2**gam)
          endif
!
          uu(7,i,jmax-n2,k)=bxj2
          uu(8,i,jmax-n2,k)=byj2
          uu(9,i,jmax-n2,k)=bzj2
!
        endif
      enddo
    enddo
  enddo
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do n=1,nm1
        
        if(myranki .eq. 0 .or. iprocs .eq. 1) then
          dei1=uri(1,n,j,k)
          vxi1=uri(2,n,j,k)
          vyi1=uri(3,n,j,k)
          vzi1=uri(4,n,j,k)
          pri1=uri(5,n,j,k)
          bxi1=uri(7,n,j,k)
          byi1=uri(8,n,j,k)
          bzi1=uri(9,n,j,k)
         
          vti1=(vxi1**2+vyi1**2+vzi1**2)/c0**2
          vbi1=(vxi1*bxi1+vyi1*byi1+vzi1*bzi1)/c0**2
          bti1=(bxi1**2+byi1**2+bzi1**2)
          gfli1=1.0/sqrt(1.0-vti1)

          if(ieos .eq. 0) then
            rohi1=dei1+(gam/(gam-1.0))*pri1
          elseif(ieos .eq. 1) then
            rohi1=(5./2.)*pri1+sqrt((9./4.)*pri1**2+dei1**2)
          elseif(ieos .eq. 2) then
            roei1=(3./2.)*(pri1+((3.*pri1**2) &
                  /(2.0*dei1+sqrt(2.*pri1**2+4.*dei1**2)) ))
            rohi1=dei1+roei1+pri1
          endif
          
          denri1=gfli1**2*rohi1
          eemi1=0.5*(bti1+vti1*bti1-vbi1)
!  
          uu(1,n,j,k)=gfli1*dei1
          uu(2,n,j,k)=(denri1+bti1)*vxi1-vbi1*bxi1
          uu(3,n,j,k)=(denri1+bti1)*vyi1-vbi1*byi1
          uu(4,n,j,k)=(denri1+bti1)*vzi1-vbi1*bzi1
          uu(5,n,j,k)=denri1-pri1+eemi1-gfli1*dei1
!
          if( iflag(6).le.1 ) then
            uu(6,n,j,k)=gfli1*dei1*x1(n)
          elseif( iflag(6).le.3 ) then
           uu(6,n,j,k)=gfli1*pri1/dei1**(gam-1.0)
          elseif( iflag(6).eq.4 ) then
            uu(6,n,j,k)=gfli1*dei1*log(pri1/dei1**gam)
          endif
!
          uu(7,n,j,k)=bxi1
          uu(8,n,j,k)=byi1
          uu(9,n,j,k)=bzi1
        endif
!!!!
        if(myranki .eq. iprocs-1 .or. iprocs .eq. 1) then
          n2=n-1
!
          dei2=uri(1,imax-n2,j,k)
          vxi2=uri(2,imax-n2,j,k)
          vyi2=uri(3,imax-n2,j,k)
          vzi2=uri(4,imax-n2,j,k)
          pri2=uri(5,imax-n2,j,k)
          bxi2=uri(7,imax-n2,j,k)
          byi2=uri(8,imax-n2,j,k)
          bzi2=uri(9,imax-n2,j,k)
         
          vti2=(vxi2**2+vyi2**2+vzi2**2)/c0**2
          vbi2=(vxi2*bxi2+vyi2*byi2+vzi2*bzi2)/c0**2
          bti2=(bxi2**2+byi2**2+bzi2**2)
          gfli2=1.0/sqrt(1.0-vti2)

          if(ieos .eq. 0) then
            rohi2=dei2+(gam/(gam-1.0))*pri2
          elseif(ieos .eq. 1) then
            rohi2=(5./2.)*pri2+sqrt((9./4.)*pri2**2+dei2**2)
          elseif(ieos .eq. 2) then
            roei2=(3./2.)*(pri2+((3.*pri2**2) &
                  /(2.0*dei2+sqrt(2.*pri2**2+4.*dei2**2)) ))
            rohi2=dei2+roei2+pri2
          endif
          
          denri2=gfli2**2*rohi2
          eemi2=0.5*(bti2+vti2*bti2-vbi2)
!
          uu(1,imax-n2,j,k)=gfli2*dei2
          uu(2,imax-n2,j,k)=(denri2+bti2)*vxi2-vbi2*bxi2
          uu(3,imax-n2,j,k)=(denri2+bti2)*vyi2-vbi2*byi2
          uu(4,imax-n2,j,k)=(denri2+bti2)*vzi2-vbi2*bzi2
          uu(5,imax-n2,j,k)=denri2-pri2+eemi2-gfli2*dei2
!
          if( iflag(6).le.1 ) then
            uu(6,imax-n2,j,k)=gfli2*dei2*x1(imax-n2)
          elseif( iflag(6).le.3 ) then
            uu(6,imax-n2,j,k)=gfli2*pri2/dei2**(gam-1.0)
          elseif( iflag(6).eq.4 ) then
            uu(6,imax-n2,j,k)=gfli2*dei2*log(pri2/dei2**gam)
          endif
!
          uu(7,imax-n2,j,k)=bxi2
          uu(8,imax-n2,j,k)=byi2
          uu(9,imax-n2,j,k)=bzi2

        endif
      enddo
    enddo
  enddo
!
  do j=js1+nm1,je1-nm1
    do i=is1+nm1,ie1-nm1
      do n=1,nm1

        if(myrankk .eq. 0 .or. kprocs .eq. 1) then
          dek1=uri(1,i,j,n)
          vxk1=uri(2,i,j,n)
          vyk1=uri(3,i,j,n)
          vzk1=uri(4,i,j,n)
          prk1=uri(5,i,j,n)
          bxk1=uri(7,i,j,n)
          byk1=uri(8,i,j,n)
          bzk1=uri(9,i,j,n)
         
          vtk1=(vxk1**2+vyk1**2+vzk1**2)/c0**2
          vbk1=(vxk1*bxk1+vyk1*byk1+vzk1*bzk1)/c0**2
          btk1=(bxk1**2+byk1**2+bzk1**2)
          gflk1=1.0/sqrt(1.0-vtk1)

          if(ieos .eq. 0) then
            rohk1=dek1+(gam/(gam-1.0))*prk1
          elseif(ieos .eq. 1) then
            rohk1=(5./2.)*prk1+sqrt((9./4.)*prk1**2+dek1**2)
          elseif(ieos .eq. 2) then
            roek1=(3./2.)*(prk1+((3.*prk1**2) &
                  /(2.0*dek1+sqrt(2.*prk1**2+4.*dek1**2)) ))
            rohk1=dek1+roek1+prk1
          endif
          
          denrk1=gflk1**2*rohk1
          eemk1=0.5*(btk1+vtk1*btk1-vbk1)
!
          uu(1,i,j,n)=gflk1*dek1
          uu(2,i,j,n)=(denrk1+btk1)*vxk1-vbk1*bxk1
          uu(3,i,j,n)=(denrk1+btk1)*vyk1-vbk1*byk1
          uu(4,i,j,n)=(denrk1+btk1)*vzk1-vbk1*bzk1
          uu(5,i,j,n)=denrk1-prk1+eemk1-gflk1*dek1
!
          if( iflag(6).le.1 ) then
            uu(6,i,j,n)=gflk1*dek1*x1(i)
          elseif( iflag(6).le.3 ) then
            uu(6,i,j,n)=gflk1*prk1/dek1**(gam-1.0)
          elseif( iflag(6).eq.4 ) then
            uu(6,i,j,n)=gflk1*dek1*log(prk1/dek1**gam)
          endif
!
          uu(7,i,j,n)=bxk1
          uu(8,i,j,n)=byk1
          uu(9,i,j,n)=bzk1
        endif
!!!!
        if(myrankk .eq. kprocs-1 .or. kprocs .eq. 1) then
          n2=n-1
 
          dek2=uri(1,i,j,kmax-n2)
          vxk2=uri(2,i,j,kmax-n2)
          vyk2=uri(3,i,j,kmax-n2)
          vzk2=uri(4,i,j,kmax-n2)
          prk2=uri(5,i,j,kmax-n2)
          bxk2=uri(7,i,j,kmax-n2)
          byk2=uri(8,i,j,kmax-n2)
          bzk2=uri(9,i,j,kmax-n2)
         
          vtk2=(vxk2**2+vyk2**2+vzk2**2)/c0**2
          vbk2=(vxk2*bxk2+vyk2*byk2+vzk2*bzk2)/c0**2
          btk2=(bxk2**2+byk2**2+bzk2**2)
          gflk2=1.0/sqrt(1.0-vtk2)

          if(ieos .eq. 0) then
            rohk2=dek2+(gam/(gam-1.0))*prk2
          elseif(ieos .eq. 1) then
           rohk2=(5./2.)*prk2+sqrt((9./4.)*prk2**2+dek2**2)
          elseif(ieos .eq. 2) then
            roek2=(3./2.)*(prk2+((3.*prk2**2) &
                  /(2.0*dek2+sqrt(2.*prk2**2+4.*dek2**2)) ))
            rohk2=dek2+roek2+prk2
          endif
          
          denrk2=gflk2**2*rohk2
          eemk2=0.5*(btk2+vtk2*btk2-vbk2)
!
          uu(1,i,j,kmax-n2)=gflk2*dek2
          uu(2,i,j,kmax-n2)=(denrk2+btk2)*vxk2-vbk2*bxk2
          uu(3,i,j,kmax-n2)=(denrk2+btk2)*vyk2-vbk2*byk2
          uu(4,i,j,kmax-n2)=(denrk2+btk2)*vzk2-vbk2*bzk2
          uu(5,i,j,kmax-n2)=denrk2-prk2+eemk2-gflk2*dek2
!
          if( iflag(6).le.1 ) then
            uu(6,i,j,kmax-n2)=gflk2*dek2*x1(i)
          elseif( iflag(6).le.3 ) then
            uu(6,i,j,kmax-n2)=gflk2*prk2/dek2**(gam-1.0)
          elseif( iflag(6).eq.4 ) then
            uu(6,i,j,kmax-n2)=gflk2*dek2*log(prk2/dek2**gam)
          endif
!
          uu(7,i,j,kmax-n2)=bxk2
          uu(8,i,j,kmax-n2)=byk2
          uu(9,i,j,kmax-n2)=bzk2        
!
        endif
      enddo
    enddo
  enddo
!
  return
end subroutine calconv
!
!---------------------------------------------------------------------@
subroutine recov1d(uu,uri,x1,x2,x3,nm1,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0, iter
  implicit none
!
  integer :: i, j, k, nnn, nm1, is1, ie1, js1, je1, ks1, ke1
  integer :: merr

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x2(jmax), x3(kmax)
      
  real(8), allocatable :: dro(:,:,:), ee(:,:,:), & 
           tx(:,:,:), ty(:,:,:), tz(:,:,:)
     
  real(8), allocatable :: ro(:,:,:), pp(:,:,:), &
           vx(:,:,:), vy(:,:,:), vz(:,:,:), vt(:,:,:)
     
  real(8), allocatable :: bx(:,:,:), by(:,:,:), bz(:,:,:), bsq(:,:,:)
      
  real(8), allocatable :: ro1(:,:,:), pp1(:,:,:), &
           vx1(:,:,:), vy1(:,:,:), vz1(:,:,:)
     
  real(8), allocatable :: psq(:,:,:), pb(:,:,:), pbsq(:,:,:), wg(:,:,:)
     
  real(8), allocatable :: del(:,:,:)
      
  integer, allocatable :: irecov(:,:,:)
      
  real(8) :: safty, gam1, gam2, vt2, bsqm, dv 
  integer :: igue, iflg
  real(8) :: gf, wg1, wsq, xsq, ee1, vt1, & 
             tmp1a, tmp1b, tmp1c, tmp1d, wgp, wgm, tmp2, tmp3a, tmp3b, &
             delta, deltaend, df, f, xxn, yyn, xo, yo, &
             w2, w3, f1, g1, dfx, dfy, dgx, dgy, det, dx, dy 
!
  allocate( dro(is1:ie1,js1:je1,ks1:ke1), ee(is1:ie1,js1:je1,ks1:ke1), &
            tx(is1:ie1,js1:je1,ks1:ke1), ty(is1:ie1,js1:je1,ks1:ke1), & 
            tz(is1:ie1,js1:je1,ks1:ke1), &
            ro(is1:ie1,js1:je1,ks1:ke1), pp(is1:ie1,js1:je1,ks1:ke1), &
            vx(is1:ie1,js1:je1,ks1:ke1), vy(is1:ie1,js1:je1,ks1:ke1), &
            vz(is1:ie1,js1:je1,ks1:ke1), vt(is1:ie1,js1:je1,ks1:ke1), &
            bx(is1:ie1,js1:je1,ks1:ke1), by(is1:ie1,js1:je1,ks1:ke1), &
            bz(is1:ie1,js1:je1,ks1:ke1), bsq(is1:ie1,js1:je1,ks1:ke1), &
            ro1(is1:ie1,js1:je1,ks1:ke1), pp1(is1:ie1,js1:je1,ks1:ke1), &
            vx1(is1:ie1,js1:je1,ks1:ke1), vy1(is1:ie1,js1:je1,ks1:ke1), &
            vz1(is1:ie1,js1:je1,ks1:ke1), &
            psq(is1:ie1,js1:je1,ks1:ke1), pb(is1:ie1,js1:je1,ks1:ke1), & 
            pbsq(is1:ie1,js1:je1,ks1:ke1), wg(is1:ie1,js1:je1,ks1:ke1), &
            del(is1:ie1,js1:je1,ks1:ke1), irecov(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr )
!   
!--- define variable of safe number ----
      safty = 1.0d-10
      
      igue=1
      
      gam1=gam/(gam-1.0)
      gam2=1.0/gam1
      
      vt2=0.d0
      bsqm=0.d0
      dv=1.0d-5
      
!=====================================================================@
!
! ----  Calculation of variables ---
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        
        dro(i,j,k)=uu(1,i,j,k)
        tx(i,j,k)=uu(2,i,j,k)
        ty(i,j,k)=uu(3,i,j,k)
        tz(i,j,k)=uu(4,i,j,k)
        ee(i,j,k)=uu(5,i,j,k)
        bx(i,j,k)=uu(7,i,j,k)
        by(i,j,k)=uu(8,i,j,k)
        bz(i,j,k)=uu(9,i,j,k)
         
        ro(i,j,k)=uri(1,i,j,k)
        vx(i,j,k)=uri(2,i,j,k)
        vy(i,j,k)=uri(3,i,j,k)
        vz(i,j,k)=uri(4,i,j,k)
        pp(i,j,k)=uri(5,i,j,k)
        
        ro1(i,j,k)=uri(1,i,j,k)
        vx1(i,j,k)=uri(2,i,j,k)
        vy1(i,j,k)=uri(3,i,j,k)
        vz1(i,j,k)=uri(4,i,j,k)
        pp1(i,j,k)=uri(5,i,j,k)
         
        vt(i,j,k)=vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2
         
        bsq(i,j,k)=bx(i,j,k)**2+by(i,j,k)**2+bz(i,j,k)**2
         
        psq(i,j,k)=tx(i,j,k)**2+ty(i,j,k)**2+tz(i,j,k)**2
         
        pb(i,j,k)=tx(i,j,k)*bx(i,j,k)+ty(i,j,k)*by(i,j,k)+tz(i,j,k)*bz(i,j,k)
        pbsq(i,j,k)=pb(i,j,k)**2
         
        vt2=max(vt(i,j,k),vt2)
        bsqm=max(bsq(i,j,k),bsqm)

      enddo
    enddo
  enddo
!
! ----  Calculation of initial guess ---
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        
        tmp2=ro(i,j,k)+(gam/(gam-1.0))*pp(i,j,k)
          
        if(vt(i,j,k) .lt. 0.8d0 .and. bsq(i,j,k)/tmp2 .lt. 1.d0) then
         
          gf=1.0/sqrt(1.0-vt(i,j,k)/c0**2)
          ro(i,j,k)=dro(i,j,k)/gf
          wg1=abs(gf**2*(ro(i,j,k)+gam1*pp(i,j,k)))
          wg(i,j,k)=wg1
           
          wsq=wg1**2
          xsq=(bsq(i,j,k)+wg1)**2
          vt(i,j,k)=abs((wsq*psq(i,j,k)+pbsq(i,j,k) &
                   *(bsq(i,j,k)+2.0*wg1))/(wsq*xsq))
          
        else
          
          ee1=ee(i,j,k)+dro(i,j,k)
          
          if(igue .eq. 1) then
            vt1=1.d0
          else
            vt1=vt(i,j,k)
          endif
         
          tmp1a=4.0-vt1
          tmp1b=4.0*(bsq(i,j,k)-ee1)
          tmp1c=psq(i,j,k)+bsq(i,j,k)**2-2.0*bsq(i,j,k)*ee1
          tmp1d=(tmp1b**2)-4.0*tmp1a*tmp1c
          wgp=(-tmp1b+sqrt(tmp1d))/2.0*tmp1a
          wgm=(-tmp1b-sqrt(tmp1d))/2.0*tmp1a
         
          if(wgp .gt. 0.d0) then
            wg1=wgp
          elseif(wgm .ge. 0.d0) then
            wg1=wgm
          endif
           
          wg(i,j,k)=wg1
          wsq=wg1*wg1
          xsq=(bsq(i,j,k)+wg1)**2
          vt(i,j,k)=abs((wsq*psq(i,j,k)+pbsq(i,j,k) &
                    *(bsq(i,j,k)+2.0*wg1))/(wsq*xsq))
          
        endif
          
      enddo
    enddo
  enddo
      
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        if(vt(i,j,k) .gt. 1.d0) then
          write(6,*) 'vt > 1.0' 
          vt(i,j,k)=1.0-dv
        endif
      enddo
    enddo
  enddo
     
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        tmp3a=wg(i,j,k)**3*(wg(i,j,k)+2.0*bsq(i,j,k)) &
             -pbsq(i,j,k)*(2.0*wg(i,j,k)+bsq(i,j,k))
        tmp3b=wg(i,j,k)**2*(psq(i,j,k)-bsq(i,j,k)**2)
          
        if(tmp3a .le. tmp3b) then
           
          iflg=1
          wg1=wg(i,j,k)
           
          do nnn=1,iter
            if(tmp3a .le. tmp3b) then
              wg1= abs(1.1*wg1)
              tmp3a=wg1**3*(wg1+2.0*bsq(i,j,k)) &
                   -pbsq(i,j,k)*(2.0*wg1+bsq(i,j,k))
              tmp3b=wg1**2*(psq(i,j,k)-bsq(i,j,k)**2)
            endif
          enddo
          
        endif
          
!        if(iflg .eq. 1) then
!          write(6,*) 'tmp3a < tmp3b'
!          wg(i,j,k)=wg1
!        endif
          
      enddo
    enddo
  enddo
          
!=====================================================================@
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1

!--- set parameter of delta and deltaend ----

        delta=1.d0
        deltaend = 0.001d0
        df=1.d0
        f=1.d0
        irecov(i,j,k)=0

        wg1=wg(i,j,k)
        vt2=vt(i,j,k)
        xxn=wg(i,j,k)
        yyn=vt(i,j,k)
        xo=wg(i,j,k)
        yo=vt(i,j,k)

!--- Newton-Raphson routine ----
         
        do nnn=1,iter

          if(delta .ge. deltaend .and. irecov(i,j,k) .eq. 0) then
           
            if(nnn .eq. iter) then
              irecov(i,j,k)=1

            else
              wg1=xxn
              vt2=yyn
            
              wsq=wg1*wg1
              w3=wsq*wg1
          
              f1=psq(i,j,k)-vt2*(wg1+bsq(i,j,k))**2 &
                +(pbsq(i,j,k)*(bsq(i,j,k)+2.0*wg1))/wsq
              g1=ee(i,j,k)-0.5*bsq(i,j,k)*(1.0+vt2) &
                +(0.5*pbsq(i,j,k)/wsq)-wg1+gam2*((1.0-vt2)*wg1 &
                -dro(i,j,k)*sqrt(1.0-vt2))+dro(i,j,k)
          
              dfx=-2.0*(vt2+(pbsq(i,j,k)/w3))*(wg1+bsq(i,j,k))
              dfy=-1.0*((wg1+bsq(i,j,k))**2)
              dgx=-1.0+gam2*(1.0-vt2)-(pbsq(i,j,k)/w3)
              dgy=-0.5*bsq(i,j,k)-gam2*wg1 &
                 +gam2*(dro(i,j,k)/(2.0*sqrt(1.0-vt2)))
 
              det=dfx*dgy-dfy*dgx

              dx=(-dgy*f1+dfy*g1)/det
              dy=(dgx*f1-dfx*g1)/det

              df=-f1*f1-g1*g1
              f=-0.5*df
            
              delta=abs((dx+dy)/2.0)
            
              xo=wg1
              yo=vt2
            
              xxn=wg1+dx
              yyn=vt2+dy
!
              if(xxn .lt. 0.d0) then
                irecov(i,j,k)=2
              endif
             
              if(yyn .gt. 1.d0) then
                dv=1.0d-5
                yyn=1.0-dv
              endif
             
              if(yyn .lt. 0.d0) then
                yyn=abs(yyn)
              endif
             
            endif
          endif

        enddo

        if(irecov(i,j,k) .eq. 0) then
          
          gf=1.0/sqrt(1.0-yyn/c0**2)
          ro(i,j,k)=dro(i,j,k)/gf
          
          w2=xxn/gf**2
          pp(i,j,k)=(gam-1.0)*(w2-ro(i,j,k))/gam
          
          vx(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                   *(tx(i,j,k)+pb(i,j,k)*bx(i,j,k)/xxn)
          vy(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                   *(ty(i,j,k)+pb(i,j,k)*by(i,j,k)/xxn)
          vz(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                   *(tz(i,j,k)+pb(i,j,k)*bz(i,j,k)/xxn)
          
        endif
                 
        wg(i,j,k)=xxn
        vt(i,j,k)=yyn
        del(i,j,k)=delta

      enddo
    enddo
  enddo

!---------------------------------------------------------------------

  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
         
        if(irecov(i,j,k) .eq. 1) then
          write(6,*) ' >> Not convergence in recov1d' &
                    ,' at i, j, k:',i, j, k
          write(6,*) ' >> delta =', del(i,j,k) &
                    ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
         
        elseif(irecov(i,j,k) .eq. 2) then
          write(6,*) ' >> wg  < 0 in recov1d' &
                    ,' at i, j, k:',i, j, k
          write(6,*) ' >> wg', wg(i,j,k) &
                    ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
         
        elseif(irecov(i,j,k) .eq. 0) then
          vt1=sqrt(vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2)
          
          if(vt1 .gt. 1.0) then
            write(6,*) ' >> vt  > 1.0 in recov1d' &
                      ,' at i, j, k:',i, j, k
            write(6,*) ' >> vt', vt1 &
                      ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
            irecov(i,j,k)=1
          endif

          if(vt1 .lt. 0.0) then
            write(6,*) ' >> vt  < 0.0 in recov1d' &
                      ,' at i, j, k:',i, j, k
           write(6,*) ' >> vt', vt1 &
                     ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
           irecov(i,j,k)=1
          endif
         
        endif
!
      enddo
    enddo
  enddo
!
!---------------------------------------------------------------------@
!   Set Primitive variables
!---------------------------------------------------------------------@
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
!
        if(irecov(i,j,k) .eq. 0) then
         
          uri(1,i,j,k)=ro(i,j,k)
          uri(2,i,j,k)=vx(i,j,k)
          uri(3,i,j,k)=vy(i,j,k)
          uri(4,i,j,k)=vz(i,j,k)
          uri(5,i,j,k)=pp(i,j,k)
          uri(6,i,j,k)=uu(6,i,j,k)/dro(i,j,k)
          uri(7,i,j,k)=bx(i,j,k)
          uri(8,i,j,k)=by(i,j,k)
          uri(9,i,j,k)=bz(i,j,k)
        
        else
         
          uri(1,i,j,k)=ro1(i,j,k)
          uri(2,i,j,k)=vx1(i,j,k)
          uri(3,i,j,k)=vy1(i,j,k)
          uri(4,i,j,k)=vz1(i,j,k)
          uri(5,i,j,k)=pp1(i,j,k)
          uri(6,i,j,k)=uu(6,i,j,k)/dro(i,j,k)
          uri(7,i,j,k)=bx(i,j,k)
          uri(8,i,j,k)=by(i,j,k)
          uri(9,i,j,k)=bz(i,j,k)
         
        endif
      enddo
    enddo
  enddo
!
!=====================================================================@
!
  deallocate( dro, ee, tx, ty, tz, ro, pp, vx, vy, vz, vt, &
              bx, by, bz, bsq, ro1, pp1, vx1, vy1, vz1, &
              psq, pb, pbsq, wg, del, irecov, stat=merr )
!
  return
end subroutine recov1d
!
!---------------------------------------------------------------------@
subroutine recov1e(uu,uri,x1,x2,x3,nm1,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0, iter, ieos
  implicit none
!
  integer :: i, j, k, nnn, nm1, is1, ie1, js1, je1, ks1, ke1
  integer :: merr

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x2(jmax), x3(kmax)

  real(8), allocatable :: dro(:,:,:), ee(:,:,:), & 
           tx(:,:,:), ty(:,:,:), tz(:,:,:)
     
  real(8), allocatable :: ro(:,:,:), pp(:,:,:), &
           vx(:,:,:), vy(:,:,:), vz(:,:,:), vt(:,:,:)
     
  real(8), allocatable :: bx(:,:,:), by(:,:,:), bz(:,:,:), bsq(:,:,:)
      
  real(8), allocatable :: ro1(:,:,:), pp1(:,:,:), &
           vx1(:,:,:), vy1(:,:,:), vz1(:,:,:)
     
  real(8), allocatable :: psq(:,:,:), pb(:,:,:), pbsq(:,:,:), wg(:,:,:)
     
  real(8), allocatable :: del(:,:,:)
      
  integer, allocatable :: irecov(:,:,:)

  real(8) :: safty, gam1, gam2, vt2, bsqm, dv 
  integer :: igue, iflg
  real(8) :: gf, wg1, wsq, xsq, ee1, vt1, & 
             tmp1a, tmp1b, tmp1c, tmp1d, wgp, wgm, roh, roe, &
             tmp3a, tmp3b, delta, deltaend, df, f, xxn, yyn, xo, yo, &
             w2, w3, f1, g1, dfx, dfy, dgx, dgy, det, dx, dy, &
             xi1, tmp2c, tmp2d, dpdxi, dpdro, t1, tmp3, dvdw, dxidw, & 
             drodw, dpdw, tmp3c, tmp3d, dwdv2, dxidv2, drodv2, dpdv2 
!  
  allocate( dro(is1:ie1,js1:je1,ks1:ke1), ee(is1:ie1,js1:je1,ks1:ke1), &
            tx(is1:ie1,js1:je1,ks1:ke1), ty(is1:ie1,js1:je1,ks1:ke1), & 
            tz(is1:ie1,js1:je1,ks1:ke1), &
            ro(is1:ie1,js1:je1,ks1:ke1), pp(is1:ie1,js1:je1,ks1:ke1), &
            vx(is1:ie1,js1:je1,ks1:ke1), vy(is1:ie1,js1:je1,ks1:ke1), &
            vz(is1:ie1,js1:je1,ks1:ke1), vt(is1:ie1,js1:je1,ks1:ke1), &
            bx(is1:ie1,js1:je1,ks1:ke1), by(is1:ie1,js1:je1,ks1:ke1), &
            bz(is1:ie1,js1:je1,ks1:ke1), bsq(is1:ie1,js1:je1,ks1:ke1), &
            ro1(is1:ie1,js1:je1,ks1:ke1), pp1(is1:ie1,js1:je1,ks1:ke1), &
            vx1(is1:ie1,js1:je1,ks1:ke1), vy1(is1:ie1,js1:je1,ks1:ke1), &
            vz1(is1:ie1,js1:je1,ks1:ke1), &
            psq(is1:ie1,js1:je1,ks1:ke1), pb(is1:ie1,js1:je1,ks1:ke1), & 
            pbsq(is1:ie1,js1:je1,ks1:ke1), wg(is1:ie1,js1:je1,ks1:ke1), &
            del(is1:ie1,js1:je1,ks1:ke1), irecov(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr )
!     
!--- define variable of safe number ----
  safty = 1.0d-10
      
  igue=1
      
  gam1=gam/(gam-1.0)
  gam2=1.0/gam1
      
  vt2=0.d0
  bsqm=0.d0
  dv=1.0d-5
      
!=====================================================================@
!
! ----  Calculation of variables ---
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        
        dro(i,j,k)=uu(1,i,j,k)
        tx(i,j,k)=uu(2,i,j,k)
        ty(i,j,k)=uu(3,i,j,k)
        tz(i,j,k)=uu(4,i,j,k)
        ee(i,j,k)=uu(5,i,j,k)
        bx(i,j,k)=uu(7,i,j,k)
        by(i,j,k)=uu(8,i,j,k)
        bz(i,j,k)=uu(9,i,j,k)
         
        ro(i,j,k)=uri(1,i,j,k)
        vx(i,j,k)=uri(2,i,j,k)
        vy(i,j,k)=uri(3,i,j,k)
        vz(i,j,k)=uri(4,i,j,k)
        pp(i,j,k)=uri(5,i,j,k)
         
        ro1(i,j,k)=uri(1,i,j,k)
        vx1(i,j,k)=uri(2,i,j,k)
        vy1(i,j,k)=uri(3,i,j,k)
        vz1(i,j,k)=uri(4,i,j,k)
        pp1(i,j,k)=uri(5,i,j,k)
        
        vt(i,j,k)=vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2
         
        bsq(i,j,k)=bx(i,j,k)**2+by(i,j,k)**2+bz(i,j,k)**2
         
        psq(i,j,k)=tx(i,j,k)**2+ty(i,j,k)**2+tz(i,j,k)**2
         
        pb(i,j,k)=tx(i,j,k)*bx(i,j,k)+ty(i,j,k)*by(i,j,k)+tz(i,j,k)*bz(i,j,k)
        pbsq(i,j,k)=pb(i,j,k)**2
         
        vt2=max(vt(i,j,k),vt2)
        bsqm=max(bsq(i,j,k),bsqm)
         
      enddo
    enddo
  enddo 

  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        
        if(ieos .eq. 0) then
          roh=ro(i,j,k)+(gam/(gam-1.0))*pp(i,j,k)
        elseif(ieos .eq. 1) then
          roh=(5./2.)*pp(i,j,k) &
             +sqrt((9./4.)*pp(i,j,k)**2+ro(i,j,k)**2)
        elseif(ieos .eq. 2) then
          roe=(3./2.)*(pp(i,j,k)+((3.*pp(i,j,k)**2) &
             /(2.0*ro(i,j,k)+sqrt(2.*pp(i,j,k)**2+4.*ro(i,j,k)**2)) ))
          roh=ro(i,j,k)+roe+pp(i,j,k)
        endif
          
        if(vt(i,j,k) .lt. 0.8d0 .and. bsq(i,j,k)/roh .lt. 1.d0) then
         
          gf=1.0/sqrt(1.0-vt(i,j,k)/c0**2)
          ro(i,j,k)=dro(i,j,k)/gf
          wg1=abs(gf**2*(ro(i,j,k)+gam1*pp(i,j,k)))
           
        else
          
          ee1=ee(i,j,k)+dro(i,j,k)
          
          if(igue .eq. 1) then
            vt1=1.d0
          else
            vt1=vt(i,j,k)
          endif
         
          tmp1a=4.0-vt1
          tmp1b=4.0*(bsq(i,j,k)-ee1)
          tmp1c=psq(i,j,k)+bsq(i,j,k)**2-2.0*bsq(i,j,k)*ee1
          tmp1d=(tmp1b**2)-4.0*tmp1a*tmp1c
          wgp=(-tmp1b+sqrt(tmp1d))/2.0*tmp1a
          wgm=(-tmp1b-sqrt(tmp1d))/2.0*tmp1a
         
          if(wgp .gt. 0.d0) then
            wg1=wgp
          elseif(wgm .ge. 0.d0) then
            wg1=wgm
          endif
           
        endif
           
        wg(i,j,k)=wg1
        wsq=wg1*wg1
        xsq=(bsq(i,j,k)+wg1)**2
        vt(i,j,k)=abs((wsq*psq(i,j,k)+pbsq(i,j,k) &
                  *(bsq(i,j,k)+2.0*wg1))/(wsq*xsq))
          
      enddo
    enddo
  enddo
  
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        if(vt(i,j,k) .gt. 1.d0) then
          write(6,*) 'vt > 1.0' 
          vt(i,j,k)=1.0-dv
        endif
      enddo
    enddo
  enddo  

  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        tmp3a=wg(i,j,k)**3*(wg(i,j,k)+2.0*bsq(i,j,k)) &
             -pbsq(i,j,k)*(2.0*wg(i,j,k)+bsq(i,j,k))
        tmp3b=wg(i,j,k)**2*(psq(i,j,k)-bsq(i,j,k)**2)
          
        if(tmp3a .le. tmp3b) then
           
          iflg=1
          wg1=wg(i,j,k)
           
          do nnn=1,iter
            if(tmp3a .le. tmp3b) then
              wg1= abs(1.1*wg1)
              tmp3a=wg1**3*(wg1+2.0*bsq(i,j,k)) &
                   -pbsq(i,j,k)*(2.0*wg1+bsq(i,j,k))
              tmp3b=wg1**2*(psq(i,j,k)-bsq(i,j,k)**2)
            endif
          enddo 
          
        endif
          
!        if(iflg .eq. 1) then
!          write(6,*) 'tmp3a < tmp3b'
!          wg(i,j,k)=wg1
!        endif
          
      enddo
    enddo
  enddo
          
!=====================================================================@
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1

!--- set parameter of delta and deltaend ----

        delta=1.d0
        deltaend = 0.001d0
        df=1.d0
        f=1.d0
        irecov(i,j,k)=0

        wg1=wg(i,j,k)
        vt2=vt(i,j,k)
        xxn=wg(i,j,k)
        yyn=vt(i,j,k)
        xo=wg(i,j,k)
        yo=vt(i,j,k)

!--- Newton-Raphson routine ----
         
        do nnn=1,iter

          if(delta .ge. deltaend .and. irecov(i,j,k) .eq. 0) then
           
            if(nnn .eq. iter) then
              irecov(i,j,k)=1

            else
              wg1=xxn
              vt2=yyn
            
              wsq=wg1*wg1
              w3=wsq*wg1
            
              gf=1.0/sqrt(1.0-vt2)
              ro(i,j,k)=dro(i,j,k)/gf
              xi1=(wg1-dro(i,j,k)*gf)/gf**2

              if(ieos .eq. 0) then
                pp(i,j,k)=((gam-1.0)/gam)*xi1
              elseif(ieos .eq. 1 .or. ieos .eq. 2) then
                tmp2c=2.0*xi1*(xi1+2.0*ro(i,j,k))
                tmp2d=5.0*(xi1+ro(i,j,k))+sqrt(9.0*xi1**2 &
                     +18.0*ro(i,j,k)*xi1+25.0*ro(i,j,k)**2)
                pp(i,j,k)=tmp2c/tmp2d
              endif
            
! --- calculation of dp/dW and dp/dv^2 term ----
!
              if(ieos .eq. 0) then
!  gamma-law EoS
                dpdxi=(gam-1.0)/gam
                dpdro=0.d0
              elseif(ieos .eq. 1 .or. ieos .eq. 2) then
!  TM Eos
                t1=5.0*ro(i,j,k)+5.0*xi1-8.0*pp(i,j,k)
                dpdxi=(2.0*xi1+2.0*ro(i,j,k)-5.0*pp(i,j,k))/t1
                dpdro=(2.0*xi1-5.0*pp(i,j,k))/t1
              endif
           
!              tmp3a=w3*(wg1+bsq(i,j,k))**3
!              tmp3b=3.0*wg1*(wg1+bsq(i,j,k))+bsq(i,j,k)**2
!              tmp3=pbsq(i,j,k)*tmp3b+psq(i,j,k)*w3
!              dvdw=-2.0*tmp3/tmp3a
          
!              dxidw=(1.0/gf**2)-0.5*gf*(dro(i,j,k)+2.0*gf*xi1)*dvdw
!              drodw=-0.5*dro(i,j,k)*gf*dvdw

              dxidw=1.0/gf**2
              drodw=0.d0
          
              dpdw=dpdxi*dxidw+dpdro*drodw
            
              tmp3c=-wsq*(wsq+2.0*bsq(i,j,k)*wg1*bsq(i,j,k)**2)
              tmp3d=4.0*vt2*w3+6.0*bsq(i,j,k)*vt2*wsq &
                   +2.0*(bsq(i,j,k)**2*vt2-psq(i,j,k))*wg1 &
                   -2.0*pbsq(i,j,k)
              dwdv2=tmp3c/tmp3d
!              dwdv2=1.0/dvdw
            
              dxidv2=-0.5*gf*(dro(i,j,k)+2.0*gf*xi1)
              drodv2=-0.5*dro(i,j,k)*gf
            
              dpdv2=dpdxi*dxidv2+dpdro*drodv2

! --- calculation of f, g and df, dg ----
!
              f1=psq(i,j,k)-vt2*(wg1+bsq(i,j,k))**2 &
                +(pbsq(i,j,k)*(bsq(i,j,k)+2.0*wg1))/wsq
              g1=ee(i,j,k)-0.5*bsq(i,j,k)*(1.0+vt2) &
                +(0.5*pbsq(i,j,k)/wsq)-wg1+pp(i,j,k)+dro(i,j,k)
          
              dfx=-2.0*(vt2+(pbsq(i,j,k)/w3))*(wg1+bsq(i,j,k))
              dfy=-1.0*((wg1+bsq(i,j,k))**2)
              dgx=-1.0-(pbsq(i,j,k)/w3)+dpdw
              dgy=-0.5*bsq(i,j,k)+dpdv2

              det=dfx*dgy-dfy*dgx

              dx=(-dgy*f1+dfy*g1)/det
              dy=(dgx*f1-dfx*g1)/det

              df=-f1*f1-g1*g1
              f=-0.5*df
            
              delta=abs((dx+dy)/2.0)
            
              xo=wg1
              yo=vt2
            
              xxn=wg1+dx
              yyn=vt2+dy
!
              if(xxn .lt. 0.d0) then
                irecov(i,j,k)=2
              endif
             
              if(yyn .gt. 1.d0) then
                dv=1.0d-5
                yyn=1.0-dv
              endif
             
              if(yyn .lt. 0.d0) then
                yyn=abs(yyn)
              endif
             
            endif
          endif

        enddo

        if(irecov(i,j,k) .eq. 0) then
          
          gf=1.0/sqrt(1.0-yyn/c0**2)
          ro(i,j,k)=dro(i,j,k)/gf
          
          xi1=(xxn-dro(i,j,k)*gf)/gf**2

          if(ieos .eq. 0) then
            pp(i,j,k)=((gam-1.0)/gam)*xi1
          elseif(ieos .eq. 1 .or. ieos .eq. 2) then
            tmp3a=2.0*xi1*(xi1+2.0*ro(i,j,k))
            tmp3b=5.0*(xi1+ro(i,j,k))+sqrt(9.0*xi1**2 &
                 +18.0*ro(i,j,k)*xi1+25.0*ro(i,j,k)**2)
            pp(i,j,k)=tmp3a/tmp3b
          endif
          
          vx(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                   *(tx(i,j,k)+pb(i,j,k)*bx(i,j,k)/xxn)
          vy(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                   *(ty(i,j,k)+pb(i,j,k)*by(i,j,k)/xxn)
          vz(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                   *(tz(i,j,k)+pb(i,j,k)*bz(i,j,k)/xxn)
          
        endif
         
        wg(i,j,k)=xxn
        vt(i,j,k)=yyn
        del(i,j,k)=delta
!
      enddo
    enddo
  enddo

!---------------------------------------------------------------------
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
         
        if(irecov(i,j,k) .eq. 1) then
          write(6,*) ' >> Not convergence in recov1e' &
                    ,' at i, j, k:',i, j, k
          write(6,*) ' >> delta =', del(i,j,k) &
                    ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
         
        elseif(irecov(i,j,k) .eq. 2) then
          write(6,*) ' >> wg  < 0 in recov1e' &
                    ,' at i, j, k:',i, j, k
          write(6,*) ' >> wg', wg(i,j,k) &
                    ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
         
        elseif(irecov(i,j,k) .eq. 0) then
          vt1=sqrt(vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2)
          
          if(vt1 .gt. 1.d0) then 
            write(6,*) ' >> vt  > 1.0 in recov1e' &
                      ,' at i, j, k:',i, j, k
            write(6,*) ' >> vt', vt1 &
                      ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
            irecov(i,j,k)=1
          endif

          if(vt1 .lt. 0.d0) then
            write(6,*) ' >> vt  < 0.0 in recov1e' &
                      ,' at i, j, k:',i, j, k
            write(6,*) ' >> vt', vt1 &
                      ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
            irecov(i,j,k)=1
          endif
         
        endif
!
      enddo
    enddo
  enddo
!
!---------------------------------------------------------------------@
!   Set Primitive variables
!---------------------------------------------------------------------@
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
   
        if(irecov(i,j,k) .eq. 0) then
         
          uri(1,i,j,k)=ro(i,j,k)
          uri(2,i,j,k)=vx(i,j,k)
          uri(3,i,j,k)=vy(i,j,k)
          uri(4,i,j,k)=vz(i,j,k)
          uri(5,i,j,k)=pp(i,j,k)
          uri(6,i,j,k)=uu(6,i,j,k)/dro(i,j,k)
          uri(7,i,j,k)=bx(i,j,k)
          uri(8,i,j,k)=by(i,j,k)
          uri(9,i,j,k)=bz(i,j,k)
        
        else
         
          uri(1,i,j,k)=ro1(i,j,k)
          uri(2,i,j,k)=vx1(i,j,k)
          uri(3,i,j,k)=vy1(i,j,k)
          uri(4,i,j,k)=vz1(i,j,k)
          uri(5,i,j,k)=pp1(i,j,k)
          uri(6,i,j,k)=uu(6,i,j,k)/dro(i,j,k)
          uri(7,i,j,k)=bx(i,j,k)
          uri(8,i,j,k)=by(i,j,k)
          uri(9,i,j,k)=bz(i,j,k)
         
        endif
      enddo
    enddo
  enddo
!
!=====================================================================@
!
  deallocate( dro, ee, tx, ty, tz, ro, pp, vx, vy, vz, vt, &
              bx, by, bz, bsq, ro1, pp1, vx1, vy1, vz1, &
              psq, pb, pbsq, wg, del, irecov, stat=merr )
!
  return
end subroutine recov1e
!
!---------------------------------------------------------------------@
subroutine recov2d(uu,uri,x1,x2,x3,nm1,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0, iter, ieos
  implicit none
!
  integer :: i, j, k, nnn, nm1, is1, ie1, js1, je1, ks1, ke1
  integer :: merr

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x2(jmax), x3(kmax)
      
  real(8), allocatable :: dro(:,:,:), ee(:,:,:), &
           tx(:,:,:), ty(:,:,:), tz(:,:,:)
     
  real(8), allocatable :: ro(:,:,:), pp(:,:,:), &
           vx(:,:,:), vy(:,:,:), vz(:,:,:), vt(:,:,:)
     
  real(8), allocatable :: bx(:,:,:), by(:,:,:), bz(:,:,:), bsq(:,:,:)
      
  real(8), allocatable :: ro1(:,:,:), pp1(:,:,:), &
           vx1(:,:,:), vy1(:,:,:), vz1(:,:,:)
     
  real(8), allocatable :: psq(:,:,:), pb(:,:,:), pbsq(:,:,:)

  real(8), allocatable :: wg(:,:,:), wgd(:,:,:)

  real(8), allocatable :: del(:,:,:)
      
  integer, allocatable :: irecov(:,:,:)
  
  real(8) :: safty, dv, roh, roe, gf, wg1, ee1, vt1, & 
             tmp1a, tmp1b, tmp1c, tmp1d, wgp, wgm, &
             delta, deltaend, df, f, wgd1, xxn, xo, &
             wsq, xsq, vt2, gfsq, xi1, tmp2c, tmp2d, t1, &
             dpdxi, dpdro,tmp3a, tmp3b, tmp3, dvdwd, dxidwd, &
             drodwd, dpdwd, &
             tmp4a, tmp4b, tmp4c, tmp4d, tmp5a, tmp5b, tmp6a, tmp6b

  integer :: igue
!
  allocate( dro(is1:ie1,js1:je1,ks1:ke1), ee(is1:ie1,js1:je1,ks1:ke1), &
            tx(is1:ie1,js1:je1,ks1:ke1), ty(is1:ie1,js1:je1,ks1:ke1), &
            tz(is1:ie1,js1:je1,ks1:ke1), &
            ro(is1:ie1,js1:je1,ks1:ke1), pp(is1:ie1,js1:je1,ks1:ke1), &
            vx(is1:ie1,js1:je1,ks1:ke1), vy(is1:ie1,js1:je1,ks1:ke1), &
            vz(is1:ie1,js1:je1,ks1:ke1), vt(is1:ie1,js1:je1,ks1:ke1), &
            bx(is1:ie1,js1:je1,ks1:ke1), by(is1:ie1,js1:je1,ks1:ke1), &
            bz(is1:ie1,js1:je1,ks1:ke1), bsq(is1:ie1,js1:je1,ks1:ke1), &
            ro1(is1:ie1,js1:je1,ks1:ke1), pp1(is1:ie1,js1:je1,ks1:ke1), &
            vx1(is1:ie1,js1:je1,ks1:ke1), vy1(is1:ie1,js1:je1,ks1:ke1), &
            vz1(is1:ie1,js1:je1,ks1:ke1), &
            psq(is1:ie1,js1:je1,ks1:ke1), pb(is1:ie1,js1:je1,ks1:ke1), & 
            pbsq(is1:ie1,js1:je1,ks1:ke1), &
            wg(is1:ie1,js1:je1,ks1:ke1), wgd(is1:ie1,js1:je1,ks1:ke1), &
            del(is1:ie1,js1:je1,ks1:ke1), irecov(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr )  
!      
!--- define variable of safe number ----
  safty = 1.0d-10
      
  igue=1
      
  dv=1.0d-5
!=====================================================================@
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
!
        dro(i,j,k)=uu(1,i,j,k)
        tx(i,j,k)=uu(2,i,j,k)
        ty(i,j,k)=uu(3,i,j,k)
        tz(i,j,k)=uu(4,i,j,k)
        ee(i,j,k)=uu(5,i,j,k)
        bx(i,j,k)=uu(7,i,j,k)
        by(i,j,k)=uu(8,i,j,k)
        bz(i,j,k)=uu(9,i,j,k)
         
        ro(i,j,k)=uri(1,i,j,k)
        vx(i,j,k)=uri(2,i,j,k)
        vy(i,j,k)=uri(3,i,j,k)
        vz(i,j,k)=uri(4,i,j,k)
        pp(i,j,k)=uri(5,i,j,k)
         
        vt(i,j,k)=vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2
         
        bsq(i,j,k)=bx(i,j,k)**2+by(i,j,k)**2+bz(i,j,k)**2
         
        psq(i,j,k)=tx(i,j,k)**2+ty(i,j,k)**2+tz(i,j,k)**2
         
        pb(i,j,k)=tx(i,j,k)*bx(i,j,k)+ty(i,j,k)*by(i,j,k)+tz(i,j,k)*bz(i,j,k)
        pbsq(i,j,k)=pb(i,j,k)**2
         
        ro1(i,j,k)=uri(1,i,j,k)
        vx1(i,j,k)=uri(2,i,j,k)
        vy1(i,j,k)=uri(3,i,j,k)
        vz1(i,j,k)=uri(4,i,j,k)
        pp1(i,j,k)=uri(5,i,j,k)
         
      enddo
    enddo
  enddo

!=====================================================================@
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1

        if(ieos .eq. 0) then
          roh=ro(i,j,k)+(gam/(gam-1.0))*pp(i,j,k)
        elseif(ieos .eq. 1) then
          roh=(5./2.)*pp(i,j,k) &
              +sqrt((9./4.)*pp(i,j,k)**2+ro(i,j,k)**2)
        elseif(ieos .eq. 2) then
          roe=(3./2.)*(pp(i,j,k)+((3.*pp(i,j,k)**2) &
              /(2.0*ro(i,j,k)+sqrt(2.*pp(i,j,k)**2+4.*ro(i,j,k)**2)) ))
          roh=ro(i,j,k)+roe+pp(i,j,k)
        endif
          
! --- calculation for initial guess ----

!        if(vt(i,j,k) .lt. 0.9d0 .and. bsq(i,j,k)/roh .lt. 1.d0) then
!           
!          gf=1.0/sqrt(1.0-vt(i,j,k)/c0**2)
!          ro(i,j,k)=dro(i,j,k)/gf
!         
!          wg1=abs(roh*gf**2)
!          
!        else

          ee1=ee(i,j,k)+dro(i,j,k)
          
          if(igue .eq. 1) then
            vt1=1.d0
          else
            vt1=vt(i,j,k)
          endif
         
          tmp1a=4.0-vt1
          tmp1b=4.0*(bsq(i,j,k)-ee1)
          tmp1c=psq(i,j,k)+bsq(i,j,k)**2-2.0*bsq(i,j,k)*ee1
          tmp1d=(tmp1b**2)-4.0*tmp1a*tmp1c
          wgp=(-tmp1b+sqrt(tmp1d))/2.0*tmp1a
          wgm=(-tmp1b-sqrt(tmp1d))/2.0*tmp1a
         
          if(wgp .gt. 0.d0) then
            wg1=wgp
          elseif(wgm .ge. 0.d0) then
            wg1=wgm
          endif
          
!        endif
         
        wg(i,j,k)=wg1
        wgd(i,j,k)=wg(i,j,k)-dro(i,j,k)
           
      enddo
    enddo
  enddo
!
!=====================================================================@
!   Newton-Raphson iteration start
!=====================================================================@
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1

! --- set parameter ----
!
        delta=1.d0
        deltaend = 0.001d0
        df=1.d0
        f=1.d0
        irecov(i,j,k)=0

        wgd1=wgd(i,j,k)
        wg1=wg(i,j,k)
        xxn=wg(i,j,k)
        xo=wg(i,j,k)

! --- Newton-Raphson routine ----
!
        do nnn=1,iter
         
          if(abs(delta) .ge. deltaend .and. irecov(i,j,k) .eq. 0) then
           
            if(nnn .eq. iter) then
              irecov(i,j,k)=1
            
            else
            
              wg1=xxn
              wgd1=xxn-dro(i,j,k)
            
              wsq=wg1*wg1
              xsq=(bsq(i,j,k)+wg1)**2
              vt2=abs((wsq*psq(i,j,k)+pbsq(i,j,k) &
                 *(bsq(i,j,k)+2.0*wg1))/(wsq*xsq))

              if(vt2 .gt. 1.d0) then
!                write(6,*) 'vt > 1.0' 
                vt2=1.0-dv
              endif
         
              gf=1.0/sqrt(1.0-vt2)
!              usq1=vt2/(1.0-vt2)
!              gf=sqrt(1.0+usq1)
           
              gfsq=gf**2
              ro(i,j,k)=dro(i,j,k)/gf

!              xi1=(wgd1/gfsq)-(dro(i,j,k)*usq1)/(1.0+gf)*gfsq
              xi1=(wg1-dro(i,j,k)*gf)/gfsq
!
              if(ieos .eq. 0) then
                pp(i,j,k)=((gam-1.0)/gam)*xi1
              elseif(ieos .eq. 1 .or. ieos .eq. 2) then
                tmp2c=2.0*xi1*(xi1+2.0*ro(i,j,k))
                tmp2d=5.0*(xi1+ro(i,j,k))+sqrt(9.0*xi1**2 &
                     +18.0*ro(i,j,k)*xi1+25.0*ro(i,j,k)**2)
                pp(i,j,k)=tmp2c/tmp2d
              endif

! --- calculation of dp/dW term ----
!
              if(ieos .eq. 0) then
!  gamma-law EoS
                dpdxi=(gam-1.0)/gam
                dpdro=0.d0
              elseif(ieos .eq. 1 .or. ieos .eq. 2) then
!  TM Eos
                t1=5.0*ro(i,j,k)+5.0*xi1-8.0*pp(i,j,k)
                dpdxi=(2.0*xi1+2.0*ro(i,j,k)-5.0*pp(i,j,k))/t1
                dpdro=(2.0*xi1-5.0*pp(i,j,k))/t1
              endif
           
              tmp3a=wg1**3*(wg1+bsq(i,j,k))**3
              tmp3b=3.0*wg1*(wg1+bsq(i,j,k))+bsq(i,j,k)**2
              tmp3=pbsq(i,j,k)*tmp3b+psq(i,j,k)*wg1**3
              dvdwd=-2.0*tmp3/tmp3a
          
              dxidwd=(1.0/gfsq)-0.5*gf*(dro(i,j,k)+2.0*gf*xi1)*dvdwd
              drodwd=-0.5*dro(i,j,k)*gf*dvdwd
          
              dpdwd=dpdxi*dxidwd+dpdro*drodwd
          
! --- calculation of f(W') and df(W')/dW' ----
!
              tmp4a=bsq(i,j,k)*psq(i,j,k)-pbsq(i,j,k)
              tmp4b=bsq(i,j,k)+wgd1+dro(i,j,k)
            
              if(tmp4a .eq. 0.d0) then
                tmp4c=0.d0
                tmp4d=0.d0
              else
                tmp4c=0.5*tmp4a/tmp4b**2
                tmp4d=tmp4a/tmp4b**3
              endif
          
              f=wgd1-ee(i,j,k)-pp(i,j,k)+0.5*bsq(i,j,k)+tmp4c
              df=1.0-dpdwd-tmp4d
          
              delta=f/df
          
              xo=wg1
              xxn=wgd1-delta+dro(i,j,k)
          
              if(xxn .lt. 0.d0) then
                irecov(i,j,k)=2
              endif

            endif
          endif

        enddo
 
        if(irecov(i,j,k) .eq. 0) then

          wsq=xxn*xxn
          xsq=(bsq(i,j,k)+xxn)**2
          tmp6a=(wsq*psq(i,j,k)+pbsq(i,j,k)*(bsq(i,j,k)+2.0*xxn))
          tmp6b=(wsq*xsq)
          vt2=abs(tmp6a/tmp6b)

          if(vt2 .gt. 1.d0) then
!            write(6,*) 'vt > 1.0' 
            vt2=1.0-dv
          endif
         
          gf=1.0/sqrt(1.0-vt2)
!          usq1=vt2/(1.0-vt2)
!          gf=sqrt(1.0+usq1)
           
          gfsq=gf**2
          ro(i,j,k)=dro(i,j,k)/gf

          xi1=(xxn-dro(i,j,k)*gf)/gfsq
!
          if(ieos .eq. 0) then
            pp(i,j,k)=((gam-1.0)/gam)*xi1
          elseif(ieos .eq. 1 .or. ieos .eq. 2) then
            tmp5a=2.0*xi1*(xi1+2.0*ro(i,j,k))
            tmp5b=5.0*(xi1+ro(i,j,k))+sqrt(9.0*xi1**2 &
                 +18.0*ro(i,j,k)*xi1+25.0*ro(i,j,k)**2)
            pp(i,j,k)=tmp5a/tmp5b
          endif

          vx(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                   *(tx(i,j,k)+pb(i,j,k)*bx(i,j,k)/xxn)
          vy(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                   *(ty(i,j,k)+pb(i,j,k)*by(i,j,k)/xxn)
          vz(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                   *(tz(i,j,k)+pb(i,j,k)*bz(i,j,k)/xxn)
          
        endif
          
        wg(i,j,k)=xxn
        del(i,j,k)=abs(delta)
          
      enddo
    enddo
  enddo         
          
!---------------------------------------------------------------------
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
         
        if(irecov(i,j,k) .eq. 1) then
          write(6,*) ' >> Not convergence in recov2d' &
                    ,' at i, j, k:',i, j, k
          write(6,*) ' >> delta =', del(i,j,k) &
                    ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
         
        elseif(irecov(i,j,k) .eq. 2) then
          write(6,*) ' >> wg  < 0 in recov2d' &
                    ,' at i, j, k:',i, j, k
          write(6,*) ' >> wg', wg(i,j,k) &
                    ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
         
        elseif(irecov(i,j,k) .eq. 0) then
          vt1=sqrt(vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2)
          
          if(vt1 .gt. 1.d0) then
            write(6,*) ' >> vt  > 1.0 in recov2d' &
                      ,' at i, j, k:',i, j, k
            write(6,*) ' >> vt', vt1 &
                      ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
            irecov(i,j,k)=3
          endif

          if(vt1 .lt. 0.d0) then
            write(6,*) ' >> vt  < 0.0 in recov2d' &
                      ,' at i, j, k:',i, j, k
            write(6,*) ' >> vt', vt1 &
                      ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
            irecov(i,j,k)=3
          endif
         
        endif

      enddo
    enddo
  enddo

!---------------------------------------------------------------------@
!   Set Primitive variables
!---------------------------------------------------------------------@
!
  do k=ks1+nm1,ke1-nm1
    do j=js1+nm1,je1-nm1
      do i=is1+nm1,ie1-nm1
        
        if(irecov(i,j,k) .eq. 0) then
         
          uri(1,i,j,k)=ro(i,j,k)
          uri(2,i,j,k)=vx(i,j,k)
          uri(3,i,j,k)=vy(i,j,k)
          uri(4,i,j,k)=vz(i,j,k)
          uri(5,i,j,k)=pp(i,j,k)
          uri(6,i,j,k)=uu(6,i,j,k)/dro(i,j,k)
          uri(7,i,j,k)=bx(i,j,k)
          uri(8,i,j,k)=by(i,j,k)
          uri(9,i,j,k)=bz(i,j,k)
        
        else
         
          uri(1,i,j,k)=ro1(i,j,k)
          uri(2,i,j,k)=vx1(i,j,k)
          uri(3,i,j,k)=vy1(i,j,k)
          uri(4,i,j,k)=vz1(i,j,k)
          uri(5,i,j,k)=pp1(i,j,k)
          uri(6,i,j,k)=uu(6,i,j,k)/dro(i,j,k)
          uri(7,i,j,k)=bx(i,j,k)
          uri(8,i,j,k)=by(i,j,k)
          uri(9,i,j,k)=bz(i,j,k)
         
        endif

      enddo
    enddo
  enddo
!
!=====================================================================@
!
  deallocate( dro, ee, tx, ty, tz, ro, pp, vx, vy, vz, vt, bx, by, bz, bsq, &
              ro1, pp1, vx1, vy1, vz1, psq, pb, pbsq, wg, wgd, del, irecov, &
              stat=merr )  
!
  return
end subroutine recov2d
!
!---------------------------------------------------------------------@
subroutine recov2da(uu,uri,x1,x2,x3,nm0,iflx,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculation of primitive variables(uri) 
!     from conserved variables(uu)
!     based on Mignone & McKinney (2007) (for variable EoS)
!     (for Riemann solver)
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, iter, ieos
  implicit none
!
  integer :: i, j, k, nnn, nm0, is1, ie1, js1, je1, ks1, ke1, merr

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x2(jmax), x3(kmax)

  real(8), allocatable :: dro(:,:,:), ee(:,:,:), &
           tx(:,:,:), ty(:,:,:), tz(:,:,:)
     
  real(8), allocatable :: ro(:,:,:), pp(:,:,:), &
           vx(:,:,:), vy(:,:,:), vz(:,:,:), vt(:,:,:)
     
  real(8), allocatable :: bx(:,:,:), by(:,:,:), bz(:,:,:), bsq(:,:,:)
      
  real(8), allocatable :: ro1(:,:,:), pp1(:,:,:), &
           vx1(:,:,:), vy1(:,:,:), vz1(:,:,:)
     
  real(8), allocatable :: psq(:,:,:), pb(:,:,:), pbsq(:,:,:)

  real(8), allocatable :: wg(:,:,:), wgd(:,:,:)

  real(8), allocatable :: del(:,:,:)
      
  integer, allocatable :: irecov(:,:,:) 
  integer :: iflx(is1:ie1,js1:je1,ks1:ke1)  
  
  real(8) :: safty, dv, roh, roe, gf, wg1, ee1, vt1, &
             tmp1a, tmp1b, tmp1c, tmp1d, wgp, wgm, &
             delta, deltaend, df, f, wgd1, xxn, xo, &
             wsq, xsq, vt2, gfsq, xi1, tmp2c, tmp2d, t1, &
             dpdxi, dpdro,tmp3a, tmp3b, tmp3, dvdwd, dxidwd, & 
             drodwd, dpdwd, &
             tmp4a, tmp4b, tmp4c, tmp4d, tmp5a, tmp5b, tmp6a, tmp6b

  integer :: igue
!
  allocate( dro(is1:ie1,js1:je1,ks1:ke1), ee(is1:ie1,js1:je1,ks1:ke1), &
            tx(is1:ie1,js1:je1,ks1:ke1), ty(is1:ie1,js1:je1,ks1:ke1), &
            tz(is1:ie1,js1:je1,ks1:ke1), &
            ro(is1:ie1,js1:je1,ks1:ke1), pp(is1:ie1,js1:je1,ks1:ke1), &
            vx(is1:ie1,js1:je1,ks1:ke1), vy(is1:ie1,js1:je1,ks1:ke1), &
            vz(is1:ie1,js1:je1,ks1:ke1), vt(is1:ie1,js1:je1,ks1:ke1), &
            bx(is1:ie1,js1:je1,ks1:ke1), by(is1:ie1,js1:je1,ks1:ke1), &
            bz(is1:ie1,js1:je1,ks1:ke1), bsq(is1:ie1,js1:je1,ks1:ke1), &
            ro1(is1:ie1,js1:je1,ks1:ke1), pp1(is1:ie1,js1:je1,ks1:ke1), &
            vx1(is1:ie1,js1:je1,ks1:ke1), vy1(is1:ie1,js1:je1,ks1:ke1), &
            vz1(is1:ie1,js1:je1,ks1:ke1), &
            psq(is1:ie1,js1:je1,ks1:ke1), pb(is1:ie1,js1:je1,ks1:ke1), & 
            pbsq(is1:ie1,js1:je1,ks1:ke1), &
            wg(is1:ie1,js1:je1,ks1:ke1), wgd(is1:ie1,js1:je1,ks1:ke1), &
            del(is1:ie1,js1:je1,ks1:ke1), irecov(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr )  
      
!--- define variable of safe number ----
  safty = 1.0d-10
      
  igue=1
      
  dv=1.0d-5
!=====================================================================@
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0

        if(iflx(i,j,k) .eq. 0) then
          dro(i,j,k)=uu(1,i,j,k)
          tx(i,j,k)=uu(2,i,j,k)
          ty(i,j,k)=uu(3,i,j,k)
          tz(i,j,k)=uu(4,i,j,k)
          ee(i,j,k)=uu(5,i,j,k)
          bx(i,j,k)=uu(7,i,j,k)
          by(i,j,k)=uu(8,i,j,k)
          bz(i,j,k)=uu(9,i,j,k)
         
          ro(i,j,k)=uri(1,i,j,k)
          vx(i,j,k)=uri(2,i,j,k)
          vy(i,j,k)=uri(3,i,j,k)
          vz(i,j,k)=uri(4,i,j,k)
          pp(i,j,k)=uri(5,i,j,k)
         
          vt(i,j,k)=vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2
         
          bsq(i,j,k)=bx(i,j,k)**2+by(i,j,k)**2+bz(i,j,k)**2
         
          psq(i,j,k)=tx(i,j,k)**2+ty(i,j,k)**2+tz(i,j,k)**2
         
          pb(i,j,k)=tx(i,j,k)*bx(i,j,k)+ty(i,j,k)*by(i,j,k) &
                   +tz(i,j,k)*bz(i,j,k)
          pbsq(i,j,k)=pb(i,j,k)**2
         
          ro1(i,j,k)=uri(1,i,j,k)
          vx1(i,j,k)=uri(2,i,j,k)
          vy1(i,j,k)=uri(3,i,j,k)
          vz1(i,j,k)=uri(4,i,j,k)
          pp1(i,j,k)=uri(5,i,j,k)
        endif

      enddo
    enddo
  enddo
!=====================================================================@
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0

        if(iflx(i,j,k) .eq. 0) then
! 
          if(ieos .eq. 0) then
            roh=ro(i,j,k)+(gam/(gam-1.0))*pp(i,j,k)
          elseif(ieos .eq. 1) then
            roh=(5./2.)*pp(i,j,k) &
               +sqrt((9./4.)*pp(i,j,k)**2+ro(i,j,k)**2)
          elseif(ieos .eq. 2) then
            roe=(3./2.)*(pp(i,j,k)+((3.*pp(i,j,k)**2) &
               /(2.0*ro(i,j,k)+sqrt(2.*pp(i,j,k)**2+4.*ro(i,j,k)**2)) ))
            roh=ro(i,j,k)+roe+pp(i,j,k)
          endif
          
! --- calculation for initial guess ----

!          if(vt(i,j,k) .lt. 0.9d0 .and. bsq(i,j,k)/roh .lt. 1.d0) then
!           
!            gf=1.0/sqrt(1.0-vt(i,j,k)/c0**2)
!            ro(i,j,k)=dro(i,j,k)/gf
!         
!            wg1=abs(roh*gf**2)
!          
!          else

            ee1=ee(i,j,k)+dro(i,j,k)
          
            if(igue .eq. 1) then
              vt1=1.d0
            else
              vt1=vt(i,j,k)
            endif
         
            tmp1a=4.0-vt1
            tmp1b=4.0*(bsq(i,j,k)-ee1)
            tmp1c=psq(i,j,k)+bsq(i,j,k)**2-2.0*bsq(i,j,k)*ee1
            tmp1d=(tmp1b**2)-4.0*tmp1a*tmp1c
            wgp=(-tmp1b+sqrt(tmp1d))/2.0*tmp1a
            wgm=(-tmp1b-sqrt(tmp1d))/2.0*tmp1a
         
            if(wgp .gt. 0.d0) then
              wg1=wgp
            elseif(wgm .ge. 0.d0) then
              wg1=wgm
            endif
          
          endif
         
          wg(i,j,k)=wg1
          wgd(i,j,k)=wg(i,j,k)-dro(i,j,k)
         
!        endif
!  
      enddo
    enddo
  enddo
!
!=====================================================================@
!   Newton-Raphson iteration start
!=====================================================================@
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0

        if(iflx(i,j,k) .eq. 0) then
! --- set parameter ----
!
          delta=1.d0
          deltaend = 0.001d0
          df=1.d0
          f=1.d0
          irecov(i,j,k)=0

          wgd1=wgd(i,j,k)
          wg1=wg(i,j,k)
          xxn=wg(i,j,k)
          xo=wg(i,j,k)

! --- Newton-Raphson routine ----
!
          do nnn=1,iter
         
            if(abs(delta) .ge. deltaend .and. irecov(i,j,k) .eq. 0) then
           
              if(nnn .eq. iter) then
                irecov(i,j,k)=1
            
              else
            
                wg1=xxn
                wgd1=xxn-dro(i,j,k)
            
                wsq=wg1*wg1
                xsq=(bsq(i,j,k)+wg1)**2
                vt2=abs((wsq*psq(i,j,k)+pbsq(i,j,k) &
                    *(bsq(i,j,k)+2.0*wg1))/(wsq*xsq))

                if(vt2 .gt. 1.d0) then
!                  write(6,*) 'vt > 1.0' 
                  vt2=1.0-dv
                endif
         
                gf=1.0/sqrt(1.0-vt2)
!                usq1=vt2/(1.0-vt2)
!                gf=sqrt(1.0+usq1)
           
                gfsq=gf**2
                ro(i,j,k)=dro(i,j,k)/gf

!                xi1=(wgd1/gfsq)-(dro(i,j,k)*usq1)/(1.0+gf)*gfsq
                xi1=(wg1-dro(i,j,k)*gf)/gfsq
!
                if(ieos .eq. 0) then
                  pp(i,j,k)=((gam-1.0)/gam)*xi1
                elseif(ieos .eq. 1 .or. ieos .eq. 2) then
                  tmp2c=2.0*xi1*(xi1+2.0*ro(i,j,k))
                  tmp2d=5.0*(xi1+ro(i,j,k))+sqrt(9.0*xi1**2 &
                       +18.0*ro(i,j,k)*xi1+25.0*ro(i,j,k)**2)
                  pp(i,j,k)=tmp2c/tmp2d
                endif

! --- calculation of dp/dW term ----
!
                if(ieos .eq. 0) then
!  gamma-law EoS
                  dpdxi=(gam-1.0)/gam
                  dpdro=0.d0
                elseif(ieos .eq. 1 .or. ieos .eq. 2) then
!  TM Eos
                  t1=5.0*ro(i,j,k)+5.0*xi1-8.0*pp(i,j,k)
                  dpdxi=(2.0*xi1+2.0*ro(i,j,k)-5.0*pp(i,j,k))/t1
                  dpdro=(2.0*xi1-5.0*pp(i,j,k))/t1
                endif
           
                tmp3a=wg1**3*(wg1+bsq(i,j,k))**3
                tmp3b=3.0*wg1*(wg1+bsq(i,j,k))+bsq(i,j,k)**2
                tmp3=pbsq(i,j,k)*tmp3b+psq(i,j,k)*wg1**3
                dvdwd=-2.0*tmp3/tmp3a
          
                dxidwd=(1.0/gfsq)-0.5*gf &
                       *(dro(i,j,k)+2.0*gf*xi1)*dvdwd
                drodwd=-0.5*dro(i,j,k)*gf*dvdwd
          
                dpdwd=dpdxi*dxidwd+dpdro*drodwd
          
! --- calculation of f(W) and df(W)/dW ----
!
                tmp4a=bsq(i,j,k)*psq(i,j,k)-pbsq(i,j,k)
                tmp4b=bsq(i,j,k)+wgd1+dro(i,j,k)
            
                if(tmp4a .eq. 0.d0) then
                  tmp4c=0.d0
                  tmp4d=0.d0
                else
                  tmp4c=0.5*tmp4a/tmp4b**2
                  tmp4d=tmp4a/tmp4b**3
                endif
          
                f=wgd1-ee(i,j,k)-pp(i,j,k)+0.5*bsq(i,j,k)+tmp4c
                df=1.0-dpdwd-tmp4d
          
                delta=f/df
          
                xo=wg1
                xxn=wgd1-delta+dro(i,j,k)
          
                if(xxn .lt. 0.d0) then
                  irecov(i,j,k)=2
                endif

              endif
            endif

          enddo
 
          if(irecov(i,j,k) .eq. 0) then

            wsq=xxn*xxn
            xsq=(bsq(i,j,k)+xxn)**2
            tmp6a=(wsq*psq(i,j,k)+pbsq(i,j,k)*(bsq(i,j,k)+2.0*xxn))
            tmp6b=(wsq*xsq)
            vt2=abs(tmp6a/tmp6b)

            if(vt2 .gt. 1.d0) then
!              write(6,*) 'vt > 1.0' 
              vt2=1.0-dv
            endif
         
            gf=1.0/sqrt(1.0-vt2)
!            usq1=vt2/(1.0-vt2)
!            gf=sqrt(1.0+usq1)
           
            gfsq=gf**2
            ro(i,j,k)=dro(i,j,k)/gf

            xi1=(xxn-dro(i,j,k)*gf)/gfsq
!
            if(ieos .eq. 0) then
              pp(i,j,k)=((gam-1.0)/gam)*xi1
            elseif(ieos .eq. 1 .or. ieos .eq. 2) then
              tmp5a=2.0*xi1*(xi1+2.0*ro(i,j,k))
              tmp5b=5.0*(xi1+ro(i,j,k))+sqrt(9.0*xi1**2 &
                   +18.0*ro(i,j,k)*xi1+25.0*ro(i,j,k)**2)
              pp(i,j,k)=tmp5a/tmp5b
            endif

            vx(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                      *(tx(i,j,k)+pb(i,j,k)*bx(i,j,k)/xxn)
            vy(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                      *(ty(i,j,k)+pb(i,j,k)*by(i,j,k)/xxn)
            vz(i,j,k)=(1.0/(xxn+bsq(i,j,k))) &
                      *(tz(i,j,k)+pb(i,j,k)*bz(i,j,k)/xxn)
          
          endif
          
          wg(i,j,k)=xxn
          del(i,j,k)=abs(delta)
         
        endif 
!
      enddo
    enddo
  enddo         
          
!---------------------------------------------------------------------
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
         
        if(iflx(i,j,k) .eq. 0) then
!         
          if(irecov(i,j,k) .eq. 1) then
            write(6,*) ' >> Not convergence in recov2da' &
                      ,' at i, j, k:',i, j, k
            write(6,*) ' >> delta =', del(i,j,k) &
                      ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
         
          elseif(irecov(i,j,k) .eq. 2) then
            write(6,*) ' >> wg  < 0 in recov2da' &
                      ,' at i, j, k:',i, j, k
            write(6,*) ' >> wg', wg(i,j,k) &
                      ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
         
          elseif(irecov(i,j,k) .eq. 0) then
            vt1=sqrt(vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2)
          
            if(vt1 .gt. 1.d0) then
              write(6,*) ' >> vt  > 1.0 in recov2da' &
                        ,' at i, j, k:',i, j, k
              write(6,*) ' >> vt', vt1 &
                        ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
              irecov(i,j,k)=3
            endif

            if(vt1 .lt. 0.d0) then
              write(6,*) ' >> vt  < 0.0 in recov2da' &
                        ,' at i, j, k:',i, j, k
              write(6,*) ' >> vt', vt1 &
                        ,', at x1, x2, x3:',x1(i),x2(j),x3(k)
              irecov(i,j,k)=3
            endif
         
          endif
!
        endif
!
      enddo
    enddo
  enddo

!---------------------------------------------------------------------@
!   Set Primitive variables
!---------------------------------------------------------------------@
!
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
       
        if(irecov(i,j,k) .eq. 0 .and. iflx(i,j,k) .eq. 0) then
         
          uri(1,i,j,k)=ro(i,j,k)
          uri(2,i,j,k)=vx(i,j,k)
          uri(3,i,j,k)=vy(i,j,k)
          uri(4,i,j,k)=vz(i,j,k)
          uri(5,i,j,k)=pp(i,j,k)
          uri(6,i,j,k)=uu(6,i,j,k)/dro(i,j,k)
          uri(7,i,j,k)=bx(i,j,k)
          uri(8,i,j,k)=by(i,j,k)
          uri(9,i,j,k)=bz(i,j,k)
        
        else
         
          uri(1,i,j,k)=ro1(i,j,k)
          uri(2,i,j,k)=vx1(i,j,k)
          uri(3,i,j,k)=vy1(i,j,k)
          uri(4,i,j,k)=vz1(i,j,k)
          uri(5,i,j,k)=pp1(i,j,k)
          uri(6,i,j,k)=uu(6,i,j,k)/dro(i,j,k)
          uri(7,i,j,k)=bx(i,j,k)
          uri(8,i,j,k)=by(i,j,k)
          uri(9,i,j,k)=bz(i,j,k)
         
        endif
        
      enddo
    enddo
  enddo
!
!=====================================================================@
!
  deallocate( dro, ee, tx, ty, tz, ro, pp, vx, vy, vz, vt, bx, by, bz, bsq, &
              ro1, pp1, vx1, vy1, vz1, psq, pb, pbsq, wg, wgd, del, irecov, &
              stat=merr )  
!
  return
end subroutine recov2da
!

