c***********************************************************************
c    3-dimensional General Relativistic MHD code 
c    Data production code for analysis
c     originally made by S. Koide, modified by Y. Mizuno
c***********************************************************************
c                                                            v. 08/08/27
c======================================================================@
c    Difinition for variables
c======================================================================@
c
      implicit real*8(a-h,o-z)
      parameter( pi=3.141592 )
      parameter( imax=128, jmax=7, kmax=256 )
      parameter( lmax=128, mmax=256, nmax=7 )
      parameter( nq=12, ns=7, nv=2, nnh=10 )
c
      parameter( ncol=40, nrow=20 )
      parameter(llmax=240,mmmax=60,nnmax=240)

      dimension xx(imax),yy(jmax),zz(kmax)
      dimension x1g(imax),x2g(jmax),x3g(kmax)
      dimension xw(lmax,mmax,nmax),yw(lmax,mmax,nmax)
     &    ,zw(lmax,mmax,nmax)
      dimension qq(nq,imax,jmax,kmax)
      dimension ff(ns,imax,jmax,kmax)
      dimension aa(2,3,imax,jmax,kmax)
      dimension fw(ns,lmax,mmax,nmax)
      dimension aw(2,3,lmax,mmax,nmax)
      dimension a2(lmax,mmax),bb(3,lmax,mmax)

      dimension fwk(lmax,mmax)
      dimension fxw(lmax,mmax),fyw(lmax,mmax)
c
      dimension ee(3,3,imax,jmax,kmax)
      dimension hh(3,imax,jmax,kmax)
c
      dimension hg(3,lmax,mmax)
c
      dimension fi(0:1,0:1,0:1)
      dimension wi(0:1,0:1,0:1)
c
      dimension fw2(ns,lmax,mmax)
      dimension aw2(2,3,lmax,mmax)
      dimension xw2(lmax,mmax),yw2(lmax,mmax),zw2(lmax,mmax)
      dimension ei(3,3,lmax,mmax,nmax)
      dimension ai(3)
      dimension han(2,3,lmax,mmax,nmax)
c
c----------------------------------------------------------------------@
c     Output variables for AVS (nq3d='a')
c----------------------------------------------------------------------@
c
c      real*4 xa1(lmax,mmax,nmax),xa2(lmax,mmax,nmax),
c     &     xa3(lmax,mmax,nmax)
c      real*4 b1(lmax,mmax,nmax),b2(lmax,mmax,nmax),
c     &     b3(lmax,mmax,nmax)
c      real*4 v1(lmax,mmax,nmax),v2(lmax,mmax,nmax),
c     &     v3(lmax,mmax,nmax)
c      real*4 dn(lmax,mmax,nmax),pr(lmax,mmax,nmax)
c
c      real*4 avsdn(llmax,mmmax,nnmax),avsbx(llmax,mmmax,nnmax),
c     &       avsby(llmax,mmmax,nnmax),avsbz(llmax,mmmax,nnmax),
c     &       avspr(llmax,mmmax,nnmax),avsvx(llmax,mmmax,nnmax),
c     &       avsvy(llmax,mmmax,nnmax),avsvz(llmax,mmmax,nnmax),
c     &       avsx1(llmax,mmmax,nnmax),avsx2(llmax,mmmax,nnmax),
c     &       avsx3(llmax,mmmax,nnmax)

      real*4 avsdna(llmax,nnmax,mmmax),avsbxa(llmax,nnmax,mmmax),
     &       avsbya(llmax,nnmax,mmmax),avsbza(llmax,nnmax,mmmax),
     &       avspra(llmax,nnmax,mmmax),avsvxa(llmax,nnmax,mmmax),
     &       avsvya(llmax,nnmax,mmmax),avsvza(llmax,nnmax,mmmax),
     &       avsxxa(llmax,nnmax,mmmax),avsxya(llmax,nnmax,mmmax),
     &       avsxza(llmax,nnmax,mmmax)
c----------------------------------------------------------------------@
c     Output variables for new IDL (nq3d='f')
c----------------------------------------------------------------------@
c
      dimension xxa(lmax,nmax,mmax),xya(lmax,nmax,mmax),
     &          xza(lmax,nmax,mmax),
     &          bxa(lmax,nmax,mmax),bya(lmax,nmax,mmax),
     &          bza(lmax,nmax,mmax),
     &          vxa(lmax,nmax,mmax),vya(lmax,nmax,mmax),
     &          vza(lmax,nmax,mmax),
     &          dna(lmax,nmax,mmax),pra(lmax,nmax,mmax)
                
      dimension xxa2(lmax,mmax),xya2(lmax,mmax),
     &          xza2(lmax,mmax),
     &          bxa2(lmax,mmax),bya2(lmax,mmax),
     &          bza2(lmax,mmax),
     &          vxa2(lmax,mmax),vya2(lmax,mmax),
     &          vza2(lmax,mmax),
     &          dna2(lmax,mmax),pra2(lmax,mmax)
     
      dimension xxa3(nmax,mmax),xya3(nmax,mmax),
     &          xza3(nmax,mmax),
     &          bxa3(nmax,mmax),bya3(nmax,mmax),
     &          bza3(nmax,mmax),
     &          vxa3(nmax,mmax),vya3(nmax,mmax),
     &          vza3(nmax,mmax),
     &          dna3(nmax,mmax),pra3(nmax,mmax)
     
      dimension xxa4(lmax,nmax),xya4(lmax,nmax),
     &          xza4(lmax,nmax),
     &          bxa4(lmax,nmax),bya4(lmax,nmax),
     &          bza4(lmax,nmax),
     &          vxa4(lmax,nmax),vya4(lmax,nmax),
     &          vza4(lmax,nmax),
     &          dna4(lmax,nmax),pra4(lmax,nmax)
c
c----------------------------------------------------------------------@
c     Output variables for 3Dkink hot plasma column (radial dist.)
c----------------------------------------------------------------------@

      dimension xr(imax,jmax,kmax),xp(imax,jmax,kmax),
     &          vr(imax,jmax,kmax),vp(imax,jmax,kmax),
     &          br(imax,jmax,kmax),bp(imax,jmax,kmax),
     &          bz(imax,jmax,kmax)
c      
c      dimension brz(imax,jmax),bpz(imax,jmax),
c     &          bzz(imax,jmax)
c          
c----------------------------------------------------------------------@
c
      integer*2 nwk(ncol)
      character*1 cwk(ncol)
      character*1 nq3d
c
      common /cxyz/ dx,dy,dz
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
      common /cmetric/ metric
      common /c3d/   nq3d
c
c======================================================================@
c     File Open
c======================================================================@
c
      open(unit=1,file='inkt',status='unknown')
      open(unit=6,file='kamt.outdat',status='unknown')
      open(unit=8,file='structr.outdat',status='unknown',
     &     form='unformatted')
c
      open(unit=201,file='tev.outdat',status='unknown')
      open(unit=202,file='teva.outdat',status='unknown')
c----------------------------------------------------------------------@
c     For IDL 
c----------------------------------------------------------------------@
      open(unit=11,file='ok1',status='unknown')
      open(unit=12,file='ok2',status='unknown')
      open(unit=13,file='ok3',status='unknown')
      open(unit=14,file='ok4',status='unknown')
      open(unit=15,file='ok5',status='unknown')
      open(unit=16,file='ok6',status='unknown')
      open(unit=17,file='ok7',status='unknown')
      open(unit=18,file='ok8',status='unknown')
      open(unit=19,file='ok9',status='unknown')
      open(unit=20,file='ok10',status='unknown')
      open(unit=21,file='ok11',status='unknown')
      open(unit=22,file='ok12',status='unknown')
      open(unit=23,file='ok13',status='unknown')
      open(unit=24,file='ok14',status='unknown')
      open(unit=25,file='ok15',status='unknown')
      open(unit=26,file='ok16',status='unknown')
      open(unit=27,file='ok17',status='unknown')
      open(unit=28,file='ok18',status='unknown')
      open(unit=29,file='ok19',status='unknown')
      open(unit=30,file='ok20',status='unknown')
      open(unit=31,file='ok21',status='unknown')
c      open(unit=32,file='ok22',status='unknown')
c      open(unit=33,file='ok23',status='unknown')
c      open(unit=34,file='ok24',status='unknown')
c      open(unit=35,file='ok25',status='unknown')
c      open(unit=36,file='ok26',status='unknown')
c      open(unit=37,file='ok27',status='unknown')
c      open(unit=38,file='ok28',status='unknown')
c      open(unit=39,file='ok29',status='unknown')
c      open(unit=40,file='ok30',status='unknown')
c      open(unit=41,file='ok31',status='unknown')
c      open(unit=42,file='ok32',status='unknown')
c      open(unit=43,file='ok33',status='unknown')
c      open(unit=44,file='ok34',status='unknown')
c      open(unit=45,file='ok35',status='unknown')
c      open(unit=46,file='ok36',status='unknown')
c      open(unit=47,file='ok37',status='unknown')
c      open(unit=48,file='ok38',status='unknown')
c      open(unit=49,file='ok39',status='unknown')
c      open(unit=50,file='ok40',status='unknown')
c      open(unit=51,file='ok41',status='unknown')
c      open(unit=52,file='ok42',status='unknown')
c      open(unit=53,file='ok43',status='unknown')
c      open(unit=54,file='ok44',status='unknown')
c      open(unit=55,file='ok45',status='unknown')
c      open(unit=56,file='ok46',status='unknown')
c      open(unit=57,file='ok47',status='unknown')
c      open(unit=58,file='ok48',status='unknown')
c      open(unit=59,file='ok49',status='unknown')
c      open(unit=60,file='ok50',status='unknown')
c      open(unit=61,file='ok51',status='unknown')
c      open(unit=62,file='ok52',status='unknown')
c      open(unit=63,file='ok53',status='unknown')
c      open(unit=64,file='ok54',status='unknown')
c      open(unit=65,file='ok55',status='unknown')
c      open(unit=66,file='ok56',status='unknown')
c      open(unit=67,file='ok57',status='unknown')
c      open(unit=68,file='ok58',status='unknown')
c      open(unit=69,file='ok59',status='unknown')
c      open(unit=70,file='ok60',status='unknown')
c      open(unit=71,file='ok61',status='unknown')
c      open(unit=72,file='ok62',status='unknown')
c      open(unit=73,file='ok63',status='unknown')
c      open(unit=74,file='ok64',status='unknown')
c      open(unit=75,file='ok65',status='unknown')
c      open(unit=76,file='ok66',status='unknown')
c      open(unit=77,file='ok67',status='unknown')
c      open(unit=78,file='ok68',status='unknown')
c      open(unit=79,file='ok69',status='unknown')
c      open(unit=80,file='ok70',status='unknown')
c      open(unit=81,file='ok71',status='unknown')
c      open(unit=82,file='ok72',status='unknown')
c      open(unit=83,file='ok73',status='unknown')
c      open(unit=84,file='ok74',status='unknown')
c      open(unit=85,file='ok75',status='unknown')
c      open(unit=86,file='ok76',status='unknown')
c      open(unit=87,file='ok77',status='unknown')
c      open(unit=88,file='ok78',status='unknown')
c      open(unit=89,file='ok79',status='unknown')
c      open(unit=90,file='ok80',status='unknown')
c      open(unit=91,file='ok81',status='unknown')
c      open(unit=92,file='ok82',status='unknown')
c      open(unit=93,file='ok83',status='unknown')
c      open(unit=94,file='ok84',status='unknown')
c      open(unit=95,file='ok85',status='unknown')
c      open(unit=96,file='ok86',status='unknown')
c      open(unit=97,file='ok87',status='unknown')
c      open(unit=98,file='ok88',status='unknown')
c      open(unit=99,file='ok89',status='unknown')
c      open(unit=100,file='ok90',status='unknown')
c      open(unit=101,file='ok91',status='unknown')
c      open(unit=102,file='ok92',status='unknown')
c      open(unit=103,file='ok93',status='unknown')
c      open(unit=104,file='ok94',status='unknown')
c      open(unit=105,file='ok95',status='unknown')
c      open(unit=106,file='ok96',status='unknown')
c      open(unit=107,file='ok97',status='unknown')
c      open(unit=108,file='ok98',status='unknown')
c      open(unit=109,file='ok99',status='unknown')
c      open(unit=110,file='ok100',status='unknown')
c      open(unit=111,file='ok101',status='unknown')
c      open(unit=112,file='ok102',status='unknown')
c      open(unit=113,file='ok103',status='unknown')
c      open(unit=114,file='ok104',status='unknown')
c      open(unit=115,file='ok105',status='unknown')
c      open(unit=116,file='ok106',status='unknown')
c      open(unit=117,file='ok107',status='unknown')
c      open(unit=118,file='ok108',status='unknown')
c      open(unit=119,file='ok109',status='unknown')
c      open(unit=120,file='ok110',status='unknown')
c      open(unit=121,file='ok111',status='unknown')
c      open(unit=122,file='ok112',status='unknown')
c      open(unit=123,file='ok113',status='unknown')
c      open(unit=124,file='ok114',status='unknown')
c      open(unit=125,file='ok115',status='unknown')
c      open(unit=126,file='ok116',status='unknown')
c      open(unit=127,file='ok117',status='unknown')
c      open(unit=128,file='ok118',status='unknown')
c      open(unit=129,file='ok119',status='unknown')
c      open(unit=130,file='ok120',status='unknown')
c
c----------------------------------------------------------------------@
c     For Radial profile of 3D hot plasma 
c----------------------------------------------------------------------@
c      open(unit=211,file='okr1',status='unknown')
c      open(unit=212,file='okr2',status='unknown')
c      open(unit=213,file='okr3',status='unknown')
c      open(unit=214,file='okr4',status='unknown')
c      open(unit=215,file='okr5',status='unknown')
c      open(unit=216,file='okr6',status='unknown')
c      open(unit=217,file='okr7',status='unknown')
c      open(unit=218,file='okr8',status='unknown')
c      open(unit=219,file='okr9',status='unknown')
c      open(unit=220,file='okr10',status='unknown')
c      open(unit=221,file='okr11',status='unknown')
c      open(unit=222,file='okr12',status='unknown')
c      open(unit=223,file='okr13',status='unknown')
c      open(unit=224,file='okr14',status='unknown')
c      open(unit=225,file='okr15',status='unknown')
c      open(unit=226,file='okr16',status='unknown')
c      open(unit=227,file='okr17',status='unknown')
c      open(unit=228,file='okr18',status='unknown')
c      open(unit=229,file='okr19',status='unknown')
c      open(unit=230,file='okr20',status='unknown')
c      open(unit=231,file='okr21',status='unknown')
c      open(unit=232,file='okr22',status='unknown')
c      open(unit=233,file='okr23',status='unknown')
c      open(unit=234,file='okr24',status='unknown')
c      open(unit=235,file='okr25',status='unknown')
c      open(unit=236,file='okr26',status='unknown')
c      open(unit=237,file='okr27',status='unknown')
c      open(unit=238,file='okr28',status='unknown')
c      open(unit=239,file='okr29',status='unknown')
c      open(unit=240,file='okr30',status='unknown')
c      open(unit=241,file='okr31',status='unknown')
c      open(unit=242,file='okr32',status='unknown')
c      open(unit=243,file='okr33',status='unknown')
c      open(unit=244,file='okr34',status='unknown')
c      open(unit=245,file='okr35',status='unknown')
c      open(unit=246,file='okr36',status='unknown')
c      open(unit=247,file='okr37',status='unknown')
c      open(unit=248,file='okr38',status='unknown')
c      open(unit=249,file='okr39',status='unknown')
c      open(unit=250,file='okr40',status='unknown')
c      open(unit=251,file='okr41',status='unknown')
c
c----------------------------------------------------------------------@
c     For AVS output
c----------------------------------------------------------------------@
c
c        open(unit=401,file='000/ro',status='unknown')
c        open(unit=402,file='000/vx',status='unknown')
c        open(unit=403,file='000/vy',status='unknown')
c        open(unit=404,file='000/vz',status='unknown')
c        open(unit=405,file='000/bx',status='unknown')
c        open(unit=406,file='000/by',status='unknown')
c        open(unit=407,file='000/bz',status='unknown')
c        open(unit=408,file='000/pr',status='unknown')
c        open(unit=409,file='000/coord1',status='unknown')
c        open(unit=410,file='000/coord2',status='unknown')
c        open(unit=411,file='000/coord3',status='unknown')
c        open(unit=412,file='000/time',status='unknown')
cc
c        open(unit=421,file='010/ro',status='unknown')
c        open(unit=422,file='010/vx',status='unknown')
c        open(unit=423,file='010/vy',status='unknown')
c        open(unit=424,file='010/vz',status='unknown')
c        open(unit=425,file='010/bx',status='unknown')
c        open(unit=426,file='010/by',status='unknown')
c        open(unit=427,file='010/bz',status='unknown')
c        open(unit=428,file='010/pr',status='unknown')
c        open(unit=429,file='010/coord1',status='unknown')
c        open(unit=430,file='010/coord2',status='unknown')
c        open(unit=431,file='010/coord3',status='unknown')
c        open(unit=432,file='010/time',status='unknown')
c
c        open(unit=441,file='020/ro',status='unknown')
c        open(unit=442,file='020/vx',status='unknown')
c        open(unit=443,file='020/vy',status='unknown')
c        open(unit=444,file='020/vz',status='unknown')
c        open(unit=445,file='020/bx',status='unknown')
c        open(unit=446,file='020/by',status='unknown')
c        open(unit=447,file='020/bz',status='unknown')
c        open(unit=448,file='020/pr',status='unknown')
c        open(unit=449,file='020/coord1',status='unknown')
c        open(unit=450,file='020/coord2',status='unknown')
c        open(unit=451,file='020/coord3',status='unknown')
c        open(unit=452,file='020/time',status='unknown')
c
c        open(unit=461,file='030/ro',status='unknown')
c        open(unit=462,file='030/vx',status='unknown')
c        open(unit=463,file='030/vy',status='unknown')
c        open(unit=464,file='030/vz',status='unknown')
c        open(unit=465,file='030/bx',status='unknown')
c        open(unit=466,file='030/by',status='unknown')
c        open(unit=467,file='030/bz',status='unknown')
c        open(unit=468,file='030/pr',status='unknown')
c        open(unit=469,file='030/coord1',status='unknown')
c        open(unit=470,file='030/coord2',status='unknown')
c        open(unit=471,file='030/coord3',status='unknown')
c        open(unit=472,file='030/time',status='unknown')
c
c        open(unit=481,file='040/ro',status='unknown')
c        open(unit=482,file='040/vx',status='unknown')
c        open(unit=483,file='040/vy',status='unknown')
c        open(unit=484,file='040/vz',status='unknown')
c        open(unit=485,file='040/bx',status='unknown')
c        open(unit=486,file='040/by',status='unknown')
c        open(unit=487,file='040/bz',status='unknown')
c        open(unit=488,file='040/pr',status='unknown')
c        open(unit=489,file='040/coord1',status='unknown')
c        open(unit=490,file='040/coord2',status='unknown')
c        open(unit=491,file='040/coord3',status='unknown')
c        open(unit=492,file='040/time',status='unknown')
c
c        open(unit=501,file='050/ro',status='unknown')
c        open(unit=502,file='050/vx',status='unknown')
c        open(unit=503,file='050/vy',status='unknown')
c        open(unit=504,file='050/vz',status='unknown')
c        open(unit=505,file='050/bx',status='unknown')
c        open(unit=506,file='050/by',status='unknown')
c        open(unit=507,file='050/bz',status='unknown')
c        open(unit=508,file='050/pr',status='unknown')
c        open(unit=509,file='050/coord1',status='unknown')
c        open(unit=510,file='050/coord2',status='unknown')
c        open(unit=511,file='050/coord3',status='unknown')
c        open(unit=512,file='050/time',status='unknown')
c
c        open(unit=521,file='060/ro',status='unknown')
c        open(unit=522,file='060/vx',status='unknown')
c        open(unit=523,file='060/vy',status='unknown')
c        open(unit=524,file='060/vz',status='unknown')
c        open(unit=525,file='060/bx',status='unknown')
c        open(unit=526,file='060/by',status='unknown')
c        open(unit=527,file='060/bz',status='unknown')
c        open(unit=528,file='060/pr',status='unknown')
c        open(unit=529,file='060/coord1',status='unknown')
c        open(unit=530,file='060/coord2',status='unknown')
c        open(unit=531,file='060/coord3',status='unknown')
c        open(unit=532,file='060/time',status='unknown')
c
c        open(unit=541,file='070/ro',status='unknown')
c        open(unit=542,file='070/vx',status='unknown')
c        open(unit=543,file='070/vy',status='unknown')
c        open(unit=544,file='070/vz',status='unknown')
c        open(unit=545,file='070/bx',status='unknown')
c        open(unit=546,file='070/by',status='unknown')
c        open(unit=547,file='070/bz',status='unknown')
c        open(unit=548,file='070/pr',status='unknown')
c        open(unit=549,file='070/coord1',status='unknown')
c        open(unit=550,file='070/coord2',status='unknown')
c        open(unit=551,file='070/coord3',status='unknown')
c        open(unit=552,file='070/time',status='unknown')
c
c        open(unit=561,file='080/ro',status='unknown')
c        open(unit=562,file='080/vx',status='unknown')
c        open(unit=563,file='080/vy',status='unknown')
c        open(unit=564,file='080/vz',status='unknown')
c        open(unit=565,file='080/bx',status='unknown')
c        open(unit=566,file='080/by',status='unknown')
c        open(unit=567,file='080/bz',status='unknown')
c        open(unit=568,file='080/pr',status='unknown')
c        open(unit=569,file='080/coord1',status='unknown')
c        open(unit=570,file='080/coord2',status='unknown')
c        open(unit=571,file='080/coord3',status='unknown')
c        open(unit=572,file='080/time',status='unknown')
c
c        open(unit=581,file='090/ro',status='unknown')
c        open(unit=582,file='090/vx',status='unknown')
c        open(unit=583,file='090/vy',status='unknown')
c        open(unit=584,file='090/vz',status='unknown')
c        open(unit=585,file='090/bx',status='unknown')
c        open(unit=586,file='090/by',status='unknown')
c        open(unit=587,file='090/bz',status='unknown')
c        open(unit=588,file='090/pr',status='unknown')
c        open(unit=589,file='090/coord1',status='unknown')
c        open(unit=590,file='090/coord2',status='unknown')
c        open(unit=591,file='090/coord3',status='unknown')
c        open(unit=592,file='090/time',status='unknown')
c        
c        open(unit=601,file='100/ro',status='unknown')
c        open(unit=602,file='100/vx',status='unknown')
c        open(unit=603,file='100/vy',status='unknown')
c        open(unit=604,file='100/vz',status='unknown')
c        open(unit=605,file='100/bx',status='unknown')
c        open(unit=606,file='100/by',status='unknown')
c        open(unit=607,file='100/bz',status='unknown')
c        open(unit=608,file='100/pr',status='unknown')
c        open(unit=609,file='100/coord1',status='unknown')
c        open(unit=610,file='100/coord2',status='unknown')
c        open(unit=611,file='100/coord3',status='unknown')
c        open(unit=612,file='100/time',status='unknown')
c
c----------------------------------------------------------------------@
c
c
c     metric      coordinates                       1996.06.14(Fri)
c
c          1  :   Cartesian
c          2  :   cylindrical
c          3  :   polar
c
      metric=1
c
c
      pcheck=0
      pmin=1.e-3
c
      ifile=1
      nfile=10000
c
      iavs=0
c
      xmin=-5.0
      xmax=5.0
      ymin=0.0
      ymax=10.0
      zmin=-5.0
      zmax=5.0
c
      x0=-5.0
      y0=0.0
      z0=0.0
      x1=5.0
      y1=y0
      z1=z0
      x2=x0
      y2=10.0
      z2=z0
      x3=x0
      y3=y0
      z3=10.0
c
c
      nh=1
      nt=0
      nt0=0     
      nwagir=1
c
c      nq3d = ' '      : coordinates and density
c      nq3d = 's'      : scalar quantities (density, pressure, ink?)
c      nq3d = 'v'      : velocity and density
c      nq3d = 'b'      : magnetic field and pressure 
c      nq3d = '2'      : 2-dimensional analysis
c      nq3d = 'e'      : every components (coordinates, scalar quantities) 
c      nq3d = 'f'      : 3D data output for IDL (x,y,z)=(l,n,m)
c      nq3d = 'a'      : 3D output for AVS (x,y,z)
c      nq3d = 'g'      : 2D data output for IDL (x,z)=(l,m), y=ymax/2
c      nq3d = 'h'      : 2D data output for IDL (y,z)=(n,m), x=xmax/2
c      nq3d = 'i'      : 2D data output for IDL (x,y)=(l,n), z=zmax/2
c
      read(1,*) nh,metric

      write(6,*) ' number of historical section:', nh
c
c**********************************************************************@
c     Main Loop1 Start 
c**********************************************************************@
c
      do 1100 ih=1,nh
c
c======================================================================@
c     Read setting of output from inkt and data from structr.outdat
c======================================================================@
c
c      if(ih.ge.2) rewind(8)
       nt0=nt
       read(1,*) nt, xmin,xmax,ymin,ymax,zmin,zmax
       read(1,*) nwagir, nq3d
       write(6,*) ' nt:',nt
       write(6,*) 'xmax,xmin,ymax,ymin,zmax,zmin'
       write(6,800) xmax,xmin,ymax,ymin,zmax,zmin
       write(6,*) ' number of cross-section:', nwagir
     &           ,',   nq3d =',nq3d
c
      if( ih+nwagir.gt.nfile ) then
       write(6,*) 'Koide: nwagir must not be greater than nfile'
       write(6,*) 'Koide: STOP at main'
       stop
      endif 
c
c     Clear
c
      do 170 k=1,kmax
       do 170 j=1,jmax
        do 170 i=1,imax
         do 170 n=1,nq
          qq(n,i,j,k)=0.0
 170  continue
c
      do 180 n=1,nmax
       do 180 m=1,mmax
        do 180 l=1,lmax
         do 181 is=1,ns
          fw(is,l,m,n)=0.0
 181     continue
          aw(1,1,l,m,n)=0.0
          aw(1,2,l,m,n)=0.0
          aw(1,3,l,m,n)=0.0
          aw(2,1,l,m,n)=0.0
          aw(2,2,l,m,n)=0.0
          aw(2,3,l,m,n)=0.0
 180  continue
c
      if( nt.lt.nt0 ) then
       rewind(8)
       do 130 it=1,nt
       read(8,end=140) time
        do 120 i=1,imax
         do 110 j=1,jmax
          do 100 k=1,kmax
           read(8,end=142) (qq(n,i,j,k),n=1,nq)
 100      continue
 110     continue
 120    continue
 130   continue
      elseif( nt.gt.nt0 ) then
       do 131 it=1,nt-nt0
       read(8,end=140) time
        do 121 i=1,imax
         do 111 j=1,jmax
          do 101 k=1,kmax
           read(8,end=142) (qq(n,i,j,k),n=1,nq)
 101      continue
 111     continue
 121    continue
 131  continue
      endif
c
      go to 164
c 
 142  continue
      write(6,*) 'file end found during reading ONE PROFILE'
      write(6,*) ' it =',it,' i =',i,' j =',j,' k =',k
      write(6,*) 'STOP at MAIN'
      stop
c
 140  continue
      write(6,*) 'file end found during reading'
      write(6,*) ' it =',it,' i =',i,' j =',j,' k =',k
      write(6,*) 'continue process'
c 
 164  continue
c----------------------------------------------------------------------@
c
      do 161 i=1,imax
       xx(i)=qq(1,i,1,1)
       xmin=min(xmin,xx(i))
       xmax=max(xmax,xx(i))
 161  continue
c
      do 162 j=1,jmax
       yy(j)=qq(2,1,j,1)
       ymin=min(ymin,yy(j))
       ymax=max(ymax,yy(j))
 162  continue
c
      do 163 k=1,kmax
       zz(k)=qq(3,1,1,k)
       zmin=min(zmin,zz(k))
       zmax=max(zmax,zz(k))
 163  continue
c                                               2000.07.21
      xmin=xx(1)
      xmax=xx(imax)
      ymin=yy(1)
      ymax=yy(jmax)
      zmin=zz(1)
      zmax=zz(kmax)
c
      if( metric.ne.1 .and. zmax.lt.0.6*pi ) then
       write(6,*) 'WARNING: We assume Mirror Symmetry with z=0 plane'
      endif
c
      dx=(xmax-xmin)/(imax-1)
      dy=(ymax-ymin)/(jmax-1)
      dz=(zmax-zmin)/(kmax-1)
c
      do 171 i=1,imax
       x1g(i)=xmin+dx*float(i-1)
 171  continue
      do 172 j=1,jmax
       x2g(j)=ymin+dy*float(j-1)
 172  continue
      do 173 k=1,kmax
       x3g(k)=zmin+dz*float(k-1)
 173  continue
c
      if( metric.eq.3 ) then
       call polmet(hh,xx,yy,zz,imax,jmax,kmax)
       call pole(ee,xx,yy,zz,imax,jmax,kmax)
      elseif( metric.eq.2 ) then
       call cylmet(hh,xx,yy,zz,imax,jmax,kmax)
       call cyle(ee,xx,yy,zz,imax,jmax,kmax)
      elseif( metric.eq.1 ) then
       call catmet(hh,xx,yy,zz,imax,jmax,kmax)
       call cate(ee,xx,yy,zz,imax,jmax,kmax)
      endif
c**********************************************************************@
c     Main Loop2 Start
c**********************************************************************@
c
      do 1000 iwagir=1,nwagir
c
c======================================================================@
c     Read Plot Setting from inkt
c======================================================================@
c
      read(1,*) x0,y0,z0
      read(1,*) x1,y1,z1
      read(1,*) x2,y2,z2
      read(1,*) x3,y3,z3
      write(6,*) ' x0, y0, z0',x0,y0,z0
      write(6,*) ' x1, y1, z1',x1,y1,z1
      write(6,*) ' x2, y2, z2',x2,y2,z2
      write(6,*) ' x3, y3, z3',x3,y3,z3
c
c=======================================================================
      do 160 k=1,kmax
       do 160 j=1,jmax
        do 160 i=1,imax
c
c x1,x2,x3 position
c
            ff(1,i,j,k)=qq(1,i,j,k)
            ff(2,i,j,k)=qq(2,i,j,k)
            ff(3,i,j,k)=qq(3,i,j,k)
c
c density
c
c            ff(4,i,j,k)=log10(max(1.d-20,qq(4,i,j,k)))
            ff(4,i,j,k)=qq(4,i,j,k)
c           ff(4,i,j,k)=log10(dmax(1.e-20,qq(4,i,j,k)))
c          qmaxv=max(1.e-20,qq(4,i,j,k))
c          ff(4,i,j,k)=log10(qmaxv)
c
c pressure
c
            ff(5,i,j,k)=qq(8,i,j,k)
c ink
            ff(6,i,j,k)=qq(9,i,j,k)
c
c velocity
c
            aa(1,1,i,j,k)=qq(5,i,j,k)
            aa(1,2,i,j,k)=qq(6,i,j,k)
            aa(1,3,i,j,k)=qq(7,i,j,k)
c
c magnetic field
c
            aa(2,1,i,j,k)=qq(10,i,j,k)
            aa(2,2,i,j,k)=qq(11,i,j,k)
            aa(2,3,i,j,k)=qq(12,i,j,k)
c


 160  continue
c
c=======================================================================
c
c     Wagiri Shori
c
      au=sqrt((x1-x0)**2+(y1-y0)**2+(z1-z0)**2)
      av=sqrt((x2-x0)**2+(y2-y0)**2+(z2-z0)**2)
      at=sqrt((x3-x0)**2+(y3-y0)**2+(z3-z0)**2)
c
      if( au .eq. 0.0d0 ) then
       write(6,*) 'longitudinal width is zero : au=0'
       write(6,*) 'STOP at main'
       stop
      endif
c
      if( av .eq. 0.0d0 ) then
       write(6,*) 'latitude width is zero : av=0'
       write(6,*) 'STOP at main'
       stop
      endif
c      
      if( at .eq. 0.0d0 ) then
       write(6,*) 'latitude width is zero : at=0'
       write(6,*) 'STOP at main'
       stop
      endif
c      
      unx=(x1-x0)/au
      uny=(y1-y0)/au
      unz=(z1-z0)/au
c
      vnx=(x2-x0)/av
      vny=(y2-y0)/av
      vnz=(z2-z0)/av
c
      tnx=(x3-x0)/at
      tny=(y3-y0)/at
      tnz=(z3-z0)/at
c
      anx=uny*vnz-unz*vny
      any=unz*vnx-unx*vnz
      anz=unx*vny-uny*vnx
      ana=sqrt(anx*anx+any*any+anz*anz)
c
      if( ana .eq. 0.0d0 ) then
       write(6,*) ' normal vector zero : ana = 0 '
       write(6,*) 'STOP at main'
       stop
      endif
c
      anx=anx/ana
      any=any/ana
      anz=anz/ana
c
      if( tnx.ne.anx .or. tny.ne.any .or. tnz.ne.anz ) then
       write(6,*) ' Warning: tnx.ne.anx .or. tny.ne.any .or. tnz.ne.anz'
       write(6,*) 'tnx, anx:',tnx,anx
       write(6,*) 'tny, any:',tny,any
       write(6,*) 'tnz, anz:',tnz,anz
      endif
c
c     Autmatic region setting                       1995.12.19
      umin=x0*unx+y0*uny+z0*unz
      umax=x1*unx+y1*uny+z1*unz
      vmin=x0*vnx+y0*vny+z0*vnz
      vmax=x2*vnx+y2*vny+z2*vnz
      tmin=x0*tnx+y0*tny+z0*tnz
      tmax=x3*tnx+y3*tny+z3*tnz
c
      dux=(x1-x0)/(lmax-1)
      duy=(y1-y0)/(lmax-1)
      duz=(z1-z0)/(lmax-1)
c
      dvx=(x2-x0)/(mmax-1)
      dvy=(y2-y0)/(mmax-1)
      dvz=(z2-z0)/(mmax-1)
c
      if( nmax.gt.1 ) then
       dtx=(x3-x0)/max(1,nmax-1)
       dty=(y3-y0)/max(1,nmax-1)
       dtz=(z3-z0)/max(1,nmax-1)
      else
       dtx=0.0d0
       dty=0.0d0
       dtz=0.0d0
      endif
c
ca    call calei(ei,lmax,mmax,nmax,x0,y0,z0,x1,y1,z1,x2,y2,z2,x3,y3,z3)
      call calei(ei,han,lmax,mmax,nmax,
     &                             x0,y0,z0,x1,y1,z1,x2,y2,z2,x3,y3,z3)
c      
      if( nq3d.ne.'2' ) then
       nnnmin=1
       nnnmax=nmax
      else
c       nnnmin=nmax/2
c       nnnmax=nmax/2
       nnnmin=(nmax/2)+1
       nnnmax=(nmax/2)+1
       dtx=0.0d0
       dty=0.0d0
       dtz=0.0d0
      endif
c
      do 300 nnn=nnnmin,nnnmax
       do 300 m=1,mmax
        do 300 l=1,lmax

         xxx=x0+dux*(l-1)+dvx*(m-1)+dtx*(nnn-1)
         yyy=y0+duy*(l-1)+dvy*(m-1)+dty*(nnn-1)
         zzz=z0+duz*(l-1)+dvz*(m-1)+dtz*(nnn-1)
c
         if( metric.eq.2 ) then
          xx1=x1umcy(xxx,yyy,zzz)
          xx2=x2umcy(xxx,yyy,zzz)
          xx3=x3umcy(xxx,yyy,zzz)
         elseif( metric.eq.1 ) then
          xx1=xxx
          xx2=yyy
          xx3=zzz
         elseif( metric.eq.3 ) then
          xx1=x1umpo(xxx,yyy,zzz)
          xx2=x2umpo(xxx,yyy,zzz)
          xx3=x3umpo(xxx,yyy,zzz)
         endif
c
         xw(l,m,nnn)=xxx
         yw(l,m,nnn)=yyy
         zw(l,m,nnn)=zzz
c
co       i=int(0.5+(xx1-xmin)/dx)
co       j=int(0.5+(xx2-ymin)/dy)
co       k=int(0.5+(xx3-zmin)/dz)
         i=int((xx1-xmin)/dx)
         j=int((xx2-ymin)/dy)
         k=int((xx3-zmin)/dz)
c         i=int((xx1-xmin)/dx)+1
c         j=int((xx2-ymin)/dy)+1
c         k=int((xx3-zmin)/dz)+1

c                                               1996.12.01>2000.07.21
         if(i.lt.1) i=1
         if(j.lt.1) j=1
         if(k.lt.1) k=1
         if(i.ge.imax) i=imax-1
         if(j.ge.jmax) j=jmax-1
         if(k.ge.kmax) k=kmax-1
c                                                   1996.10.26
ci       if(xx1.gt.xmax) i=imax+1
ci       if(xx2.gt.ymax) j=jmax+1
ci       if(xx3.gt.zmax) k=kmax+1
c
         if( 1.le.i .and. i.le.imax-1 .and. 
     &      1.le.j .and. j.le.jmax-1 .and.
     &      1.le.k .and. k.le.kmax-1 ) then
c                                                      1998.03.23(Mon)
c
          vvv=(x1g(i+1)-x1g(i))*(x2g(j+1)-x2g(j))*(x3g(k+1)-x3g(k))
          re1=xx1-x1g(i)
          re2=xx2-x2g(j)
          re3=xx3-x3g(k)
          fo1=x1g(i+1)-xx1
          fo2=x2g(j+1)-xx2
          fo3=x3g(k+1)-xx3
          wi(0,0,0)=fo1*fo2*fo3/vvv
          wi(1,0,0)=re1*fo2*fo3/vvv
          wi(0,1,0)=fo1*re2*fo3/vvv
          wi(1,1,0)=re1*re2*fo3/vvv
          wi(0,0,1)=fo1*fo2*re3/vvv
          wi(1,0,1)=re1*fo2*re3/vvv
          wi(0,1,1)=fo1*re2*re3/vvv
          wi(1,1,1)=re1*re2*re3/vvv
c
          do 310 n=1,ns
           fi(0,0,0)=ff(n,i,j,k)
           fi(0,0,1)=ff(n,i,j,k+1)
           fi(0,1,0)=ff(n,i,j+1,k)
           fi(0,1,1)=ff(n,i,j+1,k+1)
           fi(1,0,0)=ff(n,i+1,j,k)
           fi(1,0,1)=ff(n,i+1,j,k+1)
           fi(1,1,0)=ff(n,i+1,j+1,k)
           fi(1,1,1)=ff(n,i+1,j+1,k+1)

           fw(n,l,m,nnn)=fi(0,0,0)*wi(0,0,0)+fi(1,0,0)*wi(1,0,0)
     1             +fi(0,1,0)*wi(0,1,0)+fi(1,1,0)*wi(1,1,0)
     1             +fi(0,0,1)*wi(0,0,1)+fi(1,0,1)*wi(1,0,1)
     1             +fi(0,1,1)*wi(0,1,1)+fi(1,1,1)*wi(1,1,1)
co          fw(n,l,m)=ff(n,i,j,k)
 310      continue
c
          i0=i
          j0=j
          k0=k
c
          do 320 n=1,2
           do 720 k=k0,k0+1
            do 720 j=j0,j0+1
             do 720 i=i0,i0+1
              fi(i-i0,j-j0,k-k0)=aa(n,1,i,j,k)
 720       continue
c
           ai(1)=fi(0,0,0)*wi(0,0,0)+fi(1,0,0)*wi(1,0,0)
     1             +fi(0,1,0)*wi(0,1,0)+fi(1,1,0)*wi(1,1,0)
     1             +fi(0,0,1)*wi(0,0,1)+fi(1,0,1)*wi(1,0,1)
     1             +fi(0,1,1)*wi(0,1,1)+fi(1,1,1)*wi(1,1,1)
c
           do 730 k=k0,k0+1
            do 730 j=j0,j0+1
             do 730 i=i0,i0+1
              fi(i-i0,j-j0,k-k0)=aa(n,2,i,j,k)
 730       continue
c
           ai(2)=fi(0,0,0)*wi(0,0,0)+fi(1,0,0)*wi(1,0,0)
     1             +fi(0,1,0)*wi(0,1,0)+fi(1,1,0)*wi(1,1,0)
     1             +fi(0,0,1)*wi(0,0,1)+fi(1,0,1)*wi(1,0,1)
     1             +fi(0,1,1)*wi(0,1,1)+fi(1,1,1)*wi(1,1,1)
c
           do 740 k=k0,k0+1
            do 740 j=j0,j0+1
             do 740 i=i0,i0+1
              fi(i-i0,j-j0,k-k0)=aa(n,3,i,j,k)
 740       continue
c
           ai(3)=fi(0,0,0)*wi(0,0,0)+fi(1,0,0)*wi(1,0,0)
     1             +fi(0,1,0)*wi(0,1,0)+fi(1,1,0)*wi(1,1,0)
     1             +fi(0,0,1)*wi(0,0,1)+fi(1,0,1)*wi(1,0,1)
     1             +fi(0,1,1)*wi(0,1,1)+fi(1,1,1)*wi(1,1,1)
c
           ai(1)=ai(1)*han(n,1,l,m,nnn)
           ai(2)=ai(2)*han(n,2,l,m,nnn)
           ai(3)=ai(3)*han(n,3,l,m,nnn)
c
           aw(n,1,l,m,nnn)=(
     &           ai(1)*ei(1,1,l,m,nnn)
     &          +ai(2)*ei(2,1,l,m,nnn)
     &          +ai(3)*ei(3,1,l,m,nnn)
     &                  )*unx
     &          +(
     &           ai(1)*ei(1,2,l,m,nnn)
     &          +ai(2)*ei(2,2,l,m,nnn)
     &          +ai(3)*ei(3,2,l,m,nnn)
     &                  )*uny
     &          +(
     &           ai(1)*ei(1,3,l,m,nnn)
     &          +ai(2)*ei(2,3,l,m,nnn)
     &          +ai(3)*ei(3,3,l,m,nnn)
     &                  )*unz
c
           aw(n,2,l,m,nnn)=(
     &           ai(1)*ei(1,1,l,m,nnn)
     &          +ai(2)*ei(2,1,l,m,nnn)
     &          +ai(3)*ei(3,1,l,m,nnn)
     &                  )*vnx
     &         +(
     &           ai(1)*ei(1,2,l,m,nnn)
     &          +ai(2)*ei(2,2,l,m,nnn)
     &          +ai(3)*ei(3,2,l,m,nnn)
     &                  )*vny
     &         +(
     &           ai(1)*ei(1,3,l,m,nnn)
     &          +ai(2)*ei(2,3,l,m,nnn)
     &          +ai(3)*ei(3,3,l,m,nnn)
     &                  )*vnz
c
           aw(n,3,l,m,nnn)=(
     &           ai(1)*ei(1,1,l,m,nnn)
     &          +ai(2)*ei(2,1,l,m,nnn)
     &          +ai(3)*ei(3,1,l,m,nnn)
     &                  )*anx
     &         +(
     &           ai(1)*ei(1,2,l,m,nnn)
     &          +ai(2)*ei(2,2,l,m,nnn)
     &          +ai(3)*ei(3,2,l,m,nnn)
     &                  )*any
     &         +(
     &           ai(1)*ei(1,3,l,m,nnn)
     &          +ai(2)*ei(2,3,l,m,nnn)
     &          +ai(3)*ei(3,3,l,m,nnn)
     &                  )*anz
c
 320      continue
         else
          do 330 n=1,ns
           fw(n,l,m,nnn)=0.0d0
 330      continue
c
           aw(1,1,l,m,nnn)=0.0d0
           aw(1,2,l,m,nnn)=0.0d0
           aw(1,3,l,m,nnn)=0.0d0
           aw(2,1,l,m,nnn)=0.0d0
           aw(2,2,l,m,nnn)=0.0d0
           aw(2,3,l,m,nnn)=0.0d0
         endif

c           if(m.ge.198 .and. m.le.200 .and. l .eq. 3) then
c              write(*,*) 'after convert'
c              write(*,*) 'l,zz,ro=', l, zw(l,m,nnn),fw(4,l,m,nnn)
c           endif

 300  continue
c
      if( metric.ne.1 ) then
       if( zmax.le.0.6*3.14159 ) then
cz      call vhant(aw,xw,yw,zw,nv,lmax,mmax,nmax)
       endif
      endif
c
      call t3d2d(aw,fw,xw,yw,zw,aw2,fw2,xw2,yw2,zw2
     &                         ,ns,lmax,mmax,nmax)
c
ca    if( metric.ne.1 ) then
ca     call vhan(aw2,xw2,yw2,zw2,nv,lmax,mmax)
ca    endif
c
cd      call caa2cn(aw2,fw2,7,ns,lmax,mmax,xw2,yw2,zw2,bb,a2)
cd      call cala2c(aw2,fw2,7,ns,lmax,mmax,xw2,yw2,zw2,bb,a2)
c
c  --- Calculation of vector potential from B-field ----
c
        call caa2cn(aw2,fw2,7,ns,lmax,mmax,xw2,yw2,zw2,bb,a2)
c
c  --- Write each time slice data ----
c
c     if( nmax.eq.0 .or. nq3d.eq.'2' ) then
      
      if( nq3d.eq.'2' ) then
       do 200 m=1,mmax
        do 200 l=1,lmax
         write(10+ifile,800)  xw2(l,m),yw2(l,m),zw2(l,m)
     &            ,aw2(1,1,l,m),aw2(1,2,l,m),aw2(1,3,l,m)
     &            ,aw2(2,1,l,m),aw2(2,2,l,m),aw2(2,3,l,m)
     &            ,fw2(4,l,m),fw2(5,l,m),fw2(6,l,m),fw2(7,l,m)
 200   continue
       
       write(10+ifile,*) time,'   time'
       write(10+ifile,801) umin, umax, vmin, vmax, tmin, tmax
       
      elseif( nq3d.ne.'a' .and. nq3d.ne.'f' .and. nq3d.ne.'g'
     &        .and. nq3d.ne.'h' .and. nq3d.ne.'i') then
c
       do 210 n=1,nmax
        do 210 m=1,mmax
         do 210 l=1,lmax
        
         if( nq3d.eq.' ' ) then
          write(10+ifile,800) xw(l,m,n),yw(l,m,n),zw(l,m,n)
     &                       ,fw(4,l,m,n)
         elseif( nq3d.eq.'v' ) then
          write(10+ifile,800) aw(1,1,l,m,n),aw(1,2,l,m,n),aw(1,3,l,m,n)
     &                       ,fw(4,l,m,n)
     &                       ,xw(l,m,n),yw(l,m,n),zw(l,m,n)
         elseif( nq3d.eq.'e')  then       
          write(10+ifile,800) xw(l,m,n),yw(l,m,n),zw(l,m,n)
     &            ,aw(1,1,l,m,n),aw(1,2,l,m,n),aw(1,3,l,m,n)
     &            ,aw(2,1,l,m,n),aw(2,2,l,m,n),aw(2,3,l,m,n)
     &            ,fw(4,l,m,n),fw(5,l,m,n)
         
c         elseif( nq3d .eq. 'a' .or. nq3d .eq. 'f' ) then
c
cy          xa1(l,m,n)=xw(l,m,n)
cy          xa2(l,m,n)=yw(l,m,n)
cy          xa3(l,m,n)=zw(l,m,n)
cy          v1(l,m,n)=aw(1,1,l,m,n)
cy          v2(l,m,n)=aw(1,2,l,m,n)
cy          v3(l,m,n)=aw(1,3,l,m,n)
cy          b1(l,m,n)=aw(2,1,l,m,n)
cy          b2(l,m,n)=aw(2,2,l,m,n)
cy          b3(l,m,n)=aw(2,3,l,m,n)
cy          dn(l,m,n)=fw(4,l,m,n)
cy          pr(l,m,n)=fw(5,l,m,n)
          
         endif
c
 210  continue
 
       write(6,*) ' read time =',time
       write(6,*) ' read xmin, xmax, ymin, ymax, zmin, zmax'
       write(6,800) xmin, xmax, ymin, ymax, zmin, zmax
       
       write(10+ifile,*) time,'   time'
       write(10+ifile,801) umin, umax, vmin, vmax, tmin, tmax
cy       write(10+ifile,*) 'umin, umax, vmin, vmax, tmin, tmax'

      endif
c
c-----------------------------------------------------------------------
c   Data output for new IDL 
c-----------------------------------------------------------------------
      if(nq3d.eq.'f') then
      
       do 221 m=1,mmax
        do 221 n=1,nmax
         do 221 l=1,lmax
         
           dna(l,n,m) =fw(4,l,m,n)
           pra(l,n,m) =fw(5,l,m,n)
           
           bxa(l,n,m) =aw(2,1,l,m,n)
           bya(l,n,m) =-aw(2,3,l,m,n)
           bza(l,n,m) =aw(2,2,l,m,n)

           if(metric .eq. 1) then
            vxa(l,n,m) =aw(1,1,l,m,n)
            vya(l,n,m) =-aw(1,3,l,m,n)  
           
           elseif(metric .eq. 2) then
            
            if(yw(l,m,n) .ge. 0.0) then
             vxa(l,n,m) =aw(1,1,l,m,n)
             vya(l,n,m) =-aw(1,3,l,m,n)
            else
             vxa(l,n,m) =-aw(1,1,l,m,n)
             vya(l,n,m) =aw(1,3,l,m,n)           
            endif

           endif
           
           vza(l,n,m) =aw(1,2,l,m,n)
           
           xxa(l,n,m) =xw(l,m,n)
           xya(l,n,m) =yw(l,m,n)
           xza(l,n,m) =zw(l,m,n)

  221  continue

       do 222 m=1,mmax
        do 222 n=1,nmax
         do 222 l=1,lmax
          
          write(10+ifile,800) xxa(l,n,m),xya(l,n,m),xza(l,n,m)
     &            ,vxa(l,n,m),vya(l,n,m),vza(l,n,m)
     &            ,bxa(l,n,m),bya(l,n,m),bza(l,n,m)
     &            ,dna(l,n,m),pra(l,n,m)

  222  continue

       write(6,*) ' read time =',time
       write(6,*) ' read xmin, xmax, ymin, ymax, zmin, zmax'
       write(6,800) xmin, xmax, ymin, ymax, zmin, zmax
       
       write(10+ifile,*) time,'   time'
       write(10+ifile,801) umin, umax, vmin, vmax, tmin, tmax

      endif
      
      if(nq3d .eq. 'g') then
      
       nn2=nmax/2+1
       
       do 223 m=1,mmax
        do 223 l=1,lmax
          
          dna2(l,m) =fw(4,l,m,nn2)
          pra2(l,m) =fw(5,l,m,nn2)
          
          bxa2(l,m) =aw(2,1,l,m,nn2)
          bya2(l,m) =-aw(2,3,l,m,nn2)
          bza2(l,m) =aw(2,2,l,m,nn2)

          if(metric .eq. 1) then
           vxa2(l,m) =aw(1,1,l,m,nn2)
           vya2(l,m) =-aw(1,3,l,m,nn2)  
           
          elseif(metric .eq. 2) then
           
           if(yw(l,m,nn2) .ge. 0.0d0) then
            vxa2(l,m) =aw(1,1,l,m,nn2)
            vya2(l,m) =-aw(1,3,l,m,nn2)
           else
            vxa2(l,m) =-aw(1,1,l,m,nn2)
            vya2(l,m) =aw(1,3,l,m,nn2)           
           endif

          endif
           
          vza2(l,m) =aw(1,2,l,m,nn2)
           
          xxa2(l,m) =xw(l,m,nn2)
          xya2(l,m) =yw(l,m,nn2)
          xza2(l,m) =zw(l,m,nn2)

  223  continue

       do 224 m=1,mmax
        do 224 l=1,lmax
c          
          write(10+ifile,800) xxa2(l,m),xya2(l,m),xza2(l,m)
     &            ,vxa2(l,m),vya2(l,m),vza2(l,m)
     &            ,bxa2(l,m),bya2(l,m),bza2(l,m)
     &            ,dna2(l,m),pra2(l,m)

  224  continue

c       write(6,*) ' read time =',time
c       write(6,*) ' read xmin, xmax, ymin, ymax, zmin, zmax'
c       write(6,800) xmin, xmax, ymin, ymax, zmin, zmax
c       
       write(10+ifile,*) time,'   time'
       write(10+ifile,801) umin, umax, vmin, vmax, tmin, tmax

      endif

      if(nq3d .eq. 'h') then
      
       ll2=lmax/2+1
       
       do 225 m=1,mmax
        do 225 n=1,nmax
          
          dna3(n,m) =fw(4,ll2,m,n)
          pra3(n,m) =fw(5,ll2,m,n)
          
          bxa3(n,m) =aw(2,1,ll2,m,n)
          bya3(n,m) =-aw(2,3,ll2,m,n)
          bza3(n,m) =aw(2,2,ll2,m,n)

          if(metric .eq. 1) then
           vxa3(n,m) =aw(1,1,ll2,m,n)
           vya3(n,m) =-aw(1,3,ll2,m,n)  
           
          elseif(metric .eq. 2) then
           
           if(yw(ll2,m,n) .ge. 0.0) then
            vxa3(n,m) =aw(1,1,ll2,m,n)
            vya3(n,m) =-aw(1,3,ll2,m,n)
           else
            vxa3(n,m) =-aw(1,1,ll2,m,n)
            vya3(n,m) =aw(1,3,ll2,m,n)           
           endif

          endif
           
          vza3(n,m) =aw(1,2,ll2,m,n)
           
          xxa3(n,m) =xw(ll2,m,n)
          xya3(n,m) =yw(ll2,m,n)
          xza3(n,m) =zw(ll2,m,n)

  225  continue

       do 226 m=1,mmax
        do 226 n=1,nmax
          
          write(10+ifile,800) xxa3(n,m),xya3(n,m),xza3(n,m)
     &            ,vxa3(n,m),vya3(n,m),vza3(n,m)
     &            ,bxa3(n,m),bya3(n,m),bza3(n,m)
     &            ,dna3(n,m),pra3(n,m)

  226  continue

       write(6,*) ' read time =',time
       write(6,*) ' read xmin, xmax, ymin, ymax, zmin, zmax'
       write(6,800) xmin, xmax, ymin, ymax, zmin, zmax
       
       write(10+ifile,*) time,'   time'
       write(10+ifile,801) umin, umax, vmin, vmax, tmin, tmax

      endif

      if(nq3d .eq. 'i') then
      
       mm2=mmax/2+1
       
       do 227 n=1,nmax
        do 227 l=1,lmax
          
          dna4(l,n) =fw(4,l,mm2,n)
          pra4(l,n) =fw(5,l,mm2,n)
          
          bxa4(l,n) =aw(2,1,l,mm2,n)
          bya4(l,n) =-aw(2,3,l,mm2,n)
          bza4(l,n) =aw(2,2,l,mm2,n)

          if(metric .eq. 1) then
           vxa4(l,n) =aw(1,1,l,mm2,n)
           vya4(l,n) =-aw(1,3,l,mm2,n)  
           
          elseif(metric .eq. 2) then
           
c           if(yw(l,mm2,n) .ge. 0.0) then
            vxa4(l,n) =aw(1,1,l,mm2,n)
            vya4(l,n) =-aw(1,3,l,mm2,n)
c           else
c            vxa4(l,n) =-aw(1,1,l,mm2,n)
c            vya4(l,n) =aw(1,3,l,mm2,n)           
c           endif

          endif
           
          vza4(l,n) =aw(1,2,l,mm2,n)
           
          xxa4(l,n) =xw(l,mm2,n)
          xya4(l,n) =yw(l,mm2,n)
          xza4(l,n) =zw(l,mm2,n)

  227  continue

c       do 228 n=1,nmax
c        do 228 l=1,lmax
c          
c          write(10+ifile,800) xxa4(l,n),xya4(l,n),xza4(l,n)
c     &            ,vxa4(l,n),vya4(l,n),vza4(l,n)
c     &            ,bxa4(l,n),bya4(l,n),bza4(l,n)
c     &            ,dna4(l,n),pra4(l,n)
c
c  228  continue

c       write(6,*) ' read time =',time
c       write(6,*) ' read xmin, xmax, ymin, ymax, zmin, zmax'
c       write(6,800) xmin, xmax, ymin, ymax, zmin, zmax
c       
c       write(10+ifile,*) time,'   time'
c       write(10+ifile,801) umin, umax, vmin, vmax, tmin, tmax

      endif
c
c-----------------------------------------------------------------------
c    Data output for AVS
c-----------------------------------------------------------------------
c
      if(nq3d.eq.'a') then
      
cy       ifileavs=mod(ifile-1,10)
cy       ifileavs=0
cy       if(ih .eq. 1) then
cy       if(ifile .eq. 2) then
cy        ifileavs=1
cy       endif
c
cy       if(ifileavs .eq. 1) then
c
cy        write(*,*) 'check ok'
        dmin=0.5
        pmin=0.1
cy        do 230 n=1,nmax
cy         do 230 m=1,mmax
cy          do 230 l=1,lmax
cy           avsdn(l+1,m+1,n+1)=dn(l,m,n)
c           dn1=dn(l,m,n)
c           if (dn1.lt.dmin) then
c            avsdn(l+1,m+1,n+1)=dmin
c           endif
cy           avspr(l+1,m+1,n+1)=pr(l,m,n)
c           pr2=pr(l,m,n)
c           if (pr2.lt.pmin) then
c            avspr(l+1,m+1,n+1)=pmin
c           endif
cy           avsbx(l+1,m+1,n+1) =b1(l,m,n)
cy           avsby(l+1,m+1,n+1) =b2(l,m,n)
cy           avsbz(l+1,m+1,n+1) =b3(l,m,n)
cy           avsvx(l+1,m+1,n+1) =v1(l,m,n)
cy           avsvy(l+1,m+1,n+1) =v2(l,m,n)
cy           avsvz(l+1,m+1,n+1) =v3(l,m,n)
cy           avsx1(l+1,m+1,n+1) =xa1(l,m,n)
cy           avsx2(l+1,m+1,n+1) =xa2(l,m,n)
cy           avsx3(l+1,m+1,n+1) =xa3(l,m,n)
cy  230   continue
           
        do 231 m=1,mmax
         do 231 n=1,nmax
          do 231 l=1,lmax
          
           avsdna(l,n,m) =fw(4,l,m,n)
           avspra(l,n,m) =fw(5,l,m,n)
           
           if(metric .eq. 1) then
           
            avsvxa(l,n,m) =aw(1,1,l,m,n)
            avsvya(l,n,m) =-aw(1,3,l,m,n)  
            avsvza(l,n,m) =aw(1,2,l,m,n)
           
            avsbxa(l,n,m) =aw(2,1,l,m,n)
            avsbya(l,n,m) =-aw(2,3,l,m,n)
            avsbza(l,n,m) =aw(2,2,l,m,n)
           
           elseif(metric .eq. 2) then
            if(yw(l,m,n) .ge. 0.0) then
             avsvxa(l,n,m) =aw(1,1,l,m,n)
             avsvya(l,n,m) =-aw(1,3,l,m,n)
             avsvza(l,n,m) =aw(1,2,l,m,n)
             
             avsbxa(l,n,m) =aw(2,1,l,m,n)
             avsbya(l,n,m) =-aw(2,3,l,m,n)
             avsbza(l,n,m) =aw(2,2,l,m,n)
            else
             avsvxa(l,n,m) =-aw(1,1,l,m,n)
             avsvya(l,n,m) =aw(1,3,l,m,n)
             avsvza(l,n,m) =aw(1,2,l,m,n)
             
             avsbxa(l,n,m) =-aw(2,1,l,m,n)
             avsbya(l,n,m) =aw(2,3,l,m,n)
             avsbza(l,n,m) =aw(2,2,l,m,n)           
            endif
           
           endif
           
           avsxxa(l,n,m) =xw(l,m,n)
           avsxya(l,n,m) =yw(l,m,n)
           avsxza(l,n,m) =zw(l,m,n)

c           rr1=sqrt(avsxxa(l,n,m)**2+avsxya(l,n,m)**2)
c           zz1=avsxza(l,n,m)
          
c          tmp1=abs(avsxxa(l,n,m))/avsxya(l,n,m)
c          phi2=atan(tmp1)
          
c          if(avsxya(l,n,m) .ge. 0.0) then
c           
c           if(avsxxa(l,n,m) .ge. 0.0) then
c            phi1=atan(tmp1)
c           else
c            phi1=2.0*pi-abs(atan(tmp1))
c           endif
c          
c          else
c          
c           if(avsxxa(l,n,m) .ge. 0.0) then
c            phi1=pi-abs(atan(tmp1))
c           else
c            phi1=pi+abs(atan(tmp1))
c           endif
c          
c          endif

  231   continue

        do 234 m=1,mmax
         do 234 n=1,nmax
          do 234 l=1,lmax
           write(400+iavs*20+1,*) avsdna(l,n,m)
           write(400+iavs*20+2,*) avsvxa(l,n,m)
           write(400+iavs*20+3,*) avsvya(l,n,m)
           write(400+iavs*20+4,*) avsvza(l,n,m)
           write(400+iavs*20+5,*) avsbxa(l,n,m)
           write(400+iavs*20+6,*) avsbya(l,n,m)
           write(400+iavs*20+7,*) avsbza(l,n,m)
           write(400+iavs*20+8,*) avspra(l,n,m)
  234   continue
  
        do 242 l=1,lmax
           write(400+iavs*20+9,*) avsxxa(l,1,1)
  242   continue
  
        do 244 n=1,nmax
           write(400+iavs*20+10,*) avsxya(1,n,1)
  244   continue

        do 243 m=1,mmax
           write(400+iavs*20+11,*) avsxza(1,1,m)
  243   continue

         write(400+iavs*20+12,*) ' time =',time
         write(400+iavs*20+12,*)  umin, umax, vmin, vmax, tmin, tmax
  
        iavs=iavs+1
cy       endif
      endif
c
c-----------------------------------------------------------------------
c
c        call vhashi(aw2,1,lmax,mmax,ncol,nrow,fxw,fyw,cwk)
c        call vhashi(aw2,2,lmax,mmax,ncol,nrow,fxw,fyw,cwk)
c        call hashi(fw2,ns,lmax,mmax,ncol,nrow,fwk,nwk)
c
      ifile=ifile+1
c
1000  continue
1100  continue
c
c---------------------------------------------------------------------@
c     Calculation of Nolm
c---------------------------------------------------------------------@
c
c      roerr1=0.0d0
c      v1err1=0.0d0
c      prerr1=0.0d0
c      
c      imax1=4
c      imax2=28
c      
c      rmin=0.1d0
c      rmax=0.9d0
c      dx1=xx(2)-xx(1)
c      
cy      do 250 i=1,imax
cy       if(xx(i) .ge. rmin .and. xx(i) .le. rmax) then
c       if(i .ge. imax1 .and. i .le. imax2) then
cy        roerr1=roerr1+abs((roc(3,i,3,3)-roc(1,i,3,3)))*dx1
cy        v1err1=v1err1+abs((v1c(3,i,3,3)-v1c(1,i,3,3)))*dx1
cy        v2err1=v2err1+abs((v2c(3,i,3,3)-v2c(1,i,3,3)))*dx1
cy        prerr1=prerr1+abs((prc(3,i,3,3)-prc(1,i,3,3)))*dx1
cy       endif
cy 250  continue
      
c      roerr1=roerr1/(rmax-rmin)
c      v1err1=v1err1/(rmax-rmin)
c      prerr1=prerr1/(rmax-rmin)
      
cy      write(*,*) 'roerr1=',roerr1
cy      write(*,*) 'v1err1=',v1err1
cy      write(*,*) 'v2err1=',v2err1
cy      write(*,*) 'prerr1=',prerr1

c---------------------------------------------------------------------@
c
 800  format(1h ,1pe12.4,21(1pe12.4))
 801  format(1h ,1pe12.4,21(1pe12.4),'   umin, umax, vmin, vmax, 
     &       tmin, tmax')
c
      stop
      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine vhashi(aa,iv,imax,jmax,ncol,nrow,fxw,fyw,cwk)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
c
c
      dimension aa(2,3,imax,jmax)
      dimension fxw(imax,jmax),fyw(imax,jmax)
      character*1 cwk(ncol)
c
      do 100 j=1,jmax
       do 100 i=1,imax
        fxw(i,j)=aa(iv,1,i,j)
        fyw(i,j)=aa(iv,2,i,j)
 100  continue
c
       call vmodok(fxw(1,1),fyw(1,1),60.d0,imax+1,jmax+1,ncol,
     &             nrow,cwk)
c
      return
      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine hashi(ff,nv,imax,jmax,ncol,nrow,fwk,nwk)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
c
c
      dimension ff(nv,0:imax,0:jmax)
          dimension fwk(0:imax,0:jmax)
          integer*2 nwk(ncol)
c
      do 100 j=1,jmax
       do 100 i=1,imax
        fwk(i,j)=ff(4,i,j)
 100  continue
c
       call modoki(fwk(0,0),imax+1,jmax+1,ncol,nrow,nwk)
c
      return
      end
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine vmodok(fx,fy,ang,imax,jmax,ncol,nrow,cf)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
      parameter( pi=3.1415926 )
          dimension fx(imax,jmax),fy(imax,jmax)
          character*1 cf(ncol)
c
      nfile=6
      arad=ang*pi/180.0
          tn1=tan(pi*0.25+arad*0.5)
          tn2=tan(0.5*arad)
          eps=0.1d0
c
      call smnmxv(fx,fy,imax,jmax,fmin,fmax)
          write(nfile,*) 'maximum :',fmax
          write(nfile,*) 'minimum :',fmin
          write(nfile,*) jmax
          write(nfile,*) ' '
c
      if(fmax.eq.0.0d0) then
       fmax=1.0d0
      endif
      fmin=eps*fmax
c
          do 110 m=1,nrow
           j=(nrow-m)*(jmax-1)
           j=j/(nrow-1)+1
       do 100 l=1,ncol
            i=(l-1)*(imax-1)
                i=i/(ncol-1)+1
                if( 1 .le. i .and. i.le.imax .and. 
     &      1.le.j .and. j.le.jmax) then
                fxp=fx(i,j)
                fyp=fy(i,j)
                else
                fxp=0.0d0
                fyp=0.0d0
                write(6,*) 'error : i,j',i,j
                endif
c
c
c
        ff=sqrt( fxp*fxp+fyp*fyp )
                if( ff .lt. fmin ) then
                 cf(l)=' '
                elseif( fxp .eq. 0.0d0 ) then
                 cf(l)='|'
                else
                 tng=fyp/fxp
                 if( tng.le.-tn1 ) then
                  cf(l)='|'
                 elseif( -tn1.lt.tng .and. tng.le.-tn2 ) then
                  cf(l)='L'
                 elseif( -tn2.lt.tng .and. tng.le.tn2 ) then
                  cf(l)='-'
                 elseif( tn2.lt.tng .and. tng.le.tn1 ) then
                  cf(l)='/'
                 elseif( tn1.lt.tng ) then
                  cf(l)='|'
                 else
                  write(6,*) 'ERROR in vmodok'
                 endif
                endif
 100   continue
           write(nfile,600) '  I ',(cf(l),l=1,ncol)
 110  continue
       write(nfile,*) '  I-',('-',l=1,ncol)
c
       write(nfile,*) '1'
           write(nfile,*) '1',(' ',l=1,ncol-8),imax
 600  format(1h ,a4,72a1)
c
      return
          end
c----------------------------------------------------------------------
      subroutine smnmxv(fx,fy,imax,jmax,amin,amax)
c----------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension fx(imax,jmax),fy(imax,jmax)
c
      amax=sqrt(fx(1,1)**2+fy(1,1)**2)
      amin=amax
c
      do 100 j=1,jmax
       do 100 i=1,imax
        aa=sqrt( fx(i,j)**2 + fy(i,j)**2 )
        amax=max(amax,aa)
        amin=min(amin,aa)
 100  continue
c
      return
      end
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine modoki(ff,imax,jmax,ncol,nrow,nf)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
          dimension ff(imax,jmax)
          integer*2 nf(ncol)
c
      nfile=6
      call smnmx2(ff,imax,jmax,fmin,fmax)
          write(nfile,*) 'maximum :',fmax
          write(nfile,*) 'minimum :',fmin
          write(nfile,*) jmax
          write(nfile,*) ' '
          if( fmin.eq.fmax ) then
          write(6,*) 'fmin = fmax: ',fmin
          write(6,*) 'return'
          return
          endif
c
          do 110 m=1,nrow
           j=(nrow-m)*(jmax-1)
           j=j/(nrow-1)+1
       do 100 l=1,ncol
            i=(l-1)*(imax-1)
                i=i/(ncol-1)+1
                if( 1 .le. i .and. i.le.imax .and. 
     &      1.le.j .and. j.le.jmax) then
                fp=ff(i,j)
                else
                fp=fmax
                write(6,*) 'error : i,j',i,j
                endif
                nn=(fp-fmin)*8
                nf(l)=nn/(fmax-fmin)+1
                if( fp .eq. fmin ) nf(l)=0
                if( fp .eq. fmax ) nf(l)=9
 100   continue
           write(nfile,600) '  I ',(nf(l),l=1,ncol)
 110  continue
       write(nfile,*) '  I-',('-',l=1,ncol)
c
       write(nfile,*) '1'
           write(nfile,*) '1',(' ',l=1,ncol-8),imax
 600  format(1h ,a4,72i1)
c
      return
          end
c----------------------------------------------------------------------
      subroutine smnmx2(a,imax,jmax,amin,amax)
c----------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension a(imax,jmax)
c
      amax=a(1,1)
      amin=a(1,1)
c
      do 100 j=1,jmax
       do 100 i=1,imax
        aa=a(i,j)
        amax=max(amax,aa)
        amin=min(amin,aa)
 100  continue
c
      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine caa2cn(aw,fw,np,ns,imax,kmax,xx,yy,zz,bb,a2)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
c     only for cylindrical coordinates                        1996.10.17
c
      dimension fw(ns,imax,kmax)
      dimension aw(2,3,imax,kmax)
      dimension xx(imax,kmax),yy(imax,kmax),zz(imax,kmax)
      dimension bb(3,imax,kmax),a2(imax,kmax)
c
      common /cmetric/ metric
cx      common/cxyz/ dx,dy,dz
c
      dx=xx(2,1)-xx(1,1)
      dy=0.0d0
      dz=zz(1,2)-zz(1,1)
c
      do 100 k=1,kmax
       do 100 i=1,imax
        bb(1,i,k)=aw(2,1,i,k)
        bb(2,i,k)=aw(2,3,i,k)
        bb(3,i,k)=aw(2,2,i,k)
 100  continue
c
       a2(1,1)=0.0d0
c
       do 310 k=1,kmax-1
        a2(1,k+1)=a2(1,k)-0.5*(bb(1,1,k+1)+bb(1,1,k))*dz
c     &                       *xx(0,0)
 310  continue
c
cz       do 210 i=1,imax
cz        do 220 k=1,kmax-1
cz         a2(i,k+1)=a2(i,k)-0.5*(bb(1,i,k+1)+bb(1,i,k))*dz
cz     &                        *xx(i,1)
cz 220    continue
cz 210   continue
c
       do 300 i=1,imax-1
        do 300 k=1,kmax
         if(metric .eq. 1) then
          a2(i+1,k)=a2(i,k)+0.5*(bb(3,i+1,k)+bb(3,i,k))*dx
c     &                        *xx(1,1)

         elseif(metric .eq. 2) then
         a2(i+1,k)=a2(i,k)+0.5*(bb(3,i+1,k)+bb(3,i,k))*dx
     &                        *0.5*(xx(i+1,k)+xx(i,k))
        endif
 300  continue
c
      do 320 k=1,kmax
        do 320 i=1,imax
          fw(np,i,k)=a2(i,k)
c         if( xx(i,1).ne.0.0d0 ) then
c          fw(np,i,k)=a2(i,k)/xx(i,1)
c         else
c          fw(np,i,k)=a2(i,k)
c         endif
 320  continue
c
      return
      end
c***********************************************************************
c      for GENERAL ORTHOGONAL COORDINATES CALCULATION
c***********************************************************************
c
c      Hanten                                                1996.06.05
c
c----------------------------------------------------------------------
      subroutine vhant(aw,xw,yw,zw,nv,imax,jmax,kmax)
c----------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension xw(imax,jmax,kmax),yw(imax,jmax,kmax)
     &    ,zw(imax,jmax,kmax)
      dimension aw(nv,3,imax,jmax,kmax)
c
      do 100 k=1,kmax
       do 100 j=1,jmax
        do 100 i=1,imax
        zz=zw(i,j,k)
        if(  zz.ge.0.0d0 ) then
        elseif( zz.lt.0.0d0 ) then
         aw(1,1,i,j,k)=aw(1,1,i,j,k)
         aw(1,2,i,j,k)=-aw(1,2,i,j,k)
         aw(1,3,i,j,k)=aw(1,3,i,j,k)
         aw(2,1,i,j,k)=-aw(2,1,i,j,k)
         aw(2,2,i,j,k)=aw(2,2,i,j,k)
         aw(2,3,i,j,k)=-aw(2,3,i,j,k)
         aw(3,1,i,j,k)=aw(3,1,i,j,k)
         aw(3,2,i,j,k)=-aw(3,2,i,j,k)
         aw(3,3,i,j,k)=aw(3,3,i,j,k)
        endif
 100  continue
c
      return
      end
c----------------------------------------------------------------------
      subroutine vhan(aw,xw,yw,zw,nv,imax,jmax)
c----------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension xw(imax,jmax),yw(imax,jmax),zw(imax,jmax)
      dimension aw(nv,3,imax,jmax)
c
      do 100 j=1,jmax
       do 100 i=1,imax
        xx=xw(i,j)
        zz=zw(i,j)
        if( xx.ge.0.0d0 .and. zz.ge.0.0d0 ) then
        elseif( xx.lt.0.0d0 .and. zz.ge.0.0d0 ) then
         aw(1,1,i,j)=-aw(1,1,i,j)
         aw(1,2,i,j)=aw(1,2,i,j)
         aw(1,3,i,j)=-aw(1,3,i,j)
         aw(2,1,i,j)=-aw(2,1,i,j)
         aw(2,2,i,j)=aw(2,2,i,j)
         aw(2,3,i,j)=-aw(2,3,i,j)
         aw(3,1,i,j)=-aw(3,1,i,j)
         aw(3,2,i,j)=aw(3,2,i,j)
         aw(3,3,i,j)=-aw(3,3,i,j)
        elseif( xx.lt.0.0d0 .and. zz.lt.0.0d0 ) then
         aw(1,1,i,j)=-aw(1,1,i,j)
         aw(1,2,i,j)=-aw(1,2,i,j)
         aw(1,3,i,j)=-aw(1,3,i,j)
         aw(2,1,i,j)=aw(2,1,i,j)
         aw(2,2,i,j)=aw(2,2,i,j)
         aw(2,3,i,j)=aw(2,3,i,j)
         aw(3,1,i,j)=-aw(3,1,i,j)
         aw(3,2,i,j)=-aw(3,2,i,j)
         aw(3,3,i,j)=-aw(3,3,i,j)
        elseif( xx.ge.0.0d0 .and. zz.lt.0.0d0 ) then
         aw(1,1,i,j)=aw(1,1,i,j)
         aw(1,2,i,j)=-aw(1,2,i,j)
         aw(1,3,i,j)=aw(1,3,i,j)
         aw(2,1,i,j)=-aw(2,1,i,j)
         aw(2,2,i,j)=aw(2,2,i,j)
         aw(2,3,i,j)=-aw(2,3,i,j)
         aw(3,1,i,j)=aw(3,1,i,j)
         aw(3,2,i,j)=-aw(3,2,i,j)
         aw(3,3,i,j)=aw(3,3,i,j)
        endif
 100  continue
c
      return
      end
c
c      Cylindrical Coordinates
c
c======================================================================
c         Ippan zahyou (general coordinates)                 1996.05.27
c======================================================================
c     cylindrical coordinates
c
c     nonuniform mesh
c......................................................................
      function x1umcn(xx,yy,zz,rr)
      implicit real*8(a-h,o-z)
c
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
      common /cxyz/ dx,dy,dz
c
      if( rr.eq.1.0d0 ) then
       x1umcn=sqrt(xx*xx+yy*yy)
      else
       ak=log(rr)/dx
       anum=(exp(ak*xmax)-exp(ak*xmin))*abs(xx)-xmin*exp(ak*xmax)
     &                                    +xmax*exp(ak*xmin)
       x1umcn=log(anum/(xmax-xmin))/ak
      endif
c
      return
      end
c
c......................................................................
      function x3umcn(xx,yy,zz,rr)
      implicit real*8(a-h,o-z)
c
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
      common /cxyz/ dx,dy,dz
c
      if( rr.eq.1.0d0 ) then
       x3umcn=zz
      else
       ak=log(rr)/dz
       anum=(exp(ak*zmax)-exp(ak*zmin))*abs(zz)-zmin*exp(ak*zmax)
     &                                    +zmax*exp(ak*zmin)
       x3umcn=log(anum/(zmax-zmin))/ak
      endif
c symmetry                                              1996.9.26
      x3umcn=abs(x3umcn)
c
      return
      end
c
c     uniform mesh
c......................................................................
      function x1umcy(xx,yy,zz)
      implicit real*8(a-h,o-z)
c
      x1umcy=sqrt(xx*xx+yy*yy)
c
      return
      end
c
c......................................................................
      function x2umcy(xx,yy,zz)
      implicit real*8(a-h,o-z)
c
c      x2umcy=acos(xx/sqrt(xx*xx+yy*yy))*sign(1.0,yy)
c symmetry
       x2umcy=0.0d0
c
      return
      end
c
c......................................................................
      function x3umcy(xx,yy,zz)
      implicit real*8(a-h,o-z)
c
c      x3umcy=zz
c symmetry                                                  1996.9.26
      x3umcy=abs(zz)
c
      return
      end
c
c--------------------------------------------------------------------
      subroutine catmet(hh,x1,x2,x3,imax,jmax,kmax)
c--------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension hh(3,imax,jmax,kmax)
      dimension x1(imax),x2(jmax),x3(kmax)
c
      do 100 k=1,kmax
       do 100 j=1,jmax
        do 100 i=1,imax
         hh(1,i,j,k)=1.0d0
         hh(2,i,j,k)=1.0d0
         hh(3,i,j,k)=1.0d0
 100  continue
c
      return
      end
c--------------------------------------------------------------------
      subroutine cate(ee,x1,x2,x3,imax,jmax,kmax)
c--------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension ee(3,3,imax,jmax,kmax)
      dimension x1(imax),x2(jmax),x3(kmax)
c
      do 10 k=1,kmax
       do 10 j=1,jmax
        do 10 i=1,imax
         do 10 n=1,3
          do 10 m=1,3
           ee(m,n,i,j,k)=0.0d0
 10   continue
c
      do 100 k=1,kmax
       do 100 j=1,jmax
        do 100 i=1,imax
         ee(1,1,i,j,k)=1.0d0
         ee(1,2,i,j,k)=0.0d0
         ee(2,1,i,j,k)=0.0d0
         ee(2,2,i,j,k)=1.0d0
         ee(3,3,i,j,k)=1.0d0
 100  continue
c
      return
      end
c--------------------------------------------------------------------
      subroutine cylmet(hh,x1,x2,x3,imax,jmax,kmax)
c--------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension hh(3,imax,jmax,kmax)
      dimension x1(imax),x2(jmax),x3(kmax)
c
      do 100 k=1,kmax
       do 100 j=1,jmax
        do 100 i=1,imax
         hh(1,i,j,k)=1.0d0
         hh(2,i,j,k)=x1(i)
         hh(3,i,j,k)=1.0d0
 100  continue
c
      return
      end
c--------------------------------------------------------------------
      subroutine cyle(ee,x1,x2,x3,imax,jmax,kmax)
c--------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension ee(3,3,imax,jmax,kmax)
      dimension x1(imax),x2(jmax),x3(kmax)
c
      do 10 k=1,kmax
       do 10 j=1,jmax
        do 10 i=1,imax
         do 10 n=1,3
          do 10 m=1,3
           ee(m,n,i,j,k)=0.0d0
 10   continue
c
      do 100 k=1,kmax
       do 100 j=1,jmax
        do 100 i=1,imax
         ee(1,1,i,j,k)=cos(x2(j))
         ee(1,2,i,j,k)=sin(x2(j))
         ee(2,1,i,j,k)=-sin(x2(j))
         ee(2,2,i,j,k)=cos(x2(j))
         ee(3,3,i,j,k)=1.0d0
 100  continue
c
      return
      end
c======================================================================
c     Polar coordinates                               1996.06.03
c......................................................................
      function x1umpn(xx,yy,zz,aa,imax,jmax,kmax)
      implicit real*8(a-h,o-z)
c
c     non-uniform mesh
c
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
c
       rr=sqrt(xx*xx+yy*yy+zz*zz)
       x1umpn=(aa**imax-1.0)*rr-xmin*aa**imax+xmax
       x1umpn=dlog(x1umpn/(xmax-xmin))
       x1umpn=xmin+(xmax-xmin)/dlog(aa)*x1umpn/imax
c
      return
      end
c
      function x1umpno(xx,yy,zz)
      implicit real*8(a-h,o-z)
c
c     non-uniform mesh
c
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
c
      x1umpno=xmin+(xmax-xmin)*log(sqrt(xx*xx+yy*yy+zz*zz)/xmin)
     &                       /log(xmax/xmin)
c
      return
      end
c
c......................................................................
      function x1umpo(xx,yy,zz)
      implicit real*8(a-h,o-z)
c
      x1umpo=sqrt(xx*xx+yy*yy+zz*zz)
c
      return
      end
c
c......................................................................
      function x2umpo(xx,yy,zz)
      implicit real*8(a-h,o-z)
      parameter( pi=3.1415926 )
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
c
cz    if( ymax.ge.2.0*3.14 ) then
      if( xx*xx+yy*yy.gt.0.0d0 ) then
       x2umpo=acos(sqrt(xx*xx/(xx*xx+yy*yy)))*sign(1.d0,yy)
      else
       x2umpo=0.0d0
      endif
cnao_fortran_error
cnao   x2umpo=acos(sign(xx)*min(1.0,abs(xx)/sqrt(xx*xx+yy*yy)))
cnao &         *sign(1.0,yy)
cnao_fortran_error.
       if( x2umpo.lt.0.0d0 ) then
        x2umpo=2.0*pi+x2umpo
       endif
csymmetry
cz     else
cz     x2umpo=0.0d0
cz    endif
c
      return
      end
c
c......................................................................
      function x3umpo(xx,yy,zz)
      implicit real*8(a-h,o-z)
      parameter( pi=3.141592 )
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
c
      rr=sqrt(xx*xx+yy*yy+zz*zz)
      if( rr.ne.0.0d0 ) then
       x3umpo=acos(zz/rr)
csymmetry
       if( zmax.lt.(0.6*pi) ) then
        x3umpo=min(x3umpo,pi-x3umpo)
       endif
      else
       x3umpo=0.5*pi
      endif
c
      return
      end
c
c--------------------------------------------------------------------
      subroutine ponmet(hh,x1,x2,x3,imax,jmax,kmax)
c--------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension hh(3,imax,jmax,kmax)
      dimension x1(imax),x2(jmax),x3(kmax)
c
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
c
      rat=xmax/xmin
      do 100 k=1,kmax
       do 100 j=1,jmax
        do 100 i=1,imax
         rr=sqrt(x1(i)**2+x2(j)**2+x3(k)**2)
         hh(1,i,j,k)=log(rat)/(rat-1.0)*rr/xmin
         hh(2,i,j,k)=x1(i)*sin(x3(k))
         hh(3,i,j,k)=x1(i)
 100  continue
c
      return
      end
c--------------------------------------------------------------------
      subroutine polmet(hh,x1,x2,x3,imax,jmax,kmax)
c--------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension hh(3,imax,jmax,kmax)
      dimension x1(imax),x2(jmax),x3(kmax)
c
      do 100 k=1,kmax
       do 100 j=1,jmax
        do 100 i=1,imax
         hh(1,i,j,k)=1.0d0
         hh(2,i,j,k)=x1(i)*sin(x3(k))
         hh(3,i,j,k)=x1(i)
 100  continue
c
      return
      end
c--------------------------------------------------------------------
      subroutine pole(ee,x1,x2,x3,imax,jmax,kmax)
c--------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      dimension ee(3,3,imax,jmax,kmax)
      dimension x1(imax),x2(jmax),x3(kmax)
c
      do 10 k=1,kmax
       do 10 j=1,jmax
        do 10 i=1,imax
         do 10 n=1,3
          do 10 m=1,3
           ee(m,n,i,j,k)=0.0d0
 10   continue
c
      do 100 k=1,kmax
       do 100 j=1,jmax
        do 100 i=1,imax
         ee(1,1,i,j,k)=sin(x3(k))*cos(x2(j))
         ee(1,2,i,j,k)=sin(x3(k))*sin(x2(j))
         ee(1,3,i,j,k)=cos(x3(k))
caution :  When you use the order of coordinates (r, phi, theta),
caution :  You should use followings:
         ee(2,1,i,j,k)= sin(x2(j))
         ee(2,2,i,j,k)=-cos(x2(j))
caution :  instead of following two lines:
caution :  When you use the order of coordinates (r, theta, phi), 
caution :  followings are OK.
c        ee(2,1,i,j,k)=-sin(x2(j))
c        ee(2,2,i,j,k)=cos(x2(j))
         ee(3,1,i,j,k)=cos(x3(k))*cos(x2(j))
         ee(3,2,i,j,k)=cos(x3(k))*sin(x2(j))
         ee(3,3,i,j,k)=-sin(x3(k))
 100  continue
c
      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine t3d2d(aw,fw,xw,yw,zw,aw2,fw2,xw2,yw2,zw2
     &                                    ,ns,lmax,mmax,nmax)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit real*8(a-h,o-z)
c
      dimension aw(2,3,lmax,mmax,nmax)
      dimension fw(ns,lmax,mmax,nmax)
      dimension xw(lmax,mmax,nmax),yw(lmax,mmax,nmax)
     &    ,zw(lmax,mmax,nmax)
c
      dimension aw2(2,3,lmax,mmax)
      dimension fw2(ns,lmax,mmax)
      dimension xw2(lmax,mmax),yw2(lmax,mmax),zw2(lmax,mmax)
c
      n=nmax/2+1
c      write(*,*) 'n=',n
      do 10 m=1,mmax
       do 10 l=1,lmax
        xw2(l,m)=xw(l,m,n)
        yw2(l,m)=yw(l,m,n)
        zw2(l,m)=zw(l,m,n)
  10  continue
c
      do 100 m=1,mmax
       do 100 l=1,lmax
        do 100 is=1,ns
         fw2(is,l,m)=fw(is,l,m,n)
 100  continue
c
      do 200 m=1,mmax
       do 200 l=1,lmax
         aw2(1,1,l,m)=aw(1,1,l,m,n)
         aw2(1,2,l,m)=aw(1,2,l,m,n)
         aw2(1,3,l,m)=aw(1,3,l,m,n)
         aw2(2,1,l,m)=aw(2,1,l,m,n)
         aw2(2,2,l,m)=aw(2,2,l,m,n)
         aw2(2,3,l,m)=aw(2,3,l,m,n)
 200  continue
c
      return
      end
c--------------------------------------------------------------------
      subroutine calei(ei,han,lmax,mmax,nmax,
     &                         x0,y0,z0,x1,y1,z1,x2,y2,z2,x3,y3,z3)
c--------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      parameter( pi=3.141592 )
      dimension ei(3,3,lmax,mmax,nmax)
      dimension han(2,3,lmax,mmax,nmax)
      character*1 nq3d
      common /cmetric/ metric
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
      common /c3d/   nq3d
c
      small=1.0d-10
c
      dux=(x1-x0)/(lmax-1)
      duy=(y1-y0)/(lmax-1)
      duz=(z1-z0)/(lmax-1)
c
      dvx=(x2-x0)/(mmax-1)
      dvy=(y2-y0)/(mmax-1)
      dvz=(z2-z0)/(mmax-1)
c
      if( nmax.gt.0 ) then
       dtx=(x3-x0)/max(1,nmax-1)
       dty=(y3-y0)/max(1,nmax-1)
       dtz=(z3-z0)/max(1,nmax-1)
      else
       dtx=0.0d0
       dty=0.0d0
       dtz=0.0d0
      endif
c
      do 10 n=1,nmax
       do 10 m=1,mmax
        do 10 l=1,lmax
         ei(1,1,l,m,n)=0.0d0
         ei(1,2,l,m,n)=0.0d0
         ei(1,3,l,m,n)=0.0d0
         ei(2,1,l,m,n)=0.0d0
         ei(2,2,l,m,n)=0.0d0
         ei(2,3,l,m,n)=0.0d0
         ei(3,1,l,m,n)=0.0d0
         ei(3,2,l,m,n)=0.0d0
         ei(3,3,l,m,n)=0.0d0
 10   continue
c
      do 20 n=1,nmax
       do 20 m=1,mmax
        do 20 l=1,lmax
         han(1,1,l,m,n)=1.0d0
         han(1,2,l,m,n)=1.0d0
         han(1,3,l,m,n)=1.0d0
         han(2,1,l,m,n)=1.0d0
         han(2,2,l,m,n)=1.0d0
         han(2,3,l,m,n)=1.0d0
 20   continue
c
      if( nq3d.ne.'2' ) then
       nnnmin=1
       nnnmax=nmax
      else
       nnnmin=nmax/2+1
       nnnmax=nmax/2+1
       dtx=0.0d0
       dty=0.0d0
       dtz=0.0d0
      endif
c
      do 100 n=nnnmin,nnnmax
       do 100 m=1,mmax
        do 100 l=1,lmax
         xxx=x0+dux*l+dvx*m+dtx*n
         yyy=y0+duy*l+dvy*m+dty*n
         zzz=z0+duz*l+dvz*m+dtz*n
         if( metric.eq.3 ) then
c
          rr=sqrt(xxx**2+yyy**2)
          rrr=sqrt(xxx**2+yyy**2+zzz**2)
          if( rr.gt.small ) then
           sinp=yyy/rr
           cosp=xxx/rr
           sinq=rr/rrr
           cosq=zzz/rrr
          else
           sinp=0.0d0
           cosp=1.0d0
           sinq=0.0d0
           cosq=sign(1.d0,zzz)
          endif
          ei(1,1,l,m,n)=sinq*cosp
          ei(1,2,l,m,n)=sinq*sinp
          ei(1,3,l,m,n)=cosq
caution :  When you use the order of coordinates (r, phi, theta),
caution :  You should use followings:
          ei(2,1,l,m,n)= sinp
          ei(2,2,l,m,n)=-cosp
caution :  instead of following two lines:
caution :  When you use the order of coordinates (r, theta, phi), 
caution :  followings are OK.
c         ei(2,1,l,m,n)=-sinp
c         ei(2,2,l,m,n)=cosp
c
          ei(2,3,l,m,n)=0.0d0
          ei(3,1,l,m,n)=cosq*cosp
          ei(3,2,l,m,n)=cosq*sinp
          ei(3,3,l,m,n)=-sinq
c
         elseif( metric.eq.2) then
           rr=sqrt(xxx**2+yyy**2)
          rrr=sqrt(xxx**2+yyy**2+zzz**2)
          if( rr.gt.small ) then
           sinp=yyy/rr
           cosp=xxx/rr
           sinq=rr/rrr
           cosq=zzz/rrr
          else
           sinp=0.0d0
           cosp=1.0d0
           sinq=0.0d0
           cosq=sign(1.d0,zzz)
          endif
          ei(1,1,l,m,n)=cosp
          ei(1,2,l,m,n)=sinp
          ei(1,3,l,m,n)=0.0d0
          ei(2,1,l,m,n)=-sinp
          ei(2,2,l,m,n)=cosp
          ei(2,3,l,m,n)=0.0d0
          ei(3,1,l,m,n)=0.0d0
          ei(3,2,l,m,n)=0.0d0
          ei(3,3,l,m,n)=1.0d0
         elseif(metric .eq. 1) then
          ei(1,1,l,m,n)=1.0d0
          ei(1,2,l,m,n)=0.0d0
          ei(1,3,l,m,n)=0.0d0
          ei(2,1,l,m,n)=0.0d0
          ei(2,2,l,m,n)=1.0d0
          ei(2,3,l,m,n)=0.0d0
          ei(3,1,l,m,n)=0.0d0
          ei(3,2,l,m,n)=0.0d0
          ei(3,3,l,m,n)=1.0d0
         else
          write(6,*) 'ERROR in calei! Please set ei for metric'
          write(6,*) 'STOP  in calei'
          stop
         endif
c
cy         if( metric.ne.1 .and. metric.ne.2 .and. metric.ne.102 
         if(metric.ne.1 .and. zmax.lt.0.5*pi ) then
          if( zzz.lt.0.0d0 ) then
             han(2,1,l,m,n)=-1.0d0
             han(2,2,l,m,n)=-1.0d0
             han(2,3,l,m,n)=1.0d0
             han(1,1,l,m,n)=1.0d0
             han(1,2,l,m,n)=1.0d0
             han(1,3,l,m,n)=-1.0d0
          endif
         endif
 100  continue
c
      return
      end
c----------------------------------------------------------------------
      subroutine vhani(ai,x,y,z,n)
c----------------------------------------------------------------------
      implicit real*8(a-h,o-z)
      parameter( pi=3.141592 )
      dimension ai(3)
      common /cmnmx/ xmin,xmax,ymin,ymax,zmin,zmax
c
      if( zmax.gt.0.6*pi ) return
c
      if( z.lt.0.0d0 ) then
       if( n.eq.2 ) then
        ai(1)=-ai(1)
        ai(2)=-ai(2)
       else
        ai(3)=-ai(3)
       endif
      endif
c
      return
      end
c
