;
;      To plot 1D slice for 1D test simulations
;      2006.1.20(the)
;
;  Usage:
;
;  idl> .r dread1
;  idl> .r vonz1D1
;
;
; choice of device
;plot_choice='ps'
plot_choice='x'

iwx=2 & jwy=2

!p.charsize=1.5
!p.charthick=1.5
;!p.thick=1.0
;!p.charsize=1.1
;!p.charthick=1.0
;!p.thick=1.0
chsz=2.0
rx=0.6

ixon1=100

;izon=0 : z=0.0 rs

mm1=11

!x.range=[-6.0,6.0]

int=1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
case plot_choice of
'x' : begin
window,4,xs=600,ys=550,xpos=400,retain=2
end
'ps' : begin
set_plot,'ps'
device,/inches,xsize=7.5,ysize=7.0,yoffset=1,font_size=8
;device,/landscape
;device,/color,xoffset=0.5,yoffset=26.5,xsize=24,ysize=14,font_size=8
;!p.font=0 & device,/times,/italic
end
endcase

iw=iwx*jwy
dx0=1./iwx
dy0=1./jwy

!p.multi=[0,iwx,jwy]
!y.margin=[4.,5.]
!x.margin=[7.,7.]

gam=4.0/3.0
vt=v1^2+v2^2+v3^2

lo=1.0/sqrt(1.0-vt)

bt=b1^2+b2^2+b3^2

bt1=(b1^2+b2^2+b3^2)/lo^2+(b1*v1+b2*v2+b3*v3)^2

beta=2.0*pp/bt1
sigmc=bt1/(10^dd+(gam/(gam-1.0))*pp)

;
;(1) density
;
;

;ldmyct,clr_index=clr,white=white,black=black
;loadct,5

!y.range=[0.0,0.001]

plot,yar,dd(ixon1,*,mm1),title='!7q!8',xtitle='y',xstyle=1,ystyle=1,linestyle=0

;
;(2) gas pressure
;
!y.range=[0.0,0.04]

ppa=pp

plot,yar,pp(ixon1,*,mm1),title='!8p!Dgas!N',xtitle='y',xstyle=1,ystyle=1,linestyle=0

i=0
	x0=dx0*(i mod iwx)
	y0=dy0*((i-(i mod iwx))/iwx)
   xyouts,/normal,x0+dx0*0.15,1.-(y0+dy0*0.20-0.03),'time = '
   xyouts,/normal,x0+dx0*0.50,1.-(y0+dy0*0.20-0.03), $
     strmid(strcompress(string(ctime(mm1)),/remove_all),0,4)

;
;(2) magnetic pressure
;
!y.range=[-0.005,0.08]

  bsq=b1*b1+b2*b2+b3*b3
  pm=bsq/2.0
plot,yar,pm(ixon1,*,mm1),title='!8p!Dmag!N',xtitle='y',xstyle=1,ystyle=1,linestyle=0


if (plot_choice ne 'x') then begin
   device,color=0
   device,/close
   !p.font=-1
;   set_plot,'x'
endif


end
