;;
;; Creating Video for 2D results
;;
; define nnmin
;
  nnmin=1
  nddmax=21

;; valiables
nx=0l
nz=0l

im=0l
jm=0l

;; $Id$
;;
; choice of device
;plot_choice='cps'
;plot_choice='ps'
plot_choice='x'
;

gam=1.666666
inter=1
direc='/Users/mizuno/IDL/2Dkh/'
nq=13
ixmax=128
iymax=256
psb=0
nmv=0
nn=0
revmesh=0
for ih=nnmin,nddmax,inter do begin
    ;read deta

file=direc+'ok'+strtrim(ih,1)
openr,1,file

a=fltarr(nq,ixmax,iymax)
 readf,1,a
 readf,1,time
 readf,1,xmin,xmax,ymin,ymax
 close,1
 
xx=reform(a(0,*,*))
yy=reform(a(1,*,*))
zz=reform(a(2,*,*))
v1=reform(a(3,*,*))
v2=reform(a(4,*,*))
v3=reform(a(5,*,*))
b1=reform(a(6,*,*))
b2=reform(a(7,*,*))
b3=reform(a(8,*,*))
dd=reform(a(9,*,*))
pp=reform(a(10,*,*))
pom=reform(a(12,*,*))
;
xar=fltarr(ixmax)
yar=fltarr(iymax)
;
for i=0,ixmax-1 do begin
 xar(i)=xx(i,1)
endfor
;
for j=0,iymax-1 do begin
 yar(j)=zz(1,j)
endfor

; if (nn lt nnmin) then begin
 if (nn lt nddmax) then begin
   print,'nn= ',nn,' time= ',time
 endif

;; Ploting 2D results
;;

iwx=2 & jwy=1

;!p.charsize=1.4
;!p.charthick=1.4
!p.charsize=1.0
!p.charthick=1.0

mm1=ih

xrange=[-0.5,0.5] & yrange=[-1.0,1.0]


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
case plot_choice of
'x' : begin
window,4,xs=500,ys=450,xpos=400,retain=2
;window,5,xs=1200,ys=1200,xpos=400
end
'ps' : begin
set_plot,'ps'
device,/portrait
device,/inches,xsize=7,ysize=7.5,yoffset=1,font_size=8
;!p.font=0 & device,/times,/italic
end
'cps' : begin
set_plot,'ps'
;device,/color,bits_per_pix=5
device,/color,/inches,xsize=5.5,ysize=8.0,yoffset=1,font_size=8
;device,/landscape
;device,xoffset=0.5,yoffset=24.5,xsize=19*6.5/7.*0.8,ysize=19*0.8
;!p.font=0 & device,/times,/italic
end
endcase

iw=iwx*jwy
dx0=1./iwx
dy0=1./jwy

!p.multi=[0,iwx,jwy]
!x.margin=[8.,8.]
!y.margin=[4.,4.]

   
;  loadct,1
  If(plot_choice eq 'x') then begin
    device,decompose=0
  endif
    ldmyct,clr_index=clr,white=white,black=black
;

;
; (1) density
;
  data1=dd
  
clr=[10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,190]

levels1=[0.0,0.01,0.04,0.06,0.08,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,1.0,1.5]

data2=-pom
  
    fccnve $
     ,nofilled=0,nocontour=0,novector=0 $
     ,xrange=xrange,yrange=yrange $
     ,data1(*,*) $
     ,levels1=levels1,clr_index=clr, c_thick=1.5 $
     ,data2(*,*) $
     ,levels2=min(data2(*,*))+(max(data2(*,*))-min(data2(*,*)))*(findgen(20)/20)$
;     ,levels2=[0.0] $
     ,v1(*,*),v2(*,*) $
     ,scale=0.1,index_size=1.0, xarrow=0.65, limit=0.1,/sample $
     ,xplot=-0.5+0.08*findgen(100),yplot=-1.0+0.08*findgen(100) $
     ,xcord=xar,ycord=yar,xtitle='!8x',ytitle='!8y' $
     ,v_color=white 
;     ,c_colors=white, Index_color=black, Axis_color=black 
;
i=0
	x0=dx0*(i mod iwx)
	y0=dy0*((i-(i mod iwx))/iwx)

   xyouts,/normal,x0+dx0*0.08,1.-(y0+dy0*0.1-0.08),'!8(a)'
   
   xyouts,/normal,x0+dx0*0.25,1.-(y0+dy0*0.10-0.08),'!8time = '
   xyouts,/normal,x0+dx0*0.58,1.-(y0+dy0*0.10-0.08), $
     strmid(strcompress(string(time),/remove_all),0,4)

    barposition=[0.47,0.58,0.49,0.88]
    b_min=0.0 & b_max=1.1

  color_bar,/noerase,levels1 $
    ,clr $
   ,position=barposition,b_min=b_min,b_max=b_max


;(2)  Magnetic field strength

  bb=abs(sqrt(b1^2+b2^2))/abs(b3)
  data1=bb
  
clr=[10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,190]
levels1=[0.0,0.05,0.1,0.125,0.15,0.175,0.2,0.225,0.25,0.275,0.3,0.35,0.4,0.45]

    fccnve $
     ,nofilled=0,nocontour=0,novector=1 $
     ,xrange=xrange,yrange=yrange $
     ,data1(*,*) $
     ,levels1=levels1,clr_index=clr, c_thick=1.5 $
     ,data2(*,*) $
     ,levels2=min(data2(*,*))+(max(data2(*,*))-min(data2(*,*)))*(findgen(20)/20)$
     ,v1(*,*),v2(*,*) $
     ,scale=0.1,index_size=1.0, xarrow=0.65, limit=0.01,/sample $
     ,xplot=-0.5+0.08*findgen(100),yplot=-1.+0.08*findgen(100) $
     ,xcord=xar,ycord=yar, xtitle='!8x',ytitle='!8y' $
     ,v_color=white  
;     ,c_colors=white, Index_color=black, Axis_color=black 

i=1
	x0=dx0*(i mod iwx)
	y0=dy0*((i-(i mod iwx))/iwx)

   xyouts,/normal,x0+dx0*0.08,1.-(y0+dy0*0.10-0.08),'!8(b)'
;   xyouts,/normal,x0+dx0*0.25,1.-(y0+dy0*0.10-0.08),'!8time = '
;   xyouts,/normal,x0+dx0*0.58,1.-(y0+dy0*0.10-0.08), $
;     strmid(strcompress(string(time),/remove_all),0,4)


    barposition=[0.97,0.58,0.99,0.88]
    b_min=0.0 & b_max=0.45

  color_bar,/noerase,levels1 $
    ,clr $
   ,position=barposition,b_min=b_min,b_max=b_max

; for movie
;
;  device,decomposed=1

;  movie(*,*,nmv)=tvrd(0,0,xwindow,ywindow)
;  nmv=nmv+1
  nn=nn+1

;image = TVRead(/PNG)
;WSet, windowContainingImage

IF (!D.Flags AND 256) NE 0 THEN BEGIN
   Device, Get_Decomposed=theDecomposedState, Get_Visual_Depth=theDepth
   IF theDepth GT 8 THEN BEGIN
      Device, Decomposed=1
      color24 = 1
   ENDIF ELSE truecolor = 0
ENDIF ELSE BEGIN
   color24 = 0
   theDepth = 8
ENDELSE

image = TVRD(True=color24)
fileType='PNG'

CASE fileType OF

      'BMP': BEGIN
         IF color24 THEN BEGIN
            ; BMP files assume blue, green, red planes.
            Write_BMP, filename, Transpose(image[2,1,0]), _Extra=extra
         ENDIF ELSE BEGIN
            TVLCT, r, g, b, /Get
            Write_BMP, '2Drobt_ok'+strtrim(ih,1)+'.bmp', image, r, g, b, _Extra=extra
         ENDELSE
         END

      'JPEG': BEGIN
         IF color24 THEN BEGIN
            image3D = image
         ENDIF ELSE BEGIN
            TVLCT, r, g, b, /Get
            image3D = [ [[r[image]]], [[g[image]]], [[b[image]]] ]
            image3D = Transpose(image3d,[2,0,1])
         ENDELSE
         Write_JPEG, filename, image3D, True=1, Quality=quality, _Extra=extra
         END

      'PNG': BEGIN
         IF color24 THEN BEGIN
            Write_PNG, '2Dppgf_ok'+strtrim(ih,1)+'.png', image, _Extra=extra
         ENDIF ELSE BEGIN
            TVLCT, r, g, b, /Get
            image2D = image
;            Write_PNG, '2Drobt_ok'+strtrim(ih,1)+'.png', Reverse(image2D,2), r, g, b, _Extra=extra
         ENDELSE
         END

      'TIFF': BEGIN
         IF color24 THEN BEGIN
            image3D = Reverse(image,3)
         ENDIF ELSE BEGIN
            TVLCT, r, g, b, /Get
            image3D = [ [[r[image]]], [[g[image]]], [[b[image]]] ]
            image3D = Transpose(image3d,[2,0,1])
            image3D = Reverse(Temporary(image3D), 3)
         ENDELSE
         Write_TIFF, filename, image3D, 1
         END
   ENDCASE

endfor
;;;;;;;
;;;;;;; end loop
;;;;;;;


; back to default

!x.range=[0.,0.]
!y.range=[0.,0.]
!x.margin=[10.,3.]
!y.margin=[4.,2.]
!p.charsize=1.
!p.thick=1.
!p.multi=0

if (plot_choice ne 'x') then begin
;   device,color=0
   device,/close
;   !p.font=-1
;   set_plot,'x'
endif

;delvar,data1,data2
end

