!***********************************************************************
!     for BOUNDARY CONDITION
!***********************************************************************
subroutine bnd4(uu,uo,x1,nm1,is1,ie1,js1,je1,ks1,ke1, &
                myranki,myrankj,myrankk,icputable)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, iprocs, jprocs, kprocs
  implicit none
  
  integer :: nm1, is1, ie1, js1, je1, ks1, ke1
  integer :: icputable(-1:iprocs,-1:jprocs,-1:kprocs)
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1), &
             uo(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax)
  integer :: myranki, myrankj, myrankk
!
  call bndpefb4(uu,nm1,is1,ie1,js1,je1,ks1,ke1, &
                myranki,myrankj,myrankk,icputable)
  call bndryfb4(uu,uo,x1,nm1,is1,ie1,js1,je1,ks1,ke1, &
                myranki,myrankj,myrankk)
!
  return
end subroutine bnd4
!
!--------------------------------------------------------------------
subroutine bndpefb4(uu,nm1,is1,ie1,js1,je1,ks1,ke1, &
                    myranki,myrankj,myrankk,icputable)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, iprocs, jprocs, kprocs, &
                   iboux1in, iboux1ot, iboux2in, iboux2ot, iboux3in, iboux3ot  
  implicit none
  include 'mpif.h'
  
  integer :: i, j, k, n, m
  integer :: nm1, nm2, ibnd0, ibnd1, is1, ie1, js1, je1, ks1, ke1
  integer :: icputable(-1:iprocs,-1:jprocs,-1:kprocs)
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)

  integer :: myranki, myrankj, myrankk
  integer :: mmx, merr, msnd, mrcv
  integer :: mstatus(mpi_status_size), mreq
  real(8), allocatable :: bufsnd(:,:,:), bufrcv(:,:,:)
!
  nm2=2*nm1-1
!
  ibnd0=1+nm1
  ibnd1=imax-nm1
  call mpi_barrier(mpi_comm_world,merr)
!
  if(iprocs .eq. 1) then

    do k=ks1+nm1,ke1-nm1
      do j=js1+nm1,je1-nm1
        do i=1,nm1
          do m=1,nv 
           if( iboux1in(m) .eq. 1 .or. iboux1ot(m) .eq. 1 ) then
!             uu(m,n,j,k)=uu(m,imax-nm1-n,j,k)
!             uu(m,imax-n,j,k)=uu(m,nm2-n,j,k)

!             uu(m,n,j,k)=uu(m,imax-nm2+n,j,k)
!             uu(m,imax-n,j,k)=uu(m,nm2-n,j,k)

              uu(m,ibnd0-i,j,k)=uu(m,ibnd1+1-i,j,k)
              uu(m,ibnd1+i,j,k)=uu(m,ibnd0-1+i,j,k)

            endif
          enddo
        enddo
      enddo
    enddo
!
  else
    do m=1,nv
      if( iboux1in(m) .eq. 1 ) then
!
        if(myranki .eq. 0 .or. myranki .eq. iprocs-1) then
          allocate(bufsnd(nm1,js1:je1,ks1:ke1), &
                   bufrcv(nm1,js1:je1,ks1:ke1), stat=merr)
          mmx=nm1*(je1-js1+1)*(ke1-ks1+1)
          msnd=icputable(0,myrankj,myrankk)
          mrcv=icputable(iprocs-1,myrankj,myrankk)

          if(myranki .eq. iprocs-1) then
            do k=ks1,ke1
              do j=js1,je1
                do i=1,nm1
                  bufsnd(i,j,k)=uu(m,ibnd1+1-i,j,k)
                enddo
              enddo
            enddo
            call mpi_isend(bufsnd,mmx,mpi_double_precision, &
                       msnd,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)
          endif

          if(myranki .eq. 0) then
            call mpi_irecv(bufrcv,mmx,mpi_double_precision, &
                       mrcv,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)          
            do k=ks1,ke1
              do j=js1,je1
                do i=1,nm1             
                  uu(m,ibnd0-i,j,k)=bufrcv(i,j,k) 
                enddo
              enddo
            enddo
          endif
!
        endif
        deallocate(bufsnd, bufrcv, stat=merr)
      endif
!
      if(iboux1ot(m) .eq. 1 ) then
!
        if(myranki .eq. 0 .or. myranki .eq. iprocs-1) then 
          allocate(bufsnd(nm1,js1:je1,ks1:ke1), &
                   bufrcv(nm1,js1:je1,ks1:ke1), stat=merr)
          mmx=nm1*(je1-js1+1)*(ke1-ks1+1)
          msnd=icputable(iprocs-1,myrankj,myrankk)
          mrcv=icputable(0,myrankj,myrankk)
        
          if(myranki .eq. 0) then
            do k=ks1,ke1
              do j=js1,je1
                do i=1,nm1
                  bufsnd(i,j,k)=uu(m,ibnd0-1+i,j,k)
                enddo
              enddo
            enddo
            call mpi_isend(bufsnd,mmx,mpi_double_precision, &
                       msnd,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)          
          endif
!
          if(myranki .eq. iprocs-1) then
            call mpi_irecv(bufrcv,mmx,mpi_double_precision, &
                           mrcv,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)             
            do k=ks1,ke1
              do j=js1,je1
                do i=1,nm1             
                  uu(m,ibnd1+i,j,k)=bufrcv(i,j,k) 
                enddo
              enddo
            enddo
          endif
!
        endif  
        deallocate(bufsnd, bufrcv, stat=merr)
      endif
!
    enddo
!      
  endif
!
!
  ibnd0=1+nm1
  ibnd1=jmax-nm1
  call mpi_barrier(mpi_comm_world,merr)
!
  if(jprocs .eq. 1) then

    do k=ks1+nm1,ke1-nm1
      do j=1,nm1
        do i=is1+nm1,ie1-nm1
          do m=1,nv 
           if( iboux2in(m) .eq. 1 .or. iboux2ot(m) .eq. 1 ) then
!             uu(m,i,n,k)=uu(m,i,jmax-nm1-n,k)
!             uu(m,i,jmax-n,k)=uu(m,i,nm2-n,k)

!             uu(m,i,n,k)=uu(m,i,jmax-nm2+n,k)
!             uu(m,i,jmax-n,k)=uu(m,i,nm2-n,k)

              uu(m,i,ibnd0-j,k)=uu(m,i,ibnd1+1-j,k)
              uu(m,i,ibnd1+j,k)=uu(m,i,ibnd0-1+j,k)

            endif
          enddo
        enddo
      enddo
    enddo
!
  else
    do m=1,nv
      if( iboux2in(m) .eq. 1 ) then
!
        if(myrankj .eq. 0 .or. myrankj .eq. jprocs-1) then
          allocate(bufsnd(is1:ie1,nm1,ks1:ke1), &
                   bufrcv(is1:ie1,nm1,ks1:ke1), stat=merr)
          mmx=(ie1-is1+1)*nm1*(ke1-ks1+1)
          msnd=icputable(myranki,0,myrankk)
          mrcv=icputable(myranki,jprocs-1,myrankk)

          if(myrankj .eq. jprocs-1) then
            do k=ks1,ke1
              do j=1,nm1
                do i=is1,ie1
                  bufsnd(i,j,k)=uu(m,i,ibnd1+1-j,k)
                enddo
              enddo
            enddo
            call mpi_isend(bufsnd,mmx,mpi_double_precision, &
                       msnd,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)
          endif

          if(myrankj .eq. 0) then
            call mpi_irecv(bufrcv,mmx,mpi_double_precision, &
                       mrcv,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)          
            do k=ks1,ke1
              do j=1,nm1
                do i=is1,ie1             
                  uu(m,i,ibnd0-j,k)=bufrcv(i,j,k) 
                enddo
              enddo
            enddo
          endif
!
        endif
        deallocate(bufsnd, bufrcv, stat=merr)
      endif
!
      if(iboux2ot(m) .eq. 1 ) then
!
        if(myrankj .eq. 0 .or. myrankj .eq. jprocs-1) then 
          allocate(bufsnd(is1:ie1,nm1,ks1:ke1), &
                   bufrcv(is1:ie1,nm1,ks1:ke1), stat=merr)
          mmx=(ie1-is1+1)*nm1*(ke1-ks1+1)
          msnd=icputable(myranki,jprocs-1,myrankk)
          mrcv=icputable(myranki,0,myrankk)
        
          if(myrankj .eq. 0) then
            do k=ks1,ke1
              do j=1,nm1
                do i=is1,ie1
                  bufsnd(i,j,k)=uu(m,i,ibnd0-1+j,k)
                enddo
              enddo
            enddo
            call mpi_isend(bufsnd,mmx,mpi_double_precision, &
                       msnd,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)          
          endif
!
          if(myrankj .eq. jprocs-1) then
            call mpi_irecv(bufrcv,mmx,mpi_double_precision, &
                           mrcv,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)             
            do k=ks1,ke1
              do j=1,nm1
                do i=is1,ie1             
                  uu(m,i,ibnd1+j,k)=bufrcv(i,j,k) 
                enddo
              enddo
            enddo
          endif
!
        endif  
        deallocate(bufsnd, bufrcv, stat=merr)
      endif
!
    enddo
!      
  endif
!
!
  ibnd0=1+nm1
  ibnd1=kmax-nm1
!
  call mpi_barrier(mpi_comm_world,merr)
!
  if(kprocs .eq. 1) then
!
    do k=1,nm1
      do j=js1+nm1,je1-nm1
        do i=is1+nm1,ie1-nm1
          do m=1,nv
            if( iboux3in(m) .eq. 1 .or. iboux3ot(m) .eq. 1 ) then
!             uu(m,i,j,n)=uu(m,i,j,kmax-nm1-n)
!             uu(m,i,j,kmax-n)=uu(m,i,j,nm2-n)

!             uu(m,i,j,n)=uu(m,i,j,kmax-nm2+n)
!             uu(m,i,j,kmax-n)=uu(m,i,j,nm2-n)
 
              uu(m,i,j,ibnd0-k)=uu(m,i,j,ibnd1+1-k)
              uu(m,i,j,ibnd1+k)=uu(m,i,j,ibnd0-1+k)

            endif
          enddo
        enddo
      enddo
    enddo
!
  else
!
    do m=1,nv
      if( iboux3in(m) .eq. 1 ) then
  
        if(myrankk .eq. 0 .or. myrankk .eq. kprocs-1) then
          allocate(bufsnd(is1:ie1,js1:je1,nm1), &
                   bufrcv(is1:ie1,js1:je1,nm1), stat=merr)
          mmx=(ie1-is1+1)*(je1-js1+1)*nm1
          msnd=icputable(myranki,myrankj,0)
          mrcv=icputable(myranki,myrankj,kprocs-1)

          if(myrankk .eq. kprocs-1) then
            do k=1,nm1
              do j=js1,je1
                do i=is1,ie1
                  bufsnd(i,j,k)=uu(m,i,j,ibnd1+1-k)
                enddo
              enddo
            enddo
            call mpi_isend(bufsnd,mmx,mpi_double_precision, &
                       msnd,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)
          endif

          if(myrankk .eq. 0) then
            call mpi_irecv(bufrcv,mmx,mpi_double_precision, &
                       mrcv,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)          
            do k=1,nm1
              do j=js1,je1
                do i=is1,ie1             
                  uu(m,i,j,ibnd0-k)=bufrcv(i,j,k) 
                enddo
              enddo
            enddo
          endif
!
        endif
        deallocate(bufsnd, bufrcv, stat=merr)
      endif
!
      if(iboux3ot(m) .eq. 1 ) then
!
        if(myrankk .eq. 0 .or. myrankk .eq. kprocs-1) then 
          allocate(bufsnd(is1:ie1,js1:je1,nm1), &
                   bufrcv(is1:ie1,js1:je1,nm1), stat=merr)
          mmx=(ie1-is1+1)*(je1-js1+1)*nm1
          msnd=icputable(myranki,myrankj,kprocs-1)
          mrcv=icputable(myranki,myrankj,0)
        
          if(myrankk .eq. 0) then
            do k=1,nm1
              do j=js1,je1
                do i=is1,ie1
                  bufsnd(i,j,k)=uu(m,i,j,ibnd0-1+k)
                enddo
              enddo
            enddo
            call mpi_isend(bufsnd,mmx,mpi_double_precision, &
                       msnd,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)          
          endif
!
          if(myrankk .eq. kprocs-1) then
            call mpi_irecv(bufrcv,mmx,mpi_double_precision, &
                           mrcv,0,mpi_comm_world,mreq,merr)
            call mpi_wait(mreq,mstatus,merr)             
            do k=1,nm1
              do j=js1,je1
                do i=is1,ie1             
                  uu(m,i,j,ibnd1+k)=bufrcv(i,j,k) 
                enddo
              enddo
            enddo
          endif
!
        endif  
        deallocate(bufsnd, bufrcv, stat=merr)
      endif
!
    enddo
!
  endif
!
  return
end subroutine bndpefb4
!
!--------------------------------------------------------------------
subroutine bndryfb4(uu,uo,x1,nm1,is1,ie1,js1,je1,ks1,ke1, &
                    myranki,myrankj,myrankk)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, iprocs, jprocs, kprocs, &
                   iboux1in, iboux1ot, & 
                   iboux2in, iboux2ot, iboux3in, iboux3ot  
  implicit none
  
  integer :: i, j, k, n, m
  integer :: nm1, is1, ie1, js1, je1, ks1, ke1
  integer :: myranki, myrankj, myrankk
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1), &
             uo(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax)
  real(8) :: rb
!
! ibou
! 1   :    periodic boundary
! 2   :    fixed boundary
! 3   :    Neumann boundary
! 4   :    free boundary
! 5   :    u_0 = u_1       
! 7   :    radiative boundary without eigenvalue
! 12   :    anti-symmetric boundary condition (u_0=-u_1)
! 13   :    regid wall boundary condition (u_0=0.0)
! 15   :    special reflecting boundary 
!           for jet propagation (z-direction only)
! 17   :    special radiative boundary without eigenvalue
!           for jet propagation (z-direction only)
! 19   :    special boundary of u_0=u_1
!           for jet propagation (z-direction only)
!
!     x-direction
!
  do m = 1, nv
!
    if( myranki .eq. 0 .or. iprocs .eq. 1) then
!
      if( iboux1in(m) .eq. 1 ) then
!
      elseif( iboux1in(m) .eq. 2 ) then

        do k = ks1, ke1
          do j = js1, je1
            do n = 1, nm1           
              uu(m,n,j,k)=uo(m,n,j,k)
            enddo
          enddo
        enddo
 
      elseif( iboux1in(m) .eq. 3 ) then
 
        do k = ks1, ke1
          do j = js1, je1
            do n = nm1, 1, -1
              uu(m,n,j,k)=(4.0*uu(m,n+1,j,k)-uu(m,n+2,j,k))/3.0
            enddo
          enddo
        enddo
 
      elseif( iboux1in(m) .eq. 4 ) then
 
        do k = ks1, ke1
          do j = js1, je1
            do n = nm1, 1, -1
              uu(m,n,j,k)=2.0*uu(m,n+1,j,k)-uu(m,n+2,j,k)
            enddo
          enddo
        enddo
 
      elseif( iboux1in(m) .eq. 5 ) then
 
        do k = ks1, ke1
          do j = js1, je1
            do n = nm1, 1, -1
              uu(m,n,j,k)=uu(m,1+nm1,j,k)
            enddo
          enddo
        enddo
 
      elseif( iboux1in(m) .eq. 12 ) then
 
        do k = ks1, ke1
          do j = js1, je1
            do n = 1, nm1
              uu(m,n,j,k)=-uu(m,nm1+n,j,k)
            enddo
          enddo
        enddo
 
      elseif( iboux1in(m) .eq. 13 ) then
    
        do k = ks1, ke1
          do j = js1, je1
            do n = 1, nm1
              uu(m,n,j,k)=0.0d0
            enddo
          enddo
        enddo

      elseif( iboux1in(m) .eq. 7 ) then
  
        do k = ks1, ke1
          do j = js1, je1
            do n = nm1, 1, -1
              uu(m,n,j,k)=uo(m,n,j,k)+uu(m,n+1,j,k)-uo(m,n+1,j,k)
            enddo
          enddo
        enddo
  
      else
!      write(4,*) 'inner boundary setting error for x1 axis'
!      write(4,*) 'stop in bndry'
      endif
!
    endif
!
    if(myranki .eq. iprocs-1 .or. iprocs .eq. 1) then

      if( iboux1ot(m) .eq. 1 ) then
!
      elseif(iboux1ot(m) .eq. 2 ) then

        do k = ks1, ke1
          do j = js1, je1
            do n = 0, nm1-1
              uu(m,imax-n,j,k)=uo(m,imax-n,j,k)
            enddo
          enddo
        enddo
 
      elseif(iboux1ot(m) .eq. 3 ) then

        do k = ks1, ke1
          do j = js1, je1
            do n = nm1-1, 0, -1
              uu(m,imax-n,j,k)=(4.0*uu(m,imax-n-1,j,k)-uu(m,imax-n-2,j,k))/3.0
            enddo
          enddo
        enddo
 
      elseif(iboux1ot(m) .eq. 4 ) then

        do k = ks1, ke1
          do j = js1, je1
            do n = nm1-1, 0, -1
              uu(m,imax-n,j,k)=2.0*uu(m,imax-n-1,j,k)-uu(m,imax-n-2,j,k)
            enddo
          enddo
        enddo
 
      elseif(iboux1ot(m) .eq. 5 ) then 
        do k = ks1, ke1
          do j = js1, je1
            do n = nm1-1, 0, -1
              uu(m,imax-n,j,k)=uu(m,imax-nm1,j,k)
            enddo
          enddo
        enddo
 
      elseif(iboux1ot(m) .eq. 12 ) then
 
        do k = ks1, ke1
          do j = js1, je1
            do n = 0, nm1-1
              uu(m,imax-n,j,k)=-uu(m,imax-nm1-n,j,k)
            enddo
          enddo
        enddo

      elseif(iboux1ot(m) .eq. 13 ) then

        do k = ks1, ke1
          do j = js1, je1
            do n = 0, nm1-1
              uu(m,imax-n,j,k)=0.d0
            enddo
          enddo
        enddo

      elseif(iboux1ot(m) .eq. 7 ) then

        do k = ks1, ke1
          do j = js1, je1
            do n = nm1-1, 0, -1
             uu(m,imax-n,j,k)=uo(m,imax-n,j,k) &
                                 +uu(m,imax-n-1,j,k)-uo(m,imax-n-1,j,k)
            enddo
          enddo
        enddo 

      else
!        write(4,*) 'outer boundary setting error for x1 axis'
!        write(4,*) 'stop in bndry'
      endif
!
    endif
!
  enddo
!
!     y-direction
!

  do m = 1, nv

!
    if( myrankj .eq. 0 .or. jprocs .eq. 1) then
!
      if( iboux2in(m) .eq. 1 ) then
!
      elseif( iboux2in(m) .eq. 2 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = 1, nm1
              uu(m,i,n,k)=uo(m,i,n,k)
            enddo
          enddo
        enddo
 
      elseif( iboux2in(m) .eq. 3 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = nm1, 1, -1
              uu(m,i,n,k)=(4.0*uu(m,i,n+1,k)-uu(m,i,n+2,k))/3.0
            enddo
          enddo
        enddo
 
      elseif( iboux2in(m) .eq. 4 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = nm1, 1, -1
              uu(m,i,n,k)=2.0*uu(m,i,n+1,k)-uu(m,i,n+2,k)
            enddo
          enddo
        enddo
 
      elseif( iboux2in(m) .eq. 5 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = nm1, 1, -1
              uu(m,i,n,k)=uu(m,i,1+nm1,k)
            enddo
          enddo
        enddo
 
      elseif( iboux2in(m) .eq. 12 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = 1, nm1
              uu(m,i,n,k)=-uu(m,i,nm1+n+1,k)
            enddo
          enddo
        enddo

      elseif( iboux2in(m) .eq. 13 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = 1, nm1
              uu(m,i,n,k)=0.0d0
            enddo
          enddo
        enddo

      elseif( iboux2in(m) .eq. 7 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = nm1, 1, -1
              uu(m,i,n,k)=uo(m,i,n,k)+uu(m,i,n+1,k)-uo(m,i,n+1,k)
            enddo
          enddo
        enddo
        
      else
!        write(4,*) 'inner boundary setting error for x2 axis'
!        write(4,*) 'stop in bndry'
      endif
!
    endif
!
    if(myrankj .eq. jprocs-1 .or. jprocs .eq. 1) then

      if( iboux2ot(m) .eq. 1 ) then
!
      elseif( iboux2ot(m) .eq. 2 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = 0, nm1-1
              uu(m,i,jmax-n,k)=uo(m,i,jmax-n,k)
            enddo
          enddo
        enddo
 
      elseif( iboux2ot(m) .eq. 3 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = nm1-1, 0, -1
              uu(m,i,jmax-n,k)=(4.0*uu(m,i,jmax-n-1,k)-uu(m,i,jmax-n-2,k))/3.0
            enddo
          enddo
        enddo
 
      elseif(iboux2ot(m) .eq. 4 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = nm1-1, 0, -1
              uu(m,i,jmax-n,k)=2.0*uu(m,i,jmax-n-1,k)-uu(m,i,jmax-n-2,k)
            enddo
          enddo
        enddo
 
      elseif(iboux2ot(m) .eq. 5 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = nm1-1, 0, -1
              uu(m,i,jmax-n,k)=uu(m,i,jmax-nm1,k)
            enddo
          enddo
        enddo
 
      elseif(iboux2ot(m) .eq. 12 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = 0, nm1-1
              uu(m,i,jmax-n,k)=-uu(m,i,jmax-nm1-n,k)
            enddo
          enddo
        enddo

      elseif(iboux2ot(m) .eq. 13 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = 0, nm1-1
              uu(m,i,jmax-n,k)=0.0d0
            enddo
          enddo
        enddo

      elseif(iboux2ot(m) .eq. 7 ) then

        do k = ks1, ke1
          do i = is1, ie1
            do n = nm1-1, 0, -1
              uu(m,i,jmax-n,k)=uo(m,i,jmax-n,k)&
                                +uu(m,i,jmax-n-1,k)-uo(m,i,jmax-n-1,k)
            enddo
          enddo
        enddo
 
      else
!        write(4,*) 'outer boundary setting error for x2 axis'
!        write(4,*) 'stop in bndry'
      endif
!
    endif
!
  enddo
!
!     z-direction
!
  do m = 1, nv
!
    if(myrankk .eq. 0 .or. kprocs .eq. 1) then
!
      if( iboux3in(m) .eq. 1 ) then

      elseif(iboux3in(m) .eq. 2 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = 1, nm1
              uu(m,i,j,n)=uo(m,i,j,n)
            enddo
          enddo
        enddo
 
      elseif(iboux3in(m) .eq. 3 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = nm1, 1, -1
              uu(m,i,j,n)=(4.0*uu(m,i,j,n+1)-uu(m,i,j,n+2))/3.0
            enddo
          enddo
        enddo
 
      elseif(iboux3in(m) .eq. 4 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = nm1, 1, -1
              uu(m,i,j,n)=2.0*uu(m,i,j,n+1)-uu(m,i,j,n+2)
            enddo
          enddo
        enddo
 
      elseif(iboux3in(m) .eq. 5 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = nm1, 1, -1
              uu(m,i,j,n)=uu(m,i,j,1+nm1)
            enddo
          enddo
        enddo
 
      elseif(iboux3in(m) .eq. 12 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = 1, nm1
              uu(m,i,j,n)=-uu(m,i,j,nm1+n)
            enddo
          enddo
        enddo

      elseif(iboux3in(m) .eq. 13 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = 1, nm1
              uu(m,i,j,n)=0.d0
            enddo
          enddo
        enddo

      elseif(iboux3in(m) .eq. 7 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = nm1, 1, -1
              uu(m,i,j,n)=uo(m,i,j,n)+uu(m,i,j,n+1)-uo(m,i,j,n+1)
            enddo
          enddo
        enddo

      elseif( iboux3in(m) .eq. 15 ) then

        rb=1.0d0
        do j= js1, je1
          do i= is1, ie1
            do n = nm1, 1, -1
          
              if (x1(i) .le. rb) then
                uu(m,i,j,n)=uo(m,i,j,n)
              else
                uu(m,i,j,n)=uu(m,i,j,1+nm1)
              endif
            enddo
          enddo
        enddo

      elseif( iboux3in(m) .eq. 17 ) then
!
! rb : jet beam radius
!
       rb=1.d0
        do j= js1, je1
          do i= is1, ie1
            do n = nm1, 1, -1
          
              if (x1(i) .le. rb) then
                uu(m,i,j,n)=uo(m,i,j,n)
              else
                uu(m,i,j,n)=uo(m,i,j,n)+uu(m,i,j,n+1)-uo(m,i,j,n+1)
              endif
            enddo
          enddo
        enddo

      elseif( iboux3in(m) .eq. 19 ) then

        rb=1.d0

        do j= js1, je1
          do i= is1, ie1
            do n = 1, nm1

              if (x1(i) .le. rb) then
                uu(m,i,j,n)=uo(m,i,j,n)
              else
                uu(m,i,j,n)=-uu(m,i,j,nm1+n)
              endif
            enddo
          enddo
        enddo
!
      else
!        write(4,*) 'inner boundary setting error for x3 axis'
!        write(4,*) 'stop in bndry'
      endif
!
    endif
!
    if(myrankk .eq. kprocs-1 .or. kprocs .eq. 1) then
!
      if( iboux3ot(m) .eq. 1 ) then
!
      elseif( iboux3ot(m) .eq. 2 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = 0, nm1-1
              uu(m,i,j,kmax-n)=uo(m,i,j,kmax-n)
            enddo
          enddo
        enddo
 
      elseif( iboux3ot(m) .eq. 3 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = nm1-1, 0, -1
              uu(m,i,j,kmax-n)=(4.0*uu(m,i,j,kmax-n-1)-uu(m,i,j,kmax-n-2))/3.0
            enddo
          enddo
        enddo
 
      elseif(iboux3ot(m) .eq. 4 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = nm1-1, 0, -1
              uu(m,i,j,kmax-n)=2.0*uu(m,i,j,kmax-n-1)-uu(m,i,j,kmax-n-2)
            enddo
          enddo
        enddo
 
      elseif(iboux3ot(m) .eq. 5 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = nm1-1, 0, -1
              uu(m,i,j,kmax-n)=uu(m,i,j,kmax-nm1)
            enddo
          enddo
        enddo
 
      elseif(iboux3ot(m) .eq. 12 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = 0, nm1-1
              uu(m,i,j,kmax-n)=-uu(m,i,j,kmax-nm1-n)
            enddo
          enddo
        enddo

      elseif(iboux3ot(m) .eq. 13 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = 0, nm1-1
              uu(m,i,j,kmax-n)=0.d0
            enddo
          enddo
        enddo
!
      elseif(iboux3ot(m) .eq. 7 ) then

        do j = js1, je1
          do i = is1, ie1
            do n = nm1-1, 0, -1
              uu(m,i,j,kmax-n)=uo(m,i,j,kmax-n)+uu(m,i,j,kmax-n-1) &
                             -uo(m,i,j,kmax-n-1)
            enddo
          enddo
        enddo
 
      else
!        write(4,*) 'outer boundary setting error for x3 axis'
!        write(4,*) 'stop in bndry'
      endif
!
    endif
!
  enddo
!
  return
end subroutine bndryfb4 
