!---------------------------------------------------------------------
subroutine calcha4a(uriir,urijr,urikr,uriil,urijl,urikl,&
                    cmaxi,cmini,cmaxj,cminj,cmaxk,cmink,nm0,&
                    is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------
!
!     Calculate characteristics for HLLE method at cell-interface
!
  use pram, only : imax, jmax, kmax, nv
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0
  integer :: merr
!
  real(8) :: uriir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uriil(nv,is1:ie1,js1:je1,ks1:ke1), & 
             urijr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijl(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikl(nv,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: cmaxi(is1:ie1,js1:je1,ks1:ke1), cmini(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: cmaxj(is1:ie1,js1:je1,ks1:ke1), cminj(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: cmaxk(is1:ie1,js1:je1,ks1:ke1), cmink(is1:ie1,js1:je1,ks1:ke1)
!      
  real(8), allocatable :: vfipr(:,:,:), vfimr(:,:,:), &
           vfjpr(:,:,:), vfjmr(:,:,:), vfkpr(:,:,:), vfkmr(:,:,:), &
           vfipl(:,:,:), vfiml(:,:,:), vfjpl(:,:,:), vfjml(:,:,:), &
           vfkpl(:,:,:), vfkml(:,:,:)

  real(8) :: cmaxi1, cmini1, cmaxj1, cminj1, cmaxk1, cmink1
!
  allocate( vfipr(is1:ie1,js1:je1,ks1:ke1), vfimr(is1:ie1,js1:je1,ks1:ke1), &
            vfjpr(is1:ie1,js1:je1,ks1:ke1), vfjmr(is1:ie1,js1:je1,ks1:ke1), &
            vfkpr(is1:ie1,js1:je1,ks1:ke1), vfkmr(is1:ie1,js1:je1,ks1:ke1), &
            vfipl(is1:ie1,js1:je1,ks1:ke1), vfiml(is1:ie1,js1:je1,ks1:ke1), &
            vfjpl(is1:ie1,js1:je1,ks1:ke1), vfjml(is1:ie1,js1:je1,ks1:ke1), &
            vfkpl(is1:ie1,js1:je1,ks1:ke1), vfkml(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr)
!=====================================================================@

  call calcha4i(uriir,vfipr,vfimr,nm0,is1,ie1,js1,je1,ks1,ke1)
  call calcha4j(urijr,vfjpr,vfjmr,nm0,is1,ie1,js1,je1,ks1,ke1)
  call calcha4k(urikr,vfkpr,vfkmr,nm0,is1,ie1,js1,je1,ks1,ke1)
  call calcha4i(uriil,vfipl,vfiml,nm0,is1,ie1,js1,je1,ks1,ke1)
  call calcha4j(urijl,vfjpl,vfjml,nm0,is1,ie1,js1,je1,ks1,ke1)
  call calcha4k(urikl,vfkpl,vfkml,nm0,is1,ie1,js1,je1,ks1,ke1)

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0

         cmaxi1=max(0.d0,vfipr(i,j,k),vfipl(i,j,k))
         cmini1=min(0.d0,vfimr(i,j,k),vfiml(i,j,k))

         cmaxj1=max(0.d0,vfjpr(i,j,k),vfjpl(i,j,k))
         cminj1=min(0.d0,vfjmr(i,j,k),vfjml(i,j,k))

         cmaxk1=max(0.d0,vfkpr(i,j,k),vfkpl(i,j,k))
         cmink1=min(0.d0,vfkpr(i,j,k),vfkml(i,j,k))

         cmaxi(i,j,k)=cmaxi1
         cmini(i,j,k)=cmini1
         
         cmaxj(i,j,k)=cmaxj1
         cminj(i,j,k)=cminj1
     
         cmaxk(i,j,k)=cmaxk1
         cmink(i,j,k)=cmink1

      enddo
    enddo
  enddo

  deallocate( vfipr, vfimr, vfjpr, vfjmr, vfkpr, vfkmr, &
              vfipl, vfiml, vfjpl, vfjml, vfkpl, vfkml, stat=merr )
!
  return
end subroutine calcha4a
!
!---------------------------------------------------------------------@
subroutine calcha4(uri,vfip,vfim,vfjp,vfjm,vfkp,vfkm,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate characteristics for HLLE method at cell-interface
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, metric, ieos, icha
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
!
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
!      
  real(8) :: vfip(is1:ie1,js1:je1,ks1:ke1), vfim(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: vfjp(is1:ie1,js1:je1,ks1:ke1), vfjm(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: vfkp(is1:ie1,js1:je1,ks1:ke1), vfkm(is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: ro, v1, v2, v3, pp, b1, b2, b3, bt, vt, vb, deh, gf
  real(8) :: cssq, bbt, vasq, omsq, f1i, f1j, f1k, r1, f2, f3i, f3j, f3k
!     
!=====================================================================@

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        ro=uri(1,i,j,k)
        v1=uri(2,i,j,k)
        v2=uri(3,i,j,k)
        v3=uri(4,i,j,k)
        pp=uri(5,i,j,k)
        b1=uri(7,i,j,k)
        b2=uri(8,i,j,k)
        b3=uri(9,i,j,k)
        bt=b1*b1+b2*b2+b3*b3
        vt=v1*v1+v2*v2+v3*v3
        vb=v1*b1+v2*b2+v3*b3
         
        if(ieos .eq. 0) then
          deh=ro+(gam/(gam-1.0))*pp
        elseif(ieos .eq. 1) then
          deh=(5./2.)*pp+sqrt((9./4.)*pp**2 + ro**2)
        endif
        
        gf=1.0/sqrt(1.0-vt/c0**2)
         
        if(ieos .eq. 0) then
          cssq=gam*pp/deh
        elseif(ieos .eq. 1) then
          cssq=(pp/(3.0*deh))*((5.0*deh-8.0*pp)/(deh-pp))
        endif
          
        bbt=(bt/gf**2)+vb**2
         
        vasq=bbt/(deh+bbt)
        omsq=vasq+cssq*(1.0-vasq/c0)

        if(icha .eq. 0) then
!
!  --- Gammie et al. (2003)

          vfip(i,j,k)=v1+sqrt(omsq)
          vfjp(i,j,k)=v2+sqrt(omsq)
          vfkp(i,j,k)=v3+sqrt(omsq)
         
          vfim(i,j,k)=v1-sqrt(omsq)
          vfjm(i,j,k)=v2-sqrt(omsq)
          vfkm(i,j,k)=v3-sqrt(omsq)
          
        elseif(icha .eq. 1) then
!
!  --- Leismann et al. (2005)

          f1i=v1*(1.0-omsq)
          f1j=v2*(1.0-omsq)
          f1k=v3*(1.0-omsq)

          r1=cssq*vb**2/((deh+bbt)*gf**2)
         
          f2=1.0-vt*omsq-r1
         
          f3i=((vt-1.0)*omsq+r1)*((vt-v1**2)*omsq+v1**2-1.0+r1)
          f3j=((vt-1.0)*omsq+r1)*((vt-v2**2)*omsq+v2**2-1.0+r1)
          f3k=((vt-1.0)*omsq+r1)*((vt-v3**2)*omsq+v3**2-1.0+r1)

          vfip(i,j,k)=(f1i/f2)+(sqrt(f3i)/f2)
          vfjp(i,j,k)=(f1j/f2)+(sqrt(f3j)/f2)
          vfkp(i,j,k)=(f1k/f2)+(sqrt(f3k)/f2)
         
          vfim(i,j,k)=(f1i/f2)-(sqrt(f3i)/f2)
          vfjm(i,j,k)=(f1j/f2)-(sqrt(f3j)/f2)
          vfkm(i,j,k)=(f1k/f2)-(sqrt(f3k)/f2)

        elseif(icha .eq. 2) then
!
! --- Del Zanna et al. (2007)
         
          f1i=v1*(1.0-omsq)
          f1j=v2*(1.0-omsq)
          f1k=v3*(1.0-omsq)
         
          f2=1.0-vt*omsq
         
          f3i=((vt-1.0)*omsq)*((vt-v1**2)*omsq+v1**2-1.0)
          f3j=((vt-1.0)*omsq)*((vt-v2**2)*omsq+v2**2-1.0)
          f3k=((vt-1.0)*omsq)*((vt-v3**2)*omsq+v3**2-1.0)
         
          vfip(i,j,k)=(f1i/f2)+(sqrt(f3i)/f2)
          vfjp(i,j,k)=(f1j/f2)+(sqrt(f3j)/f2)
          vfkp(i,j,k)=(f1k/f2)+(sqrt(f3k)/f2)
         
          vfim(i,j,k)=(f1i/f2)-(sqrt(f3i)/f2)
          vfjm(i,j,k)=(f1j/f2)-(sqrt(f3j)/f2)
          vfkm(i,j,k)=(f1k/f2)-(sqrt(f3k)/f2)

        endif          
      enddo
    enddo
  enddo

   return
end subroutine calcha4
!
!---------------------------------------------------------------------@
subroutine calcha4i(uri,vfip,vfim,nm0,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate characteristics for HLLE method at cell-interface
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, metric, ieos, icha
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0
!
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: vfip(is1:ie1,js1:je1,ks1:ke1), vfim(is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: ro, v1, v2, v3, pp, b1, b2, b3, bt, vt, vb, deh, gf
  real(8) :: cssq, bbt, vasq, omsq, f1i, r1, f2, f3i
!     
!=====================================================================@

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        ro=uri(1,i,j,k)
        v1=uri(2,i,j,k)
        v2=uri(3,i,j,k)
        v3=uri(4,i,j,k)
        pp=uri(5,i,j,k)
        b1=uri(7,i,j,k)
        b2=uri(8,i,j,k)
        b3=uri(9,i,j,k)
        bt=b1*b1+b2*b2+b3*b3
        vt=v1*v1+v2*v2+v3*v3
        vb=v1*b1+v2*b2+v3*b3
         
        if(ieos .eq. 0) then
          deh=ro+(gam/(gam-1.0))*pp
        elseif(ieos .eq. 1) then
          deh=(5./2.)*pp+sqrt((9./4.)*pp**2 + ro**2)
        endif
          
        gf=1.0/sqrt(1.0-vt/c0**2)
         
        if(ieos .eq. 0) then
          cssq=gam*pp/deh
        elseif(ieos .eq. 1) then
          cssq=(pp/(3.0*deh))*((5.0*deh-8.0*pp)/(deh-pp))
        endif
          
        bbt=(bt/gf**2)+vb**2
         
        vasq=bbt/(deh+bbt)
        omsq=vasq+cssq*(1.0-vasq/c0)

        if(icha .eq. 0) then
!
!  --- Gammie et al. (2003)

          vfip(i,j,k)=v1+sqrt(omsq)
          vfim(i,j,k)=v1-sqrt(omsq)
          
        elseif(icha .eq. 1) then
!
!  --- Leismann et al. (2005)

          f1i=v1*(1.0-omsq)
          r1=cssq*vb**2/((deh+bbt)*gf**2)
          f2=1.0-vt*omsq-r1
          f3i=((vt-1.0)*omsq+r1)*((vt-v1**2)*omsq+v1**2-1.0+r1)
          
          vfip(i,j,k)=(f1i/f2)+(sqrt(f3i)/f2)
          vfim(i,j,k)=(f1i/f2)-(sqrt(f3i)/f2)

        elseif(icha .eq. 2) then
!
! --- Del Zanna et al. (2007)
         
          f1i=v1*(1.0-omsq)
          f2=1.0-vt*omsq
          f3i=((vt-1.0)*omsq)*((vt-v1**2)*omsq+v1**2-1.0)

          vfip(i,j,k)=(f1i/f2)+(sqrt(f3i)/f2)
          vfim(i,j,k)=(f1i/f2)-(sqrt(f3i)/f2)

        endif

      enddo
    enddo
  enddo

  return
end subroutine calcha4i
!
!---------------------------------------------------------------------@
subroutine calcha4j(uri,vfjp,vfjm,nm0,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate characteristics for HLLE method at cell-interface
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, metric, ieos, icha
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0
!
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: vfjp(is1:ie1,js1:je1,ks1:ke1), vfjm(is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: ro, v1, v2, v3, pp, b1, b2, b3, bt, vt, vb, deh, gf
  real(8) :: cssq, bbt, vasq, omsq, f1j, r1, f2, f3j
!
!=====================================================================@

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0

        ro=uri(1,i,j,k)
        v1=uri(2,i,j,k)
        v2=uri(3,i,j,k)
        v3=uri(4,i,j,k)
        pp=uri(5,i,j,k)
        b1=uri(7,i,j,k)
        b2=uri(8,i,j,k)
        b3=uri(9,i,j,k)
        bt=b1*b1+b2*b2+b3*b3
        vt=v1*v1+v2*v2+v3*v3
        vb=v1*b1+v2*b2+v3*b3
         
        if(ieos .eq. 0) then
          deh=ro+(gam/(gam-1.0))*pp
        elseif(ieos .eq. 1) then
          deh=(5./2.)*pp+sqrt((9./4.)*pp**2 + ro**2)
        endif
          
        gf=1.0/sqrt(1.0-vt/c0**2)
         
        if(ieos .eq. 0) then
          cssq=gam*pp/deh
        elseif(ieos .eq. 1) then
          cssq=(pp/(3.0*deh))*((5.0*deh-8.0*pp)/(deh-pp))
        endif
          
        bbt=(bt/gf**2)+vb**2
         
        vasq=bbt/(deh+bbt)
        omsq=vasq+cssq*(1.0-vasq/c0)

        if(icha .eq. 0) then
!
!  --- Gammie et al. (2003)

          vfjp(i,j,k)=v2+sqrt(omsq)
          vfjm(i,j,k)=v2-sqrt(omsq)
          
        elseif(icha .eq. 1) then
!
!  --- Leismann et al. (2005)

          f1j=v2*(1.0-omsq)
          r1=cssq*vb**2/((deh+bbt)*gf**2)
          f2=1.0-vt*omsq-r1
          f3j=((vt-1.0)*omsq+r1)*((vt-v2**2)*omsq+v2**2-1.0+r1)

          vfjp(i,j,k)=(f1j/f2)+(sqrt(f3j)/f2)
          vfjm(i,j,k)=(f1j/f2)-(sqrt(f3j)/f2)
!
        elseif(icha .eq. 2) then
!
! --- Del Zanna et al. (2007)
         
          f1j=v2*(1.0-omsq)
          f2=1.0-vt*omsq
          f3j=((vt-1.0)*omsq)*((vt-v2**2)*omsq+v2**2-1.0)

          vfjp(i,j,k)=(f1j/f2)+(sqrt(f3j)/f2)
          vfjm(i,j,k)=(f1j/f2)-(sqrt(f3j)/f2)
         
        endif

      enddo
    enddo
  enddo

  return
end subroutine calcha4j
!
!---------------------------------------------------------------------@
subroutine calcha4k(uri,vfkp,vfkm,nm0,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate characteristics for HLLE method at cell-interface
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, metric, ieos, icha
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0
!
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: vfkp(is1:ie1,js1:je1,ks1:ke1), vfkm(is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: ro, v1, v2, v3, pp, b1, b2, b3, bt, vt, vb, deh, gf
  real(8) :: cssq, bbt, vasq, omsq, f1k, r1, f2, f3k
!
!=====================================================================@

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        ro=uri(1,i,j,k)
        v1=uri(2,i,j,k)
        v2=uri(3,i,j,k)
        v3=uri(4,i,j,k)
        pp=uri(5,i,j,k)
        b1=uri(7,i,j,k)
        b2=uri(8,i,j,k)
        b3=uri(9,i,j,k)
        bt=b1*b1+b2*b2+b3*b3
        vt=v1*v1+v2*v2+v3*v3
        vb=v1*b1+v2*b2+v3*b3
         
        if(ieos .eq. 0) then
          deh=ro+(gam/(gam-1.0))*pp
        elseif(ieos .eq. 1) then
          deh=(5./2.)*pp+sqrt((9./4.)*pp**2 + ro**2)
        endif
          
        gf=1.0/sqrt(1.0-vt/c0**2)
         
        if(ieos .eq. 0) then
          cssq=gam*pp/deh
        elseif(ieos .eq. 1) then
          cssq=(pp/(3.0*deh))*((5.0*deh-8.0*pp)/(deh-pp))
        endif
          
        bbt=(bt/gf**2)+vb**2
         
        vasq=bbt/(deh+bbt)
        omsq=vasq+cssq*(1.0-vasq/c0)

        if(icha .eq. 0) then
!
!  --- Gammie et al. (2003)

          vfkp(i,j,k)=v3+sqrt(omsq)
          vfkm(i,j,k)=v3-sqrt(omsq)
          
        elseif(icha .eq. 1) then
!
!  --- Leismann et al. (2005)

          f1k=v3*(1.0-omsq)
          r1=cssq*vb**2/((deh+bbt)*gf**2)
          f2=1.0-vt*omsq-r1
          f3k=((vt-1.0)*omsq+r1)*((vt-v3**2)*omsq+v3**2-1.0+r1)

          vfkp(i,j,k)=(f1k/f2)+(sqrt(f3k)/f2)
          vfkm(i,j,k)=(f1k/f2)-(sqrt(f3k)/f2)

        elseif(icha .eq. 2) then
!
! --- Del Zanna et al. (2007)
         
          f1k=v3*(1.0-omsq)
          f2=1.0-vt*omsq
          f3k=((vt-1.0)*omsq)*((vt-v3**2)*omsq+v3**2-1.0)

          vfkp(i,j,k)=(f1k/f2)+(sqrt(f3k)/f2)
          vfkm(i,j,k)=(f1k/f2)-(sqrt(f3k)/f2)

        endif
       
      enddo
    enddo
  enddo

  return
end subroutine calcha4k
!
