!-----------------------------------------------------------------------
subroutine cdtcfl3(uri,hh,dtcfl,iact,dx1,dx2,dx3,dtx1,dtx2,dtx3,nm1, &
                   is1,ie1,js1,je1,ks1,ke1)
!-----------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, gam, c0, ieos
  implicit none

  integer :: i, j, k
  integer :: nm1, nmax, is1, ie1, js1, je1, ks1, ke1, merr

  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
      
  real(8), allocatable :: dtx1a(:,:,:), dtx2a(:,:,:), dtx3a(:,:,:)
     
  real(8) :: dx1(imax), dx2(jmax), dx3(kmax)
      
  integer :: iact(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: pmin, dmax, vmin, dtx1, dtx2, dtx3, dtcfl
  real(8) :: ro, v1, v2, v3, pp, b1, b2, b3, bt, vt, vb, deh, gf 
  real(8) :: cssq, bbt, vasq, omsq, f1i, f1j, f1k, r1, f2, f3i, f3j, f3k 
  real(8) :: vfip, vfjp, vfkp, vfim, vfjm, vfkm, vfi, vfj, vfk
!
  allocate( dtx1a(is1:ie1,js1:je1,ks1:ke1), dtx2a(is1:ie1,js1:je1,ks1:ke1), &
             dtx3a(is1:ie1,js1:je1,ks1:ke1),stat=merr )
!
!  nmax=nm1*2+(nm1-1)
  nmax=nm1*3
      
  pmin=uri(5,1,1,1)
  dmax=uri(1,1,1,1)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        dmax=max(dmax,uri(1,i,j,k))
        pmin=min(pmin,uri(5,i,j,k))
      enddo
    enddo
  enddo

  vmin=sqrt(gam*pmin/dmax)
!
  dtx1=abs(dx1(1)*hh(1,1,1,1)/vmin)
  dtx2=abs(dx2(1)*hh(2,1,1,1)/vmin)
  dtx3=abs(dx3(1)*hh(3,1,1,1)/vmin)
  dtcfl=max(dtx1,dtx2,dtx3)
!
  do k=ks1+1,ke1-1
    do j=js1+1,je1-1
      do i=is1+1,ie1-1
        if( iact(i,j,k).eq.1 ) then
          ro=uri(1,i,j,k)
          v1=uri(2,i,j,k)
          v2=uri(3,i,j,k)
          v3=uri(4,i,j,k)
          pp=uri(5,i,j,k)
          b1=uri(7,i,j,k)
          b2=uri(8,i,j,k)
          b3=uri(9,i,j,k)
          bt=b1*b1+b2*b2+b3*b3
          vt=v1*v1+v2*v2+v3*v3
          vb=v1*b1+v2*b2+v3*b3
         
          if(ieos .eq. 0) then
            deh=ro+(gam/(gam-1.0))*pp
          elseif(ieos .eq. 1) then
            deh=(5./2.)*pp+sqrt((9./4.)*pp**2 + ro**2)
          endif
          
          gf=1.0/sqrt(1.0-vt/c0**2)
         
          if(ieos .eq. 0) then
            cssq=gam*pp/deh
          elseif(ieos .eq. 1) then
            cssq=(pp/(3.0*deh))*((5.0*deh-8.0*pp)/(deh-pp))
          endif
          
          bbt=(bt/gf**2)+vb**2
         
          vasq=bbt/(deh+bbt)
          omsq=vasq+cssq*(1.0-vasq/c0)

          f1i=v1*(1.0-omsq)
          f1j=v2*(1.0-omsq)
          f1k=v3*(1.0-omsq)
!
!  --- Leismann et al. (2005)

          r1=cssq*vb**2/((deh+bbt)*gf**2)
         
          f2=1.0-vt*omsq-r1
         
          f3i=((vt-1.0)*omsq+r1)*((vt-v1**2)*omsq+v1**2-1.0+r1)
          f3j=((vt-1.0)*omsq+r1)*((vt-v2**2)*omsq+v2**2-1.0+r1)
          f3k=((vt-1.0)*omsq+r1)*((vt-v3**2)*omsq+v3**2-1.0+r1)
!
! --- Del Zanna et al. (2007)
         
!          f2=1.0-vt*omsq
!         
!          f3i=((vt-1.0)*omsq)*((vt-v1**2)*omsq+v1**2-1.0)
!          f3j=((vt-1.0)*omsq)*((vt-v2**2)*omsq+v2**2-1.0)
!          f3k=((vt-1.0)*omsq)*((vt-v3**2)*omsq+v3**2-1.0)
!
          vfip=(f1i/f2)+(sqrt(f3i)/f2)
          vfjp=(f1j/f2)+(sqrt(f3j)/f2)
          vfkp=(f1k/f2)+(sqrt(f3k)/f2)
         
          vfim=(f1i/f2)-(sqrt(f3i)/f2)
          vfjm=(f1j/f2)-(sqrt(f3j)/f2)
          vfkm=(f1k/f2)-(sqrt(f3k)/f2)

          vfi=max(0.d0,abs(vfip),abs(vfim))
          vfj=max(0.d0,abs(vfjp),abs(vfjm))
          vfk=max(0.d0,abs(vfkp),abs(vfkm))

          if( imax.gt.nmax .and. vfi.gt.0.d0 ) then
            dtx1a(i,j,k)=abs(dx1(i)/vfi)
          else
            dtx1a(i,j,k)=dtx1
          endif
!
          if( jmax.gt.nmax .and. vfj.gt.0.d0 ) then
            dtx2a(i,j,k)=abs(dx2(j)/vfj)
          else
            dtx2a(i,j,k)=dtx2
          endif
          if ( kmax.gt.nmax .and. vfk.gt.0.d0 ) then
            dtx3a(i,j,k)=abs(dx3(k)/vfk)
            if(i .eq. 7 .and. j .eq. 7) then
            endif
          else
            dtx3a(i,j,k)=dtx3
          endif
!
        endif
      enddo
    enddo
  enddo
          
  do k=ks1+1,ke1-1
    do j=js1+1,je1-1
      do i=is1+1,ie1-1
        if( iact(i,j,k).eq.1 ) then

          dtcfl=min(dtcfl,dtx1a(i,j,k))
          dtcfl=min(dtcfl,dtx2a(i,j,k))
          dtcfl=min(dtcfl,dtx3a(i,j,k))
!
          dtx1=min(dtx1,dtx1a(i,j,k))
          dtx2=min(dtx2,dtx2a(i,j,k))
          dtx3=min(dtx3,dtx3a(i,j,k))
!
        endif
      enddo
    enddo
  enddo
!
  deallocate( dtx1a,dtx2a,dtx3a,stat=merr )
!
  return
end subroutine cdtcfl3
!
!-----------------------------------------------------------------------
subroutine cdtcfl4(uri,dtcfl,dx1,dx2,dx3,dtx1,dtx2,dtx3,nm1, &
                   is1,ie1,js1,je1,ks1,ke1)
!-----------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, gam, c0  
  implicit none

  integer :: i, j, k
  integer :: nm1, nmax, is1, ie1, js1, je1, ks1, ke1
  integer :: merr

  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
      
  real(8), allocatable :: dtx1a(:,:,:), dtx2a(:,:,:), dtx3a(:,:,:)
     
  real(8) :: dx1(imax), dx2(jmax), dx3(kmax)

  real(8), allocatable :: vfip(:,:,:), vfim(:,:,:), &
           vfjp(:,:,:), vfjm(:,:,:), vfkp(:,:,:), vfkm(:,:,:)
     
  real(8) :: pmin, dmax, vmin1, tmp1, vmin, dtx1, dtx2, dtx3, dtcfl
  real(8) :: vfi, vfj, vfk 
!
  allocate( dtx1a(is1:ie1,js1:je1,ks1:ke1), dtx2a(is1:ie1,js1:je1,ks1:ke1), &
            dtx3a(is1:ie1,js1:je1,ks1:ke1), &
            vfip(is1:ie1,js1:je1,ks1:ke1), vfim(is1:ie1,js1:je1,ks1:ke1), &
            vfjp(is1:ie1,js1:je1,ks1:ke1), vfjm(is1:ie1,js1:je1,ks1:ke1), &
            vfkp(is1:ie1,js1:je1,ks1:ke1), vfkm(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr )
!
  nmax=nm1*2+(nm1-1)
!  nmax=nm1*2+2
      
  vmin1=uri(5,is1,js1,ks1)/uri(1,is1,js1,ks1)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        tmp1=uri(5,i,j,k)/uri(1,i,j,k)
        vmin1=max(vmin1,tmp1)
      enddo
    enddo
  enddo
!
  vmin=sqrt(gam*vmin1)
!
  dtcfl=1.d0
  dtx1=1.d0
  dtx2=1.d0
  dtx3=1.d0

  call calcha4(uri,vfip,vfim,vfjp,vfjm,vfkp,vfkm,is1,ie1,js1,je1,ks1,ke1)

  do k=ks1+1,ke1-1
    do j=js1+1,je1-1
      do i=is1+1,ie1-1

        vfi=max(0.d0,abs(vfip(i,j,k)),abs(vfim(i,j,k)))
        vfj=max(0.d0,abs(vfjp(i,j,k)),abs(vfjm(i,j,k)))
        vfk=max(0.d0,abs(vfkp(i,j,k)),abs(vfkm(i,j,k)))

        if( imax.gt.nmax .and. vfi.gt.0.d0 ) then
          if(vfi .eq. 0.d0) then
            dtx1a(i,j,k)=1.d0
          else
            dtx1a(i,j,k)=abs(dx1(i)/vfi)
          endif
        else
!          dtx1a(i,j,k)=dtx1
          dtx1a(i,j,k)=1.d0
        endif
!
        if( jmax.gt.nmax .and. vfj.gt.0.d0 ) then
          dtx2a(i,j,k)=abs(dx2(j)/vfj)
        else          
!           dtx2a(i,j,k)=dtx2
!           dtx2a(i,j,k)=dtcfl
          dtx2a(i,j,k)=1.d0
        endif
        if ( kmax.gt.nmax .and. vfk.gt.0.d0 ) then
          dtx3a(i,j,k)=abs(dx3(k)/vfk)
        else
!          dtx3a(i,j,k)=dtx3
!          dtx3a(i,j,k)=dtcfl
          dtx3a(i,j,k)=1.d0 
        endif

      enddo
    enddo
  enddo
          
  do k=ks1+1,ke1-1
    do j=js1+1,je1-1
      do i=is1+1,ie1-1

        dtcfl=min(dtcfl,dtx1a(i,j,k))
        dtcfl=min(dtcfl,dtx2a(i,j,k))
        dtcfl=min(dtcfl,dtx3a(i,j,k))
!
        dtx1=min(dtx1,dtx1a(i,j,k))
        dtx2=min(dtx2,dtx2a(i,j,k))
        dtx3=min(dtx3,dtx3a(i,j,k))
!
      enddo
    enddo
  enddo

  deallocate( dtx1a,dtx2a,dtx3a,vfip,vfim,vfjp,vfjm,vfkp,vfkm,stat=merr )
!
  return
end  subroutine cdtcfl4
!
