!--------------------------------------------------------------------
subroutine prece1(uu,uri,uri0,x1,x2,x3,rj,vj,vpre1,vplu1,opre1,time1,&
                  is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv
  implicit none
!
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri0(nv,is1:ie1,js1:je1,ks1:ke1)
     
  real(8) :: x1(imax),x2(jmax),x3(kmax)

  real(8) :: vj, rj, vpre1, vplu1, opre1, time1, vpre, vplu, opre
  real(8) :: v1, v2, v3, rr, zz
!
! Parameter
!
  vj=0.9d0
  rj=1.d0
  vpre1=0.01d0
  vplu1=0.d0
  opre1=0.42d0

  vpre=vpre1*vj
  vplu=vplu1*vj
  opre=opre1*vj/rj
!
!$OMP PARALLEL DO PRIVATE( k, j, i, rr, zz, v1, v2, v3 )

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        rr=sqrt(x1(i)**2+x2(j)**2)
        zz=x3(k)
        if(rr .le. rj .and. zz .le. 0.5d0) then
!
!   Precession
!
!           v1=uri0(2,i,j,k)+vpre*sin(opre*time1)
!           v2=uri0(3,i,j,k)+vpre*cos(opre*time1)
          v1=vpre*sin(opre*time1)
          v2=vpre*cos(opre*time1)
!
!   Plusing
!
          v3=uri0(4,i,j,k)+vplu*sin(opre*time1)
           
        else
          v1=uri(2,i,j,k)
          v2=uri(3,i,j,k)
          v3=uri(4,i,j,k)
        endif
          
        uri(2,i,j,k)=v1
        uri(3,i,j,k)=v2
        uri(4,i,j,k)=v3
          
      enddo
    enddo
  enddo
!
  call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
!
  return
end subroutine prece1
!
!--------------------------------------------------------------------
subroutine rotate1(uu,uri,uri0,x1,x2,x3,omk1,nm1,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!     Purpose
!     Input rotation from inner boundary 
!     for 3D kink instability
!
!     Variables
!     uu: conserved variables
!     uri: primitive variables, uri0: primitive variables (initial)
!     de: density, pr: pressure
!     v1,v2,v3: velocity components of x1,x2,x3 direction
!     b1,b2,b3: magnetic field components of x1,x2,x3 direction
!
  use pram, only : imax, jmax, kmax, nv 
  implicit none

  integer :: i, j, k, nm1, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri0(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax),x2(jmax),x3(kmax)

  real(8) :: omk1, aa1, aa2, alp1, alp2
  real(8) :: rr, theta1, phi1, zz, tmp1, tmp2a, tmp2, vro, v1, v2, v3
!
! Parameter
!
  omk1=0.25d0
  aa1=1.d0
  aa2=2.5d0
  alp1=1.d0
  alp2=1.5d0

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        rr=sqrt(x1(i)**2+x2(j)**2)
        phi1=atan(x2(j)/x1(i))
        zz=x3(k)
!
!   Rotation Parameter
!
        tmp1=(1.0+(rr**2/aa1**2))**alp1
        tmp2a=rr**2/aa2**2
        if(tmp2a .gt. 1.d0) then
          tmp2a=1.d0
        endif
        tmp2=(1.0-tmp2a)**alp2
        vro=rr*omk1*tmp2/tmp1
!
!        if(zz .le. 0.5d0) then
        if(k .le. nm1+2) then
          v1=-vro*sin(theta1)
          v2=vro*cos(theta1)
          v3=uri0(4,i,j,k)
        endif
          
        uri(2,i,j,k)=v1
        uri(3,i,j,k)=v2
        uri(4,i,j,k)=v3

      enddo
    enddo
  enddo
!
  call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
!
  return
end subroutine rotate1
!
!--------------------------------------------------------------------@
subroutine inpjet2(uu,uri,x1,x2,x3,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0, metric
  implicit none
!
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
      
  real(8) :: x1(imax), x2(jmax), x3(kmax)
  
  real(8) :: rjx, rjz, dej, deb, cmac, vb, vv1, pa, paj, bbg
  real(8) :: rr, xx, zz, de, v1, v2, v3, pr, b1, b2, b3 

!
!     Parameter
!
  rjx=1.d0
  rjz=1.d0
!  dej=0.01
  dej=0.1d0
  deb=10.0d0
  cmac=6.0d0
  vb=0.99d0
!  vv1=fjump(xx,vb,0.d0,rjx,0.25d0,0.25d0)*fjump(zz,vb,0.d0,rjz,0.25d0,0.25d0)
!  pa=(dej*vb**2.0)/(gam*(gam-1.0)*cmac**2.0 -gam*vb**2.0)
  pa=0.01d0
  paj=0.01d0
      
!  bbg=sqrt(2.0*pa)
  bbg=0.1d0

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        
        if(metric .eq. 1) then
!          rr=sqrt(x1(i)**2+x2(j)**2)
          rr=x1(i)
          xx=x1(i)
          zz=x3(k)
        elseif(metric .eq. 2) then
          rr=x1(i)
          xx=x1(i)*cos(x2(j))
          zz=x3(k)
        elseif(metric .eq. 3) then
          rr=x1(i)*sin(x3(k))
          xx=x1(i)*sin(x3(k))*cos(x2(j))
          zz=x1(i)*cos(x3(k))
        else
        endif         
        
!        if(rr .le. 1.d0 .and. zz .le. 1.d0) then  ;for minmod
        if(rr .le. 1.3d0 .and. zz .le. 1.d0) then
          de=dej
!          pr=uri(5,i,j,k)
          pr=paj
              
          if(metric .eq. 1 .or. metric .eq. 2) then
            v1=0.d0
            v2=0.d0
            v3=vb
          elseif(metric .eq. 3) then
            v1=vb*cos(x3(k))
            v2=0.d0
            v3=-vb*sin(x3(k))
          endif
      
!          b1=uri(7,i,j,k)
!          b2=uri(8,i,j,k)
!          b3=uri(9,i,j,k)

          if(metric .eq. 1 .or. metric .eq. 2) then
            b1=0.d0
            b2=0.d0
            b3=bbg
          elseif(metric .eq. 3) then
            b1=bbg*cos(x3(k))
            b2=0.d0
            b3=-bbg*sin(x3(k))
          endif
         
        endif
         
        uri(1,i,j,k)=de
        uri(2,i,j,k)=v1
        uri(3,i,j,k)=v2
        uri(4,i,j,k)=v3
        uri(5,i,j,k)=pr
        uri(7,i,j,k)=b1
        uri(8,i,j,k)=b2
        uri(9,i,j,k)=b3
         
      enddo
    enddo
  enddo
!
  call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
!
  return
end subroutine inpjet2
!
!--------------------------------------------------------------------@
subroutine inpjet3(uu,uri,x1,x2,x3,rj,vj,etaj,betaj,cmac,imagj,&
                   is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0, metric, ieos, pi
  implicit none
!
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
      
  real(8) :: x1(imax),x2(jmax),x3(kmax)
      
  real(8) :: rj, vj, etaj, betaj, cmac, rjx, rjz, gf, deb, dej, & 
             pb, tmp1a, tmp1b, tmp1c, tmp2a, tmp2b, tmp3a
  integer :: imagj
  real(8) :: rr, xx, zz, tmp1, phi1, de, v1, v2, v3, pr, b1, b2, b3, &
             b0, pj, rm, bm, bphi1, rjm, pm, rrj, sigp, sigz, bmz, rrm2, &
             tmp4, tmp5a, tmp5b, tmp6a, tmp6b, tmp6c, bphi, br, bz, rmj 
!
!--------------------------------------------------------------------
!     Parameter
!
  rj=1.0d0
  vj=0.9d0
  etaj=1.0d0
  betaj=0.01d0
  cmac=3.0d0
  imagj=1
     
  rjx=1.0d0
  rjz=0.5d0
      
  gf=1.0/sqrt(1.0-vj**2)
      
  deb=1.0d0
  dej=etaj*deb
      
  if(ieos .eq. 0) then
      
    pb=(dej*vj**2)/(gam*cmac**2 -gam*vj**2/(gam-1.0))
      
  elseif(ieos .eq. 1)  then
      
    tmp1a=(15.0-6.0*cmac**2/vj**2)
    tmp1b=(24.0-10.0*cmac**2/vj**2)
    tmp1c=9.0d0
      
    tmp2a=(-tmp1b+sqrt(tmp1b**2-4.0*tmp1a*tmp1c))/2.0*tmp1a
    tmp2b=(-tmp1b-sqrt(tmp1b**2-4.0*tmp1a*tmp1c))/2.0*tmp1a
      
    if(tmp2a .le. 0.d0) then
      tmp3a=tmp2a
    elseif(tmp2b .le. 0.d0) then
      tmp3a=tmp2b
    else
      write(*,*) 'No solution in calculation of pressure'
    endif
       
    pb=(2.0*etaj/3.0)*sqrt(tmp3a**2/(1.0-tmp3a**2))
       
  endif
!
!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        
        if(metric .eq. 1) then
          rr=sqrt(x1(i)**2+x2(j)**2)

          if(x1(i) .eq. 0.d0) then
            tmp1=0.d0
          else
            tmp1=abs(x1(i))/x2(j)
          endif
           
          if(x2(j) .ge. 0.d0) then
           
            if(x1(i) .ge. 0.d0) then
              phi1=atan(tmp1)
            else
              phi1=2.0*pi-abs(atan(tmp1))
            endif
          
          else
          
            if(x1(i) .ge. 0.d0) then
              phi1=pi-abs(atan(tmp1))
            else
              phi1=pi+abs(atan(tmp1))
            endif
          
          endif

!          rr=x1(i)
          xx=x1(i)
          zz=x3(k)
         
        elseif(metric .eq. 2) then
          rr=x1(i)
          xx=x1(i)*cos(x2(j))
          phi1=x2(j)
          zz=x3(k)
        elseif(metric .eq. 3) then
          rr=x1(i)*sin(x3(k))
          xx=x1(i)*sin(x3(k))*cos(x2(j))
          zz=x1(i)*cos(x3(k))
        else

        endif
                  
        if(rr .le. rj .and. zz .le. rjz) then      
          if(metric .eq. 1 .or. metric .eq. 2) then
            v1=0.d0
            v2=0.d0
            v3=vj
          elseif(metric .eq. 3) then
            v1=vj*cos(x3(k))
            v2=0.d0
            v3=-vj*sin(x3(k))
          endif
          
          if(imagj .eq. 1) then
! Poloidal
!
            bm=sqrt(2.0*pb*betaj)
            pj=pb
           
            if(metric .eq. 1 .or. metric .eq. 2) then
              b1=0.d0
              b2=0.d0
              b3=bm
            elseif(metric .eq. 3) then
              b1=bm*cos(x3(k))
              b2=0.d0
              b3=-bm*sin(x3(k))
            endif
           
            de=dej
            pr=pj
          
          elseif(imagj .ge. 2 .or. imagj .le. 4) then
! Toroidal
!
            if(imagj .eq. 2 .or. imagj .eq. 3) then
              rm=0.6*rj
              tmp4=betaj*(0.25-log(rm/rj))*rm**2
              bm=sqrt((pb*rj**2)/tmp4)
!              bm=sqrt(2.0*pb*betaj)
           
            elseif(imagj .eq. 4) then
              rm=0.5*rj
              sigp=0.3d0
              sigz=0.7d0
           
              tmp4=(rm**2)*(2.0*sigp -1.+4.*log(rm/rj))
              bm=sqrt(-4.*pb*sigp/tmp4)
              rmj=rm/rj
              bmz=sqrt(sigz*((bm**2)*(rmj**2)+2.*pb))
            endif
           
            br=0.d0
           
            if(imagj .eq. 2 .or. imagj .eq. 3) then
              bz=0.d0
            elseif(imagj .eq. 4) then
              bz=bmz
            endif
           
            if(rr .le. rm) then
              bphi1=bm*rr/rm
            elseif(rr .gt. rm) then
            
              if(imagj .eq. 2 .and. imagj .eq. 4) then
                bphi1=bm*rm/rr
              elseif(imagj .eq. 3) then
                bphi1=bm*(rj-rr)/(rj-rm)
              endif
            
            endif
           
            bphi=gf*bphi1
           
            if(metric .eq. 1) then
              b1=-bphi*cos(phi1)
              b2=bphi*sin(phi1)
              b3=bz
            elseif(metric .eq. 2) then
              b1=br
              b2=bphi
              b3=bz
            elseif(metric .eq. 3) then
           
            endif
           
            de=dej
           
            if(imagj .eq. 2 .or. imagj .eq. 3) then
              pr=pb
            elseif(imagj .eq. 4) then
              rrm2=(rr/rm)**2
              if(rrm2 .le. 1.d0) then
                pr=pb+(bm**2)*(1.0-rrm2)
              else
                pr=pb
              endif
            endif
                    
!            if(betaj .eq. 0.0) then
!              pr=pb
!            else
!            
!            rmj=rm/rj
!            
!            
!              if(rr .le. rm) then
!
!                if(imagj .eq. 2) then
!              
!                  tmp5a=1.0-(1.0/betaj)*(rm/rj)**2
!                  tmp5b=(2.0/betaj)*(1.0-(rr/rm)**2)
!                  pr=pb*(tmp5a+tmp5b)
!                elseif(imagj .eq. 3) then
!                  tmp6a=(3.0*(1.0-rmj)-(1.0-rmj**2)+log(rmj))*0.5*bm**2
!                  pm=pb-(2.0/(1.0-rmj)**2)*tmp6a
!                  tmp6b=2.0*(1.0-(rr/rm)**2)*((bm**2)/(2.0*pb))
!                  pr=(tmp6b+(pm/pb))*pb
!                endif
!             
!              elseif(rr .gt. rm) then
!           
!                if(imagj .eq. 2) then
!                  tmp5a=1.0-(1.0/betaj)*(rm/rj)**2
!                  pr=tmp5a*pb
!                elseif(imagj .eq. 3) then
!                  rrj=rr/rj
!                  tmp6c=(3.0*(1.0-rrj)-(1.0-rrj**2)+log(rrj)) &
!                        *((bm**2)/(2.0*pb))
!                  pr=(1.0-(2.0/(1.0-rmj**2))*tmp6c)*pb
!                endif
!              endif
!          
!            endif
!           
          else
          
          endif
         
        else
          de=uri(1,i,j,k)
          v1=uri(2,i,j,k)
          v2=uri(3,i,j,k)
          v3=uri(4,i,j,k)
          pr=uri(5,i,j,k)
          b1=uri(7,i,j,k)
          b2=uri(8,i,j,k)
          b3=uri(9,i,j,k)
        endif
         
        uri(1,i,j,k)=de
        uri(2,i,j,k)=v1
        uri(3,i,j,k)=v2
        uri(4,i,j,k)=v3
        uri(5,i,j,k)=pr
        uri(7,i,j,k)=b1
        uri(8,i,j,k)=b2
        uri(9,i,j,k)=b3
         
      enddo
    enddo
  enddo
!
  call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
!
  return
end subroutine inpjet3
!
!--------------------------------------------------------------------@
subroutine inpflow1(uu,uri,x1,x2,x3,vj,wkn,pkn2d,pkn1d, &
                    totpkn2d,totpkn1d,thetan,phin,cmac,betaj,bm,time1, &
                    it,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, nkmax, gam, pi 
  implicit none
!
  integer :: i, j, k, n, is1, ie1, js1, je1, ks1, ke1 

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
      
  real(8) :: x1(imax), x2(jmax), x3(kmax)
      
  real(8) :: wkn(nkmax), pkn2d(nkmax), pkn1d(nkmax), & 
             thetan(nkmax),phin(nkmax)
  
  integer :: it
  real(8) :: vj, totpkn2d, totpkn1d, cmac, betaj, bm, time1, gf,  &
             de0, de1a, pb, sigma, sigmab, sigma1, sigmad, thetan1, vcd, & 
             x1a, x3a, fluc, df1d, df2d, df1dvx, df1dvy, df2dvx, df2dvy, &
            tmp1d, tmp2d, amp1d, amp2d 
!
!--------------------------------------------------------------------
!     Parameter
!     
  vj=0.4d0
  cmac=3.0d0
  betaj=0.01d0

  gf=1.0/sqrt(1.0-vj**2)
  de0=1.d0
  de1a=0.d0
      
!  pb=(de0*vj**2)/(gam*cmac**2 -gam*vj**2/(gam-1.0))
  pb=0.01d0
  bm=sqrt(2.0*pb*betaj)

!  write(*,*) 'vj,betaj,bm=',vj,betaj,bm      

  sigma=0.02d0
  sigmab=0.25*bm
!  sigma1=sigmab
  sigma1=sigma
  sigmad=de0
      
!  thetan1=0.0
  thetan1=1.570796d0 
      
!  vcd=(gf/(gf+1.0))*vj
  vcd=vj
  x1a=-vcd*time1
!
!--------------------------------------------------------------------
!

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        
        if(x1(i) .le. 0.1d0) then
!        if(i .le. 6) then
          x3a=x3(k)

          df1d=0.d0
          df2d=0.d0
!          df2dvx=0.0
!          df2dvy=0.0
!          df1dvx=0.0
!          df1dvy=0.0

          do n=1,nkmax
         
            amp2d=sqrt(sigma*pkn2d(n)/totpkn2d)
            amp1d=sqrt(sigma*pkn1d(n)/totpkn1d)
          
            tmp2d=wkn(n)*cos(thetan(n))*x1a+wkn(n)*sin(thetan(n))*x3a+phin(n)
            tmp1d=wkn(n)*cos(thetan1)*x1a+wkn(n)*sin(thetan1)*x3a+phin(n)
!            tmp1d=wkn(n)*x1a+phin(n)
          
!            df2d=df2d+amp2d*(sin(tmp2d)+cos(tmp2d))
!            df1d=df1d+amp1d*(sin(tmp1d)+cos(tmp1d))
       
            df2d=df2d+amp2d*sin(tmp2d)
            df1d=df1d+amp1d*sin(tmp1d)
       
!            df2dvx=df2dvx+amp2d*sin(thetan(n))*sin(tmp2d)
!            df2dvy=df2dvy-amp2d*cos(thetan(n))*sin(tmp2d)
       
!            df1dvx=df1dvx+amp1d*sin(thetan1d)*sin(tmp1d)
!            df1dvy=df1dvy-amp1d*cos(thetan1d)*sin(tmp1d)

          enddo
          
!          call kolfra1(wkn,pkn1d,pkn2d,totpkn1d,totpkn2d,thetan,phin, &
!                       df1d,df2d,df1dvx,df1dvy,df2dvx,df2dvy, &
!                       sigma1,thetan1,x1a,x3a)

!          flc1=1.0-2.0*ran1(iseed1)
     
          uri(1,i,j,k)=de0*exp(de1a+df2d)
!          uri(1,i,j,k)=de0*exp(de1a+df1d)
!          uri(1,i,j,k)=de0+sigma*df2d

!          uri(1,i,j,k)=de0+sigma*flc1
         
          uri(2,i,j,k)=vj
          uri(5,i,j,k)=pb

!          uri(7,i,j,k)=0.d0
          uri(7,i,j,k)=bm

          uri(8,i,j,k)=0.d0

          uri(9,i,j,k)=0.d0
!          uri(9,i,j,k)=bm
!          uri(9,i,j,k)=bm*(1.0+df1d)
!          uri(9,i,j,k)=bm+bm*exp(df1d)
          
        endif
         
      enddo
    enddo
  enddo
!
  call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
!
  return
end subroutine inpflow1
!
!--------------------------------------------------------------------@
subroutine kolfra1(wkn,pkn1d,pkn2d,totpkn1d,totpkn2d,thetan,phin, &
                   df1d,df2d,df1dvx,df1dvy,df2dvx,df2dvy, &
                   sigma,thetan1d,x1a,x3a)
!--------------------------------------------------------------------@
  use pram, only : nkmax
  implicit none
!
  integer :: n

  real(8) :: wkn(nkmax), pkn2d(nkmax), pkn1d(nkmax)
  real(8) :: thetan(nkmax), phin(nkmax)

  real(8) ::  df1d, df2d, df1dvx, df1dvy, df2dvx, df2dvy, &
              totpkn1d, totpkn2d, &
              sigma, thetan1d, x1a, x3a, amp2d, amp1d, tmp1d, tmp2d
!
!--------------------------------------------------------------------
!  Parameter
!
  df1d=0.d0
  df2d=0.d0
  df2dvx=0.d0
  df2dvy=0.d0
  df1dvx=0.d0
  df1dvy=0.d0

!--------------------------------------------------------------------

  do n=1,nkmax
         
    amp2d=sqrt(sigma*pkn2d(n)/totpkn2d)
    amp1d=sqrt(sigma*pkn1d(n)/totpkn1d)
          
    tmp2d=wkn(n)*cos(thetan(n))*x1a+wkn(n)*sin(thetan(n))*x3a+phin(n)
     
    tmp1d=wkn(n)*cos(thetan1d)*x1a+wkn(n)*sin(thetan1d)*x3a+phin(n)

!    tmp1d=wkn(n)*x1a+phin(n)
          
!    df2d=df2d+amp2d*(sin(tmp2d)+cos(tmp2d))
!    df1d=df1d+amp1d*(sin(tmp1d)+cos(tmp1d))
       
    df2d=df2d+amp2d*sin(tmp2d)
    df1d=df1d+amp1d*sin(tmp1d)
       
    df2dvx=df2dvx+amp2d*sin(thetan(n))*sin(tmp2d)
    df2dvy=df2dvy-amp2d*cos(thetan(n))*sin(tmp2d)
       
    df1dvx=df1dvx+amp1d*sin(thetan1d)*sin(tmp1d)
    df1dvy=df1dvy-amp1d*cos(thetan1d)*sin(tmp1d)

  enddo
      
  return
end subroutine kolfra1
!
!--------------------------------------------------------------------@
subroutine cleanb(uu,uri,x1,x2,x3,vj,cmac,betaj,bm,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam
  implicit none
!
  integer :: i, j, k, kh, jh, is1, ie1, js1, je1, ks1, ke1

  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
      
  real(8) :: x1(imax), x2(jmax), x3(kmax)
  
  real(8) :: vj, cmac, betaj, de0, pb, bm, xpos, temp2, xpos1
  integer :: iflg 
!
!--------------------------------------------------------------------
!     Parameter
!
  vj=0.4d0
  cmac=3.0d0
  betaj=0.01d0
!
  kh=kmax/2
  jh=jmax/2

  de0=1.0d0
  pb=(de0*vj**2)/(gam*cmac**2 -gam*vj**2/(gam-1.0))
  bm=sqrt(2.0*pb*betaj)
!--------------------------------------------------------------------
!
  iflg=0
  xpos=x1(imax)
      
  do i=is1,ie1-2
!    temp1=abs(uri(5,i+2,jh,kh)/uri(5,i,jh,kh))
    temp2=abs(uri(1,i+1,jh,kh)/uri(1,i,jh,kh))
    if(temp2 .gt. 3.d0 .and. iflg .eq. 0) then
      xpos=x1(i)
      iflg=1
    elseif(uri(1,i,jh,kh) .ge. 3.d0 .and. iflg .eq. 0) then
      xpos=x1(i)
      iflg=1
    endif
  enddo

!  write(*,*) 'xpos=',xpos
      
  xpos1=xpos-0.05
      
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
         
        if(x1(i) .lt. xpos1) then
          uri(7,i,j,k)=0.d0
          uri(8,i,j,k)=0.d0
          uri(9,i,j,k)=bm
        endif
         
      enddo
    enddo
  enddo
!
  call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
!
  return
end subroutine cleanb
!
!--------------------------------------------------------------------@
subroutine smooth(uu,uri,x1,x2,x3,time1,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam
  implicit none
!
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: merr
!
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
 
  real(8), allocatable :: ro(:,:,:), pr(:,:,:), bx(:,:,:), bz(:,:,:)
! 
  real(8) :: x1(imax),x2(jmax),x3(kmax)

  real(8) :: time1, xpos, xpos1
!
  allocate( ro(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
            bx(is1:ie1,js1:je1,ks1:ke1), bz(is1:ie1,js1:je1,ks1:ke1), &
            stat=merr )   
!
!--------------------------------------------------------------------
!     Parameter
!
  xpos=0.055*(time1-6.0)
!  xpos=0.05*(time1-8.0)
  xpos1=3.0-xpos
!
!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        ro(i,j,k)=uri(1,i,j,k)
        pr(i,j,k)=uri(5,i,j,k)
        bx(i,j,k)=uri(7,i,j,k)
        bz(i,j,k)=uri(9,i,j,k)

      enddo
    enddo
  enddo
!
  do k=ks1+1,ke1-1
    do j=js1+1,je1-1
      do i=is1+1,ie1-1

        if(x1(i) .gt. xpos1) then
          
!          uri(1,i,j,k)=(ro(i,j,k)+ro(i-1,j,k)+ro(i+1,j,k) &
!                      +ro(i,j,k-1)+ro(i,j,k+1))/5.0
!          uri(5,i,j,k)=(pr(i,j,k)+pr(i-1,j,k)+pr(i+1,j,k) &
!                      +pr(i,j,k-1)+pr(i,j,k+1))/5.0
          uri(7,i,j,k)=(bx(i,j,k)+bx(i-1,j,k)+bx(i+1,j,k) &
                      +bx(i,j,k-1)+bx(i,j,k+1))/5.0
          uri(9,i,j,k)=(bz(i,j,k)+bz(i-1,j,k)+bz(i+1,j,k) &
                      +bz(i,j,k-1)+bz(i,j,k+1))/5.0
         
        endif

      enddo      
    enddo
  enddo   
!
  call caluu2a(uri,uu,is1,ie1,js1,je1,ks1,ke1)
!
  deallocate(ro, pr, bx, bz,stat=merr)
!
  return
end subroutine smooth
!
