;;
;; Ploting 2D results
;;
;; $Id$
;;
; choice of device
;plot_choice='cps'
;plot_choice='ps'
plot_choice='x'
;
iwx=2 & jwy=2

a=findgen(17) * (!pi * 2 / 16.)
usersym, 0.5*cos(a), 0.5*sin(a),/fill

!p.charsize=1.5
!p.charthick=1.5
;!p.charsize=1.0
;!p.charthick=1.0

mmmin=1
mmmax=10

xrange=[-6.0,6.0] & yrange=[-6.0,6.0]


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
case plot_choice of
'x' : begin
window,4,xs=600,ys=550,xpos=400,retain=2
;window,5,xs=1200,ys=1200,xpos=400
end
'ps' : begin
set_plot,'ps'
device,/portrait
device,/inches,xsize=7,ysize=7.5,yoffset=1,font_size=8
;!p.font=0 & device,/times,/italic
end
'cps' : begin
set_plot,'ps'
;device,/color,bits_per_pix=5
device,/color,/inches,xsize=7.5,ysize=7.0,yoffset=1,font_size=8
;device,/landscape
;device,xoffset=0.5,yoffset=24.5,xsize=19*6.5/7.*0.8,ysize=19*0.8
;!p.font=0 & device,/times,/italic
end
endcase

iw=iwx*jwy
dx0=1./iwx
dy0=1./jwy

!p.multi=[0,iwx,jwy]
!x.margin=[7.,8.]
!y.margin=[4.,4.]

mm1=1
mm2=11

i=0
itemp=0
;
; If plot_choice='ps' or 'cps', following line should comment out.
;
; CASE !D.Name OF
; 'X': device,decompose=0
; ELSE:
; ENDCASE
;
; If you want to use different color palette, you should change number of loadct; or select ldmyct (original color palette)
;
;   loadct,1
;   TVLCT, r, g, b, /Get
;   TVLCT, Reverse(r), Reverse(g), Reverse(b)
   
 ; loadct,0
  If(plot_choice eq 'x') then begin
    device,decompose=0
  endif
    ldmyct,clr_index=clr,white=white,black=black
;
rr=sqrt(xx^2+zz^2)

;
; (1) density
; 
  data1=alog10(dd)
  
clr=[10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,190]

levels1=[-5.0,-4.1,-4.0,-3.9,-3.8,-3.7,-3.6,-3.55,-3.5,-3.45,-3.4,-3.3,-3.2,-3.1,-3.0]

data2=-b3
  
    fccnve $
     ,nofilled=0,nocontour=1,novector=1 $
     ,xrange=xrange,yrange=yrange $
     ,data1(*,*,mm2) $
     ,levels1=levels1,clr_index=clr, c_thick=1.5 $
     ,data2(*,*,mm2) $
     ,levels2=min(data2(*,*,mm2))+(max(data2(*,*,mm2))-min(data2(*,*,mm2)))*(findgen(25)/25)$
;     ,levels2=[0.0] $
     ,v1(*,*,mm2),v2(*,*,mm2) $
     ,scale=2.8,index_size=1.0, xarrow=0.65, limit=0.1,/sample $
     ,xplot=-0.5+0.65*findgen(100),yplot=-0.5+0.65*findgen(100) $
     ,xcord=xar,ycord=yar,xtitle='!8x',ytitle='!8y' $
     ,v_color=white  $
     ,c_colors=white, Index_color=white, Axis_color=white 
;
i=0
	x0=dx0*(i mod iwx)
	y0=dy0*((i-(i mod iwx))/iwx)

   xyouts,/normal,x0+dx0*0.08,1.-(y0+dy0*0.20-0.05),'!8(a)'
   
   xyouts,/normal,x0+dx0*0.25,1.-(y0+dy0*0.20-0.05),'!8time = '
   xyouts,/normal,x0+dx0*0.58,1.-(y0+dy0*0.20-0.05), $
     strmid(strcompress(string(ctime(mm2)),/remove_all),0,4)


    barposition=[0.47,0.58,0.49,0.88]
    b_min=-4.2 & b_max=-3.0

  color_bar2,/noerase,levels1 $
    ,clr $
   ,position=barposition,b_min=b_min,b_max=b_max


;
; (2) gas pressure
;
  
  data1=pp
  
clr=[10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,190]

levels1=[0.000,0.0025,0.005,0.0075,0.01,0.0125,0.015,0.0175,0.02,0.0225,0.025,0.0275,0.03,0.035,0.04]

  data2=-b3

    printf,-1,mm2,format='(i3,$)'
    fccnve $
     ,nofilled=0,nocontour=1,novector=1 $
     ,xrange=xrange,yrange=yrange $
     ,data1(*,*,mm2) $
     ,levels1=levels1,clr_index=clr, c_thick=1.5 $
     ,data2(*,*,mm2) $
     ,levels2=min(data2(*,*,mm2))+(max(data2(*,*,mm2))-min(data2(*,*,mm2)))*(findgen(25)/25)$
;     ,levels2=min(data2(*,*,mm2))+(max(data2(*,*,mm2))-min(data2(*,*,mm2)))*(findgen(20)/20)$
     ,v1(*,*,mm2),v2(*,*,mm2) $
     ,scale=2.8,index_size=1.0, xarrow=0.65, limit=0.1,/sample $
     ,xplot=-0.+0.65*findgen(100),yplot=-0.+0.65*findgen(100) $
     ,xcord=xar,ycord=yar, xtitle='!8x',ytitle='!8y' $
     ,v_color=white  $
     ,c_colors=white, Index_color=white, Axis_color=white 

i=1
	x0=dx0*(i mod iwx)
	y0=dy0*((i-(i mod iwx))/iwx)

   xyouts,/normal,x0+dx0*0.08,1.-(y0+dy0*0.20-0.05),'!8(b)'
   xyouts,/normal,x0+dx0*0.25,1.-(y0+dy0*0.20-0.05),'!8time = '
   xyouts,/normal,x0+dx0*0.58,1.-(y0+dy0*0.20-0.05), $
     strmid(strcompress(string(ctime(mm2)),/remove_all),0,4)


    barposition=[0.97,0.58,0.99,0.88]
    b_min=0.0 & b_max=0.04

  color_bar2,/noerase,levels1 $
    ,clr $
   ,position=barposition,b_min=b_min,b_max=b_max


;
; (3)Lorenz factor 
;
  vsq=v1*v1+v2*v2+v3*v3
  lo=1./sqrt(1.-vsq)
  data1=lo
  
clr=[10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,190]

levels1=[1.0,1.25,1.5,1.75,2.0,2.25,2.5,2.75,3.0,3.25,3.5,3.75,4.0]

  data2=-b3
  
    fccnve $
     ,nofilled=0,nocontour=1,novector=1 $
     ,xrange=xrange,yrange=yrange $
     ,data1(*,*,mm2) $
     ,levels1=levels1,clr_index=clr, c_thick=1.5 $
     ,data2(*,*,mm2) $
     ,levels2=min(data2(*,*,mm2))+(max(data2(*,*,mm2))-min(data2(*,*,mm2)))*(findgen(8)/8)^2$
;     ,levels2=[0.0] $
     ,v1(*,*,mm2),v2(*,*,mm2) $
     ,scale=2.8,index_size=1.0, xarrow=0.65, limit=0.1,/sample $
     ,xplot=-0.5+0.65*findgen(100),yplot=-0.5+0.65*findgen(100) $
     ,xcord=xar,ycord=yar,xtitle='!8x',ytitle='!8y' $
     ,v_color=white  $
     ,c_colors=white, Index_color=white, Axis_color=white 
;
i=2
	x0=dx0*(i mod iwx)
	y0=dy0*((i-(i mod iwx))/iwx)

   xyouts,/normal,x0+dx0*0.08,1.-(y0+dy0*0.20-0.05),'!8(c)'
   
   xyouts,/normal,x0+dx0*0.25,1.-(y0+dy0*0.20-0.05),'!8time = '
   xyouts,/normal,x0+dx0*0.58,1.-(y0+dy0*0.20-0.05), $
     strmid(strcompress(string(ctime(mm2)),/remove_all),0,4)

    barposition=[0.47,0.08,0.49,0.38]
    b_min=1.0 & b_max=3.75

  color_bar2,/noerase,levels1 $
    ,clr $
   ,position=barposition,b_min=b_min,b_max=b_max

;
; (3) Magnetic Pressure 
;
  bsq=b1*b1+b2*b2+b3*b3
  pm=bsq/2.0
  data1=pm
  
clr=[10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,190]

levels1=[0.0,0.005,0.01,0.015,0.02,0.025,0.03,0.035,0.04,0.045,0.05,0.055,0.06,0.065,0.07]

    printf,-1,mm2,format='(i3,$)'
    fccnve $
     ,nofilled=0,nocontour=1,novector=1 $
     ,xrange=xrange,yrange=yrange $
     ,data1(*,*,mm2) $
     ,levels1=levels1,clr_index=clr, c_thick=1.5 $
     ,data2(*,*,mm2) $
     ,levels2=min(data2(*,*,mm2))+(max(data2(*,*,mm2))-min(data2(*,*,mm2)))*(findgen(8)/8)^2$
;     ,levels2=min(data2(*,*,mm2))+(max(data2(*,*,mm2))-min(data2(*,*,mm2)))*(findgen(20)/20)$
     ,v1(*,*,mm2),v2(*,*,mm2) $
     ,scale=2.8,index_size=1.0, xarrow=0.65, limit=0.1,/sample $
     ,xplot=-0.+0.65*findgen(100),yplot=-0.+0.65*findgen(100) $
     ,xcord=xar,ycord=yar, xtitle='!8x',ytitle='!8y' $
     ,v_color=white  $
     ,c_colors=white, Index_color=white, Axis_color=white 

i=3
	x0=dx0*(i mod iwx)
	y0=dy0*((i-(i mod iwx))/iwx)

   xyouts,/normal,x0+dx0*0.08,1.-(y0+dy0*0.20-0.05),'!8(d)'
   xyouts,/normal,x0+dx0*0.25,1.-(y0+dy0*0.20-0.05),'!8time = '
   xyouts,/normal,x0+dx0*0.58,1.-(y0+dy0*0.20-0.05), $
     strmid(strcompress(string(ctime(mm2)),/remove_all),0,4)


    barposition=[0.97,0.08,0.99,0.38]
    b_min=0.0 & b_max=0.065

  color_bar2,/noerase,levels1 $
    ,clr $
   ,position=barposition,b_min=b_min,b_max=b_max





; back to default

!x.range=[0.,0.]
!y.range=[0.,0.]
!x.margin=[10.,3.]
!y.margin=[4.,2.]
!p.charsize=1.
!p.thick=1.
!p.multi=0

if (plot_choice ne 'x') then begin
   device,color=0
   device,/close
   !p.font=-1
;   set_plot,'x'
endif

;delvar,data1,data2
end

