!---------------------------------------------------------------------@
subroutine calflx(uriir,urijr,urikr,uriil,urijl,urikl,&
                 nm0,uuir,uujr,uukr,uuil,uujl,uukl,&
                 vir,vjr,vkr,vil,vjl,vkl,wwir,wwjr,wwkr,wwil,wwjl,wwkl, &
                 is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
!
!     Calculate flux at cell-interface
!
  use pram, only : imax, jmax, kmax, nv, gam, c0, ieos, iflag
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0  
  integer, parameter :: ni=13 
!
  real(8) :: uriir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uriil(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urijl(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikr(nv,is1:ie1,js1:je1,ks1:ke1), &
             urikl(nv,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: uuir(nv,is1:ie1,js1:je1,ks1:ke1), &
             uuil(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uujl(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukr(nv,is1:ie1,js1:je1,ks1:ke1), &
             uukl(nv,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: wwir(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwil(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwjl(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkr(nv,is1:ie1,js1:je1,ks1:ke1), &
             wwkl(nv,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: vir(ni,is1:ie1,js1:je1,ks1:ke1), &
             vil(ni,is1:ie1,js1:je1,ks1:ke1), &
             vjr(ni,is1:ie1,js1:je1,ks1:ke1), &
             vjl(ni,is1:ie1,js1:je1,ks1:ke1), &
             vkr(ni,is1:ie1,js1:je1,ks1:ke1), &
             vkl(ni,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: roir, rojr, rokr, roil, rojl, rokl
  real(8) :: vxir, vxjr, vxkr, vxil, vxjl, vxkl
  real(8) :: vyir, vyjr, vykr, vyil, vyjl, vykl
  real(8) :: vzir, vzjr, vzkr, vzil, vzjl, vzkl 
  real(8) :: ppir, ppjr, ppkr, ppil, ppjl, ppkl
  real(8) :: bxir, bxjr, bxkr, bxil, bxjl, bxkl 
  real(8) :: byir, byjr, bykr, byil, byjl, bykl 
  real(8) :: bzir, bzjr, bzkr, bzil, bzjl, bzkl 
  real(8) :: vtir, vtjr, vtkr, vtil, vtjl, vtkl 
  real(8) :: btir, btjr, btkr, btil, btjl, btkl 
  real(8) :: vbir, vbjr, vbkr, vbil, vbjl, vbkl 
  real(8) :: gfir, gfjr, gfkr, gfil, gfjl, gfkl
  real(8) :: droir, drojr, drokr, droil, drojl, drokl 
  real(8) :: exir, exjr, exkr, exil, exjl, exkl 
  real(8) :: eyir, eyjr, eykr, eyil, eyjl, eykl 
  real(8) :: ezir, ezjr, ezkr, ezil, ezjl, ezkl 
  real(8) :: sxir, sxjr, sxkr, sxil, sxjl, sxkl 
  real(8) :: syir, syjr, sykr, syil, syjl, sykl 
  real(8) :: szir, szjr, szkr, szil, szjl, szkl 
  real(8) :: eemir, eemjr, eemkr, eemil, eemjl, eemkl
  real(8) :: rohir, rohjr, rohkr, rohil, rohjl, rohkl 
  real(8) :: roeir, roejr, roekr, roeil, roejl, roekl 
  real(8) :: denrir, denrjr, denrkr, denril, denrjl, denrkl
  real(8) :: eeir, eejr, eekr, eeil, eejl, eekl  
  real(8) :: ron
!
!----------------------------------------------------------------------
  ron=1.d0

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0

        roir=uriir(1,i,j,k)
        rojr=urijr(1,i,j,k)
        rokr=urikr(1,i,j,k)
        roil=uriil(1,i,j,k)
        rojl=urijl(1,i,j,k)
        rokl=urikl(1,i,j,k)
         
        vxir=uriir(2,i,j,k)
        vxjr=urijr(2,i,j,k)
        vxkr=urikr(2,i,j,k)
        vxil=uriil(2,i,j,k)
        vxjl=urijl(2,i,j,k)
        vxkl=urikl(2,i,j,k)
         
        vyir=uriir(3,i,j,k)
        vyjr=urijr(3,i,j,k)
        vykr=urikr(3,i,j,k)
        vyil=uriil(3,i,j,k)
        vyjl=urijl(3,i,j,k)
        vykl=urikl(3,i,j,k)
         
        vzir=uriir(4,i,j,k)
        vzjr=urijr(4,i,j,k)
        vzkr=urikr(4,i,j,k)
        vzil=uriil(4,i,j,k)
        vzjl=urijl(4,i,j,k)
        vzkl=urikl(4,i,j,k)
        
        ppir=uriir(5,i,j,k)
        ppjr=urijr(5,i,j,k)
        ppkr=urikr(5,i,j,k)
        ppil=uriil(5,i,j,k)
        ppjl=urijl(5,i,j,k)
        ppkl=urikl(5,i,j,k)
        
        bxir=uriir(7,i,j,k)
        bxjr=urijr(7,i,j,k)
        bxkr=urikr(7,i,j,k)
        bxil=uriil(7,i,j,k)
        bxjl=urijl(7,i,j,k)
        bxkl=urikl(7,i,j,k)
        
        byir=uriir(8,i,j,k)
        byjr=urijr(8,i,j,k)
        bykr=urikr(8,i,j,k)
        byil=uriil(8,i,j,k)
        byjl=urijl(8,i,j,k)
        bykl=urikl(8,i,j,k)
        
        bzir=uriir(9,i,j,k)
        bzjr=urijr(9,i,j,k)
        bzkr=urikr(9,i,j,k)
        bzil=uriil(9,i,j,k)
        bzjl=urijl(9,i,j,k)
        bzkl=urikl(9,i,j,k)
         
        vtir=vxir*vxir+vyir*vyir+vzir*vzir
        vtjr=vxjr*vxjr+vyjr*vyjr+vzjr*vzjr
        vtkr=vxkr*vxkr+vykr*vykr+vzkr*vzkr
        vtil=vxil*vxil+vyil*vyil+vzil*vzil
        vtjl=vxjl*vxjl+vyjl*vyjl+vzjl*vzjl
        vtkl=vxkl*vxkl+vykl*vykl+vzkl*vzkl
         
        btir=bxir**2+byir**2+bzir**2
        btjr=bxjr**2+byjr**2+bzjr**2
        btkr=bxkr**2+bykr**2+bzkr**2
        btil=bxil**2+byil**2+bzil**2
        btjl=bxjl**2+byjl**2+bzjl**2
        btkl=bxkl**2+bykl**2+bzkl**2
     
        vbir=vxir*bxir+vyir*byir+vzir*bzir
        vbjr=vxjr*bxjr+vyjr*byjr+vzjr*bzjr
        vbkr=vxkr*bxkr+vykr*bykr+vzkr*bzkr
        vbil=vxil*bxil+vyil*byil+vzil*bzil
        vbjl=vxjl*bxjl+vyjl*byjl+vzjl*bzjl
        vbkl=vxkl*bxkl+vykl*bykl+vzkl*bzkl
     
        gfir=1.0/sqrt(1.0-vtir/c0**2)
        gfjr=1.0/sqrt(1.0-vtjr/c0**2)
        gfkr=1.0/sqrt(1.0-vtkr/c0**2)
        gfil=1.0/sqrt(1.0-vtil/c0**2)
        gfjl=1.0/sqrt(1.0-vtjl/c0**2)
        gfkl=1.0/sqrt(1.0-vtkl/c0**2)
        
        droir=roir*gfir
        drojr=rojr*gfjr
        drokr=rokr*gfkr
        droil=roil*gfil
        drojl=rojl*gfjl
        drokl=rokl*gfkl
        
        exir=vzir*byir-vyir*bzir
        exjr=vzjr*byjr-vyjr*bzjr
        exkr=vzkr*bykr-vykr*bzkr
        exil=vzil*byil-vyil*bzil
        exjl=vzjl*byjl-vyjl*bzjl
        exkl=vzkl*bykl-vykl*bzkl
        
        eyir=vxir*bzir-vzir*bxir
        eyjr=vxjr*bzjr-vzjr*bxjr
        eykr=vxkr*bzkr-vzkr*bxkr
        eyil=vxil*bzil-vzil*bxil
        eyjl=vxjl*bzjl-vzjl*bxjl
        eykl=vxkl*bzkl-vzkl*bxkl
        
        ezir=vyir*bxir-vxir*byir
        ezjr=vyjr*bxjr-vxjr*byjr
        ezkr=vykr*bxkr-vxkr*bykr
        ezil=vyil*bxil-vxil*byil
        ezjl=vyjl*bxjl-vxjl*byjl
        ezkl=vykl*bxkl-vxkl*bykl
        
        sxir=(eyir*bzir-ezir*byir)/c0
        sxjr=(eyjr*bzjr-ezjr*byjr)/c0
        sxkr=(eykr*bzkr-ezkr*bykr)/c0
        sxil=(eyil*bzil-ezil*byil)/c0
        sxjl=(eyjl*bzjl-ezjl*byjl)/c0
        sxkl=(eykl*bzkl-ezkl*bykl)/c0
       
        syir=(ezir*bxir-exir*bzir)/c0
        syjr=(ezjr*bxjr-exjr*bzjr)/c0
        sykr=(ezkr*bxkr-exkr*bzkr)/c0
        syil=(ezil*bxil-exil*bzil)/c0
        syjl=(ezjl*bxjl-exjl*bzjl)/c0
        sykl=(ezkl*bxkl-exkl*bzkl)/c0
       
        szir=(exir*byir-eyir*bxir)/c0
        szjr=(exjr*byjr-eyjr*bxjr)/c0
        szkr=(exkr*bykr-eykr*bxkr)/c0
        szil=(exil*byil-eyil*bxil)/c0
        szjl=(exjl*byjl-eyjl*bxjl)/c0
        szkl=(exkl*bykl-eykl*bxkl)/c0
         
        eemir=0.5*(btir+exir**2+eyir**2+ezir**2)
        eemjr=0.5*(btjr+exjr**2+eyjr**2+ezjr**2)
        eemkr=0.5*(btkr+exkr**2+eykr**2+ezkr**2)
        eemil=0.5*(btil+exil**2+eyil**2+ezil**2)
        eemjl=0.5*(btjl+exjl**2+eyjl**2+ezjl**2)
        eemkl=0.5*(btkl+exkl**2+eykl**2+ezkl**2)

        if(ieos .eq. 0) then
          rohir=roir+(gam/(gam-1.0))*ppir
          rohjr=rojr+(gam/(gam-1.0))*ppjr
          rohkr=rokr+(gam/(gam-1.0))*ppkr
          rohil=roil+(gam/(gam-1.0))*ppil
          rohjl=rojl+(gam/(gam-1.0))*ppjl
          rohkl=rokl+(gam/(gam-1.0))*ppkl
        elseif(ieos .eq. 1) then
          rohir=(5./2.)*ppir+sqrt((9./4.)*ppir**2 +roir**2)
          rohjr=(5./2.)*ppjr+sqrt((9./4.)*ppjr**2 +rojr**2)
          rohkr=(5./2.)*ppkr+sqrt((9./4.)*ppkr**2 +rokr**2)
          rohil=(5./2.)*ppil+sqrt((9./4.)*ppil**2 +roil**2)
          rohjl=(5./2.)*ppjl+sqrt((9./4.)*ppjl**2 +rojl**2)
          rohkl=(5./2.)*ppkl+sqrt((9./4.)*ppkl**2 +rokl**2)
        elseif(ieos .eq. 2) then
          roeir=(3./2.)*(ppir+((3.*ppir**2)&
              /(2.0*roir+sqrt(2.*ppir**2+4.*roir**2)) ))
          roejr=(3./2.)*(ppjr+((3.*ppjr**2)&
              /(2.0*rojr+sqrt(2.*ppjr**2+4.*rojr**2)) ))
          roekr=(3./2.)*(ppkr+((3.*ppkr**2)&
              /(2.0*rokr+sqrt(2.*ppkr**2+4.*rokr**2)) ))
          roeil=(3./2.)*(ppil+((3.*ppil**2)&
              /(2.0*roil+sqrt(2.*ppil**2+4.*roil**2)) ))
          roejl=(3./2.)*(ppjl+((3.*ppjl**2)&
              /(2.0*rojl+sqrt(2.*ppjl**2+4.*rojl**2)) ))
          roekl=(3./2.)*(ppkl+((3.*ppkl**2)&
              /(2.0*rokl+sqrt(2.*ppkl**2+4.*rokl**2)) ))
          rohir=roir+roeir+ppir
          rohjr=rojr+roejr+ppjr
          rohkr=rokr+roekr+ppkr
          rohil=roil+roeil+ppil
          rohjl=rojl+roejl+ppjl
          rohkl=rokl+roekl+ppkl
        endif
        
        denrir=gfir**2*rohir
        denrjr=gfjr**2*rohjr
        denrkr=gfkr**2*rohkr
        denril=gfil**2*rohil
        denrjl=gfjl**2*rohjl
        denrkl=gfkl**2*rohkl
        
        eeir=denrir-ppir+eemir-droir
        eejr=denrjr-ppjr+eemjr-drojr
        eekr=denrkr-ppkr+eemkr-drokr
        eeil=denril-ppil+eemil-droil
        eejl=denrjl-ppjl+eemjl-drojl
        eekl=denrkl-ppkl+eemkl-drokl
!
        uuir(1,i,j,k)=droir
        uuir(2,i,j,k)=(denrir+btir)*vxir-vbir*bxir
        uuir(3,i,j,k)=(denrir+btir)*vyir-vbir*byir
        uuir(4,i,j,k)=(denrir+btir)*vzir-vbir*bzir
        uuir(5,i,j,k)=eeir
        uuir(7,i,j,k)=bxir
        uuir(8,i,j,k)=byir
        uuir(9,i,j,k)=bzir
!
        uujr(1,i,j,k)=drojr
        uujr(2,i,j,k)=(denrjr+btjr)*vxjr-vbjr*bxjr
        uujr(3,i,j,k)=(denrjr+btjr)*vyjr-vbjr*byjr
        uujr(4,i,j,k)=(denrjr+btkr)*vzjr-vbjr*bzjr
        uujr(5,i,j,k)=eejr
        uujr(7,i,j,k)=bxjr
        uujr(8,i,j,k)=byjr
        uujr(9,i,j,k)=bzjr
!
        uukr(1,i,j,k)=drokr
        uukr(2,i,j,k)=(denrkr+btkr)*vxkr-vbkr*bxkr
        uukr(3,i,j,k)=(denrkr+btkr)*vykr-vbkr*bykr
        uukr(4,i,j,k)=(denrkr+btkr)*vzkr-vbkr*bzkr
        uukr(5,i,j,k)=eekr
        uukr(7,i,j,k)=bxkr
        uukr(8,i,j,k)=bykr
        uukr(9,i,j,k)=bzkr
!
        uuil(1,i,j,k)=droil
        uuil(2,i,j,k)=(denril+btil)*vxil-vbil*bxil
        uuil(3,i,j,k)=(denril+btil)*vyil-vbil*byil
        uuil(4,i,j,k)=(denril+btil)*vzil-vbil*bzil
        uuil(5,i,j,k)=eeil
        uuil(7,i,j,k)=bxil
        uuil(8,i,j,k)=byil
        uuil(9,i,j,k)=bzil
!
        uujl(1,i,j,k)=drojl
        uujl(2,i,j,k)=(denrjl+btjl)*vxjl-vbjl*bxjl
        uujl(3,i,j,k)=(denrjl+btjl)*vyjl-vbjl*byjl
        uujl(4,i,j,k)=(denrjl+btjl)*vzjl-vbjl*bzjl
        uujl(5,i,j,k)=eejl
        uujl(7,i,j,k)=bxjl
        uujl(8,i,j,k)=byjl
        uujl(9,i,j,k)=bzjl
!
        uukl(1,i,j,k)=drokl
        uukl(2,i,j,k)=(denrkl+btkl)*vxkl-vbkl*bxkl
        uukl(3,i,j,k)=(denrkl+btkl)*vykl-vbkl*bykl
        uukl(4,i,j,k)=(denrkl+btkl)*vzkl-vbkl*bzkl
        uukl(5,i,j,k)=eekl
        uukl(7,i,j,k)=bxkl
        uukl(8,i,j,k)=bykl
        uukl(9,i,j,k)=bzkl
!
        if( iflag(6).le.1 ) then
          uuir(6,i,j,k)=gfir*roir
          uujr(6,i,j,k)=gfjr*rojr
          uukr(6,i,j,k)=gfkr*rokr
          uuil(6,i,j,k)=gfil*roil
          uujl(6,i,j,k)=gfjl*rojl
          uukl(6,i,j,k)=gfkl*rokl
        elseif( iflag(6).le.3 ) then
          uuir(6,i,j,k)=gfir*ppir/roir**(gam-1.0)
          uujr(6,i,j,k)=gfjr*ppjr/rojr**(gam-1.0)
          uukr(6,i,j,k)=gfkr*ppkr/rokr**(gam-1.0)
          uuil(6,i,j,k)=gfil*ppil/roil**(gam-1.0)
          uujl(6,i,j,k)=gfjl*ppjl/rojl**(gam-1.0)
          uukl(6,i,j,k)=gfkl*ppkl/rokl**(gam-1.0)
        elseif( iflag(6).eq.4 ) then
          uuil(6,i,j,k)=gfir*roir*log(ppir/roir**gam)
          uujl(6,i,j,k)=gfjr*rojr*log(ppjr/rojr**gam)
          uukl(6,i,j,k)=gfkr*rokr*log(ppkr/rokr**gam)
          uuil(6,i,j,k)=gfil*roil*log(ppil/roil**gam)
          uujl(6,i,j,k)=gfjl*rojl*log(ppjl/rojl**gam)
          uukl(6,i,j,k)=gfkl*rokl*log(ppkl/rokl**gam)
        endif
!
        vir(1,i,j,k)=vxir
        vir(2,i,j,k)=vyir
        vir(3,i,j,k)=vzir
        vir(4,i,j,k)=exir
        vir(5,i,j,k)=eyir
        vir(6,i,j,k)=ezir
        vir(7,i,j,k)=sxir
        vir(8,i,j,k)=syir
        vir(9,i,j,k)=szir
        vir(10,i,j,k)=denrir
        vir(11,i,j,k)=ppir
        vir(12,i,j,k)=eemir
        vir(13,i,j,k)=gfir
        
        vjr(1,i,j,k)=vxjr
        vjr(2,i,j,k)=vyjr
        vjr(3,i,j,k)=vzjr
        vjr(4,i,j,k)=exjr
        vjr(5,i,j,k)=eyjr
        vjr(6,i,j,k)=ezjr
        vjr(7,i,j,k)=sxjr
        vjr(8,i,j,k)=syjr
        vjr(9,i,j,k)=szjr
        vjr(10,i,j,k)=denrjr
        vjr(11,i,j,k)=ppjr
        vjr(12,i,j,k)=eemjr
        vjr(13,i,j,k)=gfjr
        
        vkr(1,i,j,k)=vxkr
        vkr(2,i,j,k)=vykr
        vkr(3,i,j,k)=vzkr
        vkr(4,i,j,k)=exkr
        vkr(5,i,j,k)=eykr
        vkr(6,i,j,k)=ezkr
        vkr(7,i,j,k)=sxkr
        vkr(8,i,j,k)=sykr
        vkr(9,i,j,k)=szkr
        vkr(10,i,j,k)=denrkr
        vkr(11,i,j,k)=ppkr
        vkr(12,i,j,k)=eemkr
        vkr(13,i,j,k)=gfkr
        
        vil(1,i,j,k)=vxil
        vil(2,i,j,k)=vyil
        vil(3,i,j,k)=vzil
        vil(4,i,j,k)=exil
        vil(5,i,j,k)=eyil
        vil(6,i,j,k)=ezil
        vil(7,i,j,k)=sxil
        vil(8,i,j,k)=syil
        vil(9,i,j,k)=szil
        vil(10,i,j,k)=denril
        vil(11,i,j,k)=ppil
        vil(12,i,j,k)=eemil
        vil(13,i,j,k)=gfil
                 
        vjl(1,i,j,k)=vxjl
        vjl(2,i,j,k)=vyjl
        vjl(3,i,j,k)=vzjl
        vjl(4,i,j,k)=exjl
        vjl(5,i,j,k)=eyjl
        vjl(6,i,j,k)=ezjl
        vjl(7,i,j,k)=sxjl
        vjl(8,i,j,k)=syjl
        vjl(9,i,j,k)=szjl
        vjl(10,i,j,k)=denrjl
        vjl(11,i,j,k)=ppjl
        vjl(12,i,j,k)=eemjl
        vjl(13,i,j,k)=gfjl
        
        vkl(1,i,j,k)=vxkl
        vkl(2,i,j,k)=vykl
        vkl(3,i,j,k)=vzkl
        vkl(4,i,j,k)=exkl
        vkl(5,i,j,k)=eykl
        vkl(6,i,j,k)=ezkl
        vkl(7,i,j,k)=sxkl
        vkl(8,i,j,k)=sykl
        vkl(9,i,j,k)=szkl
        vkl(10,i,j,k)=denrkl
        vkl(11,i,j,k)=ppkl
        vkl(12,i,j,k)=eemkl
        vkl(13,i,j,k)=gfkl
!
      enddo
    enddo
  enddo
      
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0

        wwir(1,i,j,k)=uuir(1,i,j,k)*vir(1,i,j,k)
        wwir(2,i,j,k)=vir(10,i,j,k)*vir(1,i,j,k)*vir(1,i,j,k)+vir(11,i,j,k)
        wwir(3,i,j,k)=vir(10,i,j,k)*vir(1,i,j,k)*vir(2,i,j,k)
        wwir(4,i,j,k)=vir(10,i,j,k)*vir(1,i,j,k)*vir(3,i,j,k)
        wwir(5,i,j,k)=(vir(11,i,j,k)+uuir(5,i,j,k))*vir(1,i,j,k)
        wwir(6,i,j,k)=uuir(6,i,j,k)*vir(1,i,j,k)
        
        wwil(1,i,j,k)=uuil(1,i,j,k)*vil(1,i,j,k)
        wwil(2,i,j,k)=vil(10,i,j,k)*vil(1,i,j,k)*vil(1,i,j,k)+vil(11,i,j,k)
        wwil(3,i,j,k)=vil(10,i,j,k)*vil(1,i,j,k)*vil(2,i,j,k)
        wwil(4,i,j,k)=vil(10,i,j,k)*vil(1,i,j,k)*vil(3,i,j,k)
        wwil(5,i,j,k)=(vil(11,i,j,k)+uuil(5,i,j,k))*vil(1,i,j,k)
        wwil(6,i,j,k)=uuil(6,i,j,k)*vil(1,i,j,k)
        
        wwjr(1,i,j,k)=uujr(1,i,j,k)*vjr(2,i,j,k)
        wwjr(2,i,j,k)=vjr(10,i,j,k)*vjr(2,i,j,k)*vjr(1,i,j,k)
        wwjr(3,i,j,k)=vjr(10,i,j,k)*vjr(2,i,j,k)*vjr(2,i,j,k)+vjr(11,i,j,k)
        wwjr(4,i,j,k)=vjr(10,i,j,k)*vjr(2,i,j,k)*vjr(3,i,j,k)
        wwjr(5,i,j,k)=(vjr(11,i,j,k)+uujr(5,i,j,k))*vjr(2,i,j,k)
        wwjr(6,i,j,k)=uujr(6,i,j,k)*vjr(2,i,j,k)
        
        wwjl(1,i,j,k)=uujl(1,i,j,k)*vjl(2,i,j,k)
        wwjl(2,i,j,k)=vjl(10,i,j,k)*vjl(2,i,j,k)*vjl(1,i,j,k)
        wwjl(3,i,j,k)=vjl(10,i,j,k)*vjl(2,i,j,k)*vjl(2,i,j,k)+vjl(11,i,j,k)
        wwjl(4,i,j,k)=vjl(10,i,j,k)*vjl(2,i,j,k)*vjl(3,i,j,k)
        wwjl(5,i,j,k)=(vjl(11,i,j,k)+uujl(5,i,j,k))*vjl(2,i,j,k)
        wwjl(6,i,j,k)=uujl(6,i,j,k)*vjl(2,i,j,k)
         
        wwkr(1,i,j,k)=uukr(1,i,j,k)*vkr(3,i,j,k)
        wwkr(2,i,j,k)=vkr(10,i,j,k)*vkr(3,i,j,k)*vkr(1,i,j,k)
        wwkr(3,i,j,k)=vkr(10,i,j,k)*vkr(3,i,j,k)*vkr(2,i,j,k)
        wwkr(4,i,j,k)=vkr(10,i,j,k)*vkr(3,i,j,k)*vkr(3,i,j,k)+vkr(11,i,j,k)
        wwkr(5,i,j,k)=(vkr(11,i,j,k)+uukr(5,i,j,k))*vkr(3,i,j,k)
        wwkr(6,i,j,k)=uukr(6,i,j,k)*vkr(3,i,j,k)

        wwkl(1,i,j,k)=uukl(1,i,j,k)*vkl(3,i,j,k)
        wwkl(2,i,j,k)=vkl(10,i,j,k)*vkl(3,i,j,k)*vkl(1,i,j,k)
        wwkl(3,i,j,k)=vkl(10,i,j,k)*vkl(3,i,j,k)*vkl(2,i,j,k)
        wwkl(4,i,j,k)=vkl(10,i,j,k)*vkl(3,i,j,k)*vkl(3,i,j,k)+vkl(11,i,j,k)
        wwkl(5,i,j,k)=(vkl(11,i,j,k)+uukl(5,i,j,k))*vkl(3,i,j,k)
        wwkl(6,i,j,k)=uukl(6,i,j,k)*vkl(3,i,j,k)
         
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
    
        wwir(2,i,j,k)=wwir(2,i,j,k)&
         -uriir(7,i,j,k)*uriir(7,i,j,k)-vir(4,i,j,k)*vir(4,i,j,k)+vir(12,i,j,k)
        wwir(3,i,j,k)=wwir(3,i,j,k)&
         -uriir(7,i,j,k)*uriir(8,i,j,k)-vir(4,i,j,k)*vir(5,i,j,k)
        wwir(4,i,j,k)=wwir(4,i,j,k)&
         -uriir(7,i,j,k)*uriir(9,i,j,k)-vir(4,i,j,k)*vir(6,i,j,k)
        wwir(5,i,j,k)=wwir(5,i,j,k)-vir(12,i,j,k)*vir(1,i,j,k)+vir(7,i,j,k)
        wwir(7,i,j,k)=0.d0
        wwir(8,i,j,k)=vir(1,i,j,k)*uriir(8,i,j,k)-vir(2,i,j,k)*uriir(7,i,j,k)
        wwir(9,i,j,k)=vir(1,i,j,k)*uriir(9,i,j,k)-vir(3,i,j,k)*uriir(7,i,j,k)

        wwil(2,i,j,k)=wwil(2,i,j,k)&
         -uriil(7,i,j,k)*uriil(7,i,j,k)-vil(4,i,j,k)*vil(4,i,j,k)+vil(12,i,j,k)
        wwil(3,i,j,k)=wwil(3,i,j,k)&
         -uriil(7,i,j,k)*uriil(8,i,j,k)-vil(4,i,j,k)*vil(5,i,j,k)
        wwil(4,i,j,k)=wwil(4,i,j,k)&
         -uriil(7,i,j,k)*uriil(9,i,j,k)-vil(4,i,j,k)*vil(6,i,j,k)
        wwil(5,i,j,k)=wwil(5,i,j,k)-vil(12,i,j,k)*vil(1,i,j,k)+vil(7,i,j,k)
        wwil(7,i,j,k)=0.d0
        wwil(8,i,j,k)=vil(1,i,j,k)*uriil(8,i,j,k)-vil(2,i,j,k)*uriil(7,i,j,k)
        wwil(9,i,j,k)=vil(1,i,j,k)*uriil(9,i,j,k)-vil(3,i,j,k)*uriil(7,i,j,k)

        wwjr(2,i,j,k)=wwjr(2,i,j,k)&
         -urijr(8,i,j,k)*urijr(7,i,j,k)-vjr(5,i,j,k)*vjr(4,i,j,k)
        wwjr(3,i,j,k)=wwjr(3,i,j,k)&
         -urijr(8,i,j,k)*urijr(8,i,j,k)-vjr(5,i,j,k)*vjr(5,i,j,k)+vjr(12,i,j,k)
        wwjr(4,i,j,k)=wwjr(4,i,j,k)&
         -urijr(8,i,j,k)*urijr(9,i,j,k)-vjr(5,i,j,k)*vjr(6,i,j,k)
        wwjr(5,i,j,k)=wwjr(5,i,j,k)-vjr(12,i,j,k)*vjr(2,i,j,k)+vjr(8,i,j,k)
        wwjr(7,i,j,k)=vjr(2,i,j,k)*urijr(7,i,j,k)-vjr(1,i,j,k)*urijr(8,i,j,k)
        wwjr(8,i,j,k)=0.d0
        wwjr(9,i,j,k)=vjr(2,i,j,k)*urijr(9,i,j,k)-vjr(3,i,j,k)*urijr(8,i,j,k)

        wwjl(2,i,j,k)=wwjl(2,i,j,k)&
         -urijl(8,i,j,k)*urijl(7,i,j,k)-vjl(5,i,j,k)*vjl(4,i,j,k)
        wwjl(3,i,j,k)=wwjl(3,i,j,k)&
         -urijl(8,i,j,k)*urijl(8,i,j,k)-vjl(5,i,j,k)*vjl(5,i,j,k)+vjl(12,i,j,k)
        wwjl(4,i,j,k)=wwjl(4,i,j,k)&
         -urijl(8,i,j,k)*urijl(9,i,j,k)-vjl(5,i,j,k)*vjl(6,i,j,k)
        wwjl(5,i,j,k)=wwjl(5,i,j,k)-vjl(12,i,j,k)*vjl(2,i,j,k)+vjl(8,i,j,k)
        wwjl(7,i,j,k)=vjl(2,i,j,k)*urijl(7,i,j,k)-vjl(1,i,j,k)*urijl(8,i,j,k)
        wwjl(8,i,j,k)=0.d0
        wwjl(9,i,j,k)=vjl(2,i,j,k)*urijl(9,i,j,k)-vjl(3,i,j,k)*urijl(8,i,j,k)

        wwkr(2,i,j,k)=wwkr(2,i,j,k)&
         -urikr(9,i,j,k)*urikr(7,i,j,k)-vkr(6,i,j,k)*vkr(4,i,j,k)
        wwkr(3,i,j,k)=wwkr(3,i,j,k)&
         -urikr(9,i,j,k)*urikr(8,i,j,k)-vkr(6,i,j,k)*vkr(5,i,j,k)
        wwkr(4,i,j,k)=wwkr(4,i,j,k)&
         -urikr(9,i,j,k)*urikr(9,i,j,k)-vkr(6,i,j,k)*vkr(6,i,j,k)+vkr(12,i,j,k)
        wwkr(5,i,j,k)=wwkr(5,i,j,k)-vkr(12,i,j,k)*vkr(3,i,j,k)+vkr(9,i,j,k)
        wwkr(7,i,j,k)=vkr(3,i,j,k)*urikr(7,i,j,k)-vkr(1,i,j,k)*urikr(9,i,j,k)
        wwkr(8,i,j,k)=vkr(3,i,j,k)*urikr(8,i,j,k)-vkr(2,i,j,k)*urikr(9,i,j,k)
        wwkr(9,i,j,k)=0.d0

        wwkl(2,i,j,k)=wwkl(2,i,j,k)&
         -urikl(9,i,j,k)*urikl(7,i,j,k)-vkl(6,i,j,k)*vkl(4,i,j,k)
        wwkl(3,i,j,k)=wwkl(3,i,j,k)&
         -urikl(9,i,j,k)*urikl(8,i,j,k)-vkl(6,i,j,k)*vkl(5,i,j,k)
        wwkl(4,i,j,k)=wwkl(4,i,j,k)&
         -urikl(9,i,j,k)*urikl(9,i,j,k)-vkl(6,i,j,k)*vkl(6,i,j,k)+vkl(12,i,j,k)
        wwkl(5,i,j,k)=wwkl(5,i,j,k)-vkl(12,i,j,k)*vkl(3,i,j,k)+vkl(9,i,j,k)
        wwkl(7,i,j,k)=vkl(3,i,j,k)*urikl(7,i,j,k)-vkl(1,i,j,k)*urikl(9,i,j,k)
        wwkl(8,i,j,k)=vkl(3,i,j,k)*urikl(8,i,j,k)-vkl(2,i,j,k)*urikl(9,i,j,k)
        wwkl(9,i,j,k)=0.d0

      enddo
    enddo
  enddo

  return
end subroutine calflx
!
!---------------------------------------------------------------------@
subroutine calflx3i(uu,wwi,uri,nm0,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0  
  implicit none
!
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0
  integer :: merr  
!
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwi(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: v(:,:,:,:)
      
  real(8), allocatable :: dro(:,:,:), ee(:,:,:), &
           ro(:,:,:), pp(:,:,:), vx(:,:,:), vy(:,:,:), vz(:,:,:), &
           bx(:,:,:), by(:,:,:), bz(:,:,:)

  real(8) :: vt, gf, ex, ey, ez, sx, sy, sz, em, eem, dp

  allocate( v(13,is1:ie1,js1:je1,ks1:ke1), &
            dro(is1:ie1,js1:je1,ks1:ke1), ee(is1:ie1,js1:je1,ks1:ke1), &
            ro(is1:ie1,js1:je1,ks1:ke1), pp(is1:ie1,js1:je1,ks1:ke1), &
            vx(is1:ie1,js1:je1,ks1:ke1), vy(is1:ie1,js1:je1,ks1:ke1), &
            vz(is1:ie1,js1:je1,ks1:ke1), &
            bx(is1:ie1,js1:je1,ks1:ke1), by(is1:ie1,js1:je1,ks1:ke1), &
            bz(is1:ie1,js1:je1,ks1:ke1), stat=merr )

!=====================================================================@
 
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        
        dro(i,j,k)=uu(1,i,j,k)
        ee(i,j,k)=uu(5,i,j,k)
        bx(i,j,k)=uu(7,i,j,k)
        by(i,j,k)=uu(8,i,j,k)
        bz(i,j,k)=uu(9,i,j,k)
        
        ro(i,j,k)=uri(1,i,j,k)
        vx(i,j,k)=uri(2,i,j,k)
        vy(i,j,k)=uri(3,i,j,k)
        vz(i,j,k)=uri(4,i,j,k)
        pp(i,j,k)=uri(5,i,j,k)
        bx(i,j,k)=uri(7,i,j,k)
        by(i,j,k)=uri(8,i,j,k)
        bz(i,j,k)=uri(9,i,j,k)
         
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
 
        vt=vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2
        gf=1.0/sqrt(1.0-vt/c0**2)
 
        ex=vz(i,j,k)*by(i,j,k)-vy(i,j,k)*bz(i,j,k)
        ey=vx(i,j,k)*bz(i,j,k)-vz(i,j,k)*bx(i,j,k)
        ez=vy(i,j,k)*bx(i,j,k)-vx(i,j,k)*by(i,j,k)
        
        sx=(ey*bz(i,j,k)-ez*by(i,j,k))/c0
        sy=(ez*bx(i,j,k)-ex*bz(i,j,k))/c0
        sz=(ex*by(i,j,k)-ey*bx(i,j,k))/c0

        em=0.5*(bx(i,j,k)**2+by(i,j,k)**2+bz(i,j,k)**2)
        eem=em+0.5*(ex**2+ey**2+ez**2)
        dp=dro(i,j,k)+(ee(i,j,k)+pp(i,j,k)-eem)/c0**2

        v(1,i,j,k)=vx(i,j,k)
        v(2,i,j,k)=vy(i,j,k)
        v(3,i,j,k)=vz(i,j,k)
        v(4,i,j,k)=ex
        v(5,i,j,k)=ey
        v(6,i,j,k)=ez
        v(7,i,j,k)=sx
        v(8,i,j,k)=sy
        v(9,i,j,k)=sz
        v(10,i,j,k)=dp
        v(11,i,j,k)=pp(i,j,k)
        v(12,i,j,k)=eem
        v(13,i,j,k)=gf
        
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
         
        wwi(1,i,j,k)=uu(1,i,j,k)*v(1,i,j,k)
        wwi(2,i,j,k)=v(10,i,j,k)*v(1,i,j,k)*v(1,i,j,k)+v(11,i,j,k)
        wwi(3,i,j,k)=v(10,i,j,k)*v(1,i,j,k)*v(2,i,j,k)
        wwi(4,i,j,k)=v(10,i,j,k)*v(1,i,j,k)*v(3,i,j,k)
        wwi(5,i,j,k)=(v(11,i,j,k)+uu(5,i,j,k))*v(1,i,j,k)
        wwi(6,i,j,k)=uu(6,i,j,k)*v(1,i,j,k)
         
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        
        wwi(2,i,j,k)=wwi(2,i,j,k)&
          -uu(7,i,j,k)*uu(7,i,j,k)-v(4,i,j,k)*v(4,i,j,k)+v(12,i,j,k)
        wwi(3,i,j,k)=wwi(3,i,j,k)&
          -uu(7,i,j,k)*uu(8,i,j,k)-v(4,i,j,k)*v(5,i,j,k)
        wwi(4,i,j,k)=wwi(4,i,j,k)&
          -uu(7,i,j,k)*uu(9,i,j,k)-v(4,i,j,k)*v(6,i,j,k)
        wwi(5,i,j,k)=wwi(5,i,j,k)-v(12,i,j,k)*v(1,i,j,k)+v(7,i,j,k)
        wwi(7,i,j,k)=0.d0
        wwi(8,i,j,k)=v(1,i,j,k)*uu(8,i,j,k)-v(2,i,j,k)*uu(7,i,j,k)
        wwi(9,i,j,k)=v(1,i,j,k)*uu(9,i,j,k)-v(3,i,j,k)*uu(7,i,j,k)
        
      enddo
    enddo
  enddo

  deallocate( v, dro, ee, ro, pp, vx, vy, vz, bx, by, bz, stat=merr )

  return
end subroutine calflx3i
!
!---------------------------------------------------------------------@
subroutine calflx3j(uu,wwj,uri,nm0,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0  
  implicit none
!
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0
  integer :: merr  
!
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwj(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: v(:,:,:,:)
      
  real(8), allocatable :: dro(:,:,:), ee(:,:,:), &
           ro(:,:,:), pp(:,:,:), vx(:,:,:), vy(:,:,:), vz(:,:,:), &
           bx(:,:,:), by(:,:,:), bz(:,:,:)

  real(8) :: vt, gf, ex, ey, ez, sx, sy, sz, em, eem, dp

  allocate(  v(13,is1:ie1,js1:je1,ks1:ke1),&
             dro(is1:ie1,js1:je1,ks1:ke1), ee(is1:ie1,js1:je1,ks1:ke1), &
             ro(is1:ie1,js1:je1,ks1:ke1), pp(is1:ie1,js1:je1,ks1:ke1), &
             vx(is1:ie1,js1:je1,ks1:ke1), vy(is1:ie1,js1:je1,ks1:ke1), &
             vz(is1:ie1,js1:je1,ks1:ke1), &
             bx(is1:ie1,js1:je1,ks1:ke1), by(is1:ie1,js1:je1,ks1:ke1), &
             bz(is1:ie1,js1:je1,ks1:ke1), stat=merr )
!
!=====================================================================@
 
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        
        dro(i,j,k)=uu(1,i,j,k)
        ee(i,j,k)=uu(5,i,j,k)
        bx(i,j,k)=uu(7,i,j,k)
        by(i,j,k)=uu(8,i,j,k)
        bz(i,j,k)=uu(9,i,j,k)
        
        ro(i,j,k)=uri(1,i,j,k)
        vx(i,j,k)=uri(2,i,j,k)
        vy(i,j,k)=uri(3,i,j,k)
        vz(i,j,k)=uri(4,i,j,k)
        pp(i,j,k)=uri(5,i,j,k)
        bx(i,j,k)=uri(7,i,j,k)
        by(i,j,k)=uri(8,i,j,k)
        bz(i,j,k)=uri(9,i,j,k)
         
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
 
        vt=vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2
        gf=1.0/sqrt(1.0-vt/c0**2)
 
        ex=vz(i,j,k)*by(i,j,k)-vy(i,j,k)*bz(i,j,k)
        ey=vx(i,j,k)*bz(i,j,k)-vz(i,j,k)*bx(i,j,k)
        ez=vy(i,j,k)*bx(i,j,k)-vx(i,j,k)*by(i,j,k)
        
        sx=(ey*bz(i,j,k)-ez*by(i,j,k))/c0
        sy=(ez*bx(i,j,k)-ex*bz(i,j,k))/c0
        sz=(ex*by(i,j,k)-ey*bx(i,j,k))/c0

        em=0.5*(bx(i,j,k)**2+by(i,j,k)**2+bz(i,j,k)**2)
        eem=em+0.5*(ex**2+ey**2+ez**2)
        dp=dro(i,j,k)+(ee(i,j,k)+pp(i,j,k)-eem)/c0**2

        v(1,i,j,k)=vx(i,j,k)
        v(2,i,j,k)=vy(i,j,k)
        v(3,i,j,k)=vz(i,j,k)
        v(4,i,j,k)=ex
        v(5,i,j,k)=ey
        v(6,i,j,k)=ez
        v(7,i,j,k)=sx
        v(8,i,j,k)=sy
        v(9,i,j,k)=sz
        v(10,i,j,k)=dp
        v(11,i,j,k)=pp(i,j,k)
        v(12,i,j,k)=eem
        v(13,i,j,k)=gf

      enddo 
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
         
        wwj(1,i,j,k)=uu(1,i,j,k)*v(2,i,j,k)
        wwj(2,i,j,k)=v(10,i,j,k)*v(2,i,j,k)*v(1,i,j,k)
        wwj(3,i,j,k)=v(10,i,j,k)*v(2,i,j,k)*v(2,i,j,k)+v(11,i,j,k)
        wwj(4,i,j,k)=v(10,i,j,k)*v(2,i,j,k)*v(3,i,j,k)
        wwj(5,i,j,k)=(v(11,i,j,k)+uu(5,i,j,k))*v(2,i,j,k)
        wwj(6,i,j,k)=uu(6,i,j,k)*v(2,i,j,k)
         
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
!
        wwj(2,i,j,k)=wwj(2,i,j,k)&
          -uu(8,i,j,k)*uu(7,i,j,k)-v(5,i,j,k)*v(4,i,j,k)
        wwj(3,i,j,k)=wwj(3,i,j,k)&
          -uu(8,i,j,k)*uu(8,i,j,k)-v(5,i,j,k)*v(5,i,j,k)+v(12,i,j,k)
        wwj(4,i,j,k)=wwj(4,i,j,k)&
          -uu(8,i,j,k)*uu(9,i,j,k)-v(5,i,j,k)*v(6,i,j,k)
        wwj(5,i,j,k)=wwj(5,i,j,k)-v(12,i,j,k)*v(2,i,j,k)+v(8,i,j,k)
        wwj(7,i,j,k)=v(2,i,j,k)*uu(7,i,j,k)-v(1,i,j,k)*uu(8,i,j,k)
        wwj(8,i,j,k)=0.d0
        wwj(9,i,j,k)=v(2,i,j,k)*uu(9,i,j,k)-v(3,i,j,k)*uu(8,i,j,k)

      enddo
    enddo
  enddo
!
  deallocate ( v, dro, ee, ro, pp, vx, vy, vz, bx, by, bz, stat=merr )
!
  return
end subroutine calflx3j
!
!---------------------------------------------------------------------@
subroutine calflx3k(uu,wwk,uri,nm0,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0  
  implicit none
!
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0  
  integer :: merr
!
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwk(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8), allocatable :: v(:,:,:,:)
      
  real(8), allocatable :: dro(:,:,:), ee(:,:,:), &
           ro(:,:,:), pp(:,:,:), vx(:,:,:), vy(:,:,:), vz(:,:,:), &
           bx(:,:,:), by(:,:,:), bz(:,:,:)

  real(8) :: vt, gf, ex, ey, ez, sx, sy, sz, em, eem, dp
!
  allocate(  v(13,is1:ie1,js1:je1,ks1:ke1), &
             dro(is1:ie1,js1:je1,ks1:ke1), ee(is1:ie1,js1:je1,ks1:ke1), &
             ro(is1:ie1,js1:je1,ks1:ke1), pp(is1:ie1,js1:je1,ks1:ke1), &
             vx(is1:ie1,js1:je1,ks1:ke1), vy(is1:ie1,js1:je1,ks1:ke1), &
             vz(is1:ie1,js1:je1,ks1:ke1), &
             bx(is1:ie1,js1:je1,ks1:ke1), by(is1:ie1,js1:je1,ks1:ke1), &
             bz(is1:ie1,js1:je1,ks1:ke1), stat=merr )
!
!=====================================================================@
 
  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
        dro(i,j,k)=uu(1,i,j,k)
        ee(i,j,k)=uu(5,i,j,k)
        bx(i,j,k)=uu(7,i,j,k)
        by(i,j,k)=uu(8,i,j,k)
        bz(i,j,k)=uu(9,i,j,k)
        
        ro(i,j,k)=uri(1,i,j,k)
        vx(i,j,k)=uri(2,i,j,k)
        vy(i,j,k)=uri(3,i,j,k)
        vz(i,j,k)=uri(4,i,j,k)
        pp(i,j,k)=uri(5,i,j,k)
        bx(i,j,k)=uri(7,i,j,k)
        by(i,j,k)=uri(8,i,j,k)
        bz(i,j,k)=uri(9,i,j,k)
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
 
        vt=vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2
        gf=1.0/sqrt(1.0-vt/c0**2)
 
        ex=vz(i,j,k)*by(i,j,k)-vy(i,j,k)*bz(i,j,k)
        ey=vx(i,j,k)*bz(i,j,k)-vz(i,j,k)*bx(i,j,k)
        ez=vy(i,j,k)*bx(i,j,k)-vx(i,j,k)*by(i,j,k)
        
        sx=(ey*bz(i,j,k)-ez*by(i,j,k))/c0
        sy=(ez*bx(i,j,k)-ex*bz(i,j,k))/c0
        sz=(ex*by(i,j,k)-ey*bx(i,j,k))/c0

        em=0.5*(bx(i,j,k)**2+by(i,j,k)**2+bz(i,j,k)**2)
        eem=em+0.5*(ex**2+ey**2+ez**2)
        dp=dro(i,j,k)+(ee(i,j,k)+pp(i,j,k)-eem)/c0**2

        v(1,i,j,k)=vx(i,j,k)
        v(2,i,j,k)=vy(i,j,k)
        v(3,i,j,k)=vz(i,j,k)
        v(4,i,j,k)=ex
        v(5,i,j,k)=ey
        v(6,i,j,k)=ez
        v(7,i,j,k)=sx
        v(8,i,j,k)=sy
        v(9,i,j,k)=sz
        v(10,i,j,k)=dp
        v(11,i,j,k)=pp(i,j,k)
        v(12,i,j,k)=eem
        v(13,i,j,k)=gf
        
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0
         
        wwk(1,i,j,k)=uu(1,i,j,k)*v(3,i,j,k)
        wwk(2,i,j,k)=v(10,i,j,k)*v(3,i,j,k)*v(1,i,j,k)
        wwk(3,i,j,k)=v(10,i,j,k)*v(3,i,j,k)*v(2,i,j,k)
        wwk(4,i,j,k)=v(10,i,j,k)*v(3,i,j,k)*v(3,i,j,k)+v(11,i,j,k)
        wwk(5,i,j,k)=(v(11,i,j,k)+uu(5,i,j,k))*v(3,i,j,k)
        wwk(6,i,j,k)=uu(6,i,j,k)*v(3,i,j,k)
        
      enddo
    enddo
  enddo

  do k=ks1+nm0-1,ke1-nm0
    do j=js1+nm0-1,je1-nm0
      do i=is1+nm0-1,ie1-nm0

        wwk(2,i,j,k)=wwk(2,i,j,k)&
          -uu(9,i,j,k)*uu(7,i,j,k)-v(6,i,j,k)*v(4,i,j,k)
        wwk(3,i,j,k)=wwk(3,i,j,k)&
          -uu(9,i,j,k)*uu(8,i,j,k)-v(6,i,j,k)*v(5,i,j,k)
        wwk(4,i,j,k)=wwk(4,i,j,k)&
          -uu(9,i,j,k)*uu(9,i,j,k)-v(6,i,j,k)*v(6,i,j,k)+v(12,i,j,k)
        wwk(5,i,j,k)=wwk(5,i,j,k)-v(12,i,j,k)*v(3,i,j,k)+v(9,i,j,k)
        wwk(7,i,j,k)=v(3,i,j,k)*uu(7,i,j,k)-v(1,i,j,k)*uu(9,i,j,k)
        wwk(8,i,j,k)=v(3,i,j,k)*uu(8,i,j,k)-v(2,i,j,k)*uu(9,i,j,k)
        wwk(9,i,j,k)=0.d0

      enddo
    enddo
  enddo
!
  deallocate(  v, dro, ee, ro, pp, vx, vy, vz, bx, by, bz, stat=merr )
!
  return
end subroutine calflx3k 
!
!---------------------------------------------------------------------@
subroutine calwwo(uu,wwo,uri,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: nm0, merr  
!
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwo(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: uri(nv,is1:ie1,js1:je1,ks1:ke1)
!
  real(8), allocatable :: v(:,:,:,:), &
           dro(:,:,:), ee(:,:,:), ro(:,:,:), pp(:,:,:), &
           vx(:,:,:), vy(:,:,:), vz(:,:,:), &
           bx(:,:,:), by(:,:,:), bz(:,:,:)

  real(8) :: vt, gf, ex, ey, ez, sx, sy, sz, em, eem, dp
!
  allocate( v(13,is1:ie1,js1:je1,ks1:ke1), &
            dro(is1:ie1,js1:je1,ks1:ke1), ee(is1:ie1,js1:je1,ks1:ke1), &
            ro(is1:ie1,js1:je1,ks1:ke1), pp(is1:ie1,js1:je1,ks1:ke1), &
            vx(is1:ie1,js1:je1,ks1:ke1), vy(is1:ie1,js1:je1,ks1:ke1), &
            vz(is1:ie1,js1:je1,ks1:ke1), &
            bx(is1:ie1,js1:je1,ks1:ke1), by(is1:ie1,js1:je1,ks1:ke1), &
            bz(is1:ie1,js1:je1,ks1:ke1), stat=merr )
!
!=====================================================================@

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        dro(i,j,k)=uu(1,i,j,k)
        ee(i,j,k)=uu(5,i,j,k)
        bx(i,j,k)=uu(7,i,j,k)
        by(i,j,k)=uu(8,i,j,k)
        bz(i,j,k)=uu(9,i,j,k)
        
        ro(i,j,k)=uri(1,i,j,k)
        vx(i,j,k)=uri(2,i,j,k)
        vy(i,j,k)=uri(3,i,j,k)
        vz(i,j,k)=uri(4,i,j,k)
        pp(i,j,k)=uri(5,i,j,k)
        bx(i,j,k)=uri(7,i,j,k)
        by(i,j,k)=uri(8,i,j,k)
        bz(i,j,k)=uri(9,i,j,k)
      enddo
    enddo
  enddo

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
 
        vt=vx(i,j,k)**2+vy(i,j,k)**2+vz(i,j,k)**2
        gf=1.0/sqrt(1.0-vt/c0**2)
 
        ex=vz(i,j,k)*by(i,j,k)-vy(i,j,k)*bz(i,j,k)
        ey=vx(i,j,k)*bz(i,j,k)-vz(i,j,k)*bx(i,j,k)
        ez=vy(i,j,k)*bx(i,j,k)-vx(i,j,k)*by(i,j,k)
        
        sx=(ey*bz(i,j,k)-ez*by(i,j,k))/c0
        sy=(ez*bx(i,j,k)-ex*bz(i,j,k))/c0
        sz=(ex*by(i,j,k)-ey*bx(i,j,k))/c0

        em=0.5*(bx(i,j,k)**2+by(i,j,k)**2+bz(i,j,k)**2)
        eem=em+0.5*(ex**2+ey**2+ez**2)
        dp=dro(i,j,k)+(ee(i,j,k)+pp(i,j,k)-eem)/c0**2

        v(1,i,j,k)=vx(i,j,k)
        v(2,i,j,k)=vy(i,j,k)
        v(3,i,j,k)=vz(i,j,k)
        v(4,i,j,k)=ex
        v(5,i,j,k)=ey
        v(6,i,j,k)=ez
        v(7,i,j,k)=sx
        v(8,i,j,k)=sy
        v(9,i,j,k)=sz
        v(10,i,j,k)=dp
        v(11,i,j,k)=pp(i,j,k)
        v(12,i,j,k)=eem
        v(13,i,j,k)=gf
        
      enddo
    enddo
  enddo

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        wwo(1,1,i,j,k)=uu(1,i,j,k)*v(1,i,j,k)
        wwo(2,1,i,j,k)=uu(1,i,j,k)*v(2,i,j,k)
        wwo(3,1,i,j,k)=uu(1,i,j,k)*v(3,i,j,k)
!
        wwo(1,2,i,j,k)=v(10,i,j,k)*v(1,i,j,k)*v(1,i,j,k)+v(11,i,j,k)
        wwo(1,3,i,j,k)=v(10,i,j,k)*v(1,i,j,k)*v(2,i,j,k)
        wwo(1,4,i,j,k)=v(10,i,j,k)*v(1,i,j,k)*v(3,i,j,k)
!
        wwo(2,2,i,j,k)=v(10,i,j,k)*v(2,i,j,k)*v(1,i,j,k)
        wwo(2,3,i,j,k)=v(10,i,j,k)*v(2,i,j,k)*v(2,i,j,k)+v(11,i,j,k)
        wwo(2,4,i,j,k)=v(10,i,j,k)*v(2,i,j,k)*v(3,i,j,k)
!
        wwo(3,2,i,j,k)=v(10,i,j,k)*v(3,i,j,k)*v(1,i,j,k)
        wwo(3,3,i,j,k)=v(10,i,j,k)*v(3,i,j,k)*v(2,i,j,k)
        wwo(3,4,i,j,k)=v(10,i,j,k)*v(3,i,j,k)*v(3,i,j,k)+v(11,i,j,k)
!
        wwo(1,5,i,j,k)=(v(11,i,j,k)+uu(5,i,j,k))*v(1,i,j,k)
        wwo(2,5,i,j,k)=(v(11,i,j,k)+uu(5,i,j,k))*v(2,i,j,k)
        wwo(3,5,i,j,k)=(v(11,i,j,k)+uu(5,i,j,k))*v(3,i,j,k)
!
        wwo(1,6,i,j,k)=uu(6,i,j,k)*v(1,i,j,k)
        wwo(2,6,i,j,k)=uu(6,i,j,k)*v(2,i,j,k)
        wwo(3,6,i,j,k)=uu(6,i,j,k)*v(3,i,j,k)
      enddo
    enddo
  enddo

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        wwo(1,2,i,j,k)=wwo(1,2,i,j,k)&
          -uu(7,i,j,k)*uu(7,i,j,k)-v(4,i,j,k)*v(4,i,j,k)+v(12,i,j,k)
        wwo(1,3,i,j,k)=wwo(1,3,i,j,k)&
          -uu(7,i,j,k)*uu(8,i,j,k)-v(4,i,j,k)*v(5,i,j,k)
        wwo(1,4,i,j,k)=wwo(1,4,i,j,k)&
          -uu(7,i,j,k)*uu(9,i,j,k)-v(4,i,j,k)*v(6,i,j,k)
!
        wwo(2,2,i,j,k)=wwo(2,2,i,j,k)&
          -uu(8,i,j,k)*uu(7,i,j,k)-v(5,i,j,k)*v(4,i,j,k)
        wwo(2,3,i,j,k)=wwo(2,3,i,j,k)&
          -uu(8,i,j,k)*uu(8,i,j,k)-v(5,i,j,k)*v(5,i,j,k)+v(12,i,j,k)
        wwo(2,4,i,j,k)=wwo(2,4,i,j,k)&
          -uu(8,i,j,k)*uu(9,i,j,k)-v(5,i,j,k)*v(6,i,j,k)
!
        wwo(3,2,i,j,k)=wwo(3,2,i,j,k)&
          -uu(9,i,j,k)*uu(7,i,j,k)-v(6,i,j,k)*v(4,i,j,k)
        wwo(3,3,i,j,k)=wwo(3,3,i,j,k)&
          -uu(9,i,j,k)*uu(8,i,j,k)-v(6,i,j,k)*v(5,i,j,k)
        wwo(3,4,i,j,k)=wwo(3,4,i,j,k)&
          -uu(9,i,j,k)*uu(9,i,j,k)-v(6,i,j,k)*v(6,i,j,k)+v(12,i,j,k)
!
        wwo(1,5,i,j,k)=wwo(1,5,i,j,k)-v(12,i,j,k)*v(1,i,j,k)+v(7,i,j,k)
        wwo(2,5,i,j,k)=wwo(2,5,i,j,k)-v(12,i,j,k)*v(2,i,j,k)+v(8,i,j,k)
        wwo(3,5,i,j,k)=wwo(3,5,i,j,k)-v(12,i,j,k)*v(3,i,j,k)+v(9,i,j,k)
!
        wwo(1,7,i,j,k)=0.d0
        wwo(1,8,i,j,k)=v(1,i,j,k)*uu(8,i,j,k)-v(2,i,j,k)*uu(7,i,j,k)
        wwo(1,9,i,j,k)=v(1,i,j,k)*uu(9,i,j,k)-v(3,i,j,k)*uu(7,i,j,k)
!
        wwo(2,7,i,j,k)=v(2,i,j,k)*uu(7,i,j,k)-v(1,i,j,k)*uu(8,i,j,k)
        wwo(2,8,i,j,k)=0.d0
        wwo(2,9,i,j,k)=v(2,i,j,k)*uu(9,i,j,k)-v(3,i,j,k)*uu(8,i,j,k)
!
        wwo(3,7,i,j,k)=v(3,i,j,k)*uu(7,i,j,k)-v(1,i,j,k)*uu(9,i,j,k)
        wwo(3,8,i,j,k)=v(3,i,j,k)*uu(8,i,j,k)-v(2,i,j,k)*uu(9,i,j,k)
        wwo(3,9,i,j,k)=0.d0
!
      enddo
    enddo
  enddo
!
  deallocate( v, dro, ee, ro, pp, vx, vy, vz, bx, by, bz, stat=merr )
!
  return
end subroutine calwwo
