!***********************************************************************
!     for Calculation of Source Terms
!***********************************************************************
!
!---------------------------------------------------------------------
subroutine calsf(sf,uu,wwo,gm,dt,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1  
!
  real(8) :: uu(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: sf(2:5,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: wwo(3,nv,is1:ie1,js1:je1,ks1:ke1)
!
  real(8) :: dt
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        sf(2,i,j,k)=-(gm(2,1,i,j,k)*wwo(2,3,i,j,k)&
                    +gm(3,1,i,j,k)*wwo(3,4,i,j,k)&
                    -gm(1,2,i,j,k)*wwo(1,3,i,j,k)&
                    -gm(1,3,i,j,k)*wwo(1,4,i,j,k))*dt&
                    +gm(0,1,i,j,k)*(uu(1,i,j,k)*c0**2+uu(5,i,j,k))*dt
        sf(3,i,j,k)=-(gm(3,2,i,j,k)*wwo(3,4,i,j,k)&
                    +gm(1,2,i,j,k)*wwo(1,2,i,j,k)&
                    -gm(2,3,i,j,k)*wwo(2,4,i,j,k)&
                    -gm(2,1,i,j,k)*wwo(2,2,i,j,k))*dt&
                    +gm(0,2,i,j,k)*(uu(1,i,j,k)*c0**2+uu(5,i,j,k))*dt
        sf(4,i,j,k)=-(gm(1,3,i,j,k)*wwo(1,2,i,j,k)&
                    +gm(2,3,i,j,k)*wwo(2,3,i,j,k)&
                    -gm(3,1,i,j,k)*wwo(3,2,i,j,k)&
                    -gm(3,2,i,j,k)*wwo(3,3,i,j,k))*dt&
                    +gm(0,3,i,j,k)*(uu(1,i,j,k)*c0**2+uu(5,i,j,k))*dt
        sf(5,i,j,k)=dt*c0**2*(gm(0,1,i,j,k)*uu(2,i,j,k)&
                    +gm(0,2,i,j,k)*uu(3,i,j,k)&
                    +gm(0,3,i,j,k)*uu(4,i,j,k))

      enddo
    enddo
  enddo
!
  return
end subroutine calsf
