!***********************************************************************
!      for GENERAL ORTHOGONAL COORDINATES CALCULATION
!***********************************************************************
!
!     Cartesian Coordinates
!
!--------------------------------------------------------------------
subroutine carmet(hh,hhi,hhj,hhk,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        hh(0,i,j,k)=1.d0
        hh(1,i,j,k)=1.d0
        hh(2,i,j,k)=1.d0
        hh(3,i,j,k)=1.d0
        
        hhi(0,i,j,k)=1.d0
        hhi(1,i,j,k)=1.d0
        hhi(2,i,j,k)=1.d0
        hhi(3,i,j,k)=1.d0
         
        hhj(0,i,j,k)=1.d0
        hhj(1,i,j,k)=1.d0
        hhj(2,i,j,k)=1.d0
        hhj(3,i,j,k)=1.d0
         
        hhk(0,i,j,k)=1.d0
        hhk(1,i,j,k)=1.d0
        hhk(2,i,j,k)=1.d0
        hhk(3,i,j,k)=1.d0
      enddo
    enddo
  enddo
!
  return
end subroutine carmet
!--------------------------------------------------------------------
subroutine cargeo(gm,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax 
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        gm(0,1,i,j,k)=0.d0
        gm(0,2,i,j,k)=0.d0
        gm(0,3,i,j,k)=0.d0
        gm(1,1,i,j,k)=0.d0
        gm(1,2,i,j,k)=0.d0
        gm(1,3,i,j,k)=0.d0
        gm(2,1,i,j,k)=0.d0
        gm(2,2,i,j,k)=0.d0
        gm(2,3,i,j,k)=0.d0
        gm(3,1,i,j,k)=0.d0
        gm(3,2,i,j,k)=0.d0
        gm(3,3,i,j,k)=0.d0
      enddo
    enddo
  enddo
!
  return
end subroutine cargeo
!
!      Cylindrical Coordinates
!
!--------------------------------------------------------------------
subroutine cylmet(hh,x1,hhi,hhj,hhk,x1a,is1,ie1,js1,je1,ks1,ke1) 
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
 
  real(8) :: x1(imax), x1a(imax)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        hh(0,i,j,k)=1.d0
        hh(1,i,j,k)=1.d0
        hh(2,i,j,k)=x1(i)
        hh(3,i,j,k)=1.d0
         
        hhi(0,i,j,k)=1.d0
        hhi(1,i,j,k)=1.d0
        hhi(2,i,j,k)=x1a(i)
        hhi(3,i,j,k)=1.d0
         
        hhj(0,i,j,k)=1.d0
        hhj(1,i,j,k)=1.d0
        hhj(2,i,j,k)=x1(i)
        hhj(3,i,j,k)=1.d0
         
        hhk(0,i,j,k)=1.d0
        hhk(1,i,j,k)=1.d0
        hhk(2,i,j,k)=x1(i)
        hhk(3,i,j,k)=1.d0
      enddo
    enddo
  enddo
!
  return
end subroutine cylmet
!
!--------------------------------------------------------------------
subroutine cylgeo(gm,hh,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax  
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        gm(0,1,i,j,k)=0.d0
        gm(0,2,i,j,k)=0.d0
        gm(0,3,i,j,k)=0.d0
        gm(1,1,i,j,k)=0.d0
        gm(1,2,i,j,k)=0.d0
        gm(1,3,i,j,k)=0.d0
        gm(2,1,i,j,k)=-1.0/hh(2,i,j,k)
        gm(2,2,i,j,k)=0.d0
        gm(2,3,i,j,k)=0.d0
        gm(3,1,i,j,k)=0.d0
        gm(3,2,i,j,k)=0.d0
        gm(3,3,i,j,k)=0.d0
      enddo
    enddo
  enddo
!
  return
end subroutine cylgeo
!
!      Spherical Coordinates
!
!--------------------------------------------------------------------
subroutine sphmet(hh,x1,x3,hhi,hhj,hhk,x1a,x3a,is1,ie1,js1,je1,ks1,ke1) 
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
 
  real(8) :: x1(imax), x3(kmax), x1a(imax), x3a(kmax)

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        hh(0,i,j,k)=1.d0
        hh(1,i,j,k)=1.d0
        hh(2,i,j,k)=x1(i)*sin(x3(k))
        hh(3,i,j,k)=x1(i)
         
        hhi(0,i,j,k)=1.d0
        hhi(1,i,j,k)=1.d0
        hhi(2,i,j,k)=x1a(i)*sin(x3(k))
        hhi(3,i,j,k)=x1a(i)
         
        hhj(0,i,j,k)=1.d0
        hhj(1,i,j,k)=1.d0
        hhj(2,i,j,k)=x1(i)*sin(x3(k))
        hhj(3,i,j,k)=x1(i)
         
        hhk(0,i,j,k)=1.d0
        hhk(1,i,j,k)=1.d0
        hhk(2,i,j,k)=x1(i)*sin(x3a(k))
        hhk(3,i,j,k)=x1(i)
      enddo
    enddo
  enddo
!
  return
end subroutine sphmet
!--------------------------------------------------------------------
subroutine sphgeo(gm,x3,hh,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, kmax
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  
  real(8) :: gm(0:3,3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x3(kmax)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
!
!    First  -1/h_j *dh_i/dx^j
!
        gm(0,1,i,j,k)=0.d0
        gm(0,2,i,j,k)=0.d0
        gm(0,3,i,j,k)=0.d0
        gm(1,1,i,j,k)=0.d0
        gm(1,2,i,j,k)=0.d0
        gm(1,3,i,j,k)=0.d0
        gm(2,1,i,j,k)=-sin(x3(k))
        gm(2,2,i,j,k)=0.d0
        gm(2,3,i,j,k)=-cos(x3(k))
        gm(3,1,i,j,k)=-1.d0
        gm(3,2,i,j,k)=0.d0
        gm(3,3,i,j,k)=0.d0
      enddo
    enddo
  enddo
!
!     Second h_0 *gm(i,j)/h_i
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        gm(1,1,i,j,k)=hh(0,i,j,k)*gm(1,1,i,j,k)/hh(1,i,j,k)
        gm(1,2,i,j,k)=hh(0,i,j,k)*gm(1,2,i,j,k)/hh(1,i,j,k)
        gm(1,3,i,j,k)=hh(0,i,j,k)*gm(1,3,i,j,k)/hh(1,i,j,k)
        gm(2,1,i,j,k)=hh(0,i,j,k)*gm(2,1,i,j,k)/hh(2,i,j,k)
        gm(2,2,i,j,k)=hh(0,i,j,k)*gm(2,2,i,j,k)/hh(2,i,j,k)
        gm(2,3,i,j,k)=hh(0,i,j,k)*gm(2,3,i,j,k)/hh(2,i,j,k)
        gm(3,1,i,j,k)=hh(0,i,j,k)*gm(3,1,i,j,k)/hh(3,i,j,k)
        gm(3,2,i,j,k)=hh(0,i,j,k)*gm(3,2,i,j,k)/hh(3,i,j,k)
        gm(3,3,i,j,k)=hh(0,i,j,k)*gm(3,3,i,j,k)/hh(3,i,j,k)
      enddo
    enddo
  enddo
!
  return
end subroutine sphgeo
!
!--------------------------------------------------------------------
subroutine calhoi(hh,hi,ho,hhi,hhj,hhk,hii,hij,hik,hoi,hoj,hok, &
                  is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, nv
  implicit none
  
  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: hh(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhi(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhj(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hhk(0:3,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hi(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hii(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hij(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hik(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: ho(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hoi(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hoj(nv,is1:ie1,js1:je1,ks1:ke1)
  real(8) :: hok(nv,is1:ie1,js1:je1,ks1:ke1)

  real(8) :: h0, h1, h2, h3, h123, h123a, h0i, h1i, h2i, h3i, h123i 
  real(8) :: h0j, h1j, h2j, h3j, h123j, h0k, h1k, h2k, h3k, h123k

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        h0=hh(0,i,j,k)
        h1=hh(1,i,j,k)
        h2=hh(2,i,j,k)
        h3=hh(3,i,j,k)
        h123=1.0/(h1*h2*h3)

        h123a=h1*h2*h3

        h0i=hhi(0,i,j,k)
        h1i=hhi(1,i,j,k)
        h2i=hhi(2,i,j,k)
        h3i=hhi(3,i,j,k)
        h123i=1.0/(h1i*h2i*h3i)

        h0j=hhj(0,i,j,k)
        h1j=hhj(1,i,j,k)
        h2j=hhj(2,i,j,k)
        h3j=hhj(3,i,j,k)
        h123j=1.0/(h1j*h2j*h3j)

        h0k=hhk(0,i,j,k)
        h1k=hhk(1,i,j,k)
        h2k=hhk(2,i,j,k)
        h3k=hhk(3,i,j,k)
        h123k=1.0/(h1k*h2k*h3k)
!
        ho(1,1,i,j,k)=h123
        ho(2,1,i,j,k)=h123
        ho(3,1,i,j,k)=h123
        ho(1,2,i,j,k)=h123
        ho(2,2,i,j,k)=h123
        ho(3,2,i,j,k)=h123
        ho(1,3,i,j,k)=h123
        ho(2,3,i,j,k)=h123
        ho(3,3,i,j,k)=h123
        ho(1,4,i,j,k)=h123
        ho(2,4,i,j,k)=h123
        ho(3,4,i,j,k)=h123
        ho(1,5,i,j,k)=h123
        ho(2,5,i,j,k)=h123
        ho(3,5,i,j,k)=h123
        ho(1,6,i,j,k)=h123
        ho(2,6,i,j,k)=h123
        ho(3,6,i,j,k)=h123
         
        hoi(1,i,j,k)=h123i
        hoi(2,i,j,k)=h123i
        hoi(3,i,j,k)=h123i
        hoi(4,i,j,k)=h123i
        hoi(5,i,j,k)=h123i
        hoi(6,i,j,k)=h123i

        hoj(1,i,j,k)=h123j
        hoj(2,i,j,k)=h123j
        hoj(3,i,j,k)=h123j 
        hoj(4,i,j,k)=h123j
        hoj(5,i,j,k)=h123j
        hoj(6,i,j,k)=h123j

        hok(1,i,j,k)=h123k 
        hok(2,i,j,k)=h123k
        hok(3,i,j,k)=h123k
        hok(4,i,j,k)=h123k
        hok(5,i,j,k)=h123k
        hok(6,i,j,k)=h123k
 
        hi(1,1,i,j,k)=h2*h3*h0
        hi(2,1,i,j,k)=h3*h1*h0
        hi(3,1,i,j,k)=h1*h2*h0
        hi(1,2,i,j,k)=h2*h3*h0
        hi(2,2,i,j,k)=h3*h1*h0
        hi(3,2,i,j,k)=h1*h2*h0
        hi(1,3,i,j,k)=h2*h3*h0
        hi(2,3,i,j,k)=h3*h1*h0
        hi(3,3,i,j,k)=h1*h2*h0
        hi(1,4,i,j,k)=h2*h3*h0
        hi(2,4,i,j,k)=h3*h1*h0
        hi(3,4,i,j,k)=h1*h2*h0
        hi(1,5,i,j,k)=h2*h3*h0
        hi(2,5,i,j,k)=h3*h1*h0
        hi(3,5,i,j,k)=h1*h2*h0
        hi(1,6,i,j,k)=h2*h3*h0
        hi(2,6,i,j,k)=h3*h1*h0
        hi(3,6,i,j,k)=h1*h2*h0
        
        hii(1,i,j,k)=h2i*h3i*h0i
        hii(2,i,j,k)=h2i*h3i*h0i
        hii(3,i,j,k)=h2i*h3i*h0i
        hii(4,i,j,k)=h2i*h3i*h0i
        hii(5,i,j,k)=h2i*h3i*h0i
        hii(6,i,j,k)=h2i*h3i*h0i
 
        hij(1,i,j,k)=h3j*h1j*h0j
        hij(2,i,j,k)=h3j*h1j*h0j
        hij(3,i,j,k)=h3j*h1j*h0j
        hij(4,i,j,k)=h3j*h1j*h0j
        hij(5,i,j,k)=h3j*h1j*h0j
        hij(6,i,j,k)=h3j*h1j*h0j
 
        hik(1,i,j,k)=h1k*h2k*h0k         
        hik(2,i,j,k)=h1k*h2k*h0k
        hik(3,i,j,k)=h1k*h2k*h0k
        hik(4,i,j,k)=h1k*h2k*h0k
        hik(5,i,j,k)=h1k*h2k*h0k
        hik(6,i,j,k)=h1k*h2k*h0k
!
        ho(1,7,i,j,k)=0.d0
        ho(2,7,i,j,k)=1.d0/(h2*h3)
        ho(3,7,i,j,k)=1.d0/(h2*h3)
        ho(1,8,i,j,k)=1.d0/(h3*h1)
        ho(2,8,i,j,k)=0.d0
        ho(3,8,i,j,k)=1.d0/(h3*h1)
        ho(1,9,i,j,k)=1.d0/(h1*h2)
        ho(2,9,i,j,k)=1.d0/(h1*h2)
        ho(3,9,i,j,k)=0.d0
        hi(1,7,i,j,k)=0.d0
        hi(2,7,i,j,k)=h3*h0
        hi(3,7,i,j,k)=h2*h0
        hi(1,8,i,j,k)=h3*h0
        hi(2,8,i,j,k)=0.d0
        hi(3,8,i,j,k)=h1*h0
        hi(1,9,i,j,k)=h2*h0
        hi(2,9,i,j,k)=h1*h0
        hi(3,9,i,j,k)=0.d0
!
        hoi(7,i,j,k)=0.d0
        hoi(8,i,j,k)=1.0/(h3i*h1i)
        hoi(9,i,j,k)=1.0/(h1i*h2i)
        hii(7,i,j,k)=0.d0
        hii(8,i,j,k)=h3i*h0i
        hii(9,i,j,k)=h2i*h0i

        hoj(7,i,j,k)=1.0/(h2j*h3j)
        hoj(8,i,j,k)=0.d0
        hoj(9,i,j,k)=1.0/(h1j*h2j)
        hij(7,i,j,k)=h3j*h0j
        hij(8,i,j,k)=0.d0
        hij(9,i,j,k)=h1j*h0j

        hok(7,i,j,k)=1.0/(h2k*h3k)
        hok(8,i,j,k)=1.0/(h3k*h1k)
        hok(9,i,j,k)=0.d0
        hik(7,i,j,k)=h2k*h0k
        hik(8,i,j,k)=h1k*h0k
        hik(9,i,j,k)=0.d0

      enddo
    enddo
  enddo
!
  return
end subroutine calhoi
