!---------------------------------------------------------------------@
subroutine deriv(ww,ider,nm1,nm2,is1,ie1,js1,je1,ks1,ke1)
!---------------------------------------------------------------------@
  use pram, only : imax, jmax, kmax, nv
  implicit none

  integer :: i, j, k, m, is1, ie1, js1, je1, ks1, ke1
  integer :: nm1, nm2, ider, nm1a, merr

  real(8) :: ww(3,nv,is1:ie1,js1:je1,ks1:ke1)
  real(8), allocatable :: ww2(:,:,:,:,:), ww4(:,:,:,:,:)
!
  allocate( ww2(3,nv,is1:ie1,js1:je1,ks1:ke1), &
            ww4(3,nv,is1:ie1,js1:je1,ks1:ke1), &
            stat=merr)
!
!=====================================================================@
!
  if (ider .eq. 1) then
    nm2=nm1+1

    do k=ks1+nm2-1,ke1-nm2
      do j=js1+nm2-1,je1-nm2
        do i=is1+nm2-1,ie1-nm2
          do m=1,nv
 
             ww2(1,m,i,j,k)=ww(1,m,i-1,j,k)-2.0*ww(1,m,i,j,k)+ww(1,m,i+1,j,k)
             ww2(2,m,i,j,k)=ww(2,m,i,j-1,k)-2.0*ww(2,m,i,j,k)+ww(2,m,i,j+1,k)
             ww2(3,m,i,j,k)=ww(3,m,i,j,k-1)-2.0*ww(3,m,i,j,k)+ww(3,m,i,j,k+1)
 
          enddo
        enddo
      enddo
    enddo 
 
    do k=ks1+nm2-1,ke1-nm2
      do j=js1+nm2-1,je1-nm2
        do i=is1+nm2-1,ie1-nm2
          do m=1,nv
 
             ww(1,m,i,j,k)=ww(1,m,i,j,k)-(1.0/24.0)*ww2(1,m,i,j,k)
             ww(2,m,i,j,k)=ww(2,m,i,j,k)-(1.0/24.0)*ww2(2,m,i,j,k)
             ww(3,m,i,j,k)=ww(3,m,i,j,k)-(1.0/24.0)*ww2(3,m,i,j,k)
 
          enddo
        enddo
      enddo
    enddo
 
  elseif (ider .eq. 2) then
    nm1a=nm1+1
    nm2=nm1+2

    do k=ks1+nm1a-1,ke1-nm1a
      do j=js1+nm1a-1,je1-nm1a
        do i=is1+nm1a-1,ie1-nm1a
          do m=1,nv
 
            ww2(1,m,i,j,k)=ww(1,m,i-1,j,k)-2.0*ww(1,m,i,j,k)+ww(1,m,i+1,j,k)
            ww2(2,m,i,j,k)=ww(2,m,i,j-1,k)-2.0*ww(2,m,i,j,k)+ww(2,m,i,j+1,k)
            ww2(3,m,i,j,k)=ww(3,m,i,j,k-1)-2.0*ww(3,m,i,j,k)+ww(3,m,i,j,k+1)
 
          enddo
        enddo
      enddo
    enddo
        
    do k=ks1+nm2-1,ke1-nm2
      do j=js1+nm2-1,je1-nm2
        do i=is1+nm2-1,ie1-nm2
          do m=1,nv
            
            ww4(1,m,i,j,k)=ww2(1,m,i-1,j,k)-2.0*ww2(1,m,i,j,k)+ww2(1,m,i+1,j,k)
            ww4(2,m,i,j,k)=ww2(2,m,i,j-1,k)-2.0*ww2(2,m,i,j,k)+ww2(2,m,i,j+1,k)
            ww4(3,m,i,j,k)=ww2(3,m,i,j,k-1)-2.0*ww2(3,m,i,j,k)+ww2(3,m,i,j,k+1)
 
          enddo
        enddo
      enddo
    enddo

    do k=ks1+nm2-1,ke1-nm2
      do j=js1+nm2-1,je1-nm2
        do i=is1+nm2-1,ie1-nm2
          do m=1,nv
            
            ww(1,m,i,j,k)=ww(1,m,i,j,k)-(1.0/24.0)*ww2(1,m,i,j,k) &
                           +(3.0/640.0)*ww4(1,m,i,j,k)
            ww(2,m,i,j,k)=ww(2,m,i,j,k)-(1.0/24.0)*ww2(2,m,i,j,k) &
                           +(3.0/640.0)*ww4(2,m,i,j,k)
            ww(3,m,i,j,k)=ww(3,m,i,j,k)-(1.0/24.0)*ww2(3,m,i,j,k) &
                           +(3.0/640.0)*ww4(3,m,i,j,k)
     
          enddo
        enddo
      enddo
    enddo
      
  endif
!
  deallocate( ww2, ww4, stat=merr)
!     
  return
end subroutine deriv
!
