!----------------------------------------------------------------------
subroutine grid(x1,x2,x3,dx1,dx2,dx3,dx1a,dx2a,dx3a, &
                dx1b,dx2b,dx3b,x1a,x2a,x3a)
!----------------------------------------------------------------------
  use pram, only : imax, jmax, kmax, xmin, xmax, ymin, ymax, zmin, zmax
  implicit none
!
  integer :: i, j, k
!
  real(8) ::  x1(imax), x2(jmax), x3(kmax)
  real(8) :: x1a(imax), x2a(jmax), x3a(kmax)
  real(8) :: dx1(imax), dx2(jmax), dx3(kmax)
  real(8) :: dx1b(imax-1), dx2b(jmax-1), dx3b(kmax-1)
  real(8) :: dx1a, dx2a, dx3a
!
! x1-direction
!
  do  i=1,imax
     dx1(i)=(xmax-xmin)/float(imax-1)
     x1(i)=xmin+dx1(i)*float(i-1)
  enddo
  
  dx1a=dx1(2)

  do i=1,imax-1
    x1a(i)=(x1(i)+x1(i+1))/2.0
  enddo
  x1a(imax)=x1a(imax-1)+dx1(imax)

  do i=2,imax-1
    dx1b(i)=x1a(i)-x1a(i-1)
  enddo
  dx1b(1)=dx1b(2)
!
! x2-direction
!
  do j=1,jmax
    dx2(j)=(ymax-ymin)/float(jmax-1)
    x2(j)=ymin+dx2(j)*float(j-1)
  enddo
      
  dx2a=dx2(2)
 
  do j=1,jmax-1
    x2a(j)=(x2(j)+x2(j+1))/2.0
  enddo
  x2a(jmax)=x2a(jmax-1)+dx2(jmax)

  do j=2,jmax-1
    dx2b(j)=x2a(j)-x2a(j-1)
  enddo
  dx2b(1)=dx2b(2)
!
! x3-direction
!
  do k=1,kmax
    dx3(k)=(zmax-zmin)/float(kmax-1)
    x3(k)=zmin+dx3(k)*float(k-1)
  enddo

  dx3a=dx3(2)

  do k=1,kmax-1
    x3a(k)=(x3(k)+x3(k+1))/2.0
  enddo
  x3a(kmax)=x3a(kmax-1)+dx3(kmax)

  do k=2,kmax-1
    dx3b(k)=x3a(k)-x3a(k-1)
  enddo
  dx3b(1)=dx2b(2)
!
  return
end subroutine grid
