!--------------------------------------------------------------------
subroutine mdjetpro(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                    rj,vj,etaj,betaj,cmac,imagj,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 20; Jet Propagation Simulation Model
!         Initial Condition for Jet propagation simulation
!         made by Yosuke Mizuno 
!
  use pram, only : imax, jmax, kmax, metric, gam, c0, ieos, pi
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)

  real(8) :: rj, vj, etaj, betaj, cmac, rjx, rjz
  integer :: imagj
!           
  real(8) :: gf, deb, dej, pb, pj, rr, phi1, xx, zz, &
             bz, rm, bm, sigp, sigz, rmj, bmz, br, bphi1, bphi, rrm2, &  
             tmp1a, tmp1b, tmp1c, tmp2a, tmp2b, tmp3a, tmp1, tmp4, &
             tmp5a, tmp5b, tmp6a, pm, tmp6b, rrj, tmp6c, tmp6d 
  
!---------------------------------------------------------------------
!     Parameter
!      
  rj=1.d0
  vj=0.9d0
  etaj=1.d0
  betaj=0.01d0
  cmac=3.d0
  imagj=1

  rjx=1.d0
  rjz=1.d0

  gf=1.0/sqrt(1.0-vj**2)
      
  deb=1.d0
  dej=etaj*deb
      
  if(ieos .eq. 0) then
      
    pb=(dej*vj**2)/(gam*cmac**2 -gam*vj**2/(gam-1.0))
      
  elseif(ieos .eq. 1)  then
      
    tmp1a=(15.0-6.0*cmac**2/vj**2)
    tmp1b=(24.0-10.0*cmac**2/vj**2)
    tmp1c=9.d0
      
    tmp2a=(-tmp1b+sqrt(tmp1b**2-4.0*tmp1a*tmp1c))/2.0*tmp1a
    tmp2b=(-tmp1b-sqrt(tmp1b**2-4.0*tmp1a*tmp1c))/2.0*tmp1a
      
    if(tmp2a .le. 0.d0) then
      tmp3a=tmp2a
    elseif(tmp2b .le. 0.d0) then
      tmp3a=tmp2b
    else
      write(*,*) 'No solution in calculation of pressure'
    endif
       
    pb=(2.0*etaj/3.0)*sqrt(tmp3a**2/(1.0-tmp3a**2))
       
  endif    
!
!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        if(metric .eq. 1) then
          rr=sqrt(x1(i)**2+x2(j)**2)
          
          if(x1(i) .eq. 0.d0) then
            tmp1=0.d0
          else
           tmp1=abs(x1(i))/x2(j)
          endif
           
          if(x2(j) .ge. 0.d0) then
           
            if(x1(i) .ge. 0.d0) then
              phi1=atan(tmp1)
            else
              phi1=2.0*pi-abs(atan(tmp1))
            endif
          
          else
          
            if(x1(i) .ge. 0.d0) then
              phi1=pi-abs(atan(tmp1))
            else
              phi1=pi+abs(atan(tmp1))
            endif
          
          endif
          
!          rr=x1(i)
          xx=x1(i)
          zz=x3(k)
         
        elseif(metric .eq. 2) then
          rr=x1(i)
          xx=x1(i)*cos(x2(j))
          phi1=x2(j)
          zz=x3(k)
        elseif(metric .eq. 3) then
          rr=x1(i)*sin(x3(k))
          xx=x1(i)*sin(x3(k))*cos(x2(j))
          zz=x1(i)*cos(x3(k))
        endif
!
        if(rr .le. rj .and. zz .le. rjz) then      
          if(metric .eq. 1 .or. metric .eq. 2) then
            v1(i,j,k)=0.d0
            v2(i,j,k)=0.d0
            v3(i,j,k)=vj
          elseif(metric .eq. 3) then
            v1(i,j,k)=vj*cos(x3(k))
            v2(i,j,k)=0.d0
            v3(i,j,k)=-vj*sin(x3(k))
          endif
        else
          v1(i,j,k)=0.d0
          v2(i,j,k)=0.d0
          v3(i,j,k)=0.d0
        endif
!
!   Magnetic field
!
        if(imagj .eq. 1) then
!
!  Poloidal
!
          bz=sqrt(2.0*pb*betaj)
          pj=pb
         
          if(metric .eq. 1 .or. metric .eq. 2) then
            b1(i,j,k)=0.d0
            b2(i,j,k)=0.d0
            b3(i,j,k)=bz
          elseif(metric .eq. 3) then
            b1(i,j,k)=bz*cos(x3(k))
            b2(i,j,k)=0.d0
            b3(i,j,k)=-bz*sin(x3(k))
          endif
         
          if(rr .le. rj .and. zz .le. rjz) then
            de(i,j,k)=dej
            pr(i,j,k)=pj
          else
            de(i,j,k)=deb
            pr(i,j,k)=pb
          endif
!
        elseif(imagj .ge. 2 .and. imagj .le. 4) then
!
!   Toroidal
!
          if(imagj .eq. 2 .or. imagj .eq. 3) then
            rm=0.6*rj
            tmp4=betaj*(0.25-log(rm/rj))*rm**2
            bm=sqrt(pb*rj**2/tmp4)

!           bm=sqrt(2.0*pb*betaj)
    
          elseif(imagj .eq. 4) then
            rm=0.5*rj
            sigp=0.3d0
            sigz=0.7d0
           
            tmp4=(rm**2)*(2.0*sigp -1.+4.*log(rm/rj))
            bm=sqrt(-4.*pb*sigp/tmp4)
           
            rmj=rm/rj
           
            bmz=sqrt(sigz*((bm**2)*(rmj**2)+2.0*pb))
          endif
    
          if(rr .le. rj .and. zz .le. rjz) then
            br=0.d0
           
            if(imagj .eq. 2 .or. imagj .eq. 3) then
              bz=0.d0
            elseif(imagj .eq. 4) then
              bz=bmz
            endif
           
            if(rr .le. rm) then
              bphi1=bm*rr/rm
            elseif(rr .gt. rm) then
           
              if(imagj .eq. 2 .or. imagj .eq. 4) then
                bphi1=bm*rm/rr
              elseif(imagj .eq. 3) then
                bphi1=bm*(rj-rr)/(rj-rm)
              endif
           
            endif
          
            bphi=gf*bphi1

          else
            br=0.d0
            bphi=0.d0
           
            if(imagj .eq. 2 .or. imagj .eq. 3) then
              bz=0.d0
            elseif(imagj .eq. 4) then
              bz=bmz
            endif
           
          endif

          if(metric .eq. 1) then
            b1(i,j,k)=-bphi*cos(phi1)
            b2(i,j,k)=bphi*sin(phi1)
            b3(i,j,k)=bz
          elseif(metric .eq. 2) then
            b1(i,j,k)=br
            b2(i,j,k)=bphi
            b3(i,j,k)=bz
          elseif(metric .eq. 3) then
         
          endif
         
!          pb=0.5*betaj*bm**2
         
          if(rr .le. rj .and. zz .le. rjz) then
            de(i,j,k)=dej
           
            if(imagj .eq. 2 .or. imagj .eq. 3) then
              pr(i,j,k)=pb
           
            elseif(imagj .eq. 4) then
              rrm2=(rr/rm)**2
              if(rrm2 .le. 1.d0) then
                pr(i,j,k)=pb+(bm**2)*(1.0-rrm2)
              else
                pr(i,j,k)=pb
              endif
           
            endif
          
!            if(betaj .eq. 0.d0) then
!              pr(i,j,k)=pb
!            else
!            
!            rmj=rm/rj
!            
!            if(rr .le. rm) then
!            
!             if(imagj .eq. 2) then
!             
!              tmp5a=1.0-(1.0/betaj)*(rmj)**2
!              tmp5b=(2.0/betaj)*(1.0-(rr/rm)**2)
!              pr(i,j,k)=pb*(tmp5a+tmp5b)
!             
!             elseif(imagj .eq. 3) then
!             
!              tmp6a=(3.0*(1.0-rmj)-(1.0-rmj**2)+log(rmj))*0.5*bm**2
!              pm=pb-(2.0/(1.0-rmj)**2)*tmp6a
!              tmp6b=2.0*(1.0-(rr/rm)**2)*((bm**2)/(2.0*pb))
!              pr(i,j,k)=(tmp6b+(pm/pb))*pb
!             
!             endif
!             
!            elseif(rr .gt. rm) then
!            
!             if(imagj .eq. 2) then
!             
!              tmp5a=1.0-(1.0/betaj)*(rmj)**2
!              pr(i,j,k)=tmp5a*pb
!              
!             elseif(imagj .eq. 3) then
!              
!              rrj=rr/rj
!              tmp6c=(3.0*(1.0-rrj)-(1.0-rrj**2)+log(rrj))*((bm**2)/(2.0*pb))
!              tmp6d=1.0-2.0/(1.0-rmj)**2
!              pr(i,j,k)=tmp6d*tmp6c*pb
!             
!             endif
!             
!            endif
!           
!           endif
!           
          else
            de(i,j,k)=deb
            pr(i,j,k)=pb
          endif

        endif
!
      enddo
    enddo
  enddo
 
  return
end subroutine mdjetpro
!
!--------------------------------------------------------------------
subroutine mdprejet(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                    e0,rj,vj,vpre1,vplu1,opre1,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!     model = 21; Stability Analysis of Propagating relativistic 
!     Jet (relativistic version of Hardee et al. (2001))
!     written by Yosuke Mizuno 
!
  use pram, only : imax, jmax, kmax, gam, c0, ieos, pi
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)
!
  real(8) :: vj, rj, e0, vpre1, vplu1, opre1, b0, bj, bbg, pitch, &
             dj0, dj, db, gvj, vb, gvb, as, assq, ppj, ppb, bsq, em, &
             theta1, h1, geff, rr, phi1, rt1, br, bz, bphi, &
             vpre, opre, vplu, &
             tmp1a, tmp1b, tmp1c, tmp2a, tmp2b, tmp3a, tmp3b, tmp1
  real(8) :: ffjump

!--------------------------------------------------------------------
!
!    Parameter
!
  vj=0.9d0
  rj=1.d0
  e0=0.1d0
  vpre1=0.01d0
  vplu1=0.d0
  opre1=0.42d0
      
!  b0=0.25
!  b0=0.4
  b0=0.7d0
  bj=b0
  bbg=b0
      
  pitch=0.25d0
      
  dj0=1.d0
  dj=dj0/b0**2
!  dj=dj0
!  dj=dj0*(b0**2)

  db=dj
!  db=0.5*dj

  gvj=(1./sqrt(1.0-vj*vj))*vj
!  gvj=0.d0
  vb=0.d0
!  gvb=(1./sqrt(1.0-vb*vb))*vb
  gvb=0.d0

  as=0.1d0
  assq=as**2
      
  if(ieos .eq. 0) then
!    ppj=dj0*assq/(gam-(gam/(gam-1.0))*assq)
!    ppj=0.439840d0
    ppj=0.02d0

  elseif(ieos .eq. 1) then
       
    tmp1a=(15.0-6.0/assq)
    tmp1b=(24.0-10.0/assq)
    tmp1c=9.d0
      
    tmp2a=(-tmp1b+sqrt(tmp1b**2-4.0*tmp1a*tmp1c))/(2.0*tmp1a)
    tmp2b=(-tmp1b-sqrt(tmp1b**2-4.0*tmp1a*tmp1c))/(2.0*tmp1a)
      
    if(tmp2a .gt. 0.d0) then
      tmp3a=tmp2a
    elseif(tmp2b .gt. 0.d0) then
      tmp3a=tmp2b
    else
      write(*,*) 'No solution in calculation of pressure'
    endif
       
    ppj=(2.0*dj/3.0)*sqrt(tmp3a**2/(1.0-tmp3a**2))
       
    theta1=ppj/dj
    h1=5.0*theta1/2.0+sqrt((9.0*theta1**2/4.0)+1.0)
    geff=(h1-1.0)/(h1-1.0-theta1)
       
  endif

  ppb=ppj
!
!--------------------------------------------------------------------
!
!     Setup for pre-exisiting jets (not put in perturbation)
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
          
        rr=sqrt(x1(i)**2+x2(j)**2)
!        rr=sqrt(x1(i)**2)

        if(x1(i) .eq. 0.d0) then
          tmp1=0.0
        else
          tmp1=abs(x1(i))/x2(j)
        endif
           
        if(x2(j) .ge. 0.d0) then
           
          if(x1(i) .ge. 0.d0) then
            phi1=atan(tmp1)
          else
            phi1=2.0*pi-abs(atan(tmp1))
          endif
          
        else
          
          if(x1(i) .ge. 0.d0) then
            phi1=pi-abs(atan(tmp1))
          else
            phi1=pi+abs(atan(tmp1))
          endif
          
        endif
! ---
!  Initial Condition
! ---
!
        v1(i,j,k)=0.d0
        v2(i,j,k)=0.d0
        v3(i,j,k)=ffjump(rr,vj,vb,rj,0.05d0,0.05d0)
!        vg=ffjump(rr,gvj,gvb,rj,0.05d0,0.05d0)
!        v3(i,j,k)=vg/sqrt(1.0+vg**2.0)
!        v3(i,j,k)=vj
!

! parallel magnetic field
          
!        b1(i,j,k)=0.d0
!        b2(i,j,k)=0.d0
!y        b3(i,j,k)=ffjump(rr,bj,bbg,rj,0.3,0.3)
!        b3(i,j,k)=b0

! helical force-free magnetic field

        rt1=rr/pitch
        
        br=0.d0
        bphi=b0*rt1/(1.0+rt1**2)
        bz=b0/(1.0+rt1**2)
!
        b1(i,j,k)=-bphi*cos(phi1)
        b2(i,j,k)=bphi*sin(phi1)
        b3(i,j,k)=bz

        bsq=bphi**2+bz**2
          
!        de(i,j,k)=ffjump(rr,dj,db,rj,0.3,0.3)
!        de(i,j,k)=dj
        de(i,j,k)=dj*bsq
!        de(i,j,k)=dj/bsq

!!        pr(i,j,k)=ffjump(rr,ppj,ppb,rj,0.3,0.3)
        pr(i,j,k)=ppj

        em=0.5*(b1(i,j,k)*b1(i,j,k)+b2(i,j,k)*b2(i,j,k)+b3(i,j,k)*b3(i,j,k))
!
!        pr(i,j,k)=(gam-1.0)*e0-em

      enddo
    enddo
  enddo
!
!--------------------------------------------------------------------
!
!    Precession Prameter
!
!      vpre=vpre1*vj
!      opre=opre1*vj/rj
!
!    Plusing Parameter
!
!      vplu=vplu1*vj
!
  return
end subroutine mdprejet
!
!--------------------------------------------------------------------
subroutine mdkinkjet(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3,e0,rj,vj,nm1,&
                     is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!     model = 22; 3D kink instability 

  use pram, only : imax, jmax, kmax, metric, gam, c0
  implicit none

  integer :: i, j, k, nm1, nm1a, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)

  real(8) :: rj, vj, vb, e0, dj, db, gvj, gvb, bj, bbg, ppj, ppb, &
             hj1, hj2, vaj1, vaj2, vaj, omk1, &
             aa1, aa2, alp1, alp2, rr, phi1, zz, tmp1, tmp2a, tmp2, vro, &
             bjp, pch0, dd1, em  
!
!--------------------------------------------------------------------
!    Parameter
!
  nm1a=nm1+2
      
  rj=1.0d0
  vj=0.9d0
  e0=0.1d0

  dj=10.d0
  db=dj
!  db=0.5*dj
!  gvj=(1./sqrt(1.0-vj*vj))*vj
  gvj=0.d0
  vb=0.d0
!  gvb=(1./sqrt(1.0-vb*vb))*vb
  gvb=0.d0
  bj=1.825742d0
!  bj=4.53347d0
  bbg=bj
  ppj=0.d0
!  ppj=0.6243
  ppb=ppj
          
!  hj1=dj+(gam/(gam-1.0))*ppj
!  hj2=db+(gam/(gam-1.0))*ppb
  vaj1=bj/sqrt(dj+bj**2)
!  vaj2=bbg/sqrt(hj2+bbg**2)
!  vaj=0.5*(vaj1+vaj2)
  vaj=vaj1

!  omk1=3.0*(2.0*pi*vaj1/zmax)
  omk1=0.08*vaj
  aa1=1.d0
  aa2=2.5d0
  alp1=1.d0
  alp2=1.5d0
      
!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        if(metric .eq. 1) then
          rr=sqrt(x1(i)**2+x2(j)**2)
          phi1=atan(x2(j)/x1(i))
        elseif(metric .eq. 2) then
          rr=x1(i)
          phi1=x2(j)
        endif
        zz=x3(k)
!---
!    Rotation Prameter
!---
        tmp1=(1.0+(rr**2/aa1**2))**alp1
        tmp2a=rr**2/aa2**2
        if(tmp2a .gt. 1.d0) then
          tmp2a=1.d0
        endif
        tmp2=(1.0-tmp2a)**alp2
        vro=rr*omk1*tmp2/tmp1
!        vro=0.0
!---
!    Initial condition
!---
!!        de(i,j,k)=ffjump(rr,dj,db,rj,0.25,0.25)
        de(i,j,k)=dj
!
!         if(zz .le. 0.5d0) then
        if(k .le. nm1a) then
          if(metric .eq. 1) then
            v1(i,j,k)=-vro*sin(phi1)
            v2(i,j,k)=vro*cos(phi1)
          elseif(metric .eq. 2) then
            v1(i,j,k)=0.d0
            v2(i,j,k)=vro
          endif
!        elseif(k .ge. kmax-nm1a) then
!          if(metric .eq. 1) then
!            v1(i,j,k)=vro*sin(phi1)
!            v2(i,j,k)=-vro*cos(phi1)
!          elseif(metric .eq. 2) then
!            v1(i,j,k)=0.d0
!            v2(i,j,k)=-vro
!          endif
        else
          v1(i,j,k)=0.d0
          v2(i,j,k)=0.d0
        endif
!        vg=ffjump(rr,gvj,gvb,rj,0.25d0,0.25d0)
!        v3(i,j,k)=vg/sqrt(1.0+vg**2.0)
        v3(i,j,k)=0.d0
!---
!    Uniform magnetic field
!---
        b1(i,j,k)=0.d0
        b2(i,j,k)=0.d0
!!        b3(i,j,k)=ffjump(rr,bj,bbg,rj,0.2,0.2)
        b3(i,j,k)=bj
!---
!    Helical magnetic field (Appl et al. 2000) 
!     in cylindrical coordinate
!---
!!        bjp=bj
!!        pch0=1.d0/3.d0
!!        b1(i,j,k)=0.d0
!!        b2(i,j,k)=(bjp*rr/pch0)/(1.0+rr**2/pch0**2)
!!        b3(i,j,k)=bjp/(1.0+rr**2/pch0**2)
!---
!   Helical magnetic field (Todo et al. 1992)
!    in cylindrical coordinate
!---
!!        bjp=1.d0
!!        aa1=0.99d0
!!        dd1=1.d0
!!        pch0=1.d0/3.d0
!!        b1(i,j,k)=0.d0
!!        b2(i,j,k)=bjp*sqrt((0.5*aa1*dd1*rr**2)/(rr+0.5*dd1)**3)
!!        b3(i,j,k)=bjp*sqrt(1.0-((aa1*(rr+dd1)*rr**2)) &
!!                          /(rr+0.5*dd1)**3)
!---
          
!!        pr(i,j,k)=ffjump(rr,ppj,ppb,rj,0.2d0,0.2d0)
        pr(i,j,k)=0.d0

!        em=0.5*(b1(i,j,k)*b1(i,j,k)+b2(i,j,k)*b2(i,j,k)+b3(i,j,k)*b3(i,j,k))
!
!        pr(i,j,k)=(gam-1.0)*e0-em
!
      enddo
    enddo
  enddo

  return
end subroutine mdkinkjet
!
!--------------------------------------------------------------------
subroutine mdkinkjet2(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3,e0,rj,vj,&
                      is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!     model = 24; 3D kink instability in Periodic box

  use pram, only : imax, jmax, kmax, metric, gam, c0, pi, zmax, iseed
 
 implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)

  real(8) :: vj, rj, e0, ra, ra1, deltav, a1, b0, pitch, b0a, pcnst, &
             rb1, dj, dj0, db, gvj, vb, gvb, rr, phi1, zz, em, &
             rt1, br, bphi, bz, bext, bsq, rt1a, bphia, bza, bsqa, emp, &
             rt2, alp1, rt2a, vr, rand1, prtb1a, prtb1b, prtb2a, prtb2b, &
             prtb, prtb1, vg, tmp1, tmp1a
  integer :: mmode, nmode, nmode2
  real(8) :: ffjump
!
!--------------------------------------------------------------------
!    Parameter
!

!  vj=0.3d0
!  rj=0.25d0
  vj=0.d0
  rj=0.d0
  e0=0.1d0

  ra=0.5d0
!  ra1=1.d0
  ra1=rj
!  deltav=0.1d0
  deltav=0.01d0
!  deltav=0.0d0
  a1=0.2d0
  mmode=1
  nmode=1
  nmode2=2
!  nmode=2

!  call srand(iseed)

!  b0=0.15
  b0=0.4d0
!  b0=0.6

  pitch=0.25d0
!  pitch=0.5

!  b0a=b0*ra/pitch

!  pcnst=0.5
  pcnst=0.02d0
      
!  rb1=1.5*pitch
  rb1=0.3d0

!  dj=10.0

  dj0=1.d0
  dj=dj0/b0**2

  db=dj
  gvj=(1./sqrt(1.0-vj*vj))*vj
!  gvj=0.d0
  vb=0.d0
!  gvb=(1./sqrt(1.0-vb*vb))*vb
  gvb=0.d0
      
!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        if(metric .eq. 1) then
          
          rr=sqrt(x1(i)**2+x2(j)**2)
          
          if(x1(i) .eq. 0.d0) then
            tmp1=0.d0
          else
            tmp1=abs(x1(i))/x2(j)
          endif
           
          if(x2(j) .ge. 0.d0) then
           
            if(x1(i) .ge. 0.d0) then
              phi1=atan(tmp1)
            else
              phi1=2.0*pi-abs(atan(tmp1))
            endif
          
          else
          
            if(x1(i) .ge. 0.d0) then
              phi1=pi-abs(atan(tmp1))
            else
              phi1=pi+abs(atan(tmp1))
            endif
          
          endif
          
        elseif(metric .eq. 2) then
          rr=x1(i)
          phi1=x2(j)
          
        endif
        zz=x3(k)

!---
!    Initial condition
!---
!---
!    Uniform magnetic field
!---
!        b1(i,j,k)=0.d0
!        b2(i,j,k)=0.d0
!        b3(i,j,k)=b0
!         
!        em=0.5*(br**2+bphi**2+bz**2)
!         
!        pr(i,j,k)=pcnst-em
!
!---
!    Helical magnetic field 
!     in cylindrical coordinate
!---
!        b0a=ffjump(rr,b0,0.d0,2.d0,0.2d0,0.2d0)
        
!
! Baty & Keppens
!
!        rt1=rr/ra
!        br=0.0
!        bphi=b0a*rt1/(1.0+rt1**2)
!        bphi=b0
!        bz=b0
!        bz=b0/(1.0+rt1**2)
        
!        bext=0.5*b0a**2/(1.0+rt1**2)
!
! Baty (Constant Pitch)
!
        rt1=rr/pitch
!        
        br=0.d0
!        
!        if(rr .le. rb1) then
        bphi=b0*rt1/(1.0+rt1**2)
        bz=b0/(1.0+rt1**2)
!        else
!          bphi=0.d0
!          bz=0.d0
!        endif
!        
        bsq=bphi*bphi+bz*bz
!        em=0.5*(br**2+bphi**2+bz**2)
!        
!        rt1a=rb1/pitch
!        bphia=b0*rt1a/(1.0+rt1a**2)
!        bza=b0/(1.0+rt1a**2)
!        bsqa=bphia*bphia+bza*bza
!        emp=0.5*bsqa
!
! Yuri
!
!!        rt1=rr/pitch
!!        rt2=1.0+rt1**2
!!        alp1=0.75d0
!         
!!        br=0.d0
!!        bz=b0/rt2**alp1
!         
!         if(alp1 .eq. 0.5d0) then
!          
!           if(rt1 .eq. 0.d0) then
!             bphi=0.d0
!           else
!            tmp1=log(rt2)-(rt1**2)/rt2
!            bphi=b0*sqrt(tmp1)/rt1
!           endif
!          
!         else
!
!!          if(rt1 .eq. 0.d0) then
!!            bphi=0.d0
!             bz=b0/rt2**alp1
!           elseif(rr .le. rb1) then
!!          else
!!            alp2=2.0*alp1
!!            tmp1=((rt2**alp2)-1.0-alp2*rt1**2)/(alp2-1.0)
!!            bphi=b0*sqrt(tmp1)/(rt1*rt2**alp1)
!            bz=b0/rt2**alp1
!          else
!            bphi=0.0
!            bz=0.0
!!         endif
!
!          rt1a=rb1/pitch
!          rt2a=1.0+rt1**2
!          tmp1a=((rt2a**alp2)-1.0-alp2*rt1a**2)/(alp2-1.0)
!          bphia=b0*sqrt(tmp1a)/(rt1a*rt2a**alp1)
!          bza=b0/rt2a**alp1
!          bsqa=bphia*bphia+bza*bza
!          emp=0.5*bsqa
!          
!         endif
!         
!         bsq=bphi*bphi+bz*bz
!        
        if(metric .eq. 1) then
         
          b1(i,j,k)=-bphi*cos(phi1)
          b2(i,j,k)=bphi*sin(phi1)
          b3(i,j,k)=bz
         
          em=0.5*(br**2+bphi**2+bz**2)

!          pr(i,j,k)=pcnst-em+bext
!         
!          if(rr .le. rb1) then
          pr(i,j,k)=pcnst
!          else
!            pr(i,j,k)=emp
!          endif
         
        elseif(metric .eq. 2) then
          b1(i,j,k)=br
          b2(i,j,k)=bphi
          b3(i,j,k)=bz
        
          em=0.5*(br**2+bphi**2+bz**2)

          pr(i,j,k)=pcnst
        endif
!---

!        de(i,j,k)=ffjump(rr,dj,db,ra1,0.2,0.2)
!          
!        if(rr .le. rb1) then
        de(i,j,k)=dj*bsq
!        de(i,j,k)=dj/bsq
!        else
!          de(i,j,k)=dj*bsqa
!        endif
          
!        de(i,j,k)=dj
         
!        vr=0.d0
!        rand1=2.0*rand(iseed)-1.0
        prtb1a=cos(float(mmode)*phi1)
        prtb1b=sin(2.0*pi*float(nmode)*zz/zmax)
        prtb1=prtb1a*prtb1b

!        prtb2a=cos(float(mmode)*phi1)
!        prtb2b=sin(2.0*pi*float(nmode2)*zz/zmax)
!        prtb2=prtb2a*prtb2b

        prtb=prtb1
!        prtb=0.5*(prtb1+prtb2)
         
!        tmp1=exp(-((abs(rr)-ra1)/ra)**2)
        tmp1=exp(-(abs(rr)/ra))
!        vr=deltav*tmp1*rand1
        vr=deltav*tmp1*prtb

!        if( rr .lt. ra1 ) then
!          vr=deltav*rand1
!          vr=deltav*prtb1
!        else
!          vr=0.d0
!        endif
         
        if(abs(vr) .lt. 1.0d-6) then
          vr=0.d0
        endif
         
!        if(rr .gt. rb1) then
!          vr=0.0
!        endif
         
        if(metric .eq. 1) then
!          if(x2(j) .ge. 0.d0) then
!            v1(i,j,k)=vr*sin(phi1)
!            v2(i,j,k)=vr*cos(phi1)

          v1(i,j,k)=vr*cos(phi1)
          v2(i,j,k)=vr*sin(phi1)

!        else
!          v1(i,j,k)=-vr*sin(phi1)
!          v2(i,j,k)=-vr*cos(phi1)
!        endif

        elseif(metric .eq. 2) then
          v1(i,j,k)=vr
          v2(i,j,k)=0.d0
        endif
         
!        vg=ffjump(rr,gvj,gvb,ra1,0.2d0,0.2d0)
!        v3(i,j,k)=vg/sqrt(1.0+vg**2.0)
        v3(i,j,k)=0.0

      enddo
    enddo
  enddo

  return
end subroutine mdkinkjet2
!
!--------------------------------------------------------------------
subroutine mdkinkjet3(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                      is1,ie1,js1,je1,ks1,ke1,npe,myrank)
!--------------------------------------------------------------------
!     model = 25; 3D kink instability of hot static plasma
!                 in Periodic box

  use pram, only : imax, jmax, kmax, metric, gam, c0, pi, zmax, &
                   iseed, iter 
  implicit none
  include 'mpif.h' ! for MPI

  integer :: i, j, k, nnn, nkmax, n, m
  integer :: is1, ie1, js1, je1, ks1, ke1
  integer :: myrank, npe, merr 

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)
  real(8) :: phik1(kmax), ampxk(kmax), ampyk(kmax)

  real(8) :: deltav, d0, p0, ra, ra1, ra2, rb1, rb2, vb, gvb, alpha1, &
             dx, dxend, rr, phi1, zz, tmp1, eta1, eta2, df, f, &
             xx_old, del1, pr1, pr2, br, btmp, bphi, bphi1, bphi2, &
             bz, bz1, bz2, dz, dvx1, dvy1, ampx1, ampy1, dvx2, dvy2, &
             tempz, tempp
  real(8) :: ran1,tmp2
!
!--------------------------------------------------------------------
!    Parameter
!
!  deltav=0.1d0
  deltav=0.01d0
!  deltav=0.d0

  d0=0.01d0
  p0=0.1d0
  ra=1.d0
  ra1=0.5d0
  ra2=1.d0
!  rb1=0.1d0
!  rb1=0.01d0
  rb1=0.d0
  rb2=0.1d0
      
  vb=0.d0
  gvb=0.d0
      
!  alpha1=1.0d-4
  alpha1=0.d0
!
  dx=1.d0
  dxend=0.0001d0
!
!====================================================================@
!   Initial Condition
!====================================================================@
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        
        if(metric .eq. 1) then
          rr=sqrt(x1(i)**2+x2(j)**2)          
         
          if(x1(i) .eq. 0.d0) then
            tmp1=0.d0
          else
            tmp1=abs(x1(i))/x2(j)
          endif
           
          if(x2(j) .ge. 0.d0) then
            if(x1(i) .ge. 0.d0) then
              phi1=atan(tmp1)
            else
              phi1=2.0*pi-abs(atan(tmp1))
            endif
          else
            if(x1(i) .ge. 0.d0) then
              phi1=pi-abs(atan(tmp1))
            else
              phi1=pi+abs(atan(tmp1))
            endif
          endif
          
        elseif(metric .eq. 2) then
          rr=x1(i)
          phi1=x2(j)
        endif
        zz=x3(k)
!
!----------------------------------------------------------------------@
!     Calculation of eta by Newton-Raphson
!----------------------------------------------------------------------@

! ---- initialization ----
         
        eta1=2.25d0
        eta2=2.25d0
         
        df=1.d0
        f=1.d0
! ----   
        if(rr .le. ra) then
          f=eta1**3.0-eta1**2.0-(9./4.)*eta1*rr**2.0-(81./64.)*rr**4.0
          df=3.*eta1**2.0-2.*eta1-(9./4.)*rr**2.0
         
          dx=f/df

          do nnn=1, iter
                     
            if(abs(dx) .gt. dxend) then

             xx_old=eta1
             eta1=eta1-dx             

             f=eta1**3.0-eta1**2.0-(9./4.)*eta1*rr**2.0-(81./64.)*rr**4.0
             df=3.*eta1**2.0-2.*eta1-(9./4.)*rr**2.0
         
             dx=f/df             
            endif

          enddo
          
          eta1=eta1-dx

          if(abs(dx) .gt. dxend) then
           write(6,*) ' >> Not convergence in kinkjet3 at i:',i
           write(6,*) ' >> dx, iter =', dx, nnn,', at x1:',x1(i)
          endif
                   
        else
         
          eta1=2.25
        endif
         
! ---- Calculation of pressure and magnetic field

        if(rr .le. ra) then
          pr(i,j,k)=p0/(eta1**2.0)
        elseif(rr .gt. ra .and. rr .le. ra+rb1) then
          del1=(rr-1.0)/rb1
          pr(i,j,k)=(p0/(eta2**2))*(1.+(9.*del1**2)/(2.*eta2) &
                   -(9.*del1**3)/(4.*eta2))
        else
          pr(i,j,k)=(p0/(eta2**2.0))+(9.*p0/(4.*eta2**3.0))
        endif
         
!        pr1=p0/(eta1**2.0)
!        pr2=(p0/(eta2**2.0))+(9.*p0/(4.*eta2**3.0))
!        pr(i,j,k)=ffjump(rr,pr1,pr2,ra,rb1,rb1)

        br=0.d0
         
        if(rr .le. ra) then
          bphi=sqrt((18.*p0*rr**2.0)/(4.*eta1**3.0))
        elseif(rr .gt. ra .and. rr .le. ra+rb1) then
          del1=(rr-1.0)/rb1
          btmp=((18.*p0)/(4.*eta2**3))*(1.-2*del1**2+del1**3)
          bphi=sqrt(btmp)
        else
          bphi=0.d0
        endif
         
!        bphi1=sqrt((18.*p0*rr**2.0)/(4.*eta1**3.0))
!        bphi2=0.0
!        bphi=ffjump(rr,bphi1,bphi2,ra,rb1,rb1)
         
!        bz1=0.0
!        bz2=sqrt(2.0*alpha1*p0)         
!        bz=ffjump(rr,bz1,bz2,ra,rb1,rb1)
         
        bz=0.d0
         
        de(i,j,k)=d0
         
        if(metric .eq. 1) then
          b1(i,j,k)=-bphi*cos(phi1)
          b2(i,j,k)=bphi*sin(phi1)
          b3(i,j,k)=bz
          
        elseif(metric .eq. 2) then
          b1(i,j,k)=br
          b2(i,j,k)=bphi
          b3(i,j,k)=bz
        endif

        v1(i,j,k)=0.d0
        v2(i,j,k)=0.d0
        v3(i,j,k)=0.d0
      enddo
    enddo
  enddo

! --- Calculation of velocity perturbation

  dz=zmax/float(kmax)
  nkmax=int(zmax/(10.0*dz))

  nkmax=2

  if(myrank .eq. 1) then    
    write(*,*) 'dz, nkmax', dz, nkmax
  endif
 
  if(myrank .eq. 1) then     
    do n=1, nkmax
!!     phik1(n)=2.0*pi*ran1(iseed+n)
!     phik1(n)=0.0
!
!     ampxk(n)=1.0-2.0*ran1(iseed+n)

       call random_number(tmp2)    
       ampxk(n)=1.0-2.0*tmp2
       ampyk(n)=sqrt(1.0-ampxk(n)**2)
    enddo
  endif
  call mpi_barrier(mpi_comm_world,merr)
  call mpi_bcast(ampxk,nkmax,mpi_double_precision,0,mpi_comm_world,merr)
  call mpi_bcast(ampyk,nkmax,mpi_double_precision,0,mpi_comm_world,merr)
        
!  ampxk(1)=1.d0
!  ampyk(1)=0.d0
!          
!  ampxk(2)=0.d0
!  ampyk(2)=1.d0
      
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
         
        if(metric .eq. 1) then
          rr=sqrt(x1(i)**2+x2(j)**2)          
         
          if(x1(i) .eq. 0.d0) then
            tmp1=0.d0
          else
            tmp1=abs(x1(i))/x2(j)
          endif
           
          if(x2(j) .ge. 0.d0) then
            if(x1(i) .ge. 0.d0) then
              phi1=atan(tmp1)
            else
              phi1=2.0*pi-abs(atan(tmp1))
            endif
          else
            if(x1(i) .ge. 0.d0) then
              phi1=pi-abs(atan(tmp1))
            else
              phi1=pi+abs(atan(tmp1))
            endif
          endif
          
        elseif(metric .eq. 2) then
          rr=x1(i)
          phi1=x2(j)
        endif
        zz=x3(k)
!         
        dvx1=0.d0
        dvy1=0.d0
          
        do n=1,nkmax
          
          ampx1=ampxk(n)/float(nkmax)
          ampy1=ampyk(n)/float(nkmax)
           
          dvx1=dvx1+ampx1*sin((2.0*pi*float(n)*x3(k)/zmax)+phik1(n))
          dvy1=dvy1+ampy1*sin((2.0*pi*float(n)*x3(k)/zmax)+phik1(n))           

        enddo

! n=1 mode
!        dvx1=ampxk(1)*sin((2.0*pi*x3(k)/zmax))
!        dvy1=ampyk(1)*sin((2.0*pi*x3(k)/zmax))
! n=2 mode
!        dvx2=ampxk(2)*sin((2.0*pi*float(2)*x3(k)/zmax))
!        dvy2=ampyk(2)*sin((2.0*pi*float(2)*x3(k)/zmax))         
!
!        do n=0, nkmax
!          do m=0, 2
!           
!            phik=2.0*pi*ran1(iseed)
!           
!            ampx1=1.0/3.0*float(nkmax)
!            ampy1=1.0/3.0*float(nkmax)
!           
!            tempz=(2.0*pi*float(n)*zz/zmax)
!            tempp=float(m)*phi1
!            dvx1=dvx1+ampx1*cos(tempp)*sin(tempz+phik)*cos(phi1)
!            dvy1=dvy1+ampy1*cos(tempp)*sin(tempz+phik)*sin(phi1)
!          
!          enddo
!        enddo

        tmp1=exp(-(abs(rr)/ra1))
!        tmp1=exp(-((abs(rr)-ra2)/ra1)**2)

        if(metric .eq. 1) then
          v1(i,j,k)=deltav*tmp1*dvx1
          v2(i,j,k)=deltav*tmp1*dvy1
        elseif(metric .eq. 2) then
          v1(i,j,k)=deltav*tmp1*(dvx1*cos(phi1)+dvy1*sin(phi1))
          v2(i,j,k)=deltav*tmp1*(-dvx1*sin(phi1)+dvy1*cos(phi1))
        endif

!        v1(i,j,k)=ffjump(rr,deltav*dvx1,0.d0,ra,rb2,rb2)
!        v2(i,j,k)=0.d0
        
        if(rr .gt. 1.d0) then
          v1(i,j,k)=0.d0
          v2(i,j,k)=0.d0
        endif
        
      enddo
    enddo
  enddo
 
  return
end subroutine mdkinkjet3
!
!--------------------------------------------------------------------
subroutine mdkinkjet4(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                      is1,ie1,js1,je1,ks1,ke1,npe,myrank)
!--------------------------------------------------------------------
!     model = 28; 3D kink instability with jet in Periodic box

  use pram, only : imax, jmax, kmax, metric, gam, c0, pi, zmax
  implicit none
  include 'mpif.h' ! for MPI

  integer :: i, j, k, n, is1, ie1, js1, je1, ks1, ke1
  integer :: myrank, npe, merr 

  integer, parameter :: nkmax=8

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)
  real(8) :: phik1(nkmax)

  real(8) :: deltav, a1, b0, ra, r0, omg0, dj0, dj1, pcnst, &
             rr, phi1, zz, tmp1, em, b0a, rt1, rt2, rt3, rt4, br, bz, & 
             omg, bphi, bext, bsq, alp1, alp2, bet1, tmp2, &
             vr, vphi, vz, rand1, prtb1a, prtb1b, prtb, prtb1, rp, rt3a 
  integer :: mmode, nmode, nmode2
  real(8) :: ran1, ran0, ran2, tmp3
!
!--------------------------------------------------------------------
!    Parameter
!
!  deltav=0.1d0
  deltav=0.01d0
!  deltav=0.d0
  a1=0.2d0

  mmode=1
  nmode=1
  nmode2=2
!  nmode=2

  b0=0.8d0
!  b0=2.d0
  ra=0.25d0
  r0=0.25d0
  rp=0.5d0
!  omg0=1.d0
  omg0=4.d0

!  b0a=b0*ra/pitch

!  dj0=1.d0
  dj0=1.1d0
  dj1=dj0/b0**2

!  pcnst=0.1*dj0
  pcnst=0.02d0

  if(myrank .eq. 0) then
    do n=1, nkmax
!      call random_number(tmp3) 
!      phik1(n)=2.0*pi*tmp3
!      phik1(n)=2.0*pi*ran2(iseed+n)
      phik1(n)=0.d0      
    enddo
  endif
  call mpi_barrier(mpi_comm_world,merr)
  call mpi_bcast(phik1,nkmax,mpi_double_precision,0,mpi_comm_world,merr) 
!
!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        if(metric .eq. 1) then
          
          rr=sqrt(x1(i)**2+x2(j)**2)
          
          if(x1(i) .eq. 0.d0) then
            tmp1=0.d0
          else
            tmp1=abs(x1(i))/x2(j)
          endif
           
          if(x2(j) .ge. 0.d0) then
           
            if(x1(i) .ge. 0.d0) then
              phi1=atan(tmp1)
            else
              phi1=2.0*pi-abs(atan(tmp1))
            endif
          
          else
          
            if(x1(i) .ge. 0.d0) then
              phi1=pi-abs(atan(tmp1))
            else
              phi1=pi+abs(atan(tmp1))
            endif
          
          endif
          
        elseif(metric .eq. 2) then
          rr=x1(i)
          phi1=x2(j)
          
        endif
        zz=x3(k)

!---
!    Initial condition
!---
!---
!    Uniform magnetic field
!---
!        b1(i,j,k)=0.d0
!        b2(i,j,k)=0.d0
!        b3(i,j,k)=b0
!         
!        em=0.5*(br**2+bphi**2+bz**2)
!         
!        pr(i,j,k)=pcnst-em
!
!---
!    Helical magnetic field 
!     in cylindrical coordinate
!---
!        b0a=ffjump(rr,b0,0.d0,2.d0,0.2d0,0.2d0)
        
!
! Baty & Keppens
!
!        rt1=rr/ra
!        br=0.d0
!        bphi=b0a*rt1/(1.0+rt1**2)
!        bphi=b0
!        bz=b0
!        bz=b0/(1.0+rt1**2)
        
!        bext=0.5*b0a**2/(1.0+rt1**2)
!
! Constant Pitch
!
        rt1=rr/ra
        rt3=rr/r0
!        
        br=0.d0
        bz=b0/(1.0+rt1**2)
!        omg=omg0/(1.0+rt3**2)
!        
        if(rr .le. r0) then
         omg=omg0
        else 
         omg=omg0/rt3
        endif
! 
        bphi=-(b0*rt1/(1.0+rt1**2))*sqrt(1.0+(omg*ra)**2)
!        
        bsq=bphi*bphi+bz*bz
!
! Increase/Decrease Pitch
!
!        rt1=rr/ra
!        rt2=1.0+rt1**2
!        alp1=0.35000d0
!         
!        rt3=rr/r0
!!         rt4=1.0+rt3**2
!        rt4=r0/rr
!        bet1=1.d0        
!!         
!        br=0.d0
!        bz=b0/(rt2**alp1)
!        if(rr .le. r0) then
!          omg=omg0
!        else
!          omg=omg0*(rt4**bet1)
!        endif
!!
!        if(rt1 .eq. 0.d0) then
!          bphi=0.d0
!        else
!          alp2=2.0*alp1
!          tmp1=((rt2**alp2)-1.0-alp2*rt1**2)/(alp2-1.0)
!          tmp2=(omg*rr*rt1)**2
!          bphi=-b0*sqrt(tmp1+tmp2)/(rt1*(rt2**alp1))
!        endif
!!         
!        bsq=bphi*bphi+bz*bz
!
        if(metric .eq. 1) then
          b1(i,j,k)=bphi*cos(phi1)
          b2(i,j,k)=-bphi*sin(phi1)
          b3(i,j,k)=bz         
          em=0.5*(br**2+bphi**2+bz**2)
        elseif(metric .eq. 2) then
          b1(i,j,k)=br
          b2(i,j,k)=bphi
          b3(i,j,k)=bz        
          em=0.5*(br**2+bphi**2+bz**2)
        endif     
!
!---
!  Pressure profile
!
!        pr(i,j,k)=pcnst-em+bext
!        pr(i,j,k)=pcnst-em
!        pr(i,j,k)=pcnst
        rt3a=rr/rp
        if(rr .le. rp) then
         pr(i,j,k)=pcnst
        else 
         pr(i,j,k)=pcnst/rt3a
        endif
!
!---
!  Density profile
!          
!        de(i,j,k)=dj0 
        de(i,j,k)=dj1*bsq
!        de(i,j,k)=dj1/bsq                   
!
!---
!  Velocity profile 
!
        vr=0.d0
        vphi=omg*rr*(1.0-(bphi**2)/bsq)
        vz=-(bphi*bz/bsq)*(omg*rr)
!---
!   Velocity Perturbation
! 
!         tmp1=exp(-((abs(rr)-ra1)/ra)**2)
        tmp1=exp(-(abs(rr)/ra))
        
        do n=1, nkmax

!          rand1=2.0*rand(iseed)-1.0
          prtb1a=cos(float(mmode)*phi1)
          prtb1b=sin((2.0*pi*0.5*float(n)*zz/zmax)+phik1(n))
          prtb1=prtb1a*prtb1b

          prtb=prtb1/float(nkmax)
!          prtb=0.5*(prtb1+prtb2)
         
!          vr=deltav*tmp1*rand1
          vr=vr+deltav*tmp1*prtb

!          if( rr .lt. ra1 ) then
!            vr=deltav*rand1
!            vr=deltav*prtb1
!          else
!            vr=0.0
!          endif
        enddo
         
        if(abs(vr) .lt. 1.0d-6) then
          vr=0.d0
        endif
         
        if(metric .eq. 1) then
!         if(x2(j) .ge. 0.0) then
!           v1(i,j,k)=vr*sin(phi1)
!           v2(i,j,k)=vr*cos(phi1)
! or 
!           v1(i,j,k)=vr*cos(phi1)
!           v2(i,j,k)=vr*sin(phi1)
! 
!          v1(i,j,k)=vr*sin(phi1)-vphi*cos(phi1)
!          v2(i,j,k)=vr*cos(phi1)+vphi*sin(phi1)
          v1(i,j,k)=vr*cos(phi1)-vphi*cos(phi1)
          v2(i,j,k)=vr*sin(phi1)+vphi*sin(phi1)
          v3(i,j,k)=vz
          
!         else
!           v1(i,j,k)=-vr*sin(phi1)
!           v2(i,j,k)=-vr*cos(phi1)
!         endif
           
        elseif(metric .eq. 2) then
          v1(i,j,k)=vr
          v2(i,j,k)=vphi
          v3(i,j,k)=vz
        endif
!
!        if(k .eq. 20) then
!          write(*,*) 'i,j,ro=',i,j,de(i,j,k)         
!        endif
      enddo
    enddo
  enddo

  return
end subroutine mdkinkjet4
!
!--------------------------------------------------------------------
subroutine md2dblast(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                     is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 23; 2D Blast Wave Test
  use pram, only : imax, jmax, kmax,  gam, c0
  implicit none

  integer :: i, j, k, is1 ,ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)

  real(8) :: rex, de1, de2, pr1, pr2, b0, rr
  real(8) :: ffjump

!--------------------------------------------------------------------
!  Parameter
!
  rex=0.8d0
  de1=0.01d0 
  de2=1.0d-4
  pr1=1.0d0
  pr2=5.0d-4
  b0=0.1d0
  
!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
          
        rr=sqrt(x1(i)**2+x3(k)**2)
          
        de(i,j,k)=ffjump(rr,de1,de2,rex,0.2d0,0.2d0)
        pr(i,j,k)=ffjump(rr,pr1,pr2,rex,0.2d0,0.2d0)
        v1(i,j,k)=0.d0
        v2(i,j,k)=0.d0
        v3(i,j,k)=0.d0
        b1(i,j,k)=b0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0

     enddo
    enddo
  enddo

  return
end subroutine md2dblast
!
!--------------------------------------------------------------------
subroutine md2dmagadv(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                      is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 26; 2D Magnetic Loop Advection Test
  use pram, only : imax, jmax, kmax, gam, c0, xmax
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: merr

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pom2(imax,jmax,kmax), &
             b1a(imax,jmax,kmax), b2a(imax,jmax,kmax), b3a(imax,jmax,kmax)
  real(8) :: x1(imax), x2(jmax), x3(kmax) 
!
  real(8) :: xmax1, a0, r0, r1, a2, a1, rr
!
!--------------------------------------------------------------------
!  Parameter
!
  xmax1=0.3d0
  a0=1.0d-3
  r0=0.3*xmax1
  r1=0.2*r0
  a2=-0.5*a0/r1
  a1=a0*(r0-r1)-a2*r1**2

!--------------------------------------------------------------------

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
          
        rr=sqrt(x1(i)**2+x3(k)**2)
          
        de(i,j,k)=1.d0
        pr(i,j,k)=0.37272727d0
        v1(i,j,k)=2.0*xmax1
        v2(i,j,k)=0.d0
        v3(i,j,k)=xmax1
          
        b1(i,j,k)=0.d0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0
          
      enddo
    enddo
  enddo

  do k=1,kmax
    do j=1,jmax
      do i=1,imax
        rr=sqrt(x1(i)**2+x3(k)**2)
!          
!        if(rr .le. r0) then
!          pom2(i,j,k)=a0*(r0-rr)
!        else
!          pom2(i,j,k)=0.d0
!        endif
!
        if(rr .ge. 0.d0 .and. rr .le. r1) then
          pom2(i,j,k)=a1+a2*rr**2
        elseif(rr .gt. r1 .and. rr .le. r0) then
          pom2(i,j,k)=a0*(r0-rr)
        else
          pom2(i,j,k)=0.d0
        endif
      enddo
    enddo
  enddo
         
  do k=2,kmax-1
    do j=1,jmax
      do i=2,imax-1
          
        b1a(i,j,k)=-(pom2(i,j,k-1)-pom2(i,j,k+1))/(x3(k-1)-x3(k+1))
        b2a(i,j,k)=0.d0
        b3a(i,j,k)=(pom2(i-1,j,k)-pom2(i+1,j,k))/(x1(i-1)-x1(i+1))
 
      enddo
    enddo
  enddo         
        
  do k=1,kmax
    do j=1,jmax
          
      b1a(1,j,k)=b1a(2,j,k)
      b1a(imax,j,k)=b1a(imax-1,j,k)
      b2a(1,j,k)=b2a(2,j,k)
      b2a(imax,j,k)=b2a(imax-1,j,k)
      b3a(1,j,k)=b3a(2,j,k)
      b3a(imax,j,k)=b3a(imax-1,j,k)

    enddo
  enddo

  do j=1,jmax
    do i=1,imax
          
      b1a(i,j,1)=b1a(i,j,2)
      b1a(i,j,kmax)=b1a(i,j,kmax-1)
      b2a(i,j,1)=b2a(i,j,2)
      b2a(i,j,kmax)=b2a(i,j,kmax-1)
      b3a(i,j,1)=b3a(i,j,2)
      b3a(i,j,kmax)=b3a(i,j,kmax-1)

    enddo
  enddo
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        b1(i,j,k)=b1a(i,j,k)
        b2(i,j,k)=b2a(i,j,k)
        b3(i,j,k)=b3a(i,j,k)
      enddo
    enddo
  enddo


  return
end subroutine md2dmagadv
!
!--------------------------------------------------------------------
subroutine md3dmagadv(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                      is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 29; 3D Magnetic Loop Advection Test
  use pram, only : imax, jmax, kmax, gam, c0, xmax
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: merr

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: pom3(imax,jmax,kmax), &
             b1a(imax,jmax,kmax), b2a(imax,jmax,kmax), b3a(imax,jmax,kmax)
  real(8) :: x1(imax), x2(jmax), x3(kmax) 
!
  real(8) ::  xmax1, zmax1, xmax2, zmax2, a0, r0, r1, a2, a1, rr, alp1, &
             gam2, sina2, cosa2, amda, x1a, x2a, x3a
!
!--------------------------------------------------------------------
!  Parameter
!
!  xmax1=0.3d0
  zmax1=0.3d0
  xmax1=0.50*zmax1
  zmax2=2.0*zmax1
  xmax2=2.0*xmax1

  a0=1.0d-3
  r0=0.3*xmax2
  r1=0.2*r0
  a2=-0.5*a0/r1
  a1=a0*(r0-r1)-a2*r1**2

  alp1=0.0
!  gam2=atan(0.5*xmax1)
  gam2=atan(xmax2/zmax2)
  sina2=sin(gam2)
  cosa2=cos(gam2)
  if (cosa2 .ge. sina2) then
    amda=xmax2*cosa2
   else
    amda=zmax2*sina2
   endif
!   write(*,*) 'gam2, amda=', gam2, amda
!--------------------------------------------------------------------

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

        de(i,j,k)=1.d0
!        pr(i,j,k)=0.070589d0  
!        pr(i,j,k)=0.1714d0
        pr(i,j,k)=0.327272727d0
!        pr(i,j,k)=0.6d0

!        v1(i,j,k)=0.0
!        v2(i,j,k)=0.0
!        v3(i,j,k)=0.0

        v1(i,j,k)=zmax1
        v2(i,j,k)=zmax1
        v3(i,j,k)=2.0*zmax1
          
        b1(i,j,k)=0.d0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0

!        if(rr .le. r0) then
!          pom2(i,j,k)=a0*(r0-rr)
!        else
!          pom2(i,j,k)=0.d0
!        endif

!        x1a=cos(gam2)*cos(alp1)*x1(i)
!            -sin(alp1)*x2(j) 
!            -sin(gam2)*cos(alp1)*x3(k)
!        x2a=cos(gam2)*sin(alp1)*x1(i)
!            +cos(alp1)*x2(j)
!            -sin(gam2)*sin(alp1)*x3(k)
!        x3a=sin(gam2)*x1(i)+cos(gam2)*x3(k)

        x1a=cosa2*x1(i)-sina2*x3(k)
        x2a=x2(j)
        x3a=sina2*x1(i)+cosa2*x3(k)
!        x1a=cos(gam2)*x1(i)+sin(gam2)*x3(k)
!        x2a=x2(j)
!        x3a=-sin(gam2)*x1(i)+cos(gam2)*x3(k)

        if(x1a .gt. 0.5*amda) then
          x1a=x1a-amda
        elseif(x1a .lt. -0.5*amda) then
          x1a=x1a+amda
        endif

        rr=sqrt(x1a**2+x2a**2)

!        if(rr .le. r0) then
!          pom2(i,j,k)=a0*(r0-rr)
!        else
!          pom2(i,j,k)=0.d0
!        endif
!
        if(rr .ge. 0.d0 .and. rr .le. r1) then
          pom3(i,j,k)=a1+a2*rr**2
        elseif(rr .gt. r1 .and. rr .le. r0) then
          pom3(i,j,k)=a0*(r0-rr)
        else
          pom3(i,j,k)=0.d0
        endif
  
      enddo
    enddo
  enddo
         
  do k=1,kmax
    do j=2,jmax-1
      do i=2,imax-1
          
        b1a(i,j,k)=-(pom3(i,j-1,k)-pom3(i,j+1,k))/(x2(j-1)-x2(j+1))
        b2a(i,j,k)=(pom3(i-1,j,k)-pom3(i+1,j,k))/(x1(i-1)-x1(i+1))
        b3a(i,j,k)=0.0
 
      enddo
    enddo
  enddo         
        
  do k=1,kmax
    do j=1,jmax
          
      b1a(1,j,k)=b1a(2,j,k)
      b1a(imax,j,k)=b1a(imax-1,j,k)
      b2a(1,j,k)=b2a(2,j,k)
      b2a(imax,j,k)=b2a(imax-1,j,k)
      b3a(1,j,k)=b3a(2,j,k)
      b3a(imax,j,k)=b3a(imax-1,j,k)

    enddo
  enddo

  do k=1,kmax
    do i=1,imax
          
      b1a(i,1,k)=b1a(i,2,k)
      b1a(i,jmax,k)=b1a(i,jmax-1,k)
      b2a(i,1,k)=b2a(i,2,k)
      b2a(i,jmax,k)=b2a(i,jmax-1,k)
      b3a(i,1,k)=b3a(i,2,k)
      b3a(i,jmax,k)=b3a(i,jmax-1,k)

    enddo
  enddo
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
        b1(i,j,k)=b1a(i,j,k)
        b2(i,j,k)=b2a(i,j,k)
        b3(i,j,k)=b3a(i,j,k)
      enddo
    enddo
  enddo


  return
end subroutine md3dmagadv
!
!--------------------------------------------------------------------
subroutine md2drotor(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                     is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 27; 2D(3D) Rotor test problem
  use pram, only : imax, jmax, kmax, kmax, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)

  real(8) :: rc, rt1, rt2, de1, de2, p0, omega0, b0, rr, v1t, v3t
  real(8) :: ffjump
!--------------------------------------------------------------------
!  Parameter
!
!  gam=5.d0/3.d0
  rc=0.1d0
  rt1=0.001d0
  rt2=0.01d0
  de1=10.d0
  de2=1.d0
  p0=1.d0
  omega0=9.95d0
  b0=1.d0

!--------------------------------------------------------------------
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1

! 2D          
        rr=sqrt(x1(i)**2+x3(k)**2)
! 3D
!        rr=sqrt(x1(i)**2+x2(j)**2+x3(k)**2)
!          
        de(i,j,k)=ffjump(rr,de1,de2,rc,rt1,rt2)
         
        v1t=-omega0*x3(k)
        v3t=omega0*x1(i)
        v1(i,j,k)=ffjump(rr,v1t,0.0d0,rc,rt1,rt2)
        v2(i,j,k)=0.d0
        v3(i,j,k)=ffjump(rr,v3t,0.0d0,rc,rt1,rt2)
                
!        if(rr .le. rc) then
!          de(i,j,k)=de1
!          v1(i,j,k)=-1.*omega0*x3(k)
!          v2(i,j,k)=0.d0
!          v3(i,j,k)=omega0*x1(i)
!        else
!          de(i,j,k)=de2
!          v1(i,j,k)=0.d0
!          v2(i,j,k)=0.d0
!          v3(i,j,k)=0.d0
!        endif
          
        pr(i,j,k)=p0
          
        b1(i,j,k)=b0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0

      enddo
    enddo
  enddo

  return
end subroutine md2drotor
!
!--------------------------------------------------------------------
subroutine mdshoctub(de,pr,v1,v2,v3,b1,b2,b3,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 50; 1D Shock Tube Test Problem

  use pram, only : imax, jmax, kmax, kmax, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)

!--------------------------------------------------------------------
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
  
!        gam=2.d0
        if(i .le. imax/2) then
          de(i,j,k)=1.d0
          pr(i,j,k)=1.d0
          v1(i,j,k)=0.d0
          v2(i,j,k)=0.d0
          v3(i,j,k)=0.d0
          b1(i,j,k)=0.5d0
          b2(i,j,k)=1.d0
!          b1(i,j,k)=0.d0
!          b2(i,j,k)=0.d0 
          b3(i,j,k)=0.0d0
        else
          de(i,j,k)=0.125d0
          pr(i,j,k)=0.1d0
          v1(i,j,k)=0.d0
          v2(i,j,k)=0.d0
          v3(i,j,k)=0.d0
          b1(i,j,k)=0.5d0
          b2(i,j,k)=-1.d0
!          b1(i,j,k)=0.d0
!          b2(i,j,k)=0.d0
          b3(i,j,k)=0.0d0
        endif

      enddo
    enddo
  enddo

  return
end subroutine mdshoctub
!
!--------------------------------------------------------------------
subroutine mdalfvenpro(de,pr,v1,v2,v3,b1,b2,b3,x1,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 50; 1D Shock Tube Test Problem
!
  use pram, only : imax, jmax, kmax, kmax, gam, c0, pi
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax)

  real(8) :: eta1, amp, akap, b0, pp0, dd0, va
!
!--------------------------------------------------------------------
!  Parameter
!
!  gam=4.0/3.0
  eta1=1.d0
  b0=1.1547d0
!  b0=0.46188d0
  akap=2.d0*pi
  amp=eta1*b0
!  amp=1.0d-2
  pp0=1.d0
  dd0=1.d0
!  va=b0/sqrt(dd0+(gam/(gam-1.0))*pp0+b0**2)
  va=0.5d0
!  va=0.25d0

!--------------------------------------------------------------------
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
 

        de(i,j,k)=dd0
        pr(i,j,k)=pp0
        b1(i,j,k)=b0
        b2(i,j,k)=amp*cos(akap*x1(i))
        b3(i,j,k)=amp*sin(akap*x1(i))
        v1(i,j,k)=0.d0
        v2(i,j,k)=-(va/b0)*b2(i,j,k)
        v3(i,j,k)=-(va/b0)*b3(i,j,k)
    
!        v1(i,j,k)=0.d0
!        v2(i,j,k)=amp*cos(akap*x1(i))
!        v2(i,j,k)=0.d0
!        v3(i,j,k)=0.d0
!        b1(i,j,k)=b0
!        b2(i,j,k)=-b0*(amp/va)*cos(akap*x1(i))
!        b2(i,j,k)=0.d0
!        b3(i,j,k)=0.d0

      enddo
    enddo
  enddo

  return
end subroutine mdalfvenpro
!
!--------------------------------------------------------------------
subroutine mdshelpro(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                     is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 52; 1D Shell Propagation Test Problem
!
  use pram, only : imax, jmax, kmax, gam, c0, metric, pi
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)
 
  real(8) :: db, pb, v1b, b2b, ds, ps, v1s, b2s, rshin, rshot, rtra, &
             zzin, zzot, ztra, thin, thout, thtra, xx, rr, zz, tmp1, &
             theta, v1sx, v1sr, v1sz, shjmp1, shjmp2, shjmp3
  real(8) :: ffjump
!--------------------------------------------------------------------
!   Parameter
!     
  db=1.d0
  pb=1.d-5
  v1b=0.d0
  b2b=0.d0
    
  ds=1.d2
  ps=1.d-3
!  v1s=0.99d0
  v1s=0.995d0
  b2s=0.d0
!  b2s=31.63d0
    
  rshin=1.d0
!  rshot=1.2d0
  rshot=1.1d0
  rtra=0.02d0
!  rtra=0.0d0
            
  zzin=-0.5d0
  zzot=0.5d0
  ztra=0.05d0
      
  thin=1.3708d0
  thout=1.7708d0
  thtra=0.03d0
      
!  gam=4.d0/3.d0

!--------------------------------------------------------------------
!   Interstellar medium profile
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
          
         de(i,j,k)=db
         pr(i,j,k)=pb
         v1(i,j,k)=0.0
         v2(i,j,k)=0.0
         v3(i,j,k)=0.0
         b1(i,j,k)=0.0
         b2(i,j,k)=0.0
         b3(i,j,k)=0.0
          
         if(metric .eq. 1) then
          
           xx=x1(i)
           zz=x3(k)
           
           if(zz .eq. 0.d0) then
             tmp1=0.d0
           else
             tmp1=sqrt(xx**2)/zz
           endif
           
           if(tmp1 .ge. 0.d0) then
             theta=atan(tmp1)
           else
             theta=pi+atan(tmp1)
           endif
           
           v1sx=v1s*sin(theta)
           v1sz=v1s*cos(theta)
           
           shjmp1=(ffjump(xx,0.0d0,1.0d0,rshin,rtra,rtra) &
                      *ffjump(xx,1.0d0,0.0d0,rshot,rtra,rtra))
           shjmp2=(ffjump(zz,0.0d0,1.0d0,zzin,ztra,ztra) &
                      *ffjump(zz,1.0d0,0.0d0,zzot,ztra,ztra))
           shjmp3=shjmp1*shjmp2
           
!!           de(i,j,k)=db+shjmp3*(ds-db)
!!           pr(i,j,k)=pb+shjmp3*(ps-pb)

           de(i,j,k)=db+shjmp1*(ds-db)
           pr(i,j,k)=pb+shjmp1*(ps-pb)
           
!!           v1(i,j,k)=v1b+shjmp3*(v1sx-v1b)
!!           v2(i,j,k)=0.d0
!!           v3(i,j,k)=v1b+shjmp3*(v1sz-v1b)
!           v3(i,j,k)=0.d0

           v1(i,j,k)=v1b+shjmp1*(v1s-v1b)
           v2(i,j,k)=0.d0
           v3(i,j,k)=0.d0
           
           b1(i,j,k)=0.d0
!!           b2(i,j,k)=b2b+shjmp3*(b2s-b2b)
           b2(i,j,k)=b2b+shjmp1*(b2s-b2b)
           b3(i,j,k)=0.d0
           
         elseif(metric .eq. 2) then
          
           rr=x1(i)
           zz=x3(k)
           
           theta=atan(rr/zz)
           
           v1sr=v1s*sin(theta)
           v1sz=v1s*cos(theta)
           
           if(rr .le. 1.25d0) then
           
             de(i,j,k)=ffjump(xx,db,ds,rshin,rtra,rtra)
             pr(i,j,k)=ffjump(xx,pb,ps,rshin,rtra,rtra)
             v1(i,j,k)=ffjump(xx,v1b,v1sr,rshin,rtra,rtra)
             v3(i,j,k)=ffjump(xx,v1b,v1sz,rshin,rtra,rtra)
             b2(i,j,k)=ffjump(xx,b2b,b2s,rshin,rtra,rtra)
            
             if(rr .ge. rshin) then
              
               if(zz .le. 0.d0) then
              
                 de(i,j,k)=ffjump(zz,db,ds,zzin,ztra,ztra)
                 pr(i,j,k)=ffjump(zz,pb,ps,zzin,ztra,ztra)
                 v1(i,j,k)=ffjump(zz,v1b,v1sr,zzin,ztra,ztra)
                 v3(i,j,k)=ffjump(zz,v1b,v1sz,zzin,ztra,ztra)
                 b2(i,j,k)=ffjump(zz,b2b,b2s,zzin,ztra,ztra)
              
               else
              
                 de(i,j,k)=ffjump(zz,ds,db,zzot,ztra,ztra)
                 pr(i,j,k)=ffjump(zz,ps,pb,zzot,ztra,ztra)
                 v1(i,j,k)=ffjump(zz,v1sr,v1b,zzot,ztra,ztra)
                 v3(i,j,k)=ffjump(zz,v1sz,v1b,zzot,ztra,ztra)
                 b2(i,j,k)=ffjump(zz,b2s,b2b,zzot,ztra,ztra)
              
               endif
              
             endif
              
           else
           
             de(i,j,k)=ffjump(xx,ds,db,rshot,rtra,rtra)
             pr(i,j,k)=ffjump(xx,ps,pb,rshot,rtra,rtra)
             v1(i,j,k)=ffjump(xx,v1sr,v1b,rshot,rtra,rtra)
             v3(i,j,k)=ffjump(xx,v1sz,v1b,rshot,rtra,rtra)
             b2(i,j,k)=ffjump(xx,b2s,b2b,rshot,rtra,rtra)
            
             if(rr .le. rshot) then
              
               if(zz .le. 0.d0) then
              
                 de(i,j,k)=ffjump(zz,db,ds,zzin,ztra,ztra)
                 pr(i,j,k)=ffjump(zz,pb,ps,zzin,ztra,ztra)
                 v1(i,j,k)=ffjump(zz,v1b,v1sr,zzin,ztra,ztra)
                 v3(i,j,k)=ffjump(zz,v1b,v1sz,zzin,ztra,ztra)
                 b2(i,j,k)=ffjump(zz,b2b,b2s,zzin,ztra,ztra)
              
               else
              
                 de(i,j,k)=ffjump(zz,ds,db,zzot,ztra,ztra)
                 pr(i,j,k)=ffjump(zz,ps,pb,zzot,ztra,ztra)
                 v1(i,j,k)=ffjump(zz,v1sr,v1b,zzot,ztra,ztra)
                 v3(i,j,k)=ffjump(zz,v1sz,v1b,zzot,ztra,ztra)
                 b2(i,j,k)=ffjump(zz,b2s,b2b,zzot,ztra,ztra)
              
               endif
            
             endif
            
           endif
           
           v2(i,j,k)=0.d0
           b1(i,j,k)=0.d0
           b3(i,j,k)=0.d0
            
         elseif(metric .eq. 3) then
           rr=x1(i)
           theta=x3(k)
           
           shjmp1=(ffjump(rr,0.d0,1.d0,rshin,rtra,rtra) &
                      *ffjump(rr,1.d0,0.d0,rshot,rtra,rtra))
           shjmp2=(ffjump(theta,0.d0,1.d0,thin,thtra,thtra) &
                      *ffjump(theta,1.d0,0.d0,thout,thtra,thtra))
           shjmp3=shjmp1*shjmp2
           
           de(i,j,k)=db+shjmp3*(ds-db)
           pr(i,j,k)=pb+shjmp3*(ps-pb)
           
           v1(i,j,k)=v1b+shjmp3*(v1s-v1b)
           v2(i,j,k)=0.d0
           v3(i,j,k)=0.d0
           
           b1(i,j,k)=0.d0
           b2(i,j,k)=b2b+shjmp3*(b2s-b2b)
           b3(i,j,k)=0.d0
           
         endif
          
      enddo
    enddo
  enddo
 
  return
end subroutine mdshelpro
!
!--------------------------------------------------------------------
subroutine mdshref(de,pr,v1,v2,v3,b1,b2,b3,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 53; 1D Shock Reflection Test Problem
!
  use pram, only : imax, jmax, kmax, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)

!--------------------------------------------------------------------
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
          
!        gam=4.d0/3.d0
          
        de(i,j,k)=1.d0
        pr(i,j,k)=1.0d-2
        v1(i,j,k)=0.5d0
        v2(i,j,k)=0.d0
        v3(i,j,k)=0.d0
        b1(i,j,k)=0.d0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0

      enddo
    enddo
  enddo

  return
end subroutine mdshref
!
!--------------------------------------------------------------------
subroutine mdshpro(de,pr,v1,v2,v3,b1,b2,b3,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 55; 1D Shock Reflection Test Problem

  use pram, only : imax, jmax, kmax, gam, c0
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)

!--------------------------------------------------------------------
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
          
!        gam=5.d0/3.d0
          
        de(i,j,k)=1.d0
           
        if(i .le. 5) then
          pr(i,j,k)=0.1d0
        else
          pr(i,j,k)=1.d-2
        endif
         v1(i,j,k)=0.d0
         v2(i,j,k)=0.d0
         v3(i,j,k)=0.d0
         b1(i,j,k)=0.d0
         b2(i,j,k)=0.d0
         b3(i,j,k)=0.d0

      enddo
    enddo
  enddo

  return
end subroutine mdshpro
!
!--------------------------------------------------------------------
subroutine md2dshref(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3,vj, &
                     wkn,pkn2d,pkn1d,totpkn2d,totpkn1d, &
                     thetan,phin,cmac,betaj,bm,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 54; 2D Shock Reflection
!
  use pram, only : imax, jmax, kmax, nkmax, gam, c0, iseed
  implicit none

  integer :: i, j, k, n, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)
  real(8) :: x1(imax), x2(jmax), x3(kmax)
      
  real(8) :: wkn(nkmax), pkn2d(nkmax), pkn1d(nkmax), &
             thetan(nkmax), phin(nkmax)
 
  real(8) :: vj, betaj, de0, de1a, cmac, pb, bm, & 
             sigma, sigmab, sigma1, sigmad, thetan1d, amp2d, amp1d, &
             tmp1d, tmp2d, x1a, x3a, totpkn2d, totpkn1d, &
             df2d, df1d, df2dvx, df2dvy, df1dvx, df1dvy, flc1     
!--------------------------------------------------------------------
!  Parameter
!
  vj=0.4d0      
  betaj=0.01d0
 
  de0=1.d0
  de1a=0.d0

!  cmac=3.d0      
!  pb=(de0*vj**2)/(gam*cmac**2 -gam*vj**2/(gam-1.0))
  pb=0.01d0

  bm=sqrt(2.0*pb*betaj)
!  bm=0.d0
!  bm=0.036524d0
      
!   write(*,*) 'pb, bm=',pb, bm
!   write(*,*) 'totpkn1d, totpkn2d', totpkn1d, totpkn2d
!--------------------------------------------------------------------
!   Make fractuation
!
  sigma=0.02d0
  sigmab=0.25*bm
!  sigma1=sigmab
  sigma1=sigma
  sigmad=de0
      
!  thetan1=0.d0
  thetan1d=1.570796d0

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
         
        x1a=x1(i)
        x3a=x3(k)
          
        df1d=0.d0
        df2d=0.d0
!        df2dvx=0.0
!        df2dvy=0.0
!        df1dvx=0.0
!        df1dvy=0.0

        do n=1,nkmax
         
          amp2d=sqrt(sigma*pkn2d(n)/totpkn2d)
          amp1d=sqrt(sigma*pkn1d(n)/totpkn1d)
          
          tmp2d=wkn(n)*cos(thetan(n))*x1a+wkn(n)*sin(thetan(n))*x3a+phin(n)
          tmp1d=wkn(n)*cos(thetan1d)*x1a+wkn(n)*sin(thetan1d)*x3a+phin(n)
!          tmp1d=wkn(n)*x1a+phin(n)
          
!          df2d=df2d+amp2d*(sin(tmp2d)+cos(tmp2d))
!          df1d=df1d+amp1d*(sin(tmp1d)+cos(tmp1d))
       
          df2d=df2d+amp2d*sin(tmp2d)
          df1d=df1d+amp1d*sin(tmp1d)
       
!          df2dvx=df2dvx+amp2d*sin(thetan(n))*sin(tmp2d)
!          df2dvy=df2dvy-amp2d*cos(thetan(n))*sin(tmp2d)
       
!          df1dvx=df1dvx+amp1d*sin(thetan1d)*sin(tmp1d)
!          df1dvy=df1dvy-amp1d*cos(thetan1d)*sin(tmp1d)

        enddo
          
!        call kolfra1(wkn,pkn1d,pkn2d,totpkn1d,totpkn2d,thetan,phin, &
!                     df1d,df2d,df1dvx,df1dvy,df2dvx,df2dvy, &
!                     sigma,thetan1d,x1a,x3a)

!        flc1=1.0-2.0*ran1(iseed)
 
        de(i,j,k)=de0*exp(de1a+df2d)
!        de(i,j,k)=de0*exp(de1a+df1d)
!        de(i,j,k)=de0+sigma*df2d
!        de(i,j,k)=de0*(1.0+df2d)
!        de(i,j,k)=de0+sigma*flc1
         
        pr(i,j,k)=pb
         
        v1(i,j,k)=vj
        v2(i,j,k)=0.d0
        v3(i,j,k)=0.d0
         
!        b1(i,j,k)=bm*(1.0+df1d)
!        b1(i,j,k)=0.d0
        b1(i,j,k)=bm
         
        b2(i,j,k)=0.d0
         
        b3(i,j,k)=0.d0
!        b3(i,j,k)=bm
!        b3(i,j,k)=bm*(1.0+df1d)
!        b3(i,j,k)=bm+sigma*df2d
!        b3(i,j,k)=bm+bm*exp(df1d)

!        if(j .eq. 5 .and. k .eq. 32) then
!         write(*,*) 'i, de, bx=', i, de(i,j,k), b1(i,j,k)
!        endif         

      enddo
    enddo
  enddo
       
  return
end subroutine md2dshref
!
!--------------------------------------------------------------------
subroutine md2dshpro(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                     vj,wkn,pkn2d,pkn1d,totpkn2d,totpkn1d, &
                     thetan,phin,betaj,bm,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 56; 2D Shock Propagation
!
  use pram, only : imax, jmax, kmax, nkmax, gam, c0, pi, iseed
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x2(jmax), x3(kmax)
      
  real(8) :: wkn(nkmax), pkn2d(nkmax), pkn1d(nkmax), &
             thetan(nkmax), phin(nkmax)
      
  real(8) :: ps, pb, vj, betaj, b0, de0, de1a, bm, &
             sigma, sigmab, sigma1, sigmad, thetan1, totpkn1d, totpkn2d, &
             df1d, df2d, df1dvx, df1dvy, df2dvx, df2dvy, x1a, x3a 
!
!--------------------------------------------------------------------
!  Parameter
!
  ps=0.1d0
  pb=1.0d-2
  vj=0.5d0
  betaj=0.001d0
!  b0=0.1d0
      
  de0=1.d0
  de1a=0.d0
      
  bm=sqrt(betaj/2.0*pb)
!  bm=0.d0
      
!  write(*,*) 'pb, bm=',pb, bm
!  write(*,*) 'totpkn1d, totpkn2d', totpkn1d, totpkn2d
!--------------------------------------------------------------------
!   Make fractuation
!
  sigma=0.01
  sigmab=0.25*bm
!  sigma1=sigmab
  sigma1=sigma
  sigmad=0.5*de0
      
!  thetan1=0.d0
  thetan1=1.570796d0
            
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
         
        x1a=x1(i)
        x3a=x3(k)
          
        call kolfra1(wkn,pkn1d,pkn2d,totpkn1d,totpkn2d,thetan,phin, &
                     df1d,df2d,df1dvx,df1dvy,df2dvx,df2dvy, &
                     sigma,thetan1,x1a,x3a)
 
!        de(i,j,k)=de0*exp(de1a+df2d)
!        de(i,j,k)=de0*exp(de1a+df1d)
        de(i,j,k)=de0+sigmad*df2d
         
        if(x1(i) .le. 0.1d0) then
          pr(i,j,k)=ps
        else
          pr(i,j,k)=pb
        endif
         
        v1(i,j,k)=0.d0
        v2(i,j,k)=0.d0
        v3(i,j,k)=0.d0
         
!        b1(i,j,k)=bm*(1.0+df1d)
        b1(i,j,k)=0.d0
         
        b2(i,j,k)=0.d0
         
        b3(i,j,k)=0.d0
!        b3(i,j,k)=bm
!        b3(i,j,k)=bm+df1d
!        b3(i,j,k)=bm+sigmab*df1d
!        b3(i,j,k)=bm+bm*exp(df1d)
         
!        if(k .eq. 4 .and. j .eq. 4) then
!          write(*,*) 'df2d, de, x1', df2d, de(i,j,k), x1(i)
!          write(*,*) 'df1d, b3, x1', df1d, b3(i,j,k)
!        endif
 
      enddo
    enddo
  enddo
       
  return
end subroutine md2dshpro
!
!--------------------------------------------------------------------
subroutine md2dkh(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                 is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 31; 2D KH unstable flow Test
  use pram, only : imax, jmax, kmax,  gam, c0, pi
  implicit none

  integer :: i, j, k, is1 ,ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x2(jmax), x3(kmax)
  real(8) :: dd0, dd1, pp0, v0, aa, bb, cc, b0, sigp, sigt, beta, tmp1

!--------------------------------------------------------------------
!  Parameter
!
  dd0=1.d0
  dd1=0.01d0
!  pp0=20.d0
  pp0=1.d0
  v0=0.5d0
!
  aa=0.01d0
  bb=0.1d0
  cc=0.1d0

  b0=0.001d0

  sigp=0.01d0
  sigt=1.d0
!  beta=1.d0/10.d0
!
!--------------------------------------------------------------------
!
  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
 
        if(x3(k) .gt. 0.d0) then
          v1(i,j,k)=v0*tanh((x3(k)-0.5d0)/aa)
          v3(i,j,k)=bb*v0*sin(2.*pi*x1(i))*exp(-((x3(k)-0.5d0)/cc)**2)  
        else
          v1(i,j,k)=-v0*tanh((x3(k)+0.5d0)/aa)
          v3(i,j,k)=-bb*v0*sin(2.*pi*x1(i))*exp(-((x3(k)+0.5d0)/cc)**2) 
        endif
        v2(i,j,k)=0.d0     

        if(v1(i,j,k) .ge. 0.d0) then
          de(i,j,k)=dd0
        else
          de(i,j,k)=dd1
        endif
!
        pr(i,j,k)=pp0

!        b1(i,j,k)=b0
!        b2(i,j,k)=0.d0
        b1(i,j,k)=sqrt(2.*sigp*pp0)
        b2(i,j,k)=sqrt(2.*sigt*pp0)
        b3(i,j,k)=0.d0

!        tmp1=(x3(k)/beta)**2
!        v1(i,j,k)=-0.25*tanh(100.0*x3(k))
!        v2(i,j,k)=0.d0
!        v3(i,j,k)=(1./400.)*sin(2.*pi*x1(i))*exp(-tmp1)        
!        b1(i,j,k)=sqrt(2.*sigp*pp0)
!        b2(i,j,k)=sqrt(2.*sigt*pp0)
!        b3(i,j,k)=0.d0
!
     enddo
    enddo
  enddo

  return
end subroutine md2dkh
!
!--------------------------------------------------------------------
subroutine md3dkh(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                  is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 30; 3D Kenvin-Helmholtz instability
!
  use pram, only : imax, jmax, kmax, gam, c0, pi, iseed
  implicit none
  include 'mpif.h' ! for MPI  

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1
  integer :: myrank, npe, merr 

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x2(jmax), x3(kmax)
  real(8) :: phix(imax), phiy(jmax), phiz(kmax)

  real(8) :: d0, p0, v0, b0, ap, thp, dvx, dvy, dvz
  real(8) :: ran1, tmp1, tmp2, tmp3
!
!--------------------------------------------------------------------
!  Parameter
!
  d0=1.d0
  p0=1.d0
  v0=0.5d0
  b0=1.0d-3

  ap=0.01d0
  thp=0.05d0

!--------------------------------------------------------------------

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
         
        de(i,j,k)=d0
        pr(i,j,k)=p0
         
        if(x2(j) .gt. 0.25d0 .or. x2(j) .le. -0.25d0) then
          v1(i,j,k)=v0
        else
          v1(i,j,k)=-v0
        endif
        v2(i,j,k)=0.d0
        v3(i,j,k)=0.d0
         
        b1(i,j,k)=b0
        b2(i,j,k)=0.d0
        b3(i,j,k)=0.d0
         
      enddo
    enddo
  enddo
!
! Perturbation
!
  if(myrank .eq. 0) then
    do i=1,imax
      call random_number(tmp1)
      phix(i)=2.0*pi*tmp1      
    enddo
    do j=1,jmax
      call random_number(tmp2)
      phiy(j)=2.0*pi*tmp2        
    enddo
    do k=1,kmax
      call random_number(tmp3)
      phiz(k)=2.0*pi*tmp3        
    enddo
  endif
  call mpi_barrier(mpi_comm_world,merr)
  call mpi_bcast(phix,imax,mpi_double_precision,0,mpi_comm_world,merr) 
  call mpi_bcast(phiy,jmax,mpi_double_precision,0,mpi_comm_world,merr) 
  call mpi_bcast(phiz,kmax,mpi_double_precision,0,mpi_comm_world,merr) 

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1         
        dvx=ap*cos(2.*pi*cos(thp*x1(i))+phix(i))
        dvy=ap*cos(2.*pi*sin(thp*x2(j))+phiy(j))
        dvz=ap*cos(phiz(k))
         
        v1(i,j,k)=v1(i,j,k)+dvx
        v2(i,j,k)=v2(i,j,k)+dvy
        v3(i,j,k)=v3(i,j,k)+dvz
      enddo
    enddo
  enddo
        
  return
end subroutine md3dkh
!
!--------------------------------------------------------------------
subroutine md3dshcol(de,pr,v1,v2,v3,b1,b2,b3,x1,x2,x3, &
                     wkn,pkn2d,pkn1d,totpkn2d,totpkn1d, &
                     thetan,phin,thetan1,phin1,is1,ie1,js1,je1,ks1,ke1)
!--------------------------------------------------------------------
!         model = 57; 3D Relativistic Shell Collision
!
  use pram, only : imax, jmax, kmax, nkmax, gam, c0, pi, iseed
  implicit none

  integer :: i, j, k, is1, ie1, js1, je1, ks1, ke1

  real(8) :: de(is1:ie1,js1:je1,ks1:ke1), pr(is1:ie1,js1:je1,ks1:ke1), &
             v1(is1:ie1,js1:je1,ks1:ke1), v2(is1:ie1,js1:je1,ks1:ke1), &
             v3(is1:ie1,js1:je1,ks1:ke1), &
             b1(is1:ie1,js1:je1,ks1:ke1), b2(is1:ie1,js1:je1,ks1:ke1), &
             b3(is1:ie1,js1:je1,ks1:ke1)

  real(8) :: x1(imax), x2(jmax), x3(kmax)

!  real(8) :: phik(nkmax), thetak(nkmax), ampxk(nkmax), ampyk(nkmax)      
  real(8) :: wkn(nkmax), pkn2d(nkmax), pkn1d(nkmax), &
             thetan(nkmax), phin(nkmax), thetan1(nkmax),phin1(nkmax)
  
  real(8) :: ra1, d0l, d0r, p0l, p0r, v0l, v0r, b0, b0l, b0r, ap1, &
             dvx1, dvy1, ampx1, ampy1, tmp1, totpkn2d, totpkn1d, &
             de1a, sigma, thetan1d, x1a, x3a, df1d, df2d, & 
             df1dvx, df1dvy, df2dvx, df2dvy
!
!--------------------------------------------------------------------
!  Parameter
!
  ra1=0.1d0
      
  d0l=1.d0
  d0r=1.d0
  p0l=0.1d0
  p0r=0.1d0
  v0l=0.7d0
  v0r=-0.7d0
!  b0l=0.d0
!  b0r=0.d0
  b0l=0.9265d0
  b0r=0.9265d0

  ap1=0.01d0
 
!--------------------------------------------------------------------c

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
         
        if(x1(i) .le. 0.d0) then
          de(i,j,k)=d0l
          pr(i,j,k)=p0l
          v1(i,j,k)=v0l
          b3(i,j,k)=b0l
        else
          de(i,j,k)=d0r
          pr(i,j,k)=p0r
          v1(i,j,k)=v0r
          b3(i,j,k)=b0r
        endif
         
        v2(i,j,k)=0.d0
        v3(i,j,k)=0.d0
          
        b1(i,j,k)=0.d0
        b2(i,j,k)=0.d0
         
      enddo
    enddo
  enddo

!--------------------------------------------------------------------c
! Perturbation
!
! ===
!  random phase of kn
!      
!  do n=1,nkmax
!    thetak(n)=2.0*pi*ran1(iseed)
!!    phik(n)=2.0*pi*ran1(iseed)
!    phik(n)=0.d0
!
!    ampxk(n)=1.0-2.0*ran1(iseed)
!    ampyk(n)=sqrt(1.0-ampxk(n)**2)
!    write(*,*) 'phik', phik(n)
!  enddo
!
! 1D velocity perturbation 
!
!  do k=ks1,ke1
!    do j=js1,je1
!      do i=is1,ie1
!         
!        dvx1=0.0
!        dvy1=0.0
!
!        do 30 n=1,nkmax
!          ampx1=ap1/float(nkmax)
!!          ampy1=ampyk(n)/float(nkmax)
!          dvx1=dvx1+ampx1*sin(2.*pi*float(n)*x3(k)+phik(n))
!!          dvy1=dvy1+ampy1*sin((2.0*pi*float(n)*x3(k)/zmax)+phik(n))
!        enddo
!         
!        tmp1=exp(-(x1(i)/ra1)**2)
!         
!        v1(i,j,k)=v1(i,j,k)+tmp1*dvx1
!!        v2(i,j,k)=v2(i,j,k)+tmp1*dvy1
!
!      enddo
!    enddo
!  enddo

!
!  2D Kolmogorov-like perturbation
!
  de1a=1.d0
  sigma=0.01d0
!
!  thetan1d=pi/2 -> delta vx along y direction
!  thetan1d=0    -> delta vy along x direction
!

!  thetan1d=0.d0
  thetan1d=1.570796d0

  do k=ks1,ke1
    do j=js1,je1
      do i=is1,ie1
         
        x1a=x1(i)
        x3a=x3(k)
         
        if(x1(i) .le. 0.d0) then
          call kolfra1(wkn,pkn1d,pkn2d,totpkn1d,totpkn2d, &
                       thetan,phin,df1d,df2d,df1dvx,df1dvy,df2dvx,df2dvy, &
                       sigma,thetan1d,x1a,x3a)
         else
           call kolfra1(wkn,pkn1d,pkn2d,totpkn1d,totpkn2d, &
                       thetan1,phin1,df1d,df2d,df1dvx,df1dvy,df2dvx,df2dvy, &
                       sigma,thetan1d,x1a,x3a)
         endif
!
! 2D density fluctuation
!
!         de(i,j,k)=de(i,j,k)*exp(de1a+df2d)
!         de(i,j,k)=de(i,j,k)*(1.0+df2d)
!
! velocity fluctuation (2D or 1D)
!
!         if(x1(i) .le. 0.0) then
!           v1(i,j,k)=v1(i,j,k)+v0l*df2dvx
!           v3(i,j,k)=v3(i,j,k)+v0l*df2dvy
!          
!!           v1(i,j,k)=v1(i,j,k)+v0l*df1dvx
!!           v3(i,j,k)=v3(i,j,k)+v0l*df1dvy
!         else
!           v1(i,j,k)=v1(i,j,k)+v0r*df2dvx
!           v3(i,j,k)=v3(i,j,k)+v0r*df2dvy
!          
!!           v1(i,j,k)=v1(i,j,k)+v0r*df1dvx
!!           v3(i,j,k)=v3(i,j,k)+v0r*df1dvy
!         endif
!
! Magnetic field fluctuation (2D or 1D)
!
         if(x1(i) .le. 0.d0) then
           b1(i,j,k)=b1(i,j,k)+b0l*df2dvx
           b3(i,j,k)=b3(i,j,k)+b0l*df2dvy
!          
!!           b1(i,j,k)=b1(i,j,k)+b0l*df1dvx
!!           b3(i,j,k)=b3(i,j,k)+b0l*df1dvy
         else
           b1(i,j,k)=b1(i,j,k)+b0r*df2dvx
           b3(i,j,k)=b3(i,j,k)+b0r*df2dvy
!          
!!           b1(i,j,k)=b1(i,j,k)+b0r*df1dvx
!!           b3(i,j,k)=b3(i,j,k)+b0r*df1dvy
         endif

      enddo
    enddo
  enddo

  return
end subroutine md3dshcol
!
!
!***********************************************************************
!           GENERAL FUNCTIONS
!***********************************************************************
!--------------------------------------------------------------------
function ffjump(xx,bi,ee,aa,dd,bb)
!--------------------------------------------------------------------
  implicit none
  real(8) :: xx, bi, ee, aa, dd, bb, ffjump
!
  if( xx .le. aa-bb ) then
    ffjump=bi
   elseif( xx .ge. aa+bb ) then
    ffjump=ee
   else
    ffjump=1.0+tanh((xx-aa)/dd)/tanh(bb/dd)
    ffjump=bi+0.5*ffjump*(ee-bi)
   endif
!
   return
end function ffjump
!
